version 10.1
clear all
set more off
se memory 500m
set matsize 800
       
cd "D:\CUSTOMIZE PATH\"
capture log close
log using JAE_TableA4+Figure1.log, text replace

use "D:\CUSTOMIZE PATH\JAE_TableA4_Fig1.dta"

cd "D:\CUSTOMIZE PATH"

set scrollbufsize 50000

*#delimit;


*************************************************************************************************************************************************
*********************************TABLE A4: DID ESTIMATION ON THE NUMBER OF ABSENCE DAYS: PLACEBO ESTIMATES****************************************
*************************************************************************************************************************************************



*~~~~~~~~~~~~~~~~*
*COLUMN (1): 1998*
*~~~~~~~~~~~~~~~~*

preserve

keep if year==1996|year==1997|year==1998|year==1999


***


reg daysabs treatmentgroup DiD98 t1998 t1999 t2000 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly yearsincompanyly_autonoly regUnempsq oggrosswagelysq oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)

zinb daysabs treatmentgroup DiD98  t1998 t1999 t2000 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly yearsincompanyly_autonoly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr) inflate(_cons treatmentgroup DiD98 t1998 t1999 t2000 $xvar )
mfx if treatmentgroup==1 & t1998==1, predict(n) varlist(DiD98) at(mean DiD98=1 t1998=1 t1999=0 treatmentgroup=1)

nnmatch daysabs DiD98 female immigrant partnerly marriedly disabledly Realschule Hauptschule Abi erljobly newjobly yearsincompanyly whitecollarly autonoly oggrosswagely regUnemp if balancedsample==1, tc(att) m(1) bias(bias) rob(1) keep(shortabs_ps) replace

restore




*~~~~~~~~~~~~*
*COLUMN (2): 2000*
*~~~~~~~~~~~~*


preserve

keep if year==1998|year==1999|year==2000|year==2001


****

reg daysabs treatmentgroup posttreat00 DiD00g  t1998 t1999 t2000 t2001 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly yearsincompanyly_autonoly regUnempsq oggrosswagelysq oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)

zinb daysabs treatmentgroup posttreat00 DiD00g t1998 t1999 t2000 t2001  yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly yearsincompanyly_autonoly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr) inflate(_cons treatmentgroup posttreat00 DiD00g t1998 t1999 t2000 t2001 $xvar ) 
mfx if treatmentgroup==1 & posttreat00==1, predict(n) varlist(DiD00g) at(mean DiD00g=1 t1998=0 t2001=1 treatmentgroup=1 posttreat00=1)

nnmatch daysabs DiD00g female immigrant partnerly marriedly disabledly Realschule Hauptschule Abi erljobly newjobly yearsincompanyly whitecollarly autonoly oggrosswagely regUnemp if balancedsample==1, tc(att) m(1) bias(bias) rob(1) keep(shortabs_ps) replace

restore


*~~~~~~~~~~~~*
*COLUMN (3): 2001*
*~~~~~~~~~~~~*

preserve

keep if year==1999|year==2000|year==2001|year==2002

***

reg daysabs treatmentgroup posttreat01 DiD01g  t1999 t2000 t2001 t2002 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly yearsincompanyly_autonoly regUnempsq oggrosswagelysq oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)

zinb daysabs treatmentgroup posttreat01 DiD01g  t1999 t2000 t2001 t2002 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly yearsincompanyly_autonoly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr) inflate(_cons treatmentgroup posttreat01 DiD01g t1999 t2000 t2001 t2002 $xvar ) 
mfx if treatmentgroup==1 & posttreat01==1, predict(n) varlist(DiD01g) at(mean DiD01g=1 t1999=0 t2000=0 t2001=1 t2002=1 treatmentgroup=1 posttreat01=1)

nnmatch daysabs DiD01g female immigrant partnerly marriedly disabledly Realschule Hauptschule Abi erljobly newjobly yearsincompanyly whitecollarly autonoly oggrosswagely regUnemp if balancedsample==1, tc(att) m(1) bias(bias) rob(1) keep(shortabs_ps) replace

restore




*************************************************************************************************************************************************
*****************************FIGURE 1: AVERAGE SICKNESS ABSENCE DAYS FOR TREATMENT AND CONTROL GROUP OVER TIME****************************************
*************************************************************************************************************************************************


keep if year==1997|year==1998|year==1999|year==2000|year==2001|year==2002|year==2003

twoway (line daysabscontrol_group daysabstreatment_group unemplrate year, lcolor(black) lwidth(medium) msymbol(diamond) mcolor(black)), yscale(range(6 12)) xscale(range(1997 2003)) xtick(1997 (1) 2003) xlabel(1997 (2) 2003) title(Average sickness absence days) subtitle(by year and treatmentgroup) legend(off) scheme(s2mono) legend(on) xline(1998.5, lwidth(thick) lcolor(black) lpattern(tight_dot))  xline(2001, lwidth(medium) lcolor(black) lpattern(tight_dot))  ytick(6 (1) 12) ylabel(6 (1) 12)




log close 
