*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


version 10.1
clear all
set more off
se memory 500m
set matsize 800
       
*cd "C:\CUSTOMIZE PATH HERE\"
*cd "C:\CUSTOMIZE PATH HERE\"
cd "C:\CUSTOMIZE PATH HERE\"
capture log close
log using 2012-9-24 JAE_MainAnalysis.log, text replace

use "C:\CUSTOMIZE PATH HERE\JAE_Mainanalysis_clean.dta", clear
*use "C:\CUSTOMIZE PATH HERE\\JAE_MainAnalysis_clean.dta"

*cd "C:\CUSTOMIZE PATH HERE\"
cd "C:\CUSTOMIZE PATH HERE\"


set scrollbufsize 50000
set seed 135792468
gen u=uniform()
sort u

*#delimit;


******************************************************************************************************************************************************************************************
****************************************************************** TABLE A1: SUMMARY STATISTICS *******************************************************************************************
******************************************************************************************************************************************************************************************

sutex treatmentgroup daysabs longabs dropout civilservantly oeffdly selfemployedly onemanfirm smallcompany bluecollar $xvar joblossprevyear nothandicappedly severelyhandicappedly healthsatisveryhighly healthsatislowly lifesatislowly worksatislowly worriesjobhighly overtime firmlessjobsly joblossexpected1999 workcouncil2001 jobnofun1997 jobpromotionexpected1998 noreligion1997 sicknessinsurancestate1997 sicknessinsuranceprivate1997 lifeluck1999 controllifeII1999 controllife1999 drivelife1999 workhard1999 if (treatmentgroup==1|treatmentgroup==0), nobs labels minmax digits(4) title(Descriptive Statistics) key(DesStat) longtable file("DesStat_98_01.tex") replace


*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



*******************************************************************************************************************************************************************************************
***************************************************************** TABLE A2: SAMPLE MEANS OF TREATMENT AND CONTROL GROUP: RAW, MATCHED, AND BLOCKED SAMPLE***********************************
********************************************************************************************************************************************************************************************


*****************************************************************************************
* SAMPLE MEANS OF TREATMENT AND CONTROL GROUP, TABLE A1: Columns (1) - (2) [Raw Sample]*
*****************************************************************************************

tabstat female age immigrant partnerly marriedly childrenly disabledly healthgoodly healthbadly Hauptschule Realschule Abi erljobly newjobly yearsincompanyly whitecollarly oggrosswagely regUnemp if balancedsample==1, stats(mean)  columns(statistics) save f(%9.3fc) 
matrix DesStatT1 = r(StatTotal)'
matrix list DesStatT1

tabstat female age immigrant partnerly marriedly childrenly disabledly healthgoodly healthbadly Hauptschule Realschule Abi erljobly newjobly yearsincompanyly whitecollarly oggrosswagely regUnemp if balancedsample==1 & treatmentgroup==1, stats(mean)  columns(statistics) save f(%9.3fc) 
matrix DesStatT2 = r(StatTotal)'
matrix list DesStatT2

tabstat female age immigrant partnerly marriedly childrenly disabledly healthgoodly healthbadly Hauptschule Realschule Abi erljobly newjobly yearsincompanyly whitecollarly oggrosswagely regUnemp if balancedsample==1 & treatmentgroup==0, stats(mean)  columns(statistics) save f(%9.3fc) 
matrix DesStatT3 = r(StatTotal)'
matrix list DesStatT3

matrix define DesStatTall=(DesStatT1, DesStatT2, DesStatT3)
matrix list DesStatTall

outtable using DesStatTRaw_98_01, mat(DesStatTall) replace caption("Means by Treatment and Control Group") clabel(DesStatTall) longtable f(%20.3fc) 


*****************************************************************************************
* NORMALIZED DIFFERENCE OF TREATMENT AND CONTROL GROUP, TABLE A1: Column (3) [Raw Sample]*
*****************************************************************************************

global mvar "female age immigrant partnerly marriedly childrenly disabledly healthgoodly healthbadly Hauptschule Realschule Abi erljobly newjobly yearsincompanyly whitecollarly oggrosswagely regUnemp"
global xvar   "female age agesq immigrant Eastly partnerly marriedly childrenly disabledly healthgoodly healthbadly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly oggrosswagely regUnemp"


foreach m of global mvar {
	quietly sum `m' if treatmentgroup==0
	scalar `m'_t0_mean = r(mean)
	}

foreach m of global mvar {
	quietly sum `m' if treatmentgroup==1
	scalar `m'_t1_mean = r(mean)
	}	

foreach m of global mvar {
	quietly sum `m' if treatmentgroup==0
	scalar `m'_t0_var = r(Var)
	}
	
foreach m of global mvar {
	quietly sum `m' if treatmentgroup==1
	scalar `m'_t1_var = r(Var)
	}

foreach m of global mvar {
	scalar `m'_norm_diff=abs((`m'_t1_mean - `m'_t0_mean)/sqrt(`m'_t1_var+`m'_t0_var))
	display `m'_norm_diff
	}
	
	
matrix define Normdiff=(female_norm_diff, age_norm_diff, immigrant_norm_diff, partnerly_norm_diff, marriedly_norm_diff, childrenly_norm_diff, disabledly_norm_diff, healthgoodly_norm_diff, healthbadly_norm_diff, Hauptschule_norm_diff, Realschule_norm_diff, Abi_norm_diff, erljobly_norm_diff, newjobly_norm_diff, yearsincompanyly_norm_diff, whitecollarly_norm_diff, oggrosswagely_norm_diff, regUnemp_norm_diff)'
matrix list Normdiff	


***
matrix define DesStatTall=(DesStatT2, DesStatT3, Normdiff)
matrix list DesStatTall
outtable using DesStatTall_98_01_raw, mat(DesStatTall) replace caption("Descriptive Statistics By Treatment and Control Groups") clabel(DesStatTall) longtable f(%20.3fc) 
***

global dvar "female_norm_diff age_norm_diff immigrant_norm_diff partnerly_norm_diff marriedly_norm_diff childrenly_norm_diff disabledly_norm_diff healthgoodly_norm_diff healthbadly_norm_diff Realschule_norm_diff Hauptschule_norm_diff Realschule_norm_diff Abi_norm_diff erljobly_norm_diff newjobly_norm_diff yearsincompanyly_norm_diff whitecollarly_norm_diff oggrosswagely_norm_diff regUnemp_norm_diff"

  
***************************************************************************************
* SAMPLE MEANS OF TREATMENT AND CONTROL GROUP, TABLE A1: Column(4)-(5) [Blocked Sample]*
***************************************************************************************

global cvars "female immigrant partnerly marriedly disabledly Realschule Hauptschule Abi erljobly newjobly yearsincompanyly whitecollarly oggrosswagely regUnemp"
gen comsup=1
gen posweight=1


quietly logit treatmentgroup $cvars
predict psp
quietly logit treatmentgroup $cvars if posttreat==0
predict psb
quietly logit treatmentgroup $cvars if posttreat==1
predict psa

sort u

quietly psmatch2 treatmentgroup  if posttreat==1, pscore(psp)  common outcome(daysabs) n(5) ate ai(5)
replace comsup=0 if _support==0
replace posweight=0 if treatmentgroup==0&posttreat==1&_weight==.
gen self_daysabs=_self_daysabs

quietly psmatch2 posttreat  if treatmentgroup==1, pscore(psp)  common outcome(daysabs) n(5) ate ai(5)
replace comsup=0 if _support==0
replace posweight=0 if treatmentgroup==1&posttreat==0&_weight==.
replace self_daysabs=_self_daysabs if _self_daysabs~=.


quietly psmatch2 DiDg  if treatmentgroup==posttreat, pscore(psp)  common outcome(daysabs) n(5) ate ai(5)
replace comsup=0 if _support==0
replace posweight=0 if treatmentgroup==0&posttreat==0&_weight==.
replace self_daysabs=_self_daysabs if _self_daysabs~=.

quietly psmatch2 treatmentgroup  if posttreat==1, pscore(psb)  common outcome(daysabs) n(5) ate
replace comsup=0 if _support==0
replace posweight=0 if treatmentgroup==0&posttreat==1&_weight==.

quietly psmatch2 posttreat  if treatmentgroup==1, pscore(psb)  common outcome(daysabs) n(5) ate
replace comsup=0 if _support==0
replace posweight=0 if treatmentgroup==1&posttreat==0&_weight==.

quietly psmatch2 DiDg  if treatmentgroup==posttreat, pscore(psb)  common outcome(daysabs) n(5) ate
replace comsup=0 if _support==0
replace posweight=0 if treatmentgroup==0&posttreat==0&_weight==.

quietly psmatch2 treatmentgroup  if posttreat==1, pscore(psa)  common outcome(daysabs) n(5) ate
replace comsup=0 if _support==0
replace posweight=0 if treatmentgroup==0&posttreat==1&_weight==.

quietly psmatch2 posttreat  if treatmentgroup==1, pscore(psa)  common outcome(daysabs) n(5) ate
replace comsup=0 if _support==0
replace posweight=0 if treatmentgroup==1&posttreat==0&_weight==.

quietly psmatch2 DiDg  if treatmentgroup==posttreat, pscore(psa)  common outcome(daysabs) n(5) ate
replace comsup=0 if _support==0
replace posweight=0 if treatmentgroup==0&posttreat==0&_weight==.


tabstat female age immigrant partnerly marriedly childrenly disabledly healthgoodly healthbadly Hauptschule Realschule Abi erljobly newjobly yearsincompanyly whitecollarly oggrosswagely regUnemp if /*balancedsample==1 &*/ comsup==1, stats(mean)  columns(statistics) save f(%9.3fc) 
matrix DesStatT1B = r(StatTotal)'
matrix list DesStatT1B

tabstat female age immigrant partnerly marriedly childrenly disabledly healthgoodly healthbadly Hauptschule Realschule Abi erljobly newjobly yearsincompanyly whitecollarly oggrosswagely regUnemp if /*balancedsample==1 & */ treatmentgroup==1 & comsup==1, stats(mean)  columns(statistics) save f(%9.3fc) 
matrix DesStatT2B = r(StatTotal)'
matrix list DesStatT2B

tabstat female age immigrant partnerly marriedly childrenly disabledly healthgoodly healthbadly Hauptschule Realschule Abi erljobly newjobly yearsincompanyly whitecollarly oggrosswagely regUnemp if /*balancedsample==1 & */ treatmentgroup==0 & comsup==1, stats(mean)  columns(statistics) save f(%9.3fc) 
matrix DesStatT3B = r(StatTotal)'
matrix list DesStatT3B

matrix define DesStatTallB=(DesStatT1B, DesStatT2B, DesStatT3B)
matrix list DesStatTallB

outtable using DesStatTBlo_98_01, mat(DesStatTallB) replace caption("Means by Treatment and Control Group") clabel(DesStatTallB) longtable f(%20.3fc) 



*************************************************************************************************
* NORMALIZED DIFFERENCE OF TREATMENT AND CONTROL GROUP, TABLE A2: Column (6) [Blocked Sample]*
*************************************************************************************************


foreach m of global mvar {
	quietly sum `m' if treatmentgroup==0&comsup==1
	scalar `m'_t0_mean = r(mean)
	}

foreach m of global mvar {
	quietly sum `m' if treatmentgroup==1&comsup==1
	scalar `m'_t1_mean = r(mean)
	}	

foreach m of global mvar {
	quietly sum `m' if treatmentgroup==0&comsup==1
	scalar `m'_t0_var = r(Var)
	}
	
foreach m of global mvar {
	quietly sum `m' if treatmentgroup==1&comsup==1
	scalar `m'_t1_var = r(Var)
	}

foreach m of global mvar {
	scalar `m'_norm_diff=abs((`m'_t1_mean - `m'_t0_mean)/sqrt(`m'_t1_var+`m'_t0_var))
	display `m'_norm_diff
	}
	
	
matrix define NormdiffB=(female_norm_diff, age_norm_diff, immigrant_norm_diff, partnerly_norm_diff, marriedly_norm_diff, childrenly_norm_diff, disabledly_norm_diff, healthgoodly_norm_diff, healthbadly_norm_diff, Hauptschule_norm_diff, Realschule_norm_diff, Abi_norm_diff, erljobly_norm_diff, newjobly_norm_diff, yearsincompanyly_norm_diff, whitecollarly_norm_diff, oggrosswagely_norm_diff, regUnemp_norm_diff)'
matrix list NormdiffB


***
matrix define DesStatTallB=(DesStatT2B, DesStatT3B, NormdiffB)
matrix list DesStatTallB
outtable using DesStatTall_98_01_Blo, mat(DesStatTallB) replace caption("Descriptive Statistics By Treatment and Control Groups") clabel(DesStatTallB) longtable f(%20.3fc) 
***

***************************************************************************************
* SAMPLE MEANS OF TREATMENT AND CONTROL GROUP, TABLE A2: Column(7)-(8) [Matched Sample]*
***************************************************************************************

tabstat female age immigrant partnerly marriedly childrenly disabledly healthgoodly healthbadly Hauptschule Realschule Abi erljobly newjobly yearsincompanyly whitecollarly oggrosswagely regUnemp if /*balancedsample==1 &*/ comsup==1 & posweight==1, stats(mean)  columns(statistics) save f(%9.3fc) 
matrix DesStatT1M = r(StatTotal)'
matrix list DesStatT1M

tabstat female age immigrant partnerly marriedly childrenly disabledly healthgoodly healthbadly Hauptschule Realschule Abi erljobly newjobly yearsincompanyly whitecollarly oggrosswagely regUnemp if /*balancedsample==1 & */ treatmentgroup==1 & comsup==1 & posweight==1, stats(mean)  columns(statistics) save f(%9.3fc) 
matrix DesStatT2M = r(StatTotal)'
matrix list DesStatT2M

tabstat female age immigrant partnerly marriedly childrenly disabledly healthgoodly healthbadly Hauptschule Realschule Abi erljobly newjobly yearsincompanyly whitecollarly oggrosswagely regUnemp if /*balancedsample==1 & */ treatmentgroup==0 & comsup==1 & posweight==1, stats(mean)  columns(statistics) save f(%9.3fc) 
matrix DesStatT3M = r(StatTotal)'
matrix list DesStatT3M

matrix define DesStatTallM=(DesStatT1M, DesStatT2M, DesStatT3M)
matrix list DesStatTallM

outtable using DesStatTMat_98_01, mat(DesStatTallM) replace caption("Means by Treatment and Control Group") clabel(DesStatTallM) longtable f(%20.3fc) 

*************************************************************************************************
* NORMALIZED DIFFERENCE OF TREATMENT AND CONTROL GROUP, TABLE A2: Column (9) [Matched Sample]    *
*************************************************************************************************

foreach m of global mvar {
	quietly sum `m' if treatmentgroup==0&comsup==1&posweight==1
	scalar `m'_t0_mean = r(mean)
	}

foreach m of global mvar {
	quietly sum `m' if treatmentgroup==1&comsup==1&posweight==1
	scalar `m'_t1_mean = r(mean)
	}	

foreach m of global mvar {
	quietly sum `m' if treatmentgroup==0&comsup==1&posweight==1
	scalar `m'_t0_var = r(Var)
	}
	
foreach m of global mvar {
	quietly sum `m' if treatmentgroup==1&comsup==1&posweight==1
	scalar `m'_t1_var = r(Var)
	}

foreach m of global mvar {
	scalar `m'_norm_diff=abs((`m'_t1_mean - `m'_t0_mean)/sqrt(`m'_t1_var+`m'_t0_var))
	display `m'_norm_diff
	}
	
	
matrix define NormdiffM=(female_norm_diff, age_norm_diff, immigrant_norm_diff, partnerly_norm_diff, marriedly_norm_diff, childrenly_norm_diff, disabledly_norm_diff, healthgoodly_norm_diff, healthbadly_norm_diff, Hauptschule_norm_diff, Realschule_norm_diff, Abi_norm_diff, erljobly_norm_diff, newjobly_norm_diff, yearsincompanyly_norm_diff, whitecollarly_norm_diff, oggrosswagely_norm_diff, regUnemp_norm_diff)'
matrix list NormdiffM


***
matrix define DesStatTallM=(DesStatT2M, DesStatT3M, NormdiffM)
matrix list DesStatTallM
outtable using DesStatTall_98_01_mat, mat(DesStatTallM) replace caption("Descriptive Statistics By Treatment and Control Groups") clabel(DesStatTallM) longtable f(%20.3fc) 
***


*******************************************************************************
* DISTRIBUTION OF PROPENSITY SCORES SHOWING REGION OF COMMON SUPPORT, FIGURE 2 (Online Appendix)*
*******************************************************************************

label variable psp "Estimated propensity score"
label variable treatmentgroup "Treatment group"
label variable posttreat "Time"

label define treatm 1 "Treated"
label define treatm 0 "Control", add
label values treatmentgroup treatm
label define posttr 1 "Post-Treatment"
label define posttr 0 "Pre-Treatment", add
label values posttreat posttr

twoway histogram psp, by(treatmentgroup posttreat) 
*graph export Figure2.png, replace


*INTERACTIONS
*~~~~~~~~~~~~

*gen yearsincompanylysq=yearsincompanyly*yearsincompanyly
*gen oggrosswagelysq=oggrosswagely*oggrosswagely
*gen regUnempsq=regUnemp*regUnemp

*gen yearsincompanyly_female=yearsincompanyly*female
*gen yearsincompanyly_partnerly=yearsincompanyly*partnerly
*gen yearsincompanyly_erljobly=yearsincompanyly*erljobly

*gen oggrosswagely_Abi=oggrosswagely*Abi
*gen oggrosswagely_whitecollarly=oggrosswagely*whitecollarly
*gen oggrosswagely_female=oggrosswagely*female
*gen oggrosswagely_marriedly=oggrosswagely*marriedly




	
****************************************************************
* DETERMINANTS OF SICKNESS ABSENCE (results not shown in paper)*
****************************************************************

reg daysabs female age agesq immigrant Eastly partnerly marriedly childrenly disabledly healthgoodly healthbadly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly oggrosswagely_1000 regUnemp state_2-state_16 if balancedsample==1 , cl(persnr)
estimates store X2, title(OLSII: Determinants of Daysabs) 
estout X2 using DaysabsDeterminantsIIb.tex, cells("b (star fmt(3)) se (fmt(3)) ") starlevels(* 0.10 ** 0.05 *** 0.01) stats(r2_p chi2 N, labels(R-squared)) margin legend label collabels(none) varlabels(_cons Constant) posthead("") prefoot("") postfoot("") style(tex) replace


***************************************************************
* UNCONDITIONAL DOUBLE DIFFERENCE (results not shown in paper)*
***************************************************************
 
reg daysabs posttreat treatmentgroup DiDg if balancedsample==1, cl(persnr)



******************************************************************************************************************************************************************************************
***************************************************************************** TABLE 1: DID ITT ESTIMATES [Raw Sample]*********************************************************************
******************************************************************************************************************************************************************************************

*~~~~~~~~~~~~~~~~~~~~~~~~*
*A. PARAMETRIC APPROACHES*
*~~~~~~~~~~~~~~~~~~~~~~~~*


*****************
*Column (1): OLS*
*****************

reg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)
estadd summ, sum
estimates store T3I, title(OLS) 


******************
*Column (2): ZINB*
******************

zinb daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1, cl(persnr) inflate(_cons) 
mfx if DiDg==1, predict(n) varlist(DiDg) at(mean DiDg=1 treatmentgroup=1 posttreat=1 t1997=0 t1999=0)
quietly sum DiDg if balancedsample==1
scalar nt=r(mean)
estadd summ, sum

estimates store T3II, title(ZINB-2) 
estout T3I T3II using Table2Para.tex, cells(b(star fmt(4)) se(par fmt(3)) sum(fmt(0))) starlevels(* 0.10 ** 0.05 *** 0.01)  stats(N, fmt(%9.0g))   margin legend label collabels(none) varlabels(_cons Constant) title("Difference-in-Differences Intention-to-Treat Estimation: Regression") keep(DiDg) style(tex) replace



*~~~~~~~~~~~~~~~~~~~~~~*
*B. MATCHING APPROACHES*
*~~~~~~~~~~~~~~~~~~~~~~*

**********************
*Column (3): BLOCKING*
**********************

xtile blocks=psp if comsup==1, nq(10)

tabulate posttreat treatmentgroup if comsup==1
gen daysvar=(daysabs-self_daysabs)^2
scalar vartau=0


gen DiDv=DiDg-(1-posttreat)*treatmentgroup-posttreat*(1-treatmentgroup)+(1-posttreat)*(1-treatmentgroup)

egen ntreat=total(DiDg) if comsup==1

bysort treatmentgroup posttreat blocks: egen obsweight=count(daysabs) if comsup==1
bysort treatmentgroup posttreat blocks: egen avdays=mean(daysabs)
bysort blocks: egen blweight=total(DiDg) if comsup==1
gen obsweight2=blweight/(obsweight*ntreat)

bysort treatmentgroup posttreat blocks: egen blvar=total(((daysabs-avdays)^2)/obsweight)
egen blvar2=total(blvar*obsweight2^2)
gen blse=sqrt(blvar2)
egen blatt=total(obsweight2*daysabs*DiDv) if comsup==1

tabstat blatt blse if comsup==1, stats(mean)  columns(statistics) save f(%9.3fc)
matrix define blres=r(StatTotal)
quietly sum DiDg if comsup==1
matrix N=r(N)
matrix Nt=N*r(mean)
matrix define blockres=(blres, N, Nt)'
matrix rownames blockres = "DID" "se" "N" "NTreated"


****************
*Column (4): NN*
****************

preserve
drop if posweight==0
sort u

quietly psmatch2 treatmentgroup if posttreat==1, pscore(psp)  common outcome(daysabs) n(5)
gen weight= _weight

quietly psmatch2 posttreat  if treatmentgroup==1, pscore(psp)  common outcome(daysabs) n(5)
replace weight= _weight if _weight~=.

quietly psmatch2 DiDg  if treatmentgroup==posttreat, pscore(psp)  common outcome(daysabs) n(5)
replace weight= _weight if _weight~=.

egen ntreatm=total(DiDg) if weight~=.
replace weight=weight/ntreatm
egen attvar=total((weight^2)*(daysabs-self_daysabs)^2)
gen attse=sqrt(attvar)
egen att=total(weight*daysabs*DiDv)
tabstat att attse if comsup==1, stats(mean)  columns(statistics) save f(%9.3fc)
matrix define mres=r(StatTotal)
sum DiDg if comsup==1
matrix N=r(N)
matrix Nt=N*r(mean)
matrix define mres=blockres,(mres, N, Nt)'


outtable using Table3Match, mat(mres) replace caption("Difference-in-Differences Intention-to-Treat Estimation: Matching") clabel(blockres) longtable 

restore


*****************************
*Column (5): BIVARIATE MATCH*
*****************************

/* N.B. TAKES VERY LONG TIME TO RUN... */

psmatch2 treatmentgroup if posttreat==1, pscore(psb)  common outcome(daysabs) n(5) ate
psmatch2 posttreat  if treatmentgroup==1, pscore(psb)  common outcome(daysabs) n(5) ate
psmatch2 DiDg  if treatmentgroup==posttreat, pscore(psb)  common outcome(daysabs) n(5) ate

psmatch2 treatmentgroup if posttreat==1, pscore(psa)  common outcome(daysabs) n(5) ate
psmatch2 posttreat  if treatmentgroup==1, pscore(psa)  common outcome(daysabs) n(5) ate
psmatch2 DiDg  if treatmentgroup==posttreat, pscore(psa)  common outcome(daysabs) n(5) ate


/* Local polynomial smooth for the probabilities q */

gen dnt=(1-posttreat)*treatmentgroup
gen ndt=posttreat*(1-treatmentgroup)
gen ndnt=(1-posttreat)*(1-treatmentgroup)

lpoly DiDg psp, at(psp) generate(q1ap) nograph
lpoly dnt  psp, at(psp) generate(q1bp) nograph
lpoly ndt  psp, at(psp) generate(q0ap) nograph
lpoly ndnt psp, at(psp) generate(q0bp) nograph

lpoly DiDg psb, at(psb) generate(q1ab) nograph
lpoly dnt  psb, at(psb) generate(q1bb) nograph
lpoly ndt  psb, at(psb) generate(q0ab) nograph
lpoly ndnt psb, at(psb) generate(q0bb) nograph

lpoly DiDg psa, at(psa) generate(q1aa) nograph
lpoly dnt  psa, at(psa) generate(q1ba) nograph
lpoly ndt  psa, at(psa) generate(q0aa) nograph
lpoly ndnt psa, at(psa) generate(q0ba) nograph

/* Estimating components of the test variance */

gen pf11= (1-DiDg/q1ap)*psp
gen pf12= (1-ndt/q1bp)*psp
gen pf21= (1-DiDg/q1ap)*psp
gen pf22= (1-dnt/q1bp)*psp
gen pf31= (1-dnt/q1bp)*psp
gen pf32= (1-ndnt/q1bp)*psp

gen bf11= (1-DiDg/q1ab)*psb
gen bf12= (1-ndt/q1bb)*psb
gen bf21= (1-DiDg/q1ab)*psb
gen bf22= (1-dnt/q1bb)*psb
gen bf31= (1-dnt/q1bb)*psb
gen bf32= (1-ndnt/q1bb)*psb

gen af11= (1-DiDg/q1aa)*psa
gen af12= (1-ndt/q1ba)*psa
gen af21= (1-DiDg/q1aa)*psa
gen af22= (1-dnt/q1ba)*psa
gen af31= (1-dnt/q1ba)*psa
gen af32= (1-ndnt/q1ba)*psa

gen f11=(DiDg==1)
gen f12=(ndt==1)
gen f21= (DiDg==1)
gen f22= (dnt==1)
gen f31= (dnt==1)
gen f32= (ndnt==1)

global cvars "female immigrant partnerly marriedly disabledly Realschule Hauptschule Abi erljobly newjobly yearsincompanyly whitecollarly oggrosswagely regUnemp"

foreach fvar of varlist f11-f32 {
foreach cvar of global cvars {
gen p`fvar'`cvar'=p`fvar'*`cvar'
lpoly p`fvar'`cvar' psp if `fvar'==1, at(psp) generate(alphap`fvar'`cvar') nograph
gen b`fvar'`cvar'=b`fvar'*`cvar'
lpoly b`fvar'`cvar' psb if `fvar'==1, at(psb) generate(alphab`fvar'`cvar') nograph
gen a`fvar'`cvar'=a`fvar'*`cvar'
lpoly a`fvar'`cvar' psa if `fvar'==1, at(psa) generate(alphaa`fvar'`cvar') nograph
}
}

foreach cvar of global cvars {
gen alphadp1`cvar'=alphapf11`cvar'-alphapf12`cvar'
gen alphadp2`cvar'=alphapf21`cvar'-alphapf22`cvar'
gen alphadp3`cvar'=alphapf31`cvar'-alphapf32`cvar'

gen alphadb1`cvar'=alphabf11`cvar'-alphabf12`cvar'
gen alphadb2`cvar'=alphabf21`cvar'-alphabf22`cvar'
gen alphadb3`cvar'=alphabf31`cvar'-alphabf32`cvar'

gen alphada1`cvar'=alphaaf11`cvar'-alphaaf12`cvar'
gen alphada2`cvar'=alphaaf21`cvar'-alphaaf22`cvar'
gen alphada3`cvar'=alphaaf31`cvar'-alphaaf32`cvar'
}

/* Next, we construct the moments */

foreach cvar of global cvars {
gen mp1`cvar'=psp*posttreat*`cvar'*(treatmentgroup/q1ap-(1-treatmentgroup)/q0ap)
gen mp2`cvar'=psp*treatmentgroup*`cvar'*(posttreat/q1ap-(1-posttreat)/q1bp)
gen mp3`cvar'=psp*(1-posttreat)*`cvar'*(treatmentgroup/q1bp-(1-treatmentgroup)/q0bp)

gen mb1`cvar'=psb*`cvar'*posttreat*(treatmentgroup/q1ab-(1-treatmentgroup)/q0ab)
gen mb2`cvar'=psb*`cvar'*treatmentgroup*(posttreat/q1ab-(1-posttreat)/q1bb)
gen mb3`cvar'=psb*(1-posttreat)*`cvar'*(treatmentgroup/q1bb-(1-treatmentgroup)/q0bb)

gen ma1`cvar'=psa*posttreat*`cvar'*(treatmentgroup/q1aa-(1-treatmentgroup)/q0aa)
gen ma2`cvar'=psa*`cvar'*treatmentgroup*(posttreat/q1aa-(1-posttreat)/q1ba)
gen ma3`cvar'=psa*(1-posttreat)*`cvar'*(treatmentgroup/q1ba-(1-treatmentgroup)/q0ba)

}



xmlsave alphadp1* alphadp2* alphadp3* alphadb1* alphadb2* alphadb3* alphada1* alphada2* alphada3* mp1* mp2* mp3* mb1* mb2* mb3* ma1* ma2* ma3* $cvars treatmentgroup posttreat psb psa psp daysabs using "psdata.xml", replace doctype(excel)


/* The Gauss code below performs Hong's (2011) Test and estimates the DID-matching estimator with compositional changes */

/*
cls;

chdir C:\Users\karlsson\Documents\Nicolas\2Paper\Folder;
vls = reshape(error(0),9,1);

data=xlsreadm("psdata.xml", "a2", 1, vls);   @ forgauss.xml is a file containing all variables @
data=packr(data);



k=14;  @ Number of covariates @
h=0.11; @ Bin width @

m1p=sumc(data[.,9*k+1:10*k])/rows(data);
m2p=sumc(data[.,10*k+1:11*k])/rows(data);
m3p=sumc(data[.,11*k+1:12*k])/rows(data);

m1b=sumc(data[.,12*k+1:13*k])/rows(data);
m2b=sumc(data[.,13*k+1:14*k])/rows(data);
m3b=sumc(data[.,14*k+1:15*k])/rows(data);

m1a=sumc(data[.,15*k+1:16*k])/rows(data);
m2a=sumc(data[.,16*k+1:17*k])/rows(data);
m3a=sumc(data[.,17*k+1:18*k])/rows(data);

Vp=(data[.,9*k+1:12*k]+data[.,1:3*k]-(sumc(data[.,1:3*k])/rows(data))')'(data[.,9*k+1:12*k]+data[.,1:3*k]-(sumc(data[.,1:3*k])/rows(data))')/rows(data);
statp=rows(data)*(m1p'~m2p'~m3p')*inv(Vp)*(m1p|m2p|m3p);
pvp=cdfchic(statp,cols(Vp));

Vb=(data[.,12*k+1:15*k]+data[.,3*k+1:6*k]-(sumc(data[.,3*k+1:6*k])/rows(data))')'(data[.,12*k+1:15*k]+data[.,3*k+1:6*k]-(sumc(data[.,3*k+1:6*k])/rows(data))')/rows(data);
statb=rows(data)*(m1b'~m2b'~m3b')*inv(Vb)*(m1b|m2b|m3b);
pvb=cdfchic(statb,cols(Vb));

Va=(data[.,15*k+1:18*k]+data[.,6*k+1:9*k]-(sumc(data[.,6*k+1:9*k])/rows(data))')'(data[.,15*k+1:18*k]+data[.,6*k+1:9*k]-(sumc(data[.,6*k+1:9*k])/rows(data))')/rows(data);
stata=rows(data)*(m1a'~m2a'~m3a')*inv(Va)*(m1a|m2a|m3a);
pva=cdfchic(stata,cols(Va));

print "Test Pall " statp~pvp;
print "Test Pbefore " statb~pvb;
print "Test Pafter " stata~pva;



c11=(data[.,267] .eq 1).*(data[.,268] .eq 1);
c10=(data[.,267] .eq 1).*(data[.,268] .eq 0);
c01=(data[.,267] .eq 0).*(data[.,268] .eq 1);
c00=(data[.,267] .eq 0).*(data[.,268] .eq 0);

data11=selif(data,c11);
data10=selif(data,c10);
data01=selif(data,c01);
data00=selif(data,c00);

datant=selif(data,1-c11);
e1=1|0|0;

yhat=zeros(rows(data11),3);

for i(1,rows(data11),1);
selv=(abs(data11[i,269]-datant[.,269]) .lt h).*(abs(data11[i,270]-datant[.,270]) .lt h);
datantb=selif(datant,selv);
kh=(15.^2).*((((datantb[.,269]-data11[i,269])/h).^2-1).^2).*((((datantb[.,270]-data11[i,270])/h).^2-1).^2)./(16*h).^2;
xpi=ones(rows(datantb),1)~(datantb[.,269]-data11[i,269])~(datantb[.,270]-data11[i,270]);
yhat[i,1]=e1'(inv((xpi.*(datantb[.,267]).*kh)'xpi)*(xpi.*(datantb[.,267]).*kh)'datantb[.,272]);
yhat[i,2]=e1'(inv((xpi.*(datantb[.,268]).*kh)'xpi)*(xpi.*(datantb[.,268]).*kh)'datantb[.,272]);
yhat[i,3]=e1'(inv((xpi.*(1-datantb[.,267]).*(1-datantb[.,268]).*kh)'xpi)*(xpi.*(1-datantb[.,267]).*(1-datantb[.,268]).*kh)'datantb[.,272]);
endfor;


nrep=100;
sele=ceil(rows(data11)*rndu(rows(data11),nrep));
treat=data11[.,272]-yhat[.,1]-yhat[.,2]+yhat[.,3];
treat2=treat[sele[.,1]];
for i(2,100,1);
treat2=treat2~treat[sele[.,i]];
endfor;
treatm=sumc(sumc(treat2)/rows(treat2))/cols(treat2);
varest=(sumc(treat2)/rows(treat2)-treatm).^2;
varest2=sumc(varest)/(nrep-1);
treat=sumc(data11[.,272]-yhat[.,1]-yhat[.,2]+yhat[.,3])/rows(data11);

print "Estimated treatment effect " treat;
print "Standard error " sqrt(varest2);

*/


*~~~~~~~~~~~~~~~~~~~~~~*
*C. COMBINED APPROACHES*
*~~~~~~~~~~~~~~~~~~~~~~*


***********************************
*Column (6): BLOCKING + REGRESSION*
***********************************

forval i = 1/10 {
quietly zinb daysabs treatmentgroup posttreat DiDg $cvars if blocks==`i', cl(persnr) inflate(_cons) 
quietly mfx if DiDg==1, predict(n) varlist(DiDg) at(mean DiDg=1 treatmentgroup=1 posttreat=1)
matrix eb`i'=e(Xmfx_dydx)
scalar DiDg`i'=eb`i'[1,3]
matrix eV`i'=e(Xmfx_se_dydx)
scalar DiDg`i'_s=eV`i'[1,3]
quietly sum DiDg if blocks==`i'
scalar N`i'=r(sum)
}  

scalar DiDg_X= ((DiDg1*N1) + (DiDg2*N2) + (DiDg3*N3) + (DiDg4*N4) + (DiDg5*N5) + (DiDg6*N6) + (DiDg7*N7) + (DiDg8*N8) + (DiDg9*N9) + (DiDg10*N10))/(N1+N2+N3+N4+N5+N6+N7+N8+N9+N10)

scalar Var_num= N1^2*DiDg1_s + N2^2*DiDg2_s + N3^2*DiDg3_s + N4^2*DiDg4_s + N5^2*DiDg5_s + N6^2*DiDg6_s + N7^2*DiDg7_s + N8^2*DiDg8_s + N9^2*DiDg9_s + N10^2*DiDg10_s
scalar Var_denom=(N1+N2+N3+N4+N5+N6+N7+N8+N9+N10)^2
scalar DiDg_V=  sqrt(Var_num/Var_denom)

matrix define blres=DiDg_X\DiDg_V


***********************************
*Column (7): NN+ REGRESSION*
***********************************

preserve
drop if posweight==0 
drop if comsup==0
sort u

psmatch2 treatmentgroup if posttreat==1, pscore(psp)  common outcome(daysabs) n(5)
gen weight= _weight
replace _weight=round(5*_weight)
regress daysabs $cvars if _treated==0 [fweight=_weight]
gen cdaysabs01=(daysabs[_n1]+daysabs[_n2]+daysabs[_n3]+daysabs[_n4]+daysabs[_n5])/5
foreach var of global cvars {
replace cdaysabs01=cdaysabs01+_b[`var']*(`var'-(`var'[_n1]+`var'[_n2]+`var'[_n3]+`var'[_n4]+`var'[_n5])/5)
}

psmatch2 posttreat  if treatmentgroup==1, pscore(psp)  common outcome(daysabs) n(5)
replace weight= _weight if _weight~=.
replace _weight=round(5*_weight)
regress daysabs $cvars if _treated==0 [fweight=_weight]
gen cdaysabs10=(daysabs[_n1]+daysabs[_n2]+daysabs[_n3]+daysabs[_n4]+daysabs[_n5])/5

foreach var of global cvars {
replace cdaysabs10=cdaysabs10+_b[`var']*(`var'-(`var'[_n1]+`var'[_n2]+`var'[_n3]+`var'[_n4]+`var'[_n5])/5)
}

psmatch2 DiDg  if treatmentgroup==posttreat, pscore(psp)  common outcome(daysabs) n(5)
replace weight= _weight if _weight~=.

replace _weight=round(5*_weight)
regress daysabs $cvars if _treated==0 [fweight=_weight]

gen cdaysabs00=(daysabs[_n1]+daysabs[_n2]+daysabs[_n3]+daysabs[_n4]+daysabs[_n5])/5

foreach var of global cvars {
replace cdaysabs00=cdaysabs00+_b[`var']*(`var'-(`var'[_n1]+`var'[_n2]+`var'[_n3]+`var'[_n4]+`var'[_n5])/5)
}


replace cdaysabs10=daysabs if cdaysabs10==.
replace cdaysabs01=daysabs if cdaysabs01==.
replace cdaysabs00=daysabs if cdaysabs00==.

sum daysabs cdaysabs10 cdaysabs01 cdaysabs00 if DiDg==1
gen catt1=daysabs-cdaysabs10-cdaysabs01+cdaysabs00 if DiDg==1
quietly psmatch2 DiDg, pscore(psp)  common outcome(daysabs cdaysabs10 cdaysabs01 cdaysabs00) n(5) ai(5)
sum daysabs cdaysabs10 cdaysabs01 cdaysabs00 if DiDg==1

 
/* Now, generate ATT and ATE and their variances */

egen ntreatm=total(DiDg)

egen ntot=count(DiDg)

replace weight=weight/ntreatm

egen cattvar=total(DiDg*((daysabs-_self_daysabs)^2+(cdaysabs10-_self_cdaysabs10)^2+(cdaysabs01-_self_cdaysabs01)^2+(cdaysabs00-_self_cdaysabs00)^2)/ntreatm^2)

gen cattse=sqrt(cattvar)

gen catt=daysabs-cdaysabs10-cdaysabs01+cdaysabs00 if DiDg==1

sum catt catt1 cattse if DiDg==1
tabstat catt cattse if comsup==1&DiDg==1, stats(mean)  columns(statistics) save f(%9.3fc)
matrix define mrres=r(StatTotal)
matrix define mrres=(blres,mrres')
matrix define mrres=mrres\mres[3..4,1..2]
matrix list mrres
matrix rownames mrres = "DID" "se" "N" "NTreated"

outtable using Table3MatchReg, mat(mrres) replace caption("Difference-in-Differences Intention-to-Treat Estimation: Combined Methods") clabel(blockres) longtable 



*******************************************************************************************************************************************************************************************
***************************************************************************** TABLE 3: DID ITT ROBUSTENESS CHECKS [Raw Sample]*********************************************************************
*******************************************************************************************************************************************************************************************

*~~~~~~~*
*PANEL A*
*~~~~~~~*


*****************
*Column (1): FE*
*****************


xtreg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr) fe



********************************
*Column (2): WEIGHTED WITH IPWs*
********************************



gen part = 1 if balancedsample==1 & wave==1998
replace part = 2 if balancedsample==1 & wave==1999
replace part = 3 if balancedsample==1 & wave==2000
replace part = 4 if balancedsample==1 & wave==2001

gen participated=1 if part==1|part==2
replace participated=10 if part==3|part==4
tab participated

sort persnr wave
by persnr: egen dropped = total (participated)
tab dropped

gen nodrop=1 if (dropped==11|dropped==12|dropped==21|dropped==22)
replace nodrop=0 if (dropped==1|dropped==2|dropped==10|dropped==20)
tab nodrop, miss

probit nodrop daysabs t1998 $xvar state_2-state_16 if balancedsample==1 , cl(persnr)
predict n

reg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 [pw=1/n], cl(persnr)


***************************
*Column (3): 1997 vs. 2000*
***************************

preserve
keep if wave==1998| wave==2001
reg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)
restore


***************************
*Column (4): LAGGED DAYSABS*
***************************

reg daysabs daysabs_1 treatmentgroup posttreat DiDg t1997 t1999 $xvar state_2-state_16 if balancedsample==1 , cl(persnr)


*********************************************
*Column (5): IMPACT ON LONG-TERM ABSENTEEISM*
*********************************************

reg longabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)



*~~~~~~~*
*PANEL B*
*~~~~~~~*

*************************************
*Column (1): NO JOB CHANGE (TREATED)*
*************************************

sort persnr
by persnr: gen changedjob = sum(newjobly==1)
by persnr: replace changedjob = changedjob[_N]

sort wave
by wave: tab changedjob,  miss

preserve
drop if changedjob > 0 & treatmentgroup==1
reg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1, cl(persnr)
restore

**********************************************
*Column (2): NO POST-REFORM INDUSTRY CHANGERS*
**********************************************

preserve
drop if notchangedbranch==. & (wave==2000|wave==2001) 
reg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1, cl(persnr)
restore


*******************************************
*Column (3): NO SECTOR CHANGERS & WEIGHTED*
*******************************************

preserve
drop if sectorswitcher==1
reg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 [pw=1/n], cl(persnr)
restore

*********************************************
*Column (4): CLUSTERED AT STATE X YEAR LEVEL*
*********************************************

reg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1, cl(state_year)


************************************************
*Column (5): CLUSTERED AT INDUSTRY X YEAR LEVEL*
************************************************

reg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1, cl(nace_year)


**************************************************************
*OTHER CHECKS (results not displayed in tables, only reported*
**************************************************************

sort wave
by wave: tab newjobly if balancedsample==1
by wave: tab newjobly healthbadly if balancedsample==1, column row

by wave: tab oeffdprivate if balancedsample==1, miss
by wave: tab  selfprivate if balancedsample==1, miss


*******************************************************************************************************************************************************************************************
********************************************************** TABLE 3 + Table A5: DID ITT HETEROGENEITY CHECKS [Raw Sample]******************************************************************
*******************************************************************************************************************************************************************************************

*********************************************************************************************
************REVISION: CONTROL FOR EVERYTHING AT THE SAME TIME (6.4.2012)*********************
************2nd REVISION: USE THIS VARIANT FOR PANELS A & B + INCLUDE CHILDREN***************
*********************************************************************************************

*\\\\\\\*
*PANEL A*
*\\\\\\\*

reg daysabs treatmentgroup posttreat DiDg DiDg_sex DiDg_ageolder DiDg_richerhalf DiDg_partner DiDg_childrenly DiDg_eduhigh t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly female ageolder joblossprevyear Abi partnerly  richerhalf disabledly healthgoodly healthbadly healthsatisveryhighly healthsatislowly  disabledly nothandicappedly immigrant Eastly marriedly childrenly  nosportsly Hauptschule Realschule Fachabi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly regUnemp state_2-state_16 if balancedsample==1 , cl(persnr)

*~~~~~~*
*Shares*
*~~~~~~*

tab female if treatmentgroup==1 & balancedsample==1
tab ageolder if treatmentgroup==1 & balancedsample==1
tab richerhalf if treatmentgroup==1 & balancedsample==1
tab partnerly if treatmentgroup==1 & balancedsample==1
tab childrenly if treatmentgroup==1 & balancedsample==1
tab Abi if treatmentgroup==1 & balancedsample==1


*********************************************************************************************
*ALTERNATIVE I (results not shown in paper): SPLIT SAMPLE AND RUN REGRESSIONS ON SUBSAMPLES*
*********************************************************************************************

preserve
keep if female==0
reg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)
restore

preserve
keep if female==1
reg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)
restore

**********************************************************************************
*ALTERNATIVE II (results not shown in paper): JUST ADD ONE TRIPLE INTERACTION TERM*
**********************************************************************************

reg daysabs treatmentgroup posttreat DiDg DiDg_sex t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)
reg daysabs treatmentgroup posttreat DiDg DiDg_ageolder ageolder t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)
reg daysabs treatmentgroup posttreat DiDg DiDg_richerhalf richerhalf t1997 t1999 yearsincompanylysq yearsincompanyly_female  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)
reg daysabs treatmentgroup posttreat DiDg DiDg_partner t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)
reg daysabs treatmentgroup posttreat DiDg DiDg_childrenly t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)
reg daysabs treatmentgroup posttreat DiDg DiDg_eduhigh t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)


***********************************************************************
*ALTERNATIVE III (results not shown in paper): ADDITIONAL INTERACTIONS*
***********************************************************************

global nvar "female ageolder richerhalf partnerly children Abi healthgoodly healthbadly healthsatisveryhighly healthsatislowly nothandicappedly disabledly"

foreach n of global nvar{
gen posttreat_`n'=posttreat*`n'
gen treat_`n'=treatmentgroup*`n'
}

reg daysabs treatmentgroup posttreat DiDg DiDg_sex DiDg_ageolder DiDg_richerhalf DiDg_partner DiDg_childrenly DiDg_eduhigh DiDg_healthgood DiDg_healthbad  DiDg_healthsatisveryhighly  DiDg_healthsatislowly  DiDg_nothandicappedly DiDg_disabled t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly posttreat_female treat_female posttreat_ageolder treat_ageolder posttreat_richerhalf treat_richerhalf posttreat_partnerly treat_partnerly posttreat_children treat_children posttreat_Abi treat_Abi posttreat_healthgoodly treat_healthgoodly posttreat_healthbadly treat_healthbadly posttreat_healthsatisveryhighly treat_healthsatisveryhighly posttreat_healthsatislowly treat_healthsatislowly posttreat_nothandicappedly treat_nothandicappedly posttreat_disabledly treat_disabledly  female ageolder joblossprevyear Abi partnerly  richerhalf disabledly healthgoodly healthbadly healthsatisveryhighly healthsatislowly  disabledly nothandicappedly immigrant Eastly marriedly childrenly  nosportsly Hauptschule Realschule Fachabi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly regUnemp state_2-state_16 if balancedsample==1 , cl(persnr)
test (posttreat_female=0)  (treat_female=0) (posttreat_ageolder=0) (treat_ageolder=0) (posttreat_richerhalf=0) (treat_richerhalf=0) (posttreat_partnerly=0) (treat_partnerly=0) (posttreat_children=0) (treat_children=0) (posttreat_Abi =0) (treat_Abi=0) (posttreat_healthgoodly=0) (treat_healthgoodly=0) (posttreat_healthbadly=0) (treat_healthbadly=0) (posttreat_healthsatisveryhighly=0) (treat_healthsatisveryhighly=0) (posttreat_healthsatislowly=0) (treat_healthsatislowly=0) (posttreat_nothandicappedly=0) (treat_nothandicappedly=0) (posttreat_disabledly=0) (treat_disabledly=0) 



*\\\\\\\*
*PANEL B*
*\\\\\\\*

reg daysabs treatmentgroup posttreat DiDg DiDg_healthgood DiDg_sex DiDg_ageolder DiDg_richerhalf DiDg_partner DiDg_childrenly DiDg_eduhigh t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)
reg daysabs treatmentgroup posttreat DiDg DiDg_healthbad DiDg_sex DiDg_ageolder DiDg_richerhalf DiDg_partner DiDg_childrenly DiDg_eduhigh t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)
reg daysabs treatmentgroup posttreat DiDg DiDg_healthsatisveryhighly DiDg_sex DiDg_ageolder DiDg_richerhalf DiDg_partner DiDg_childrenly DiDg_eduhigh healthsatisveryhighly t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16, cl(persnr)
reg daysabs treatmentgroup posttreat DiDg DiDg_healthsatislowly DiDg_sex DiDg_ageolder DiDg_richerhalf DiDg_partner DiDg_childrenly DiDg_eduhigh healthsatislowly t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16, cl(persnr)
reg daysabs treatmentgroup posttreat DiDg DiDg_nothandicappedly DiDg_sex DiDg_ageolder DiDg_richerhalf DiDg_partner DiDg_childrenly DiDg_eduhigh  nothandicappedly t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)
reg daysabs treatmentgroup posttreat DiDg DiDg_disabled DiDg_sex DiDg_ageolder DiDg_richerhalf DiDg_partner DiDg_childrenly DiDg_eduhigh t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)

*~~~~~~*
*Shares*
*~~~~~~*

tab healthverygoodly if treatmentgroup==1 & balancedsample==1
tab healthbadly if treatmentgroup==1 & balancedsample==1
tab healthsatisveryhighly if treatmentgroup==1 & balancedsample==1
tab healthsatislowly if treatmentgroup==1 & balancedsample==11
tab nothandicappedly if treatmentgroup==1 & balancedsample==1
tab disabledly if treatmentgroup==1 & balancedsample==1



*********************************************************************************************
*ALTERNATIVE I (results not shown in paper): SPLIT SAMPLE AND RUN REGRESSIONS ON SUBSAMPLES*
*********************************************************************************************

preserve
keep if healthsatisveryhighly==1
reg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)
restore

***

preserve
keep if nothandicappedly==1
reg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)
restore

***

preserve
keep if healthbadly==1
reg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)
restore

gen DiDg_daysabs1=DiDg*daysabs_1
reg daysabs treatmentgroup posttreat DiDg DiDg_daysabs1 daysabs_1 t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)

 

**************************************************
*QUANTILE REGRESSION (results not shown in paper)*
**************************************************

qreg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1
qreg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1, q(0.6)
qreg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1, q(0.7)
qreg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1, q(0.8)
qreg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1, q(0.85)
qreg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1, q(0.9)
qreg daysabs treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1, q(0.95)


*\\\\\\\\\\\\\\\\\\*
*PANEL C (Table A5)*
*\\\\\\\\\\\\\\\\\\*


reg daysabs treatmentgroup posttreat DiDg DiDg_small t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly  female age agesq immigrant Eastly partnerly marriedly childrenly disabledly healthbadly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly smallcompany mediumcompany bigcompany hugecompany whitecollarly oggrosswagely regUnemp state_2-state_16 if balancedsample==1 , cl(persnr)
reg daysabs treatmentgroup posttreat DiDg DiDg_noworkcouncil2001 noworkcouncil2001 t1997 t1999 $xvar state_2-state_16 if balancedsample==1 , cl(persnr)
reg daysabs treatmentgroup posttreat DiDg DiDg_blue bluecollarly t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly female age agesq immigrant Eastly partnerly marriedly childrenly disabledly healthgoodly healthbadly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany oggrosswagely regUnemp state_2-state_16 if balancedsample==1 , cl(persnr)
reg daysabs treatmentgroup posttreat DiDg DiDg_firmlessjobsly firmlessjobsly t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)
reg daysabs treatmentgroup posttreat DiDg  DiDg_joblossexpected1999 joblossexpected1999 t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsamplevaradd98==1 , cl(persnr)
reg daysabs treatmentgroup posttreat DiDg DiDg_jobpromotionexpected1998 jobpromotionexpected1998 t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)

*~~~~~~*
*Shares*
*~~~~~~*

tab smallcompany if treatmentgroup==1 & balancedsample==1
tab noworkcouncil if treatmentgroup==1 & balancedsample==1
tab bluecollarly if treatmentgroup==1 & balancedsample==1
tab firmlessjobsly if treatmentgroup==1 & balancedsample==1
tab joblossexpected1999 if treatmentgroup==1 & balancedsample==1
tab jobpromotionexpected1998 if treatmentgroup==1 & balancedsample==1



*\\\\\\\\\\\\\\\\\\*
*PANEL D (Table A5)*
*\\\\\\\\\\\\\\\\\\*

reg daysabs treatmentgroup posttreat DiDg DiDg_noreligion1997 noreligion1997 t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsamplevaradd97==1 , cl(persnr)
reg daysabs treatmentgroup posttreat DiDg DiDg_sicknessinsurancestate1997 sicknessinsurancestate1997 t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsamplevaradd97==1 , cl(persnr)
reg daysabs treatmentgroup posttreat DiDg DiDg_sicknessinsurprivate1997 sicknessinsuranceprivate1997 t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsamplevaradd97==1 , cl(persnr)
reg daysabs treatmentgroup posttreat DiDg DiDg_drivelife1999 drivelife1999 t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsamplevaradd99==1 , cl(persnr)
reg daysabs treatmentgroup posttreat DiDg DiDg_controllife1999 controllife1999 t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsamplevaradd99==1 , cl(persnr)
reg daysabs treatmentgroup posttreat DiDg DiDg_workhard1999 workhard1999 t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly  regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsamplevaradd99==1 , cl(persnr)

tab noreligion1997 if treatmentgroup==1 & balancedsample==1
tab sicknessinsurancestate1997 if treatmentgroup==1 & balancedsample==1
tab sicknessinsuranceprivate1997 if treatmentgroup==1 & balancedsample==1
tab drivelife1999 if treatmentgroup==1 & balancedsample==1
tab controllife1999  if treatmentgroup==1 & balancedsample==1
tab workhard1999 if treatmentgroup==1 & balancedsample==1


*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
*Roughly assess potential share of shirkers/people with presenteeism behavior (not shown in paper)*
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*

sum daysabs if treatmentgroup==1 & balancedsample==1

count if female==0 & partnerly==1 & drivelife1999==1  & treatmentgroup==1 & balancedsample==1
count if female==0 & partnerly==1 & controllife1999==1  & treatmentgroup==1 & balancedsample==1
count if (healthbadly==1| healthsatislowly==1 | disabledly==1)  & treatmentgroup==1 & balancedsample==1


****************************************************************************************************************************************************************************************
*********************************************ESTIMATE IMPACT ON HEALTH STATUS, JOB SATISFACTION AND WORKPLACE CLIMATE: TABLE 4**************************************************
****************************************************************************************************************************************************************************************

*********************************
*FULL SAMPLE: PANEL A OF TABLE 4*
*********************************


reg healthbadly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsample==1, cl(persnr)
reg healthsatislowly      treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsample==1 , cl(persnr)
reg severelyhandicappedly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsample==1 , cl(persnr)

*****NEW: REVISION JAE 8.4.2012******

reg lifesatislowly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsample==1 , cl(persnr)


*****NEW: 2nd REVISION JAE 18.8.2012: discard small companies since they might have been affected by a dismissal protection reform in 1999*****

preserve

drop if onemanfirm==1
drop if smallcompany==1

reg worksatislowly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg worksatisveryhighly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg joblossprevyear treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16 if (balancedsampleII==1 & overtime>=0 & overtime<=.) , cl(persnr)
reg overtime daysabs treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg overtimeunpaid daysabs treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg overtimepaid daysabs treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg overtimeflexibel daysabs treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg oggrosswagely treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly healthgoodly healthbadly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly regUnemp state_2-state_16  if (balancedsampleII==1 & overtime>=0 & overtime<=.) , cl(persnr)

restore



*******************************************
*MANY PRE-ABSENCE DAYS: PANEL B OF TABLE 4*
*******************************************

gen manyabsencedaysypre=1 if (daysabs >20 & posttreat==0) 

*~~~~~~~~~~~~~~~~~~~~~~~~~~~*
*Take balanced sample: begin*
*~~~~~~~~~~~~~~~~~~~~~~~~~~~*

sort persnr wave
by persnr: gen wlongabsvalid = sum(daysabs<.)
by persnr: replace wlongabsvalid = wlongabsvalid[_N]
sort wave
by wave: tab wlongabsvalid,  miss

preserve

keep if wlongabsvalid==4 

sort persnr wave
by persnr: gen prebadbalanced = sum(manyabsencedaysypre)
by persnr: replace prebadbalanced = prebadbalanced[_N]
tab prebadbalanced


keep if prebadbalanced==1 | prebadbalanced==2

*~~~~~~~~~~~~~~~~~~~~~~~~~*
*Take balanced sample: end*
*~~~~~~~~~~~~~~~~~~~~~~~~~*


reg healthbadly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsample==1, cl(persnr)
reg healthsatislowly      treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsample==1 , cl(persnr)
reg severelyhandicappedly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsample==1 , cl(persnr)

*****NEW: REVISION JAE 8.4.2012******

reg lifesatislowly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsample==1 , cl(persnr)


*****NEW: 2nd REVISION JAE 18.8.2012: discard small companies since they might have been affected by a dismissal protection reform in 1999*****

drop if onemanfirm==1
drop if smallcompany==1

reg worksatislowly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg worksatisveryhighly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg joblossprevyear treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16 if (balancedsampleII==1 & overtime>=0 & overtime<=.) , cl(persnr)
reg overtime daysabs treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg overtimeunpaid daysabs treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg overtimepaid daysabs treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg overtimeflexibel daysabs treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg oggrosswagely treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly healthgoodly healthbadly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly regUnemp state_2-state_16  if (balancedsampleII==1 & overtime>=0 & overtime<=.) , cl(persnr)


restore 


drop  manyabsencedaysypre wlongabsvalid




******************************************
*Few PRE-ABSENCE DAYS: PANEL C OF TABLE 4*
******************************************

gen fewabsencedaysypre=1 if (daysabs <6 & posttreat==0) 


*~~~~~~~~~~~~~~~~~~~~~~~~~~~*
*Take balanced sample: begin*
*~~~~~~~~~~~~~~~~~~~~~~~~~~~*

sort persnr wave
by persnr: gen wlongabsvalid = sum(daysabs<.)
by persnr: replace wlongabsvalid = wlongabsvalid[_N]
sort wave
by wave: tab wlongabsvalid,  miss

sort persnr wave
by persnr: gen prebadbalanced = sum(fewabsencedaysypre)
by persnr: replace prebadbalanced = prebadbalanced[_N]
tab prebadbalanced

preserve

keep if wlongabsvalid==4 

keep if prebadbalanced==1 | prebadbalanced==2

*~~~~~~~~~~~~~~~~~~~~~~~~~~
*Take balanced sample: end
*~~~~~~~~~~~~~~~~~~~~~~~~~~


reg healthbadly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsample==1, cl(persnr)
reg healthsatislowly      treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsample==1 , cl(persnr)
reg severelyhandicappedly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsample==1 , cl(persnr)

*****NEW: REVISION JAE 8.4.2012******

reg lifesatislowly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsample==1 , cl(persnr)

*****NEW: 2nd REVISION JAE 18.8.2012: discard small companies since they might have been affected by a dismissal protection reform in 1999*****

drop if onemanfirm==1
drop if smallcompany==1

reg worksatislowly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg worksatisveryhighly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)

reg joblossprevyear treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16 if (balancedsampleII==1 & overtime>=0 & overtime<=.) , cl(persnr)
reg overtime daysabs treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg overtimeunpaid daysabs treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg overtimepaid daysabs treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg overtimeflexibel daysabs treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg oggrosswagely treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly healthgoodly healthbadly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly regUnemp state_2-state_16  if (balancedsampleII==1 & overtime>=0 & overtime<=.) , cl(persnr)


restore 

drop  fewabsencedaysypre wlongabsvalid prebadbalanced






********************************************************************************************
*ROBUSTNESS CHECK (not shown in paper): BY PRE-REFORM HEALTH STATUS INSTEAD OF ABSENCE DAYS*
********************************************************************************************


*******************
*A. PRE-BAD HEALTH
******************

gen healthbadlypre=1 if healthbadly==1 & posttreat==0

*~~~~~~~~~~~~~~~~~~~~~~~~~~~*
*Take balanced sample: begin*
*~~~~~~~~~~~~~~~~~~~~~~~~~~~*

sort persnr wave
by persnr: gen wlongabsvalid = sum(daysabs<.)
by persnr: replace wlongabsvalid = wlongabsvalid[_N]
sort wave
by wave: tab wlongabsvalid,  miss

preserve

keep if wlongabsvalid==4 

sort persnr wave
by persnr: gen prebadbalanced = sum(healthbadlypre)
by persnr: replace prebadbalanced = prebadbalanced[_N]
keep if prebadbalanced==1 | prebadbalanced==2

*~~~~~~~~~~~~~~~~~~~~~~~~~~
*Take balanced sample: end*
*~~~~~~~~~~~~~~~~~~~~~~~~~~



reg healthbadly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsample==1, cl(persnr)
reg healthsatislowly      treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsample==1 , cl(persnr)
reg severelyhandicappedly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsample==1 , cl(persnr)

*****NEW: REVISION JAE 8.4.2012******

reg lifesatislowly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsample==1 , cl(persnr)

********EMPLOYER SIDE**********

*****NEW: 2nd REVISION JAE 18.8.2012: discard small companies since they might have been affected by a dismissal protection reform in 1999*****

drop if onemanfirm==1
drop if smallcompany==1

reg worksatislowly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg joblossprevyear treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16 if (balancedsampleII==1 & overtime>=0 & overtime<=.) , cl(persnr)
reg overtime daysabs treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg overtimepaid daysabs treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg overtimeflexibel daysabs treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg oggrosswagely treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly healthgoodly healthbadly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly regUnemp state_2-state_16  if (balancedsampleII==1 & overtime>=0 & overtime<=.) , cl(persnr)


restore 

drop  healthbadlypre wlongabsvalid




********************
* B. PRE-GOOD HEALTH
********************

gen healthgoodlypre=1 if healthgoodly==1 & posttreat==0



*~~~~~~~~~~~~~~~~~~~~~
*Take balanced sample
*~~~~~~~~~~~~~~~~~~~~~

sort persnr wave
by persnr: gen wlongabsvalid = sum(daysabs<.)
by persnr: replace wlongabsvalid = wlongabsvalid[_N]
sort wave
by wave: tab wlongabsvalid,  miss


preserve

keep if wlongabsvalid==4 

sort persnr wave
by persnr: gen pregoodbalanced = sum(healthgoodlypre)
by persnr: replace pregoodbalanced = pregoodbalanced[_N]
keep if pregoodbalanced==1 | pregoodbalanced==2


*~~~~~~~~~~~~~~~~~~~~~
*Take balanced sample
*~~~~~~~~~~~~~~~~~~~~~


reg healthbadly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsample==1, cl(persnr)
reg healthsatislowly      treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsample==1 , cl(persnr)
reg severelyhandicappedly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsample==1 , cl(persnr)

*****NEW: REVISION JAE 8.4.2012******

reg lifesatislowly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsample==1 , cl(persnr)

********EMPLOYER SIDE**********

*****NEW: 2nd REVISION JAE 18.8.2012: discard small companies since they might have been affected by a dismissal protection reform in 1999*****

drop if onemanfirm==1
drop if smallcompany==1

reg worksatislowly treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg joblossprevyear treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16 if (balancedsampleII==1 & overtime>=0 & overtime<=.) , cl(persnr)
reg overtime daysabs treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly  oggrosswagely regUnemp state_2-state_16  if balancedsampleII==1 & overtime<=., cl(persnr)
reg oggrosswagely treatmentgroup posttreat DiDg t1997 t1999 female age agesq immigrant Eastly partnerly marriedly childrenly disabledly healthgoodly healthbadly nosportsly Hauptschule Realschule Fachabi Abi otherdegree erljobly newjobly yearsincompanyly mediumcompany bigcompany hugecompany whitecollarly regUnemp state_2-state_16  if (balancedsampleII==1 & overtime>=0 & overtime<=.) , cl(persnr)

restore 



*********************************************************
* Has healthcare been affected (Robust Check, not shown)
*********************************************************


*Need to drop 1999 since questions refers to last 3 months and can't distinguish pre-/post-reform in 1998

preserve
drop if wave==2000
reg nodoctorlqy treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 ,cl(persnr)
reg numberdoctorlqy treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)
restore

reg hospitalstay treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)
reg nightsinhospital treatmentgroup posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(persnr)





****************************************************************************************************************************************************************************************
**********************************************************DID ATT ESTIMTES--INDUSTRY COMPLIANCE APPROACH: TABLE 2***********************************************************************
****************************************************************************************************************************************************************************************

*******************************
*GENERATE TREATMENT INDICATORS*
*******************************


gen cut3daysII=.
replace cut3daysII=1 if nace==1|nace==45 & treatmentgroup==1
replace cut3daysII=0 if treatmentgroup==1 & [(nace==10 & Eastly==0) | (nace==55 & Eastly==0) | nace==22 | nace==24 | nace==26 | nace==64 | nace==65 | nace==67]
tab cut3daysII, miss
sort year
by year: tab cut3daysII


gen cut3daysII_year=1 if cut3daysII==0 & wave==1998
replace cut3daysII_year=2 if cut3daysII==1 & wave==1998
replace cut3daysII_year=3 if cut3daysII==0 & wave==1999 
replace cut3daysII_year=4 if cut3daysII==1 & wave==1999
replace cut3daysII_year=5 if cut3daysII==0 & wave==2000
replace cut3daysII_year=6 if cut3daysII==1 & wave==2000
replace cut3daysII_year=7 if cut3daysII==0 & wave==2001
replace cut3daysII_year=8 if cut3daysII==1 & wave==2001

gen cut3daysIII=.
replace cut3daysIII=1 if nace==1|nace==45 & treatmentgroup==1
replace cut3daysIII=0 if treatmentgroup==1 & (nace==10 & Eastly==0) | (nace==55 & Eastly==0) | nace==22 | nace==24 | nace==26 | nace==64 | nace==65 | nace==67
replace cut3daysIII=2 if treatmentgroup==0
tab cut3daysIII, gen(grpIII)

gen cut3daysIII_year=1 if cut3daysIII==0 & wave==1998
replace cut3daysIII_year=2 if cut3daysIII==1 & wave==1998
replace cut3daysIII_year=3 if cut3daysIII==2 & wave==1998
replace cut3daysIII_year=4 if cut3daysIII==0 & wave==1999 
replace cut3daysIII_year=5 if cut3daysIII==1 & wave==1999
replace cut3daysIII_year=6 if cut3daysIII==2 & wave==1999
replace cut3daysIII_year=7 if cut3daysIII==0 & wave==2000
replace cut3daysIII_year=8 if cut3daysIII==1 & wave==2000
replace cut3daysIII_year=9 if cut3daysIII==2 & wave==2000
replace cut3daysIII_year=10 if cut3daysIII==0 & wave==2001
replace cut3daysIII_year=11 if cut3daysIII==1 & wave==2001
replace cut3daysIII_year=12 if cut3daysIII==2 & wave==2001

gen didneuII=0
replace didneuII=1-0.3172 if cut3daysII==0 & year==1997
replace didneuII=1-0.3348 if cut3daysII==0 & year==1998
replace didneuII=1 if cut3daysII==1 & year==1998
replace didneuII=1 if cut3daysII==1 & year==1997
tab didneuII


gen didneuIII=0
replace didneuIII=1-0.3172 if cut3daysIII==0 & year==1997
replace didneuIII=1-0.3348 if cut3daysIII==0 & year==1998
replace didneuIII=1 if cut3daysIII==1 & year==1998
replace didneuIII=1 if cut3daysIII==1 & year==1997
replace didneuIII=0 if treatmentgroup==0
tab didneuIII

replace cut3daysII=. if treatmentgroup==0


*****************************
*TABLE 3: Columns (1) to (4)*
*****************************

***INTENDED***

reg daysabs grpIII1-grpIII3 posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1, cl(cut3daysIII_year) 
xtreg daysabs grpIII1-grpIII3 posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1, cl(cut3daysIII_year) fe nonest

***Implemented***

reg daysabs grpIII1-grpIII3 posttreat didneuIII t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1, cl(cut3daysIII_year) 
xtreg daysabs grpIII1-grpIII3 posttreat didneuIII t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(cut3daysIII_year) fe nonest


*****************************
*TABLE 3: Columns (5) to (8)*
*****************************

***INTENDED: Is a simple before-after: DiDg not indentified***

reg daysabs cut3daysII posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1, cl(cut3daysII_year)
xtreg daysabs cut3daysII posttreat DiDg t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1, cl(cut3daysII_year) fe nonest

***Implemented***

reg daysabs cut3daysII posttreat didneuII t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(cut3daysII_year) 
xtreg daysabs cut3daysII posttreat didneuII t1997 t1999 yearsincompanylysq yearsincompanyly_female yearsincompanyly_erljobly regUnempsq oggrosswagelysq  oggrosswagely_female oggrosswagely_whitecollarly oggrosswagely_Abi oggrosswagely_marriedly $xvar state_2-state_16 if balancedsample==1 , cl(cut3daysII_year) fe nonest

*******************************************************************************************************************************************************************************************

des

log close 
