version 10.1
clear all
set more off
se memory 500m
set matsize 800
       
cd "D:\CUSTOMIZE PATH\"
capture log close
log using JAE_LaborCostIncrease.log, text replace

use "D:\CUSTOMIZE PATH\JAE_LaborCostIncrease.dta"

cd "D:\CUSTOMIZE PATH"

set scrollbufsize 50000

*#delimit;


****

gen nphrfII=round(nphrf)
gen ophrfII=round(ophrf)
gen pphrfII=round(pphrf)
gen qphrfII=round(qphrf)
gen rphrfII=round(rphrf)

***

sum daysabs [fw=ophrfII] if  treatmentgroup==1  & wave==1998
scalar Daysabs_97N=r(N)
display Daysabs_97N
scalar Daysabs_97m=r(mean)
scalar Daysabs_97=Daysabs_97m* Daysabs_97N
display Daysabs_97

sum daysabs [fw=pphrfII] if  treatmentgroup==1  & wave==1999
scalar Daysabs_98N=r(N)
display Daysabs_98N
scalar Daysabs_98m=r(mean)
scalar Daysabs_98=Daysabs_98m* Daysabs_98N
display Daysabs_98

sum daysabs [fw=qphrfII] if  treatmentgroup==1  & wave==2000
scalar Daysabs_99N=r(N)
display Daysabs_99N
scalar Daysabs_99m=r(mean)
scalar Daysabs_99=Daysabs_99m* Daysabs_99N
display Daysabs_99

sum daysabs [fw=rphrfII] if  treatmentgroup==1  & wave==2001
scalar Daysabs_00N=r(N)
display Daysabs_00N
scalar Daysabs_00m=r(mean)
scalar Daysabs_00=Daysabs_00m* Daysabs_00N
display Daysabs_00

gen oggrosswagely_day=oggrosswagely/30


***

sum oggrosswagely_day [fw=ophrfII] if  treatmentgroup==1  & wave==1998
scalar Wageday_97N=r(N)
display Wageday_97N
scalar Wageday_97m=r(mean)
scalar Wageday_97=Wageday_97m* Wageday_97N
display Wageday_97

sum oggrosswagely_day [fw=pphrfII] if  treatmentgroup==1  & wave==1999
scalar Wageday_98N=r(N)
display Wageday_98N
scalar Wageday_98m=r(mean)
scalar Wageday_98=Wageday_98m* Wageday_98N
display Wageday_98

sum oggrosswagely_day [fw=qphrfII] if  treatmentgroup==1  & wave==2000
scalar Wageday_99N=r(N)
display Wageday_99N
scalar Wageday_99m=r(mean)
scalar Wageday_99=Wageday_99m*Wageday_99N
display Wageday_99

sum oggrosswagely_day [fw=rphrfII] if  treatmentgroup==1  & wave==2001
scalar Wageday_00N=r(N)
display Wageday_00N
scalar Wageday_00m=r(mean)
scalar Wageday_00=Wageday_00m* Wageday_00N
display Wageday_00


gen LFZ_pre=daysabs*oggrosswagely_day*0.8 if longabs!=1 
replace LFZ_pre=42*oggrosswagely_day*0.8 if longabs==1 

sum LFZ_pre [fw=ophrfII] if  treatmentgroup==1  & wave==1998
scalar LFZ_pre97N=r(N)
display LFZ_pre97N
scalar LFZ_pre97m=r(mean)
scalar LFZ_pre97=LFZ_pre97m* LFZ_pre97N
display LFZ_pre97

sum LFZ_pre [fw=pphrfII] if  treatmentgroup==1  & wave==1999
scalar LFZ_pre98N=r(N)
display LFZ_pre98N
scalar LFZ_pre98m=r(mean)
scalar LFZ_pre98=LFZ_pre98m* LFZ_pre98N
display LFZ_pre98

sum LFZ_pre [fw=qphrfII] if  treatmentgroup==1  & wave==2000
scalar LFZ_pre99N=r(N)
display LFZ_pre99N
scalar LFZ_pre99m=r(mean)
scalar LFZ_pre99=LFZ_pre99m* LFZ_pre99N
display LFZ_pre99


gen LFZ_post=daysabs*oggrosswagely_day if longabs!=1
replace LFZ_post=42*oggrosswagely_day if longabs==1 


***

sum LFZ_post [fw=ophrfII] if  treatmentgroup==1  & wave==1998
scalar LFZ_post97N=r(N)
display LFZ_post97N
scalar LFZ_post97m=r(mean)
scalar LFZ_post97=LFZ_post97m* LFZ_post97N
display LFZ_post97

sum LFZ_post [fw=pphrfII] if  treatmentgroup==1  & wave==1999
scalar LFZ_post98N=r(N)
display LFZ_post98N
scalar LFZ_post98m=r(mean)
scalar LFZ_post98=LFZ_post98m* LFZ_post98N
display LFZ_post98

sum LFZ_post [fw=qphrfII] if  treatmentgroup==1  & wave==2000
scalar LFZ_post99N=r(N)
display LFZ_post99N
scalar LFZ_post99m=r(mean)
scalar LFZ_post99=LFZ_post99m* LFZ_post99N
display LFZ_post99

sum LFZ_post [fw=rphrfII] if  treatmentgroup==1  & wave==2001
scalar LFZ_post00N=r(N)
display LFZ_post00N
scalar LFZ_post00m=r(mean)
scalar LFZ_post00=LFZ_post00m* LFZ_post00N
display LFZ_post00


************************************************************************************************************************************************
*********************************************************TOTAL LABOR COST INCREASE***************************************************************
************************************************************************************************************************************************


scalar LFZ_pre9798= LFZ_pre97 + LFZ_pre98
display LFZ_pre9798
scalar LFZ_post9900= LFZ_post99 + LFZ_post00
display LFZ_post9900

scalar LFZ_increasetotal=LFZ_pre9798-LFZ_post9900
display LFZ_increasetotal



************************************************************************************************************************************************
*********************************************************REPLACEMENT RATE EFFECT*****************************************************************
************************************************************************************************************************************************


scalar LFZ_increase97=(LFZ_pre97m-LFZ_post97m)* LFZ_post97N
display LFZ_increase97

scalar LFZ_increase98=(LFZ_pre98m-LFZ_post98m)* LFZ_post98N
display LFZ_increase98

scalar LFZ_increase= LFZ_increase97 + LFZ_increase98
display LFZ_increase



*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
*The following should be equivalent to the above calculations
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*


scalar LFZ_increase97=(LFZ_pre97m-LFZ_post97m)* LFZ_pre97N
display LFZ_increase97

scalar LFZ_increase98=(LFZ_pre98m-LFZ_post98m)* LFZ_pre98N
display LFZ_increase98

scalar LFZ_increase= LFZ_increase97+ LFZ_increase98
display LFZ_increase




************************************************************************************************************************************************
************************************************************SICK LEAVE EFFECT ********************************************************************
************************************************************************************************************************************************

*********************************************************************************************************************************************
***********************************Use Estimation Sample to Calculate Labor Cost Increase Due to Increase in Absenteeism************************************
****************************************************(otherwise overestimation of effects)************************************************************
*********************************************************************************************************************************************


preserve

keep if employmentstatusly==1
drop if age>55
drop if age<25
****
drop if balancedsample!=1 
***

*drop if longabs==1

* ACHTUNG: ganz strenggenommen msste ich dasselbe sample wir bei der SChtzung der Reformeffekte nehmen, d.h. ohne alle, die irgendwann einmal einen longabs-spell hatten; dass kann ich aber zumindest nicht 
* oben machen, da ich erst einmal alle brauche, um die Gesamtreformeffekte zu schtzen.
* Auerdem: eigentlich msste ich hier das balancedsample nehmen


sum LFZ_pre [fw=ophrfII] if  treatmentgroup==1  & wave==1998
scalar LFZ_pre97N=r(N)
display LFZ_pre97N
scalar LFZ_pre97m=r(mean)
scalar LFZ_pre97=LFZ_pre97m* LFZ_pre97N
display LFZ_pre97

sum LFZ_pre [fw=pphrfII] if  treatmentgroup==1  & wave==1999
scalar LFZ_pre98N=r(N)
display LFZ_pre98N
scalar LFZ_pre98m=r(mean)
scalar LFZ_pre98=LFZ_pre98m* LFZ_pre98N
display LFZ_pre98

sum LFZ_pre [fw=qphrfII] if  treatmentgroup==1  & wave==2000
scalar LFZ_pre99N=r(N)
display LFZ_pre99N
scalar LFZ_pre99m=r(mean)
scalar LFZ_pre99=LFZ_pre99m* LFZ_pre99N
display LFZ_pre99

sum LFZ_pre [fw=rphrfII] if  treatmentgroup==1  & wave==2001
scalar LFZ_pre00N=r(N)
display LFZ_pre00N
scalar LFZ_pre00m=r(mean)
scalar LFZ_pre00=LFZ_pre00m* LFZ_pre00N
display LFZ_pre00

***

sum LFZ_post [fw=ophrfII] if  treatmentgroup==1  & wave==1998
scalar LFZ_post97N=r(N)
display LFZ_post97N
scalar LFZ_post97m=r(mean)
scalar LFZ_post97=LFZ_post97m* LFZ_post97N
display LFZ_post97

sum LFZ_post [fw=pphrfII] if  treatmentgroup==1  & wave==1999
scalar LFZ_post98N=r(N)
display LFZ_post98N
scalar LFZ_post98m=r(mean)
scalar LFZ_post98=LFZ_post98m* LFZ_post98N
display LFZ_post98

sum LFZ_post [fw=qphrfII] if  treatmentgroup==1  & wave==2000
scalar LFZ_post99N=r(N)
display LFZ_post99N
scalar LFZ_post99m=r(mean)
scalar LFZ_post99=LFZ_post99m* LFZ_post99N
display LFZ_post99

sum LFZ_post [fw=rphrfII] if  treatmentgroup==1  & wave==2001
scalar LFZ_post00N=r(N)
display LFZ_post00N
scalar LFZ_post00m=r(mean)
scalar LFZ_post00=LFZ_post00m* LFZ_post00N
display LFZ_post00

***

sum daysabs [fw=ophrfII] if  treatmentgroup==1  & wave==1998
scalar Daysabs_97N=r(N)
display Daysabs_97N
scalar Daysabs_97m=r(mean)
scalar Daysabs_97=Daysabs_97m* Daysabs_97N
display Daysabs_97

sum daysabs [fw=pphrfII] if  treatmentgroup==1  & wave==1999
scalar Daysabs_98N=r(N)
display Daysabs_98N
scalar Daysabs_98m=r(mean)
scalar Daysabs_98=Daysabs_98m* Daysabs_98N
display Daysabs_98

sum daysabs [fw=qphrfII] if  treatmentgroup==1  & wave==2000
scalar Daysabs_99N=r(N)
display Daysabs_99N
scalar Daysabs_99m=r(mean)
scalar Daysabs_99=Daysabs_99m* Daysabs_99N
display Daysabs_99

sum daysabs [fw=rphrfII] if  treatmentgroup==1  & wave==2001
scalar Daysabs_00N=r(N)
display Daysabs_00N
scalar Daysabs_00m=r(mean)
scalar Daysabs_00=Daysabs_00m* Daysabs_00N
display Daysabs_00

***

sum oggrosswagely_day [fw=ophrfII] if  treatmentgroup==1  & wave==1998
scalar Wageday_97N=r(N)
display Wageday_97N
scalar Wageday_97m=r(mean)
scalar Wageday_97=Wageday_97m* Wageday_97N
display Wageday_97

sum oggrosswagely_day [fw=pphrfII] if  treatmentgroup==1  & wave==1999
scalar Wageday_98N=r(N)
display Wageday_98N
scalar Wageday_98m=r(mean)
scalar Wageday_98=Wageday_98m* Wageday_98N
display Wageday_98

sum oggrosswagely_day [fw=qphrfII] if  treatmentgroup==1  & wave==2000
scalar Wageday_99N=r(N)
display Wageday_99N
scalar Wageday_99m=r(mean)
scalar Wageday_99=Wageday_99m* Wageday_99N
display Wageday_99

sum oggrosswagely_day [fw=rphrfII] if  treatmentgroup==1  & wave==2001
scalar Wageday_00N=r(N)
display Wageday_00N
scalar Wageday_00m=r(mean)
scalar Wageday_00=Wageday_00m* Wageday_00N
display Wageday_00

***

scalar premeanLFZ9798= (LFZ_pre97m + LFZ_pre98m)/2
display premeanLFZ9798
scalar premeanLFZ9900= (LFZ_pre99m + LFZ_pre00m)/2
display premeanLFZ9900

scalar postmeanLFZ9798= (LFZ_post97m + LFZ_post98m)/2
display postmeanLFZ9798
scalar postmeanLFZ9900= (LFZ_post99m + LFZ_post00m)/2
display postmeanLFZ9900

***

scalar premeanN=(LFZ_pre97N + LFZ_pre98N)/2
display premeanN
scalar postmeanN=(LFZ_pre99N + LFZ_pre00N)/2
display postmeanN

scalar preDaysabs= (Daysabs_97m + Daysabs_98m)/2
display preDaysabs
scalar postDaysabs= (Daysabs_99m + Daysabs_00m)/2
display postDaysabs

scalar preWageday= (Wageday_97m + Wageday_98m)/2
display preWageday
scalar postWageday= (Wageday_99m + Wageday_00m)/2
display postWageday


**********************************************************************************************************************************************


scalar laborcostincrease=(1* preWageday*0.8)*premeanN
display laborcostincrease

scalar laborcostincrease=(1* preWageday*0.8)*postmeanN
display laborcostincrease


***Robustness Checks***

scalar laborcostincrease=(0.9* preWageday*0.8)*premeanN
display laborcostincrease

scalar laborcostincrease=(0.9* preWageday*0.8)*postmeanN
display laborcostincrease

***

scalar laborcostincrease=(1.1* preWageday*0.8)*premeanN
display laborcostincrease

scalar laborcostincrease=(1.1* preWageday*0.8)*postmeanN
display laborcostincrease

restore 


**********************************************************************************************************************************************
**********************************************************************************************************************************************
******************************ROBUSTNESS CHECK USING EMPLOYMENT DATA FROM THE FEDERAL STATISTICAL OFFICE******************************************
**********************************************************************************************************************************************
**********************************************************************************************************************************************


scalar LFZ_pre97des=LFZ_pre97m* 20547100
display LFZ_pre97des

scalar LFZ_pre98des=LFZ_pre98m* 20538600
display LFZ_pre98des

scalar LFZ_pre99des=LFZ_pre99m* 20863000
display LFZ_pre99des

scalar LFZ_pre00des=LFZ_pre00m* 21352586
display LFZ_pre00des

****

scalar LFZ_post97des=LFZ_post97m* 20547100
display LFZ_post97des

scalar LFZ_post98des=LFZ_post98m* 20538600
display LFZ_post98des

scalar LFZ_post99des=LFZ_post99m* 20863000
display LFZ_post99des

scalar LFZ_post00des=LFZ_post00m*21352586 
display LFZ_post00des

**

scalar LFZ_pre9798des= LFZ_pre97des + LFZ_pre98des
display LFZ_pre9798des
scalar LFZ_post9900des= LFZ_post99des + LFZ_post00des
display LFZ_post9900des


************************************************************************************************************************************************
*********************************************************TOTAL LABOR COST INCREASE***************************************************************
************************************************************************************************************************************************



scalar LFZ_increasetotal=LFZ_pre9798des-LFZ_post9900des
display LFZ_increasetotal


************************************************************************************************************************************************
*********************************************************REPLACEMENT RATE EFFECT*****************************************************************
************************************************************************************************************************************************


scalar LFZ_increase97des=(LFZ_pre97m-LFZ_post97m)* 20547100
display LFZ_increase97des

scalar LFZ_increase98des=(LFZ_pre98m-LFZ_post98m)* 20538600
display LFZ_increase98des

scalar LFZ_increasedes= LFZ_increase97des + LFZ_increase98des
display LFZ_increasedes


************************************************************************************************************************************************
************************************************************SICK LEAVE EFFECT ********************************************************************
************************************************************************************************************************************************


scalar LFZ_pre97des=LFZ_pre97m*(20768400-1940800-3620300)
display LFZ_pre97des

scalar LFZ_pe98des=LFZ_pre98m*(20966900-1865600-3784900)
display LFZ_pre98des


*The first number in parentheses represents all gainfully employed ("Sozialversicherungspflichtig Beschftigte"); 
* the second number are public employees and the third part-time employees


scalar LFZ_pre99des=LFZ_pre99m* (21050432-1355424-3672301)
display LFZ_pre99des

scalar LFZ_pre00des=LFZ_pre00m* (21383313-1354841-3925690)
display LFZ_pre00des

***

scalar LFZ_post97des=LFZ_post97m*(20768400-1940800-3620300)
display LFZ_post97des

scalar LFZ_post98des=LFZ_post98m*(20966900-1865600-3784900)
display LFZ_post98des

scalar LFZ_post99des=LFZ_post99m* (21050432-1355424-3672301)
display LFZ_post99des

scalar LFZ_post00des=LFZ_post00m* (21383313-1354841-3925690)
display LFZ_post00des

***

scalar Wageday_97des=Wageday_97m*(20768400-1940800-3620300)
display Wageday_97des

scalar Wageday_98des=Wageday_98m*(20966900-1865600-3784900)
display Wageday_98des

scalar Wageday_99des=Wageday_99m*(21050432-1355424-3672301)
display Wageday_99des

scalar Wageday_00des=Wageday_00m*(21383313-1354841-3925690)
display Wageday_00des

****

scalar premeanNdes=((20768400-1940800-3620300) +(20966900-1865600-3784900))/2
display premeanNdes
scalar postmeanNdes=((21050432-1355424-3672301) + (21383313-1354841-3925690))/2
display postmeanNdes

****

scalar laborcostincrease=(1* preWageday*0.8)*premeanNdes
display laborcostincrease

scalar laborcostincrease=(1* preWageday*0.8)*postmeanNdes
display laborcostincrease

**********************************************************************************************************************************************

log close 
