function [A,egls,Z,S] = varestim_gls2(X,p,regime0)
%%% GLS estimation of VAR when the model has m variance regimes 
%%% 'regime' is a T by 1 vector

[T,k]        = size(X);

%%% OLS estimation
Z            = ones(T-p,1);
for j=1:p
    Z        = [Z X(p+1-j:T-j,:)]; 
end
Y            = X(p+1:T,:);
Aols         = (Z'*Z)\(Z'*Y);
e            = Y-Z*Aols;

%%% covariance matrix construction
regime       = regime0(p+1:end,1);
regime_label = unique(regime);
m            = length(regime_label);
S            = zeros((T-p)*k,(T-p)*k);
for j=1:m
 Tj          = sum(regime==regime_label(j));
 ej          = e(regime==regime_label(j),:);
 Sj          = (ej'*ej/Tj);
 for t=1:T-p
  if regime(t,1)==j
    S((t-1)*k+1:t*k,(t-1)*k+1:t*k)=Sj;
  end
 end
end

%%% GLS estimation
Ypr          = Y';
Aglsvec      = (kron(Z',eye(k))/S*kron(Z,eye(k)))\kron(Z',eye(k))/S*Ypr(:);
Aglstrans    = reshape(Aglsvec,[k,p*k+1]);
Agls         = Aglstrans';
A            = Agls(2:end,:);
egls         = Y-Z*Agls;




