function Y=bootvar2(T,Ah,p,S,eh,regime)

k            = size(S,2);
eh           = eh-ones(size(eh,1),1)*mean(eh);

if p==0
    S        = zeros(T,k);
    Ah       = zeros(k,k);
end

Y            = zeros(T,k);
Y(1:p,:)     = S(1:p,:);
Si           = flipud(S(1:p,:));
LS           = reshape(Si',1,k*p);

eb           = zeros(size(eh));
regime_label = unique(regime);
m            = length(regime_label);

for j = 1:m
 Tj          = sum(regime == regime_label(j));
 temp        = eh(regime == regime_label(j),:);
 i           = ceil(Tj*rand(Tj,1));
 eb(regime==regime_label(j),:) = temp(i,:);
end

for t=p+1:T
    Yt       = LS*Ah + eb(t-p,:);
    LS       = [Yt LS(:,1:end-k)];
    Y(t,:)   = Yt;
end
