/*********************************************************************/
* This file runs the first-stage OLS price regressions for nearest-
* neighbor model and saves the residuals and data for use in the 
* second-stage duration model.
*
* The instruments are: Percent of Preserved Land
*                      Percentage of Undeveloped Area
*                      Zoned Lot Capacity  
*
* Author: Douglas H. Wrenn
* Date:   07-29-2016
/*********************************************************************/

* Set drive
	clear all
	cd "...\JAE Data Archive"
	
* Run Loop for the first-OLS models
	* Loop estimates the models, generates F-statistics, generates residuals, and
	* merges with the second-stage duration data. The loop is based on 8-12 nearest
	* neighbor cutoffs
	qui{ 
	foreach d of numlist 8 9 10 11 12{
	
		* Read first-stage data
		import delimited using "First_Stage_OLS_Data", clear
	
		* Set IV variables
		global priceivs prespercent_fe_`d'nn udarea_fe_`d'nn zndltqnt_ct_fe_`d'nn
		
		* Run price regression
		noi reg houseprices1k constant prespercent udarea zndltqnt_ct ///
		apprvltqnt landprices1k $priceivs i.timeprd carrind harfind, nocon
		
		* Perform F-test 
		noi test $priceivs
		
		* Generates residuals
		predict confunc_p, r
		gen confunc_p2 = confunc_p^2
		keep fe confunc_p confunc_p2 $priceivs
		
		* Save control data
		save "Control_Data", replace
		
		* Read second-stage duration data
		import delimited using "Second_Stage_Duration_Data", clear
		
		* Merge with first-stage control data
		merge m:1 fe using "Control_Data"
		drop _merge

		* Save 
		save "Second_Stage_Duration_Data_`d'_NearN", replace
			
}
}

* Erase control data
	erase "Control_Data.dta"
