/*********************************************************************/
* This file estimates the second-stage duration models using
* bootstrapped standard errors with the errors clustered at the
* neighborhood level. These models are based on a nearest-neighbor 
* cutoff for the IV variables.
*
* Author: Douglas H. Wrenn
* Date:   07-29-2016
/*********************************************************************/
	
* Set drive
	clear all
	cd "...\JAE Data Archive"
	
* Set bootstrap reps and seed
	global bootreps = 500
	global bootseed = 5
	
/**************************/
* Non-IV Models
/**************************/
	
* Read data
	use "Second_Stage_Duration_Data_12_NearN", clear
	
* Set variables
	global noniv_model_vars develop dstbaltcen surprimerd areaacre ///
	zndltqnt sewer floodplne septicsuit slpe3prcnt exhouse prespercent ///
	udarea zndltqnt_ct apprvltqnt landprices1k houseprices1k ///
	y_2-y_14 carrind harfind
	
* Estimate model
	bootstrap, reps($bootreps) cluster(fe) seed($bootseed): probit $noniv_model_vars
	
* Elasticity value for price
	margins, eyex(houseprices1k)
	
/**************************/
* IV Models
/**************************/

* Set variables
	global iv_model_vars develop dstbaltcen surprimerd areaacre ///
	zndltqnt sewer floodplne septicsuit slpe3prcnt exhouse ///
	prespercent udarea zndltqnt_ct apprvltqnt landprices1k houseprices1k ///
	confunc_p confunc_p2 y_2-y_14 carrind harfind

* Loop to run IV models
	qui{
	foreach d of numlist 8 9 10 11 12{
	
	* Estimate model
		use "Second_Stage_Duration_Data_`d'_NearN", clear
		noi bootstrap, reps($bootreps) cluster(fe) seed($bootseed): probit $iv_model_vars
	
	* Elasticity value for price
		noi margins, eyex(houseprices1k)
		
	}
	}	

	

	
