/*********************************************************************/
* This file runs the first-stage OLS price regressions for a distance 
* cutoff and saves the residuals and data for use in the 
* second-stage duration model.
*
* The instruments are: Percent of Preserved Land
*                      Percentage of Undeveloped Area
*                      Zoned Lot Capacity  
*
* Author: Douglas H. Wrenn
* Date:   07-29-2016
/*********************************************************************/

* Set drive
	clear all
	cd "...\JAE Data Archive"
	
* Run Loop for the first-OLS models
	* Loop estimates the models, generates F-statistics, generates residuals, and
	* merges with the second-stage duration data. The loop is based on 3-5 mile
	* cutoffs
	qui{ 
	foreach d of numlist 3 4 5{
	
		* Read first-stage data
		import delimited using "First_Stage_OLS_Data", clear
	
		* Set IV variables
		global priceivs prespercent_fe_`d'mi udarea_fe_`d'mi zndltqnt_ct_fe_`d'mi
		
		* Run price regression
		noi reg houseprices1k constant prespercent udarea zndltqnt_ct ///
		apprvltqnt landprices1k $priceivs i.timeprd carrind harfind, nocon
		
		* Perform F-test 
		noi test $priceivs
		
		* Generates residuals
		predict confunc_p, r
		gen confunc_p2 = confunc_p^2
		keep fe confunc_p confunc_p2 $priceivs
		
		* Save control data
		save "Control_Data", replace
		
		* Read second-stage duration data
		import delimited using "Second_Stage_Duration_Data", clear
		
		* Merge with first-stage control data
		merge m:1 fe using "Control_Data"
		drop _merge

		* Save 
		save "Second_Stage_Duration_Data_`d'_Miles", replace
			
}
}

* Erase control data
	erase "Control_Data.dta"



