clear all
set more off

cd "/Users/bwilliams/allfiles/everything/research/my research projects/testscoreregressions/submissiontoJAE/replication files/nlsy"
use data/nlsy_v1_age30

*** generating some additional variables


rename HGC_MOTHER_1979 mhgc
rename HGC_FATHER_1979 fhgc
gen hoursperwk=hours/week
gen avgwklyW=exp(LavgwklyW)

*** sample restrictions

foreach var of varlist hgc asvab_mk* asvab_pc* asvab_wk* asvab_ar* rosenberg1-rosenberg5 rotter1-rotter4 urban* region* mhgc fhgc {
drop if `var'==. | `var'<0
}

drop if hours<35*weeks 
drop if asvab_mkJi<25
drop if asvab_pcJi<15
drop if asvab_wkJi<35
drop if asvab_arJi<30 
drop if rosenbergJi<10
drop if rotterJi<4
drop if missing(LavgwklyW)
duplicates drop CASEID, force


recode year (1979=3) (1980=2.65) (1981=2.40) (1982=2.26) (1983=2.19) (1984=2.10) (1985=2.03) (1986=1.99) (1987=1.92) (1988=1.84) (1989=1.76) (1990=1.67) (1991=1.60) (1992=1.55) (1993=1.51) (1994=1.47) (1996=1.39) (1998=1.34) (2000=1.27) (2002=1.21) (2004=1.15) (2006=1.08) (2008=1.01) (2010=1), gen(CPIinflator)
gen avgwklyWinflated=avgwklyW*CPIinflator

*** summary
local vars age avgwklyWinflated hoursperwk sex white urban hgc married childrenHH  urbanat14 fhgc mhgc asvab_mkbar asvab_pcbar asvab_wkbar asvab_arbar rosenbergbar rotterbar 

estpost summarize `vars' 
esttab using results/table1.txt, cells("mean sd min max") nomtitle nonumber replace
 
