clear all
set more off

cd "/Users/bwilliams/allfiles/everything/research/my research projects/testscoreregressions/submissiontoJAE/replication files/nlsy"
use data/nlsy_v1_age30

*** sample restrictions and generated variables

keep if age==30

gen exp2=exp^2
gen collegeHS=.
replace collegeHS=1 if hgc~=. & hgc>12
replace collegeHS=0 if hgc<=12
rename HGC_MOTHER_1979 mhgc
rename HGC_FATHER_1979 fhgc

foreach var of varlist hgc asvab_mk* asvab_pc* asvab_wk* asvab_ar* rosenberg1-rosenberg5 rotter1-rotter4 urban* region* mhgc fhgc {
drop if `var'==. | `var'<0
}

drop if hours<35*weeks 
drop if asvab_mkJi<25
drop if asvab_pcJi<15
drop if asvab_wkJi<35
drop if asvab_arJi<30 
drop if rosenbergJi<10
drop if rotterJi<4
drop if missing(LavgwklyW)
duplicates drop CASEID, force

rename ASVAB_MATHKNOW_IRT_ZSCORE asvab_mk_irt
rename ASVAB_ARREASON_IRT_ZSCORE asvab_ar_irt
rename ASVAB_PARACOMP_IRT_ZSCORE asvab_pc_irt
rename ASVAB_WORDKNOW_IRT_ZSCORE asvab_wk_irt
rename ASVAB_AR_MK_IRT_ZSCORE asvabM_irt
rename ASVAB_WK_PC_IRT_ZSCORE asvabR_irt

local controlvars urban* mhgc fhgc region* i.year

gen asvabM=(asvab_mkbar*25+asvab_arbar*30)/55
gen asvabR=(asvab_pcbar*15+asvab_wkbar*35)/50

mat Rsults=J(8,6,.)
*** regressions 
** hgc
* white males
quietly reg LavgwklyW `controlvars' hgc if sex==1 & white==1, r
mat Rsults[1,1]=_b[hgc]
mat Rsults[2,1]=_se[hgc]

quietly reg LavgwklyW `controlvars' hgc asvabM if sex==1 & white==1, r
mat forlater1=_b[hgc]
mat Rsults[1,2]=_b[hgc]
mat Rsults[2,2]=_se[hgc]

quietly reg LavgwklyW `controlvars' hgc asvabM_irt if sex==1 & white==1, r
mat Rsults[1,3]=_b[hgc]
mat Rsults[2,3]=_se[hgc]

* white females
quietly reg LavgwklyW `controlvars' hgc if sex==0 & white==1, r
mat Rsults[1,4]=_b[hgc]
mat Rsults[2,4]=_se[hgc]

quietly reg LavgwklyW `controlvars' hgc asvabM if sex==0 & white==1, r
mat Rsults[1,5]=_b[hgc]
mat Rsults[2,5]=_se[hgc]

quietly reg LavgwklyW `controlvars' hgc asvabM_irt if sex==0 & white==1, r
mat Rsults[1,6]=_b[hgc]
mat Rsults[2,6]=_se[hgc]

* nonwhite males
quietly reg LavgwklyW `controlvars' hgc if sex==1 & white==0, r
mat Rsults[5,1]=_b[hgc]
mat Rsults[6,1]=_se[hgc]

quietly reg LavgwklyW `controlvars' hgc asvabM if sex==1 & white==0, r
mat Rsults[5,2]=_b[hgc]
mat Rsults[6,2]=_se[hgc]

quietly reg LavgwklyW `controlvars' hgc asvabM_irt if sex==1 & white==0, r
mat Rsults[5,3]=_b[hgc]
mat Rsults[6,3]=_se[hgc]

* nonwhite females
quietly reg LavgwklyW `controlvars' hgc if sex==0 & white==0, r
mat Rsults[5,4]=_b[hgc]
mat Rsults[6,4]=_se[hgc]

quietly reg LavgwklyW `controlvars' hgc asvabM if sex==0 & white==0, r
mat Rsults[5,5]=_b[hgc]
mat Rsults[6,5]=_se[hgc]

quietly reg LavgwklyW `controlvars' hgc asvabM_irt if sex==0 & white==0, r
mat Rsults[5,6]=_b[hgc]
mat Rsults[6,6]=_se[hgc]

** collegeHS
* white males
quietly reg LavgwklyW `controlvars' collegeHS if sex==1 & white==1, r
mat Rsults[3,1]=_b[collegeHS]
mat Rsults[4,1]=_se[collegeHS]

quietly reg LavgwklyW `controlvars' collegeHS asvabM if sex==1 & white==1, r
mat forlater2=_b[collegeHS]
mat Rsults[3,2]=_b[collegeHS]
mat Rsults[4,2]=_se[collegeHS]

quietly reg LavgwklyW `controlvars' collegeHS asvabM_irt if sex==1 & white==1, r
mat Rsults[3,3]=_b[collegeHS]
mat Rsults[4,3]=_se[collegeHS]

* white females
quietly reg LavgwklyW `controlvars' collegeHS if sex==0 & white==1, r
mat Rsults[3,4]=_b[collegeHS]
mat Rsults[4,4]=_se[collegeHS]

quietly reg LavgwklyW `controlvars' collegeHS asvabM if sex==0 & white==1, r
mat Rsults[3,5]=_b[collegeHS]
mat Rsults[4,5]=_se[collegeHS]

quietly reg LavgwklyW `controlvars' collegeHS asvabM_irt if sex==0 & white==1, r
mat Rsults[3,6]=_b[collegeHS]
mat Rsults[4,6]=_se[collegeHS]

* nonwhite males
quietly reg LavgwklyW `controlvars' collegeHS if sex==1 & white==0, r
mat Rsults[7,1]=_b[collegeHS]
mat Rsults[8,1]=_se[collegeHS]

quietly reg LavgwklyW `controlvars' collegeHS asvabM if sex==1 & white==0, r
mat Rsults[7,2]=_b[collegeHS]
mat Rsults[8,2]=_se[collegeHS]

quietly reg LavgwklyW `controlvars' collegeHS asvabM_irt if sex==1 & white==0, r
mat Rsults[7,3]=_b[collegeHS]
mat Rsults[8,3]=_se[collegeHS]

* nonwhite females
quietly reg LavgwklyW `controlvars' collegeHS if sex==0 & white==0, r
mat Rsults[7,4]=_b[collegeHS]
mat Rsults[8,4]=_se[collegeHS]

quietly reg LavgwklyW `controlvars' collegeHS asvabM if sex==0 & white==0, r
mat Rsults[7,5]=_b[collegeHS]
mat Rsults[8,5]=_se[collegeHS]

quietly reg LavgwklyW `controlvars' collegeHS asvabM_irt if sex==0 & white==0, r
mat Rsults[7,6]=_b[collegeHS]
mat Rsults[8,6]=_se[collegeHS]

cap: log close
log using results/regResults.txt, text replace
mat list Rsults
log close

**

cap: drop asvabMR
cap:gen asvabM_=round(asvabM,.001)
egen asvabMR=rank(asvabM_)
mat rs1=J(23,11,.)
mat rs2=J(23,11,.)

local i=1
local j=1
forval k1=0.4(0.025)0.9501 {
	local mxx=1/`k1'-.01
	local step=(`mxx'-.01)/10
	local mxx=`mxx'+1e-3
forval m1=.01(`step')`mxx' {
	local m2=(1-`k1'*`m1')/(1-`k1')
	local b=1-`m2'
	qui{ 
	cap: drop TasvabM
	}	
	qui:generate double TasvabM=`m1'*asvabM_
	qui: replace TasvabM=`m2'*asvabM_+`b' if asvabM_>`k1'
	cap: drop TasvabMR
	egen TasvabMR=rank(TasvabM)
	*qui:replace asvabCd=-(`b'+5*`c'*(asvab-1)^4+6*`d'*(asvab-1)^5)
	*qui: sum asvabCd
	*if r(min)>=0 {
	qui: count if asvabMR!=TasvabMR & white==1 & sex==1
	if r(N)==0 {
		qui:reg LavgwklyW hgc TasvabM `controlvars' if white==1 & sex==1, r
		mat rs1[`i',`j']=_b[hgc]
		qui: reg LavgwklyW collegeHS TasvabM `controlvars' if white==1 & sex==1, r
		mat rs2[`i',`j']=_b[collegeHS]
	}
	else {
		mat rs1[`i',`j']=-100
		mat rs2[`i',`j']=-100
	}
	local j=`j'+1
	}
	local j=1
	local i=`i'+1
}

mat rs3=vec(rs1)
svmat rs3, names(hgc_alt_ests)
svmat forlater1, names(hgc_est)
mat rs4=vec(rs2)
svmat rs4, names(CHS_alt_ests)
svmat forlater2, names(CHS_est)
sort hgc_alt_ests
gen transformation=_n
gen temp1=1-missing(hgc_alt_ests)
egen temp2=total(hgc_est), by(temp1)
replace hgc_est=temp2
drop temp1 temp2
tw (line hgc_alt_ests transformation if hgc_alt_ests~=., lcolor(black)) (line hgc_est transformation if hgc_alt_ests~=., lpattern(dash) lcolor(black)), legend(cols(1) ring(0) bplace(nw) region(lstyle(none)) label(1 "transformed estimates") label(2 "untransformed estimate")) xtitle("transformation") graphregion(color(white)) ytitle("coefficient estimate") title("(a) highest grade completed") saving(hgc, replace)
graph export "results/transformed_estimates1.pdf", replace




sort CHS_alt_ests
replace transformation=_n
gen temp1=1-missing(CHS_alt_ests)
egen temp2=total(CHS_est), by(temp1)
replace CHS_est=temp2
drop temp1 temp2
tw (line CHS_alt_ests transformation if CHS_alt_ests~=., lcolor(black)) (line CHS_est transformation if CHS_alt_ests~=., lpattern(dash) lcolor(black)), legend(cols(1) ring(0) bplace(nw) region(lstyle(none)) label(1 "transformed estimates") label(2 "untransformed estimate")) xtitle("transformation") graphregion(color(white)) ytitle("coefficient estimate") title("(b) college dummy") saving(college, replace)
graph export "results/transformed_estimates2.pdf", replace







local k1=0.4
local m1=1/`k1'-.01
local m2=(1-`k1'*`m1')/(1-`k1')
local b=1-`m2'
qui:generate double TasvabMmax=`m1'*asvabM_
qui: replace TasvabMmax=`m2'*asvabM_+`b' if asvabM_>`k1'

local k1=0.9
local mxx=1/`k1'-.01
local step=(`mxx'-.01)/10
local m1=.01+`step'*6
local m2=(1-`k1'*`m1')/(1-`k1')
local b=1-`m2'
qui:generate double TasvabMmin=`m1'*asvabM_
qui: replace TasvabMmin=`m2'*asvabM_+`b' if asvabM_>`k1'

tw (kdensity asvabM_ if white==1 & sex==1, lcolor(black)) (kdensity TasvabMmin if white==1 & sex==1, lpattern(shortdash) lcolor(black)) (kdensity TasvabMmax if white==1 & sex==1, lpattern(dash) lcolor(black) bw(0.025) ker(gau)), legend(cols(1) ring(0) bplace(nw) region(lstyle(none)) label(1 "baseline") label(3 "coefficient-maximizing") label(2 "coefficient-minimizing")) xtitle("(transformed) test score units") graphregion(color(white)) ytitle("density")
graph export "results/transformations.pdf", replace

graph combine hgc.gph college.gph, graphregion(color(white))
graph export "results/transformed_estimates_both.pdf", replace
