clear all
cd '/Users/bwilliams/allfiles/everything/research/my research projects/testscoreregressions/submissiontoJAE/replication files/nlsy'

load data/nlsy_matlab_hgc_wm.txt
delt=.05;

Y=nlsy_matlab_hgc_wm(:,1);
M1=nlsy_matlab_hgc_wm(:,[2:26 77:106]);
M2=nlsy_matlab_hgc_wm(:,107:116);
M3=nlsy_matlab_hgc_wm(:,117:120);
X=nlsy_matlab_hgc_wm(:,121:end-1);
year=nlsy_matlab_hgc_wm(:,end);

n=length(Y);
yrvalues=unique(year);
T=length(yrvalues);
Dy=zeros(n,T-1);
for z=1:T-1,
    Dy(:,z)=1*(year==yrvalues(z+1));
end
W0=[X Dy];
K=size(W0,2);
Mbar=mean(M1,2);


[temp x Jx]=kreg2(Y,Mbar,[],Mbar,delt,.025,.2,.025);
gY=temp(Jx)';
eY=Y-gY;

for k=1:K,
    [temp x Jx]=kreg2(W0(:,k),Mbar,[],Mbar,delt,.025,.2,.025);
    gW(:,k)=temp(Jx)';
    eW(:,k)=W0(:,k)-temp(Jx)';
end


Mbar_c=(Mbar-0.5*(quantile(Mbar,delt)+quantile(Mbar,1-delt))*ones(size(Mbar)))/(.5*(quantile(Mbar,1-delt)-quantile(Mbar,delt)));
eW=eW.*(functionS(Mbar_c)*ones(1,K)).^(1/2);
eY=eY.*(functionS(Mbar_c)).^(1/2);
bhatplr=inv(eW'*eW)*eW'*eY;
bhatplrSE=inv(eW'*eW)*eW'*diag((eY-eW*bhatplr).^2)*eW*inv(eW'*eW);
bhatplrSE=sqrt(diag(bhatplrSE));

meanWwm=mean(W0);
ghatwm=gY-gW*bhatplr+meanWwm*bhatplr;

outp(1,1)=bhatplr(1);
outp(2,1)=bhatplrSE(1);

Mbarwm=Mbar;
save results/PLR outp meanWwm ghatwm Mbarwm



clear all
load data/nlsy_matlab_hgc_wf.txt
delt=.05;

Y=nlsy_matlab_hgc_wf(:,1);
M1=nlsy_matlab_hgc_wf(:,[2:26 77:106]);
M2=nlsy_matlab_hgc_wf(:,107:116);
M3=nlsy_matlab_hgc_wf(:,117:120);
X=nlsy_matlab_hgc_wf(:,121:end-1);
year=nlsy_matlab_hgc_wf(:,end);

n=length(Y);
yrvalues=unique(year);
T=length(yrvalues);
Dy=zeros(n,T-1);
for z=1:T-1,
    Dy(:,z)=1*(year==yrvalues(z+1));
end
W0=[X Dy];
K=size(W0,2);
Mbar=mean(M1,2);


[temp x Jx]=kreg2(Y,Mbar,[],Mbar,delt,.025,.2,.025);
gY=temp(Jx)';
eY=Y-gY;

for k=1:K,
    [temp x Jx]=kreg2(W0(:,k),Mbar,[],Mbar,delt,.025,.2,.025);
    gW(:,k)=temp(Jx)';
    eW(:,k)=W0(:,k)-temp(Jx)';
end


Mbar_c=(Mbar-0.5*(quantile(Mbar,delt)+quantile(Mbar,1-delt))*ones(size(Mbar)))/(.5*(quantile(Mbar,1-delt)-quantile(Mbar,delt)));
eW=eW.*(functionS(Mbar_c)*ones(1,K)).^(1/2);
eY=eY.*(functionS(Mbar_c)).^(1/2);
bhatplr=inv(eW'*eW)*eW'*eY;
bhatplrSE=inv(eW'*eW)*eW'*diag((eY-eW*bhatplr).^2)*eW*inv(eW'*eW);
bhatplrSE=sqrt(diag(bhatplrSE));


load results/PLR 

ghatwf=gY-gW*bhatplr+meanWwm*bhatplr;

outp(1,2)=bhatplr(1);
outp(2,2)=bhatplrSE(1);

Mbarwf=Mbar;
save results/PLR outp meanWwm ghatwm Mbarwm ghatwf Mbarwf


clear all
load data/nlsy_matlab_hgc_nwm.txt
delt=.05;

Y=nlsy_matlab_hgc_nwm(:,1);
M1=nlsy_matlab_hgc_nwm(:,[2:26 77:106]);
M2=nlsy_matlab_hgc_nwm(:,107:116);
M3=nlsy_matlab_hgc_nwm(:,117:120);
X=nlsy_matlab_hgc_nwm(:,121:end-1);
year=nlsy_matlab_hgc_nwm(:,end);

n=length(Y);
yrvalues=unique(year);
T=length(yrvalues);
Dy=zeros(n,T-1);
for z=1:T-1,
    Dy(:,z)=1*(year==yrvalues(z+1));
end
W0=[X Dy];
K=size(W0,2);
Mbar=mean(M1,2);

[temp x Jx]=kreg2(Y,Mbar,[],Mbar,delt,.025,.2,.025);
gY=temp(Jx)';
eY=Y-gY;

for k=1:K,
    [temp x Jx]=kreg2(W0(:,k),Mbar,[],Mbar,delt,.025,.2,.025);
    gW(:,k)=temp(Jx)';
    eW(:,k)=W0(:,k)-temp(Jx)';
end


Mbar_c=(Mbar-0.5*(quantile(Mbar,delt)+quantile(Mbar,1-delt))*ones(size(Mbar)))/(.5*(quantile(Mbar,1-delt)-quantile(Mbar,delt)));
eW=eW.*(functionS(Mbar_c)*ones(1,K)).^(1/2);
eY=eY.*(functionS(Mbar_c)).^(1/2);
bhatplr=inv(eW'*eW)*eW'*eY;
bhatplrSE=inv(eW'*eW)*eW'*diag((eY-eW*bhatplr).^2)*eW*inv(eW'*eW);
bhatplrSE=sqrt(diag(bhatplrSE));


load results/PLR 

ghatnwm=gY-gW*bhatplr+meanWwm*bhatplr;

outp(5,1)=bhatplr(1);
outp(6,1)=bhatplrSE(1);

Mbarnwm=Mbar;
save results/PLR outp meanWwm ghatwm Mbarwm ghatwf Mbarwf ghatnwm Mbarnwm



clear all
load data/nlsy_matlab_hgc_nwf.txt
delt=.05;

Y=nlsy_matlab_hgc_nwf(:,1);
M1=nlsy_matlab_hgc_nwf(:,[2:26 77:106]);
M2=nlsy_matlab_hgc_nwf(:,107:116);
M3=nlsy_matlab_hgc_nwf(:,117:120);
X=nlsy_matlab_hgc_nwf(:,121:end-1);
year=nlsy_matlab_hgc_nwf(:,end);

n=length(Y);
yrvalues=unique(year);
T=length(yrvalues);
Dy=zeros(n,T-1);
for z=1:T-1,
    Dy(:,z)=1*(year==yrvalues(z+1));
end
W0=[X Dy];
K=size(W0,2);
Mbar=mean(M1,2);

[temp x Jx]=kreg2(Y,Mbar,[],Mbar,delt,.025,.2,.025);
gY=temp(Jx)';
eY=Y-gY;

for k=1:K,
    [temp x Jx]=kreg2(W0(:,k),Mbar,[],Mbar,delt,.025,.2,.025);
    gW(:,k)=temp(Jx)';
    eW(:,k)=W0(:,k)-temp(Jx)';
end


Mbar_c=(Mbar-0.5*(quantile(Mbar,delt)+quantile(Mbar,1-delt))*ones(size(Mbar)))/(.5*(quantile(Mbar,1-delt)-quantile(Mbar,delt)));
eW=eW.*(functionS(Mbar_c)*ones(1,K)).^(1/2);
eY=eY.*(functionS(Mbar_c)).^(1/2);
bhatplr=inv(eW'*eW)*eW'*eY;
bhatplrSE=inv(eW'*eW)*eW'*diag((eY-eW*bhatplr).^2)*eW*inv(eW'*eW);
bhatplrSE=sqrt(diag(bhatplrSE));



load results/PLR

ghatnwf=gY-gW*bhatplr+meanWwm*bhatplr;

outp(5,2)=bhatplr(1);
outp(6,2)=bhatplrSE(1);

Mbarnwf=Mbar;
save results/PLR outp meanWwm ghatwm Mbarwm ghatwf Mbarwf ghatnwm Mbarnwm ghatnwf Mbarnwf





clear all
load data/nlsy_matlab_chs_wm.txt
delt=.05;

Y=nlsy_matlab_chs_wm(:,1);
M1=nlsy_matlab_chs_wm(:,[2:26 77:106]);
M2=nlsy_matlab_chs_wm(:,107:116);
M3=nlsy_matlab_chs_wm(:,117:120);
X=nlsy_matlab_chs_wm(:,121:end-1);
year=nlsy_matlab_chs_wm(:,end);

n=length(Y);
yrvalues=unique(year);
T=length(yrvalues);
Dy=zeros(n,T-1);
for z=1:T-1,
    Dy(:,z)=1*(year==yrvalues(z+1));
end
W0=[X Dy mean(M2,2) mean(M3,2)];
K=size(W0,2);
Mbar=mean(M1,2);

[temp x Jx]=kreg2(Y,Mbar,[],Mbar,delt,.025,.2,.025);
eY=Y-temp(Jx)';

for k=1:K,
    [temp x Jx]=kreg2(W0(:,k),Mbar,[],Mbar,delt,.025,.2,.025);
    eW(:,k)=W0(:,k)-temp(Jx)';
end


Mbar_c=(Mbar-0.5*(quantile(Mbar,delt)+quantile(Mbar,1-delt))*ones(size(Mbar)))/(.5*(quantile(Mbar,1-delt)-quantile(Mbar,delt)));
eW=eW.*(functionS(Mbar_c)*ones(1,K)).^(1/2);
eY=eY.*(functionS(Mbar_c)).^(1/2);
bhatplr=inv(eW'*eW)*eW'*eY;
bhatplrSE=inv(eW'*eW)*eW'*diag((eY-eW*bhatplr).^2)*eW*inv(eW'*eW);
bhatplrSE=sqrt(diag(bhatplrSE));

load results/PLR
outp(3,1)=bhatplr(1);
outp(4,1)=bhatplrSE(1);
save results/PLR outp ghatwm Mbarwm ghatwf Mbarwf ghatnwm Mbarnwm ghatnwf Mbarnwf



clear all
load data/nlsy_matlab_chs_wf.txt
delt=.05;

Y=nlsy_matlab_chs_wf(:,1);
M1=nlsy_matlab_chs_wf(:,[2:26 77:106]);
M2=nlsy_matlab_chs_wf(:,107:116);
M3=nlsy_matlab_chs_wf(:,117:120);
X=nlsy_matlab_chs_wf(:,121:end-1);
year=nlsy_matlab_chs_wf(:,end);

n=length(Y);
yrvalues=unique(year);
T=length(yrvalues);
Dy=zeros(n,T-1);
for z=1:T-1,
    Dy(:,z)=1*(year==yrvalues(z+1));
end
W0=[X Dy mean(M2,2) mean(M3,2)];
K=size(W0,2);
Mbar=mean(M1,2);

[temp x Jx]=kreg2(Y,Mbar,[],Mbar,delt,.025,.2,.025);
eY=Y-temp(Jx)';

for k=1:K,
    [temp x Jx]=kreg2(W0(:,k),Mbar,[],Mbar,delt,.025,.2,.025);
    eW(:,k)=W0(:,k)-temp(Jx)';
end


Mbar_c=(Mbar-0.5*(quantile(Mbar,delt)+quantile(Mbar,1-delt))*ones(size(Mbar)))/(.5*(quantile(Mbar,1-delt)-quantile(Mbar,delt)));
eW=eW.*(functionS(Mbar_c)*ones(1,K)).^(1/2);
eY=eY.*(functionS(Mbar_c)).^(1/2);
bhatplr=inv(eW'*eW)*eW'*eY;
bhatplrSE=inv(eW'*eW)*eW'*diag((eY-eW*bhatplr).^2)*eW*inv(eW'*eW);
bhatplrSE=sqrt(diag(bhatplrSE));

load results/PLR 
outp(3,2)=bhatplr(1);
outp(4,2)=bhatplrSE(1);
save results/PLR outp ghatwm Mbarwm ghatwf Mbarwf ghatnwm Mbarnwm ghatnwf Mbarnwf



clear all
load data/nlsy_matlab_chs_nwm.txt
delt=.05;

Y=nlsy_matlab_chs_nwm(:,1);
M1=nlsy_matlab_chs_nwm(:,[2:26 77:106]);
M2=nlsy_matlab_chs_nwm(:,107:116);
M3=nlsy_matlab_chs_nwm(:,117:120);
X=nlsy_matlab_chs_nwm(:,121:end-1);
year=nlsy_matlab_chs_nwm(:,end);

n=length(Y);
yrvalues=unique(year);
T=length(yrvalues);
Dy=zeros(n,T-1);
for z=1:T-1,
    Dy(:,z)=1*(year==yrvalues(z+1));
end
W0=[X Dy mean(M2,2) mean(M3,2)];
K=size(W0,2);
Mbar=mean(M1,2);

[temp x Jx]=kreg2(Y,Mbar,[],Mbar,delt,.025,.2,.025);
eY=Y-temp(Jx)';

for k=1:K,
    [temp x Jx]=kreg2(W0(:,k),Mbar,[],Mbar,delt,.025,.2,.025);
    eW(:,k)=W0(:,k)-temp(Jx)';
end


Mbar_c=(Mbar-0.5*(quantile(Mbar,delt)+quantile(Mbar,1-delt))*ones(size(Mbar)))/(.5*(quantile(Mbar,1-delt)-quantile(Mbar,delt)));
eW=eW.*(functionS(Mbar_c)*ones(1,K)).^(1/2);
eY=eY.*(functionS(Mbar_c)).^(1/2);
bhatplr=inv(eW'*eW)*eW'*eY;
bhatplrSE=inv(eW'*eW)*eW'*diag((eY-eW*bhatplr).^2)*eW*inv(eW'*eW);
bhatplrSE=sqrt(diag(bhatplrSE));

load results/PLR
outp(7,1)=bhatplr(1);
outp(8,1)=bhatplrSE(1);
save results/PLR outp ghatwm Mbarwm ghatwf Mbarwf ghatnwm Mbarnwm ghatnwf Mbarnwf

clear all
load data/nlsy_matlab_chs_nwf.txt
delt=.05;

Y=nlsy_matlab_chs_nwf(:,1);
M1=nlsy_matlab_chs_nwf(:,[2:26 77:106]);
M2=nlsy_matlab_chs_nwf(:,107:116);
M3=nlsy_matlab_chs_nwf(:,117:120);
X=nlsy_matlab_chs_nwf(:,121:end-1);
year=nlsy_matlab_chs_nwf(:,end);

n=length(Y);
yrvalues=unique(year);
T=length(yrvalues);
Dy=zeros(n,T-1);
for z=1:T-1,
    Dy(:,z)=1*(year==yrvalues(z+1));
end
W0=[X Dy mean(M2,2) mean(M3,2)];
K=size(W0,2);
Mbar=mean(M1,2);

[temp x Jx]=kreg2(Y,Mbar,[],Mbar,delt,.025,.2,.025);
eY=Y-temp(Jx)';

for k=1:K,
    [temp x Jx]=kreg2(W0(:,k),Mbar,[],Mbar,delt,.025,.2,.025);
    eW(:,k)=W0(:,k)-temp(Jx)';
end


Mbar_c=(Mbar-0.5*(quantile(Mbar,delt)+quantile(Mbar,1-delt))*ones(size(Mbar)))/(.5*(quantile(Mbar,1-delt)-quantile(Mbar,delt)));
eW=eW.*(functionS(Mbar_c)*ones(1,K)).^(1/2);
eY=eY.*(functionS(Mbar_c)).^(1/2);
bhatplr=inv(eW'*eW)*eW'*eY;
bhatplrSE=inv(eW'*eW)*eW'*diag((eY-eW*bhatplr).^2)*eW*inv(eW'*eW);
bhatplrSE=sqrt(diag(bhatplrSE));

load results/PLR 
outp(7,2)=bhatplr(1);
outp(8,2)=bhatplrSE(1);
save results/PLR outp ghatwm Mbarwm ghatwf Mbarwf ghatnwm Mbarnwm ghatnwf Mbarnwf


save results/PLR.txt outp -ascii -tabs


   