/* =========================================================================
                Programed by Donggyu Sul (d.SuL@auckland.ac.nz)
                         July 18, 2001.
      Reference: Mark and Sul (JIE 53, 2001, pp 29-52)
===========================================================================

Notation:
 = First Difference. y(t) = y(t) - y(t-1).

============ Basic Procedures ==================================================

 (1)  k = detlag(y,p,ioption)
      determine the proper lag in ADF regression:
      model: y(t) = a + a1 y(t-1) + a2 y(t-1) + ... + ap y(t-p) + u(t)
      ioption: decide whether determinstic terms includes or not.
               ioption = 0: no constant
               ioption = 1: constant
               ioption = 2: constant + time trend

 (2) k = detlagnc(y,p,ioption)
      determine the proper lag in the following regression:
      model: y(t) = a + a2 y(t-1) + ... + ap y(t-p) + u(t)
      ioption: decide whether determinstic terms includes or not.
               ioption = 0: no constant
               ioption = 1: constant
               ioption = 2: constant + time trend

 (3) {a1, t, residual} = suladf(y,p,ioption)
     calcaluate slope coefficient and its t-value in ADF regression
     model: y(t) = a + a1 y(t-1) + a2 y(t-1) + ... + ap y(t-p) + u(t)

 (4) {y,x} = lagp(x,p)
     make y(t), y(t-1), y(t-1), ... , y(t-p)
     output: y = y(t)  (t-p-1)x1 matrix
             x = [ y(t-1) y(t-1), ... , y(t-p) ] (t-p-1)x(p+1) matrix

 (5) {y,x} = lagp1(x,p)
     make y(t), y(t-1), ... , y(t-p)
     output: y = y(t)  (t-p-1)x1 matrix
             x = [ y(t-1), ... , y(t-p) ] (t-p-1)x(p) matrix

 (6) {lr_se} = pdlong(x,p)
     x = NxT matrix
     p = the maximum lag length
     lr_se = long run standard error of x by using Campbell and Perron's top-dow
n
     method.

=============================================================================
                 Testing the null hypothesis of No Cointegation

   Model:
     s(it) = gamma_i + theta_t + beta x_(it-1)
                      + sum_{j=-p_i}^{j=p_i}d_{ij}x(it-j-1) + u(it)

     => Equation (4) in JIE 53 2001, p 35.

  Since d_{ij} is different across i, theta_t cannot be eliminated by the use of
  cross-sectional average representation.
  Hence, LSDV method should be applied here.

  Under the null, t-ratio of beta ->d Normal (see eq. (5) at p 36)

                  Bootstrap Method for testing no-cointegration
                   Use Model 2 to generate pseudo panel data
                => See bootstrap method for testing predictability


 ===============================================================================
                      Bootstrap Method for Testing Predictability
 ===============================================================================

     Model 1: DGP Under the assumption of cointegration

           s(i,t+k) - s(i,t) = s_ik + u(i,t+k)
           z(i,t) = a_iz + a_i1 z(i,t-1) +
                  + a_i2 [z(i,t-1)-z(i,t-2)] + ... + a_ip [z(i,t-p-1)-z(i,t-p)]
                  + b_i2 [s(i,t-1)-s(i,t-2)] + ... + b_ip [s(i,t-p-1)-s(i,t-p)]
+ e(i,t)

            "p" may be different over "i", but the max p = 6.

     Model 2: DGP Under the assumption of No-cointegration
           s(i,t+k) - s(i,t) = s_ik + u(i,t+k)
           z(i,t) = a_iz + z(i,t-1) +
                  + a_i2 [z(i,t-1)-z(i,t-2)] + ... + a_ip [z(i,t-p-1)-z(i,t-p)]
                  + b_i2 [s(i,t-1)-s(i,t-2)] + ... + b_ip [s(i,t-p-1)-s(i,t-p)]
+ e(i,t)

            "p" may be different over "i", but the max p = 6.

     Estimation:
           s(i,t+k) - s(i,t) = s_ik + theta(t) + bg_k z(i,t) + v(it+k)
     Forecasting:
           hat s(i,t0+k) = s(i,t0) + hat s_ik + hat bg_k z(i,t)

 ===============================================================================

 Procedures:

   Estimation of long-horizon regression
      {beta, t-ratio} = betasim(s,z,k)
      input:
      s = TxN spot rate
      z = TxN fundamentals - spot rate
      k = 1x1 the number of horizon
      output:
      beta = 1x1 Estimate of bg_k
      t-ratio = 1x1 tratio


   Estimation of LSDV Model

     {beta, t-ratio} = lsdv(y,x,p2,p)
      input:
      y = TxN dependent variables
      x = TxN independent variables
      p2 = maximum lag length for the calculation of long-run variance
      p = maximum lag length for leads and lags in panel cointegrating system.
      output:
      beta = 1x1 an estimate of a coefficient on x
      t-ratio = t-statistic

   Forecasting by using long-horizon regression

     {theil} = foresim1(s,f,t1,k)
     input:
     s = TxN spot rates
     f = TxN fundamentals
     t1 = forecasting starting point
     k = the number of horizon
     output:
     theil = Nx1 theil's U-statistics

   SUR Estimation of Model 1
     {para,sigma,resid} = sur(z,s,indx,p)
     z = TxN equilibrium error,
     s = TxN spot rate
     indx = Nx1 see "usa.pgm", the optimum lag length
     p = maximum lag length

   SUR Estimation of Model 2
     {para,sigma,resid} = surnt(z,s,nt,indx,p)
     nt = should be cols(x)

   Parametric Bootrapping
      Under the null hypothesis of no predictability
           Assumption: z-I(0)
      {th1,th2}= ms_cop(parax,paras,consx,conts,sig,t,n,isim,t0)

      input:
      parax = Nx6 matrix: a_i1 through a_ip.
      paras = Nx6 matrix: b_i1 through b_ip.
      consx = constant for z
      sig   = covariance and variance matrix between "u" and "e"
      t     = the number of time series observation
      n     = the number of cross-sectional observation
      isim  = the number of simulation
      t0    = Starting point of forecasts

      Output:
      th1   = Theil's U-statistics at 1-horizon
      th2   = Theil's U-statistics at 16-horizon

   Parametric Bootrapping
      Under the null hypothesis of no predictability
           Assumption: z-I(1)
      {th1,th2}= ms_nop(parax,paras,contx,conts,sig,t,n,isim,t0)

  =====>>>>>>>>>
      For test for the null of no cointegration
      ==> Should change the following codes to be
              rmse = foresim1(s,f,t0,1);
              simr1[is,.] = rmse';
      ==>     {bb,tt} = lsdv(s,z,p2,p)
              simr1[is,.] = tt';
       AND add "bb" and "tt" at local statement.

   Non-Parametric Bootrapping
      Under the null hypothesis of no predictability
           Assumption: z-I(0)
      {th1,th2}= ms_con(parax,paras,consx,conts,resi,sx,ds,x,t,n,isim,t0)

      input:
      parax = Nx6 matrix: a_i1 through a_ip.
      paras = Nx6 matrix: b_i1 through b_ip.
      consx = constant for z
      resi  = NxT residual matrix for z
      ds    = NxT residual matrix for s
      sx    = spot rate
      t     = the number of time series observation
      n     = the number of cross-sectional observation
      isim  = the number of simulation
      t0    = Starting point of forecasts

      Output:
      th1   = Theil's U-statistics at 1-horizon
      th2   = Theil's U-statistics at 16-horizon

Non-Parametric Bootrapping
      Under the null hypothesis of no predictability
           Assumption: z-I(1)
      {th1,th2}= ms_non(parax,paras,contx,conts,resi,sx,ds,x,t,n,isim,t0)

*/


proc (2) = ms_cop(parax,paras,contx,conts,sig,t,n,isim,t0);

local sigz, const,i,ii,seed,tsim,es,ez,e;
local betat, betag, t20, ta, theil_u, gtheil_u, gdm;
local simbt, simbg, is, s, z, simr11, simd11, simd12, rmse,dm;
local lag3, lag4, fsim;
local simr1, simr4, simr8, simr12, simr16;
local mse1,mse2,mse3;
local betag1, betag5, betat1,betat5,f;

sig  = chol(sig);
seed = 12234598;
tsim = 100+t;

simbt = zeros(isim,2);
simbg = zeros(isim,2);
simr1 = zeros(isim,n);
simr16 = zeros(isim,n);

is = 1;
do while is <= isim;
is;
   e = rndns(2*n,tsim,seed);
   e = sig'e;    e = e';
   es  = e[.,1:n];      ez  = e[.,n+1:n*2]; s = es; z = ez;

   s[1,.] = conts +          es[1,.];
   s[2,.] = conts + s[1,.] + es[2,.];
   s[3,.] = conts + s[2,.] + es[3,.];
   s[4,.] = conts + s[3,.] + es[4,.];
   s[5,.] = conts + s[4,.] + es[5,.];

 z[1,.] = contx' + ez[1,.] ;
 z[2,.] = contx' + z[1,.].*(parax[.,1]')
                 + ez[2,.] ;
 z[3,.] = contx' + z[2,.].*(parax[.,1]')
                 + (z[2,.] - z[1,.]).*(parax[.,2]')
                 + (s[2,.] - s[1,.]).*(paras[.,1]')
                 + ez[3,.];
 z[4,.] = contx' + z[3,.].*(parax[.,1]')
                 + (z[3,.] - z[2,.]).*(parax[.,2]')
                 + (z[2,.] - z[1,.]).*(parax[.,3]')
                 + (s[3,.] - s[2,.]).*(paras[.,1]')
                 + (s[2,.] - s[1,.]).*(paras[.,2]')
                 + ez[4,.];
 z[5,.] = contx' + z[4,.].*(parax[.,1]')
                 + (z[4,.] - z[3,.]).*(parax[.,2]')
                 + (z[3,.] - z[2,.]).*(parax[.,3]')
                 + (z[2,.] - z[1,.]).*(parax[.,4]')
                 + (s[4,.] - s[3,.]).*(paras[.,1]')
                 + (s[3,.] - s[2,.]).*(paras[.,2]')
                 + (s[2,.] - s[1,.]).*(paras[.,3]')
                 + ez[5,.];
 z[6,.] = contx' + z[5,.].*(parax[.,1]')
                 + (z[5,.] - z[4,.]).*(parax[.,2]')
                 + (z[4,.] - z[3,.]).*(parax[.,3]')
                 + (z[3,.] - z[2,.]).*(parax[.,4]')
                 + (z[2,.] - z[1,.]).*(parax[.,5]')
                 + (s[5,.] - s[4,.]).*(paras[.,1]')
                 + (s[4,.] - s[3,.]).*(paras[.,2]')
                 + (s[3,.] - s[2,.]).*(paras[.,3]')
                 + (s[2,.] - s[1,.]).*(paras[.,4]')
                 + ez[6,.];
   i = 7;
   do while i <= tsim;
   s[i,.] = conts + s[i-1,.] + es[i,.];
   z[i,.] = contx' + z[i-1,.].*(parax[.,1]')
                           + (z[i-1,.] - z[i-2,.]).*(parax[.,2]')
                           + (z[i-2,.] - z[i-3,.]).*(parax[.,3]')
                           + (z[i-3,.] - z[i-4,.]).*(parax[.,4]')
                           + (z[i-4,.] - z[i-5,.]).*(parax[.,5]')
                           + (z[i-5,.] - z[i-6,.]).*(parax[.,6]')
            + (s[i-1,.] - s[i-2,.]).*(paras[.,1]')
            + (s[i-2,.] - s[i-3,.]).*(paras[.,2]')
            + (s[i-3,.] - s[i-4,.]).*(paras[.,3]')
            + (s[i-4,.] - s[i-5,.]).*(paras[.,4]')
            + (s[i-5,.] - s[i-6,.]).*(paras[.,5]')
                   + ez[i,.];
   i = i + 1;
   endo;

   s = s[101:tsim,.];
   z = z[101:tsim,.];
   f = z + s;

   rmse = foresim1(s,f,t0,1);
    simr1[is,.] = rmse';
   rmse = foresim1(s,f,t0,16);
    simr16[is,.] = rmse';

 is = is + 1;
 endo;

 retp(simr1,simr16);
endp;

proc (2) = ms_con(parax,paras,contx,conts,resi,sx,ds,x,t,n,isim,t0);

local sigz, const,i,ii,seed,tsim,es,ez,e;
local betat, betag, t20, ta, theil_u, gtheil_u, gdm;
local simbt, simbg, is, z,s, simr11, simd11, simd12, rmse,dm;
local lag3, lag4, fsim;
local simr1, simr4, simr8, simr12, simr16;
local mse1,mse2,mse3;
local betag1, betag5, betat1,betat5,f,ine,ine2;

seed = 12234598;
tsim = t;

ds = ds - conts;

simbt = zeros(isim,2);
simbg = zeros(isim,2);
simr1 = zeros(isim,n);
simr16 = zeros(isim,n);

is = 1;
do while is <= isim;
   s = sx;
   z = sx;
   ine = int(1+rndus(rows(resi),1,seed).*rows(resi));
   ez   = resi[ine,.];  es = ds[ine,.];
   ine2 = int(1+rndus(1,1,seed).*(rows(resi)-7));
   z[1:6,.] = x[ine2:ine2+5,.];
   s[1:6,.] = sx[ine2:ine2+5,.];

   i = 7;
   do while i <= tsim;
   s[i,.] = conts  + s[i-1,.] + es[i-6,.];
   z[i,.] = contx' + z[i-1,.].*(parax[.,1]')
                           + (z[i-1,.] - z[i-2,.]).*(parax[.,2]')
                           + (z[i-2,.] - z[i-3,.]).*(parax[.,3]')
                           + (z[i-3,.] - z[i-4,.]).*(parax[.,4]')
                           + (z[i-4,.] - z[i-5,.]).*(parax[.,5]')
                           + (z[i-5,.] - z[i-6,.]).*(parax[.,6]')
            + (s[i-1,.] - s[i-2,.]).*(paras[.,1]')
            + (s[i-2,.] - s[i-3,.]).*(paras[.,2]')
            + (s[i-3,.] - s[i-4,.]).*(paras[.,3]')
            + (s[i-4,.] - s[i-5,.]).*(paras[.,4]')
            + (s[i-5,.] - s[i-6,.]).*(paras[.,5]')
                   + ez[i-6,.];
   i = i + 1;
   endo;

   f = z + s;

   rmse = foresim1(s,f,t0,1);
    simr1[is,.] = rmse';
   rmse = foresim1(s,f,t0,16);
    simr16[is,.] = rmse';

 is = is + 1;
 endo;

 retp(simr1,simr16);
endp;

proc (2) = ms_nop(parax,paras,contx,conts,sig,t,n,isim,t0);

local sigz, const,i,ii,seed,tsim,es,ez,e;
local betat, betag, t20, ta, theil_u, gtheil_u, gdm;
local simbt, simbg, is, s, z, simr11, simd11, simd12, rmse,dm;
local lag3, lag4, fsim;
local simr1, simr4, simr8, simr12, simr16;
local mse1,mse2,mse3;
local betag1, betag5, betat1,betat5,f;

sig  = chol(sig);
seed = 12234598;
tsim = 100+t;

simbt = zeros(isim,2);
simbg = zeros(isim,2);
simr1 = zeros(isim,n);
simr16 = zeros(isim,n);

is = 1;
do while is <= isim;
   e = rndns(2*n,tsim,seed);
   e = sig'e;    e = e';
   es  = e[.,1:n];      ez  = e[.,n+1:n*2]; s = es; z = ez;

   s[1,.] = conts +          es[1,.];
   s[2,.] = conts + s[1,.] + es[2,.];
   s[3,.] = conts + s[2,.] + es[3,.];
   s[4,.] = conts + s[3,.] + es[4,.];
   s[5,.] = conts + s[4,.] + es[5,.];
   s[6,.] = conts + s[5,.] + es[6,.];

 z[1,.] = contx' + ez[1,.] ;
 z[2,.] = contx' + z[1,.]
                 + ez[2,.] ;
 z[3,.] = contx' + z[2,.]
                 + (z[2,.] - z[1,.]).*(parax[.,1]')
                 + (s[2,.] - s[1,.]).*(paras[.,1]')
                 + ez[3,.];
 z[4,.] = contx' + z[3,.]
                 + (z[3,.] - z[2,.]).*(parax[.,1]')
                 + (z[2,.] - z[1,.]).*(parax[.,2]')
                 + (s[3,.] - s[2,.]).*(paras[.,1]')
                 + (s[2,.] - s[1,.]).*(paras[.,2]')
                 + ez[4,.];
 z[5,.] = contx' + z[4,.]
                 + (z[4,.] - z[3,.]).*(parax[.,1]')
                 + (z[3,.] - z[2,.]).*(parax[.,2]')
                 + (z[2,.] - z[1,.]).*(parax[.,3]')
                 + (s[4,.] - s[3,.]).*(paras[.,1]')
                 + (s[3,.] - s[2,.]).*(paras[.,2]')
                 + (s[2,.] - s[1,.]).*(paras[.,3]')
                 + ez[5,.];
 z[6,.] = contx' + z[5,.]
                 + (z[5,.] - z[4,.]).*(parax[.,1]')
                 + (z[4,.] - z[3,.]).*(parax[.,2]')
                 + (z[3,.] - z[2,.]).*(parax[.,3]')
                 + (z[2,.] - z[1,.]).*(parax[.,4]')
                 + (s[5,.] - s[4,.]).*(paras[.,1]')
                 + (s[4,.] - s[3,.]).*(paras[.,2]')
                 + (s[3,.] - s[2,.]).*(paras[.,3]')
                 + (s[2,.] - s[1,.]).*(paras[.,4]')
                 + ez[6,.];
   i = 7;
   do while i <= tsim;
   s[i,.] = conts + s[i-1,.] + es[i,.];
   z[i,.] = contx' + z[i-1,.]
                           + (z[i-1,.] - z[i-2,.]).*(parax[.,1]')
                           + (z[i-2,.] - z[i-3,.]).*(parax[.,2]')
                           + (z[i-3,.] - z[i-4,.]).*(parax[.,3]')
                           + (z[i-4,.] - z[i-5,.]).*(parax[.,4]')
                           + (z[i-5,.] - z[i-6,.]).*(parax[.,5]')
            + (s[i-1,.] - s[i-2,.]).*(paras[.,1]')
            + (s[i-2,.] - s[i-3,.]).*(paras[.,2]')
            + (s[i-3,.] - s[i-4,.]).*(paras[.,3]')
            + (s[i-4,.] - s[i-5,.]).*(paras[.,4]')
            + (s[i-5,.] - s[i-6,.]).*(paras[.,5]')
                   + ez[i,.];
   i = i + 1;
   endo;

   s = s[101:tsim,.];
   z = z[101:tsim,.];

   f = z + s;
   rmse = foresim1(s,f,t0,1);
    simr1[is,.] = rmse';
   rmse = foresim1(s,f,t0,16);
    simr16[is,.] = rmse';

 is = is + 1;
 endo;

 retp(simr1,simr16);
endp;

proc (2) = ms_non(parax,paras,contx,conts,resi,sx,ds,x,t,n,isim,t0);

local sigz, const,i,ii,seed,tsim,es,ez,e;
local betat, betag, t20, ta, theil_u, gtheil_u, gdm;
local simbt, simbg, is, s, z, simr11, simd11, simd12, rmse,dm;
local lag3, lag4, fsim;
local simr1, simr4, simr8, simr12, simr16;
local mse1,mse2,mse3,ds,dx;
local betag1, betag5, betat1,betat5,f,ine,ine2;

seed = 12234598;
tsim = t;

ds = ds - conts;

simbt = zeros(isim,2);
simbg = zeros(isim,2);
simr1 = zeros(isim,n);
simr16 = zeros(isim,n);

is = 1;
do while is <= isim;
   s = sx;
   z = sx;

   ine = int(1+rndus(rows(resi),1,seed).*rows(resi+1));
   ez   = resi[ine,.];  es = ds[ine,.];
   ine2 = int(1+rndus(1,1,seed)*rows(resi-7));
   z[1:6,.] = x[ine2:ine2+5,.];
   s[1:6,.] = s[ine2:ine2+5,.];

   i = 7;
   do while i <= tsim;
   s[i,.] = conts + s[i-1,.] + es[i-6,.];
   z[i,.] = contx' + z[i-1,.]
                           + (z[i-1,.] - z[i-2,.]).*(parax[.,1]')
                           + (z[i-2,.] - z[i-3,.]).*(parax[.,2]')
                           + (z[i-3,.] - z[i-4,.]).*(parax[.,3]')
                           + (z[i-4,.] - z[i-5,.]).*(parax[.,4]')
                           + (z[i-5,.] - z[i-6,.]).*(parax[.,5]')
            + (s[i-1,.] - s[i-2,.]).*(paras[.,1]')
            + (s[i-2,.] - s[i-3,.]).*(paras[.,2]')
            + (s[i-3,.] - s[i-4,.]).*(paras[.,3]')
            + (s[i-4,.] - s[i-5,.]).*(paras[.,4]')
            + (s[i-5,.] - s[i-6,.]).*(paras[.,5]')
                   + ez[i-6,.];
   i = i + 1;
   endo;

   f = z + s;

   f = z + s;

   rmse = foresim1(s,f,t0,1);
    simr1[is,.] = rmse';
   rmse = foresim1(s,f,t0,16);
    simr16[is,.] = rmse';

 is = is + 1;
 endo;

 retp(simr1,simr16);
endp;


proc  foresim1(s,f,t1,k);
local n,t,kk,rmse,fore,rwsp1,rwsp2,i3,s1,ss1,x1,y1,ss,m1;
local sss,xxx,yyy,be,f1,z,sk,z1,ssk,zz,vz,vs,beta,res;
local const,rdrif,r2,r3,mse2,mse3,thu2,kkk;

n    = cols(s);
t    = rows(s);
kk    = 1;
rmse = zeros(n,KK);

       fore  = zeros(t-t1-k+1,n);
       rwsp1  = fore; rwsp2 = fore;

         i3 = 1;
         do while i3 <= t - t1 - k + 1;

         s1 = s[1:t1+i3-1,.];
         ss1 = s[2:t1+i3-1,.] - s[1:t1+i3-2,.];
         f1 = f[1:t1+i3-1,.];
         z  = f1 - s1;
         sk    = s1[k+1:t1+i3-1,.] - s1[1:t1+i3-k-1,.];
         z1    =  z[1:t1+i3-k-1,.];
            ssk = sk - meanc(sk)';
            zz  = z1 - meanc(z1)';
            ssk = ssk - meanc(ssk');
            zz  = zz - meanc(zz');
           vz = vec(zz);
           vs = vec(ssk);
         beta = invpd(vz'vz)*vz'vs;
          res = sk - z1.*beta;
          const = meanc(res)';
         rdrif = meanc(ss1);
         fore[i3,.] = s[t1+k+i3-1,.]
                   -  const
                   - z[t1+i3-1,.].*beta - s[t1+i3-1,.];
         rwsp2[i3,.]= s[t1+i3+k-1,.] - s[t1+i3-1,.] - (rdrif*k)' ;
       i3 = i3 + 1;
       endo;
     r2      = rwsp2.*rwsp2;
     r3      = fore.*fore;
     mse2  = meanc(r2);
     mse3  = meanc(r3);
     thu2  = sqrt(mse3)./sqrt(mse2);
retp(thu2);
endp;


proc (2) = firstep(y,x,p);
local dx,pp,dxx,xx,i,ik,k,dz,dzz,dxxx;
dx = trimr(x,0,1) - trimr(x,1,0);
pp = p*2;
        y = trimr(y,1,0);x = trimr(x,1,0);
        x = trimr(x,p,p);y = trimr(y,p,p);
    ik = 1;
      do while ik <= cols(x);
        dxx = zeros(rows(dx)-pp,pp+1);
                i = 0;
                  do while i <= pp;
                      dxx[.,i+1] = trimr(dx[.,ik],i,pp-i);
                i = i + 1;
                endo;
        dxxx = ones(rows(dxx),1)~dxx;
        k       = dxxx*inv(dxxx'dxxx)*dxxx';
        y[.,ik] = y[.,ik] - k*y[.,ik];
        x[.,ik] = x[.,ik] - k*x[.,ik];
     ik = ik + 1;
     endo;

retp(y,x);
endp;

proc  pdlong(x,p);
local i,x1,j,y,xx,b,resi,s_s,se,t_last,lambda,rio,t;
local ip,tl;
t = rows(x);
rgain:
ip = p;
do while ip >= 0;
if ip == 0; lambda = x'x/rows(x); goto rio; endif;
    x1 = zeros(t-ip,ip+1);
     j = 0;
      do until j > ip;
       x1[.,j+1] = trimr(x,ip-j,j);
      j = j + 1;
     endo;

  y = x1[.,1]; xx= x1[.,2:cols(x1)];
  b = inv(xx'xx)*xx'y;
  resi = y - xx*b;
  s_s = resi'resi/(rows(y)-rows(b));
  se  = sqrt(diag(s_s*inv(xx'xx)));
 t_last = abs(b[rows(b),1]/se[rows(se),1]);
if t_last >= 1.96;
  lambda = sqrt(s_s)/(1-sumc(b));
  goto rio; endif;
ip = ip - 1;
endo;

rio:
retp(lambda);
endp;

proc (2) = betasim(s,z,k);
local kkk,ss,zz,bet,cl,t;
t = rows(z);
z  = z[1:t-k,.];
s = s[k+1:t,.] - s[1:t-k,.];
kkk = int(rows(s)/30);
{ss,zz} = firstep(s,z,kkk);
{bet,cl} = secstep(ss,zz,kkk+1,0);
retp(bet, cl);
endp;

proc (2) = secstep(y,x,p2,tbeta);
local t,vy,vx,i,beta,resi,rresi,ls,ls2,i1,ss,se,see,tl,cl,tx,tls;
local vz,xx,cl2,std,bb,tt,ltrend,vt;
t = rows(y);
vy = vec(y);
vx = vec(x);

xx = vx;

beta = inv(xx'xx)*xx'vy;
resi = vy - xx*beta;
       rresi = y - x*beta[1,1];

         ls = 0; ls2 = 0;
         i1 = 1;
          do while i1 <= cols(y);
             tls = pdlong(rresi[.,i1],p2);
             ls  = tls  + ls;
        i1 = i1 + 1;
        endo;
ls = ls/cols(y);

ss   = resi'resi/rows(resi);
se   = ss*inv(xx'xx);
cl2   = (beta-tbeta)./sqrt(diag(se));
cl2  = cl2.*sqrt(ss)/ls;
retp(beta,cl2);
endp;



proc (3) = sur(x,s,indx,p);

local t, m, dep,z, i, j, b, e, y, b1, sigma, invsig;
local num, den, indx1, indx2, indx3, indx4, i1, y2, x2, x1,parat;
local oldsig, k, bg, dis, para, k1, cr, oldbg,ik,ix,YZ,XZ,YS,XS,xx,xf;
local mi,kmax,tk,kmax1,indxq;
k1 = 850;  @ maximum number of iteration in iterative SUR @
cr = 2; @ convergence criterion in iterative SUR @

mi = indx + indx;
tk = sumc(mi);
kmax = maxc(mi);
kmax1 = maxc(indx);

{yz, xz} = lagp(x[.,1],kmax1);
t = rows(xz);
m = cols(x);
e = zeros(t,m);

        {yz, xz} = lagp(x[.,1],kmax1);
        {ys, xs} = lagp(s[.,1],kmax1);
if indx[1]== 1;  xz = xz[.,1:indx[1]]~ones(rows(xz),1); endif;
if indx[1] ne 1; xz = xz[.,1:indx[1]]~xs[.,2:indx[1]]~ones(rows(xz),1); endif;
               z = xz;
               b = invpd(z'z)*z'yz;
          e[.,1] = yz - z*b;
               y = yz;
              xx = z;

  i = 2;
  do while i <= m;
        {yz, xz} = lagp(x[.,i],kmax1);
        {ys, xs} = lagp(s[.,i],kmax1);
if indx[i]== 1;  xz = xz[.,1:indx[i]]~ones(rows(xz),1); endif;
if indx[i] ne 1; xz = xz[.,1:indx[i]]~xs[.,2:indx[i]]~ones(rows(xz),1); endif;
              z = xz;
             b1 = invpd(z'z)*z'yz;
         e[.,i] = yz - z*b1;
              y = y|yz;
             xx = xx~z;
   i = i + 1;
   endo;

sigma = zeros(m,m);

i = 1;
 do while i <= m;
   sigma[i,i] = e[.,i]'e[.,i]/(rows(z) - 1);
   j = i + 1;
   do while j <= m;
      sigma[i,j] = e[.,i]'e[.,j]/(rows(z) - 1);
      sigma[j,i] = sigma[i,j];
      j = j + 1;
   endo;
   i = i + 1;
endo;

invsig = invpd(sigma);

num = zeros(tk,1);
den = zeros(tk,tk);

indx1 = 0; indx2 = 0;
indx3 = 0; indx4 = 0;

i = 1;
 do while i <= m;

   indx1 = 1 + indx2;
   indx2 = indx1 + mi[i]-1;

   x1 = xx[.,indx1:indx2];
   den[indx1:indx2,indx1:indx2] = x1'x1*invsig[i,i];

indx3 = 0; indx4 = 0;

   j = i + 1;
   do while j <= m;
        if j == i+1; indx3 = sumc(mi[1:j-1,.]) + 1; endif;
        if j >  i+1; indx3 = 1 + indx4; endif;
                     indx4 = indx3 + mi[j]-1;
      x2 = xx[.,indx3:indx4];
      den[indx1:indx2,indx3:indx4] = x1'x2*invsig[i,j];
      den[indx3:indx4,indx1:indx2] = x2'x1*invsig[j,i];
    j = j + 1;
    endo;

 i1 = 1;
   do while i1 <= m;
      y2 = y[(i1-1)*t+1:i1*t];
      num[indx1:indx2,.] = num[indx1:indx2,.] + x1'y2*invsig[i,i1];
      i1 = i1 + 1;
  endo;

  i = i + 1;
endo;

oldbg = invpd(den)*num;

e = zeros(t,m);

indx1 = 0; indx2 = 0; indx3 = 0; indx4 = 0;

i = 1;
 do while i <= m;
                indx1 = (i-1)*t;
                indx2 = 1 + indx3;
                indx3 = indx2 + mi[i]-1;
           e[.,i] =   y[indx1+1:indx1+t]
                   - xx[.,indx2:indx3]*oldbg[indx2:indx3,.];
   i = i + 1;
endo;

oldsig = zeros(m,m);

i = 1;
 do while i <= m;
   oldsig[i,i] = e[.,i]'e[.,i]/(rows(z)-1);
   j = i + 1;
   do while j <= m;
      oldsig[i,j] = e[.,i]'e[.,j]/(rows(e)-1);
      oldsig[j,i] = oldsig[i,j];
      j = j + 1;
   endo;
   i = i + 1;
endo;


ik = 1;
 do while ik <= k1;
   invsig = inv(oldsig);

num = zeros(tk,1);
den = zeros(tk,tk);

indx1 = 0; indx2 = 0;

i = 1;
 do while i <= m;
                indx1 = 1 + indx2;
                indx2 = indx1 + mi[i]-1;
   x1 = xx[.,indx1:indx2];
   den[indx1:indx2,indx1:indx2] = x1'x1*invsig[i,i];

indx3 = 0; indx4 = 0;

   j = i + 1;
   do while j <= m;
        if j == i+1; indx3 = sumc(mi[1:j-1,.]) + 1; endif;
        if j >  i+1; indx3 = 1 + indx4; endif;
                     indx4 = indx3 + mi[j]-1;
      x2 = xx[.,indx3:indx4];
      den[indx1:indx2,indx3:indx4] = x1'x2*invsig[i,j];
      den[indx3:indx4,indx1:indx2] = x2'x1*invsig[j,i];

      j = j + 1;
 endo;

  i1 = 1;
    do while i1 <= m;
         y2 = y[(i1-1)*t+1:i1*t];
         num[indx1:indx2,.] = num[indx1:indx2,.] + x1'y2*invsig[i,i1];
         i1 = i1 + 1;
  endo;

 i = i + 1;
 endo;

   bg = invpd(den)*num;
   e = zeros(t,m);

indx1 = 0; indx2 = 0; indx3 = 0;

i = 1;
 do while i <= m;
                indx1 = (i-1)*t;
                indx2 = 1 + indx3;
                indx3 = indx2 + mi[i]-1;
  if bg[indx2,.] >= 1; bg[indx2,.] = 0.95; endif;
           e[.,i] =   y[indx1+1:indx1+t]
                   - xx[.,indx2:indx3]*bg[indx2:indx3,.];

   i = i + 1;
endo;

   sigma = zeros(m,m);

   i = 1;
   do while i <= m;
      sigma[i,i] = e[.,i]'e[.,i]/(rows(e)-cols(z));

      j = i + 1;
      do while j <= m;
         sigma[i,j] = e[.,i]'e[.,j]/(rows(e)-cols(z));
         sigma[j,i] = sigma[i,j];
         j = j + 1;
      endo;

      i = i + 1;
   endo;

   dis = abs((bg|vec(sigma))-(oldbg|vec(oldsig)))./(oldbg|vec(oldsig));
   dis = maxc(dis);
   if dis < cr; "Round:";;ik;;dis; goto label; endif;
   oldbg = bg; oldsig = sigma;
   ik = ik + 1;
   endo;

label:

para = zeros(m,p*2);
indx1 = 0; indx2 = 0; indx3 = 0; indx4 = 0;

  i = 1;
  do while i <= m;
                indx1 = 1 + indx2;
                indx2 = indx1 + mi[i]-1;
     para[i,1:rows(bg[indx1:indx2-1,.])]= (bg[indx1:indx2-1,.])';
     para[i,p*2]= (bg[indx2,.])';
  i = i + 1;
  endo;

retp(para, sigma , e);
endp;

proc (3) = surnt(x,s,nt,indx,p);

local t, m, dep,z, i, j, b, e, y, b1, sigma, invsig;
local num, den, indx1, indx2, indx3, indx4, i1, y2, x2, x1,parat;
local oldsig, k, bg, dis, para, k1, cr, oldbg,ik,ix,YZ,XZ,YS,XS,xx,xf;
local mi,kmax,tk,kmax1,indxq;
k1 = 850;  @ maximum number of iteration in iterative SUR @
cr = 1e-01; @ convergence criterion in iterative SUR @

indx = indx - 1;

i = 1;
do while i <= rows(indx);
if indx[i] == 0; indx[i] = 1; endif;
i = i + 1;
endo;

mi = indx;
i = 1;
do while i <= nt;
mi[i] = indx[i] + indx[i] + 1;
i= i + 1;
endo;

i = nt+1;
do while i <= rows(indx);
mi[i] = indx[i] + indx[i];
i= i + 1;
endo;

tk = sumc(mi);
kmax = maxc(mi);
kmax1 = maxc(indx) + 1;
{yz, xz} = lagp1(x[.,1],kmax1);
t = rows(xz);
m = cols(x);
e = zeros(t,m);

        {yz, xz} = lagp1(x[.,1],kmax1);
        {ys, xs} = lagp1(s[.,1],kmax1);
           xz = xz[.,1:indx[1]]~xs[.,1:indx[1]]~ones(t,1);
               z = xz;
               b = invpd(z'z)*z'yz;
          e[.,1] = yz - z*b;
               y = yz;
              xx = z;

  i = 2;
  do while i <= nt;
        {yz, xz} = lagp1(x[.,i],kmax1);
        {ys, xs} = lagp1(s[.,i],kmax1);
           xz = xz[.,1:indx[i]]~xs[.,1:indx[i]]~ones(t,1);
              z = xz;
             b1 = invpd(z'z)*z'yz;
         e[.,i] = yz - z*b1;
              y = y|yz;
             xx = xx~z;
   i = i + 1;
   endo;

  i = nt+1;
  do while i <= m;
        {yz, xz} = lagp1(x[.,i],kmax1);
        {ys, xs} = lagp1(s[.,i],kmax1);
           xz = xz[.,1:indx[i]]~xs[.,1:indx[i]];
              z = xz;
             b1 = invpd(z'z)*z'yz;
         e[.,i] = yz - z*b1;
              y = y|yz;
             xx = xx~z;
   i = i + 1;
   endo;

sigma = zeros(m,m);

i = 1;
 do while i <= m;
   sigma[i,i] = e[.,i]'e[.,i]/(rows(z) - 1);
   j = i + 1;
   do while j <= m;
      sigma[i,j] = e[.,i]'e[.,j]/(rows(z) - 1);
      sigma[j,i] = sigma[i,j];
      j = j + 1;
   endo;
   i = i + 1;
endo;

invsig = invpd(sigma);

num = zeros(tk,1);
den = zeros(tk,tk);

indx1 = 0; indx2 = 0;
indx3 = 0; indx4 = 0;

i = 1;
 do while i <= m;

   indx1 = 1 + indx2;
   indx2 = indx1 + mi[i]-1;

   x1 = xx[.,indx1:indx2];
   den[indx1:indx2,indx1:indx2] = x1'x1*invsig[i,i];

indx3 = 0; indx4 = 0;

   j = i + 1;
   do while j <= m;
        if j == i+1; indx3 = sumc(mi[1:j-1,.]) + 1; endif;
        if j >  i+1; indx3 = 1 + indx4; endif;
                     indx4 = indx3 + mi[j]-1;
      x2 = xx[.,indx3:indx4];
      den[indx1:indx2,indx3:indx4] = x1'x2*invsig[i,j];
      den[indx3:indx4,indx1:indx2] = x2'x1*invsig[j,i];
    j = j + 1;
    endo;

 i1 = 1;
   do while i1 <= m;
      y2 = y[(i1-1)*t+1:i1*t];
      num[indx1:indx2,.] = num[indx1:indx2,.] + x1'y2*invsig[i,i1];
      i1 = i1 + 1;
  endo;

  i = i + 1;
endo;

oldbg = invpd(den)*num;

e = zeros(t,m);

indx1 = 0; indx2 = 0; indx3 = 0; indx4 = 0;

i = 1;
 do while i <= m;
                indx1 = (i-1)*t;
                indx2 = 1 + indx3;
                indx3 = indx2 + mi[i]-1;
           e[.,i] =   y[indx1+1:indx1+t]
                   - xx[.,indx2:indx3]*oldbg[indx2:indx3,.];
   i = i + 1;
endo;

oldsig = zeros(m,m);

i = 1;
 do while i <= m;
   oldsig[i,i] = e[.,i]'e[.,i]/(rows(z)-1);
   j = i + 1;
   do while j <= m;
      oldsig[i,j] = e[.,i]'e[.,j]/(rows(e)-1);
      oldsig[j,i] = oldsig[i,j];
      j = j + 1;
   endo;
   i = i + 1;
endo;


ik = 1;
 do while ik <= k1;
   invsig = inv(oldsig);

num = zeros(tk,1);
den = zeros(tk,tk);

indx1 = 0; indx2 = 0;

i = 1;
 do while i <= m;
                indx1 = 1 + indx2;
                indx2 = indx1 + mi[i]-1;
   x1 = xx[.,indx1:indx2];
   den[indx1:indx2,indx1:indx2] = x1'x1*invsig[i,i];

indx3 = 0; indx4 = 0;

   j = i + 1;
   do while j <= m;
        if j == i+1; indx3 = sumc(mi[1:j-1,.]) + 1; endif;
        if j >  i+1; indx3 = 1 + indx4; endif;
                     indx4 = indx3 + mi[j]-1;
      x2 = xx[.,indx3:indx4];
      den[indx1:indx2,indx3:indx4] = x1'x2*invsig[i,j];
      den[indx3:indx4,indx1:indx2] = x2'x1*invsig[j,i];

      j = j + 1;
 endo;

  i1 = 1;
    do while i1 <= m;
         y2 = y[(i1-1)*t+1:i1*t];
         num[indx1:indx2,.] = num[indx1:indx2,.] + x1'y2*invsig[i,i1];
         i1 = i1 + 1;
  endo;

 i = i + 1;
 endo;

   bg = invpd(den)*num;
   e = zeros(t,m);

indx1 = 0; indx2 = 0; indx3 = 0;

i = 1;
 do while i <= m;
                indx1 = (i-1)*t;
                indx2 = 1 + indx3;
                indx3 = indx2 + mi[i]-1;
           e[.,i] =   y[indx1+1:indx1+t]
                   - xx[.,indx2:indx3]*bg[indx2:indx3,.];

   i = i + 1;
endo;

   sigma = zeros(m,m);

   i = 1;
   do while i <= m;
      sigma[i,i] = e[.,i]'e[.,i]/(rows(e)-cols(z));

      j = i + 1;
      do while j <= m;
         sigma[i,j] = e[.,i]'e[.,j]/(rows(e)-cols(z));
         sigma[j,i] = sigma[i,j];
         j = j + 1;
      endo;

      i = i + 1;
   endo;

   dis = abs((bg|vec(sigma))-(oldbg|vec(oldsig)))./(oldbg|vec(oldsig));
   dis = maxc(dis);
   if dis < cr; "Round:";;ik;;dis; goto label; endif;
   oldbg = bg; oldsig = sigma;
   ik = ik + 1;
   endo;

label:

para = zeros(m,p*2);
indx1 = 0; indx2 = 0; indx3 = 0; indx4 = 0;

  i = 1;
  do while i <= nt;
                indx1 = 1 + indx2;
                indx2 = indx1 + mi[i]-1;
     para[i,1:rows(bg[indx1:indx2-1,.])]= (bg[indx1:indx2-1,.])';
     para[i,p*2]= (bg[indx2,.])';
  i = i + 1;
  endo;

  i = nt+1;
  do while i <= m;
                indx1 = 1 + indx2;
                indx2 = indx1 + mi[i]-1;
     para[i,1:rows(bg[indx1:indx2,.])]= (bg[indx1:indx2,.])';
  i = i + 1;
  endo;

retp(para, sigma , e);
endp;

proc detlag(s,pp,icoption);
local i,ss,i1,y,x,const, b, resi,s_s,se,t_last, rio,n;
local indx;

n = cols(s);
indx = ones(n,1);

i = 1;
do while i <= n;
ss = s[.,i];

i1 = pp;
do while i1 >= 2;

{y,x} = lagp(ss,i1);
const = ones(rows(y),1);
if icoption == 1; x = const~x; endif;
if icoption == 2; x = const~seqa(1,1,rows(x))~x; endif;
b = inv(x'x)*x'y;
resi = y - x*b;
s_s = resi'resi/(rows(y) - rows(b) );
se  = sqrt(diag(s_s*inv(x'x)));
t_last = abs(b[rows(b),1]/se[rows(se),1]);
if t_last >= 1.96; indx[i,1] = i1; goto rio; endif;

i1 = i1 -1;
endo;
rio:

i = i + 1;
endo;
retp(indx);
endp;

proc detlagnc(s,pp,icoption);
local i,ss,i1,y,x,const, b, resi,s_s,se,t_last, rio,n;
local indx;

n = cols(s);
indx = ones(n,1);
i = 1;
do while i <= n;
ss = s[.,i];

i1 = pp;
do while i1 >= 2;

{y,x} = lagp1(ss,i1);
const = ones(rows(y),1);
if icoption == 1; x = const~x; endif;
b = inv(x'x)*x'y;
resi = y - x*b;
s_s = resi'resi/(rows(y) - rows(b) );
se  = sqrt(diag(s_s*inv(x'x)));
t_last = abs(b[rows(b),1]/se[rows(se),1]);
if t_last >= 1.96; indx[i,1] = i1; goto rio; endif;

i1 = i1 -1;
endo;
rio:

i = i + 1;
endo;
retp(indx);
endp;


proc (2) = lagp(x,p);
local t,i,xx,dx,y,rio;
t = rows(x);

if p == 1;
y = x[2:t,.]; x = x[1:t-1,.]; goto rio; endif;

xx = zeros(t-p,p+1);
dx = zeros(t-p,p-1);

i = 0; do while i <= p;
xx[.,i+1] = x[p+1-i:t-i,.];
i = i + 1; endo;

i = 1; do while i <= p-1;
dx[.,p-i] = xx[.,p-(i-1)] - xx[.,p+1-(i-1)];
i = i + 1; endo;

y = xx[.,1];  x = xx[.,2]~dx;
rio:
retp(y,x); endp;


 proc (3) = suladf(f,p,option);
 local y,x,beta,resi,ss,var_cov,va;
 {y, x} = lagp(f,p);
 if option == 1;  x = x~ones(rows(x),1); endif;
 if option == 2;  x = x~ones(rows(x),1)~seqa(1,1,rows(x)); endif;
 beta = inv(x'x)*x'y;
 resi = y - x*beta;
 ss   = (resi'resi)/(rows(y) - cols(x));
 var_cov = ss*inv(x'x);
 va = (beta[1,1] - 1)/sqrt(var_cov[1,1]);
 retp(beta,va,resi);
 endp;

proc (2) = lagp1(x,p);
local t,i,xx,dx,y,rio;
t = rows(x);
if p == 1; y = x[2:t,.] - x[1:t-1,.]; x = zeros(t-1,1); goto rio; endif;
xx = zeros(t-p,p+1);dx = zeros(t-p,p-1);

i = 0;do while i <= p;
xx[.,i+1] = x[p+1-i:t-i,.];
i = i + 1;endo;

i = 1;do while i <= p-1;
dx[.,p-i] = xx[.,p-(i-1)] - xx[.,p+1-(i-1)];
i = i + 1;endo;

y = xx[.,1] - xx[.,2];
x = dx; rio:
retp(y,x); endp;


proc (2) = lsdv(y,x,p2,p);
local dy,dx30,dx20,dx10,dx00,dx01,dx02,dx03,crt;
local ys1,xs1,y2,x2,y3,z3,vy,vx,xx,ys2,xs2,icount;
local resi,theta,i,k,rresi,ls,i1,tls,ss,se,cl2,be2,be3,kbe;
local const,trend,dxx,xx1,be1,kkk;
dy = y[2:rows(y),.] - y[1:rows(y)-1,.];
x  = x[1:rows(x)-1,.];

if p == 0;
dx00 = x[2:rows(x),.] - x[1:rows(x)-1,.];
y  = dy[2:rows(dy),.];
x  =  x[2:rows(x),.];
endif;

if p == 1;
dx10 = x[4:rows(x)  ,.] - x[3:rows(x)-1,.];
dx00 = x[3:rows(x)-1,.] - x[2:rows(x)-2,.];
dx01 = x[2:rows(x)-2,.] - x[1:rows(x)-3,.];
y  = dy[3:rows(dy)-1,.];
x  =  x[3:rows(x)-1,.];
endif;

if p == 2;
dx20 = x[6:rows(x),.]   - x[5:rows(x)-1,.];
dx10 = x[5:rows(x)-1,.] - x[4:rows(x)-2,.];
dx00 = x[4:rows(x)-2,.] - x[3:rows(x)-3,.];
dx01 = x[3:rows(x)-3,.] - x[2:rows(x)-4,.];
dx02 = x[2:rows(x)-4,.] - x[1:rows(x)-5,.];
y  = dy[4:rows(dy)-2,.];
x  =  x[4:rows(x)-2,.];
endif;

if p == 4;
dx00 = x[4:rows(x),.]   - x[3:rows(x)-1,.];
dx01 = x[3:rows(x)-1,.] - x[2:rows(x)-2,.];
dx02 = x[2:rows(x)-2,.] - x[1:rows(x)-3,.];
y  = dy[4:rows(dy),.];
x  =  x[4:rows(x),.];
endif;

if p == 3;
   dx30 = x[8:rows(x),.]   - x[7:rows(x)-1,.];
   dx20 = x[7:rows(x)-1,.] - x[6:rows(x)-2,.];
   dx10 = x[6:rows(x)-2,.] - x[5:rows(x)-3,.];
   dx00 = x[5:rows(x)-3,.] - x[4:rows(x)-4,.];
   dx01 = x[4:rows(x)-4,.] - x[3:rows(x)-5,.];
   dx02 = x[3:rows(x)-5,.] - x[2:rows(x)-6,.];
   dx03 = x[2:rows(x)-6,.] - x[1:rows(x)-7,.];

   x    = x[5:rows(x)-3,.];
   y   = dy[5:rows(dy)-3,.];
endif;

vy = vec(y);
vx = vec(x);

const = zeros(rows(vy),cols(y));
trend = zeros(rows(vy),cols(y));
theta = zeros(rows(vy),rows(y));

if p == 0;
dxx   = zeros(rows(vy),cols(y));
i = 1;
do while i <= cols(y);
const[1+(i-1)*rows(y):i*rows(y),i] = ones(rows(y),1);
trend[1+(i-1)*rows(y):i*rows(y),i] = seqa(1,1,rows(y));
dxx[1+(i-1)*rows(y):i*rows(y),1+(i-1):i] =
 dx00[.,i];
theta[1+(i-1)*rows(y):i*rows(y),.] = eye(rows(y));
i = i + 1;
endo;
endif;

if p == 1;
dxx   = zeros(rows(vy),cols(y)*3);
i = 1;
do while i <= cols(y);
const[1+(i-1)*rows(y):i*rows(y),i] = ones(rows(y),1);
trend[1+(i-1)*rows(y):i*rows(y),i] = seqa(1,1,rows(y));
dxx[1+(i-1)*rows(y):i*rows(y),1+(i-1)*3:i*3] =
 dx10[.,i]~dx00[.,i]~dx01[.,i];
theta[1+(i-1)*rows(y):i*rows(y),.] = eye(rows(y));
i = i + 1;
endo;
endif;

if p == 2;
dxx   = zeros(rows(vy),cols(y)*5);
i = 1;
do while i <= cols(y);
const[1+(i-1)*rows(y):i*rows(y),i] = ones(rows(y),1);
trend[1+(i-1)*rows(y):i*rows(y),i] = seqa(1,1,rows(y));
dxx[1+(i-1)*rows(y):i*rows(y),1+(i-1)*5:i*5] =
 dx20[.,i]~dx10[.,i]~dx00[.,i]~dx01[.,i]~dx02[.,i];
theta[1+(i-1)*rows(y):i*rows(y),.] = eye(rows(y));
i = i + 1;
endo;
endif;

if p == 4;
dxx   = zeros(rows(vy),cols(y)*3);
i = 1;
do while i <= cols(y);
const[1+(i-1)*rows(y):i*rows(y),i] = ones(rows(y),1);
trend[1+(i-1)*rows(y):i*rows(y),i] = seqa(1,1,rows(y));
dxx[1+(i-1)*rows(y):i*rows(y),1+(i-1)*3:i*3] =
 dx00[.,i]~dx01[.,i]~dx02[.,i];
theta[1+(i-1)*rows(y):i*rows(y),.] = eye(rows(y));
i = i + 1;
endo;
endif;

if p==3;
dxx   = zeros(rows(vy),cols(y)*7);
i = 1;
do while i <= cols(y);
const[1+(i-1)*rows(y):i*rows(y),i] = ones(rows(y),1);
trend[1+(i-1)*rows(y):i*rows(y),i] = seqa(1,1,rows(y));
dxx[1+(i-1)*rows(y):i*rows(y),1+(i-1)*7:i*7] =
  dx30[.,i]~dx20[.,i]~dx10[.,i]~dx00[.,i]~dx01[.,i]~dx02[.,i]~dx03[.,i];
theta[1+(i-1)*rows(y):i*rows(y),.] = eye(rows(y));
i = i + 1;
endo;
endif;

xx1 = vx~const~dxx~theta[.,2:cols(theta)];
kkk = invpd(xx1'xx1);
be1 = kkk*xx1'vy;

resi = vy - xx1*be1;

         ls = 0;
         i1 = 1;
          do while i1 <= cols(y);
             tls = pdlong(resi[1+(i1-1)*rows(y):i1*rows(y),.],p2);
             ls  = tls  + ls;
        i1 = i1 + 1;
        endo;
ls = ls/cols(y);

ss   = resi'resi/rows(resi);
se   = sqrt(diag(ss*kkk));
cl2   = be1[1,1]./se[1,1];
cl2  = cl2.*sqrt(ss)/ls;

retp(be1[1,1],cl2);
endp;

proc  pdlong(x,p);
local i,x1,j,y,xx,b,resi,s_s,se,t_last,lambda,rio,t;
local ip,tl,ss;
t = rows(x);
top:
ip = p;
if p == 0; lambda = sqrt((x'x)/(rows(x)-1)); retp(lambda); endif;
    x1 = zeros(t-ip,ip+1);

     j = 0;
      do until j > ip;
       x1[.,j+1] = trimr(x,ip-j,j);
      j = j + 1;
     endo;

  y = x1[.,1]; xx= x1[.,2:cols(x1)];
  b = invpd(xx'xx)*xx'y;
  resi = y - xx*b;
  s_s = resi'resi/(rows(y)-rows(b));
  ss  = diag(s_s*invpd(xx'xx));
  tl  = abs(b[rows(b)])./sqrt(ss[rows(ss)]);
  if tl > 1.96; goto final; endif;
  p = p - 1; goto top;
final:
 if sumc(b) > 1;
    "the sum of roots of error is greater than one. Reset maximum q again";
     endif;
lambda = sqrt(s_s)/(1-sumc(b));
retp(lambda);
endp;
