*-------------------------------------------------------------------------------------------------------------
*
*	Summaries File
*	Felix Ward
*	
*
*-------------------------------------------------------------------------------------------------------------

qui{
clear all

set mem 500m
set more off

*================= SETTINGS ======================================================================================

* Working directory
local path /Users/felixward/Dropbox/CrisisPrediction/


capture log close
use "`path'Data/prepared_post70_y.dta", clear

*sum

*________________CRISIS MAPS____________________

**________export csv for R CrisisMap ____________
n display "export CSV data"

order country year b0
sort country year
drop if year > 2011
outsheet country year b0 using "`path'Data/R_crisis_post70.csv", comma replace





*______________INDICATOR TABLE__________________
n display "Generate indicator table"

local all loans_y ///
	pdebt_y er_gr gdp_r_gr cpi_gr ///
	loans_r_gr pdebt_r_gr a_ltrate_gap ///
	loans_y_gr er_gap gdp_r_gap ///
	loans_r_gap pdebt_r_gap ///
	pdebt_y_gap a_pdebt_y_gap rer ///
	loans_y_gap a_stir a_ltrate a_stir_r a_ltrate_r ///
	a_pdebt_y rer_gr a_loans_y a_gdp_r_gr /// 
	a_cpi_gr a_stocks_r_gr a_loans_r_gr a_pdebt_r_gr /// 
	a_loans_y_gr a_gdp_r_gap a_stir_gap a_stir_r_gap ///
	a_ltrate_r_gap a_stocks_r_gap a_loans_r_gap a_pdebt_y_gap ///
	rer_gap a_loans_y_gap er ///
	c_y i_y nx_y c_r_gr i_r_gr ///
	nx_r_gr c_y_gr i_y_gr nx_y_gr c_r_gap ///
	i_r_gap nx_r_gap c_y_gap i_y_gap nx_y_gap ///
	a_c_y a_i_y a_nx_y a_c_r_gr a_i_r_gr ///
	a_nx_r_gr a_c_y_gr a_i_y_gr a_nx_y_gr a_c_r_gap ///
	a_i_r_gap a_nx_r_gap a_c_y_gap a_i_y_gap a_nx_y_gap 


local allname "Loans/GDP" ///
	"Public Debt/GDP" "Exchange Rate (n)(gr)" "GDP (gr)" "Inflation" ///
	"Loans (gr)" "Public Debt (gr)" "LT Interest Rate (gap)(glo)" ///
	"Loans/GDP (gr)" "Exchange Rate (n)(gap)" "GDP (gap)" ///
	"Loans (gap)" "Public Debt (gap)" ///
	"Public Debt/GDP (gap)" "Public Debt/GDP (gap)(glo)" "Real Exchange Rate" ///
	"Loans/GDP (gap)" "ST Interest Rate (n)(glo)" "LT Interest Rate (n)(glo)" "ST Interest Rate (glo)" "LT Interest Rate (glo)" ///
	"Public Debt/GDP (gap)(glo)" "Real Exchange Rate (gr)" "Loans/GDP (glo)" "GDP (gr)(glo)" ///
	"Inflation (glo)" "Stock Prices (gr)(glo)" "Loans (gr)(glo)" "Public Debt (gr)(glo)" ///
	"Loans/GDP (gr)(glo)" "GDP (gap)(glo)" "ST Interest Rate (n)(gap)(glo)" "ST Interest Rate (gap)(glo)" ///
	"LT Interest Rate (gap)(glo)" "Stock Prices (gap)(glo)" "Loans (gap)(glo)" "Public Debt/GDP (gap)(glo)" ///
	"Real Exchange Rate (gap)" "Loans/GDP (gap)" "Exchange Rate (n)" ///
	"C/GDP" "I/GDP" "Net Exports/GDP" "C (gr)" "I (gr)" ///
	"Net Exports (gr)" "C/GDP (gr)" "I/GDP (gr)" "Net Exports/GDP (gr)" "C (gap)" ///
	"I (gap)" "Net Exports (gap)" "C/GDP (gap)" "I/GDP (gap)" "Net Exports/GDP (gap)" ///
	"C/GDP (glo)" "I/GDP (glo)" "Net Exports/GDP (glo)" "C (gr)(glo)" "I (gr)(glo)" ///
	"Net Exports (gr)(glo)" "C/GDP (gr)(glo)" "I/GDP (gr)(glo)" "Net Exports/GDP (gr)(glo)" "C (gap)(glo)" ///
	"I (gap)(glo)" "Net Exports (gap)(glo)" "C/GDP (gap)(glo)" "I/GDP (gap)(glo)" "Net Exports/GDP (gap)(glo)"
 
local vecsize : word count `all'  

*observation classifier across countries
gen id = 1
replace id = id[_n-1]+1 if (_n>1)


*map variable names onto id
gen str26 name = "v"
forvalues y = 1/`vecsize' {

	local d : word `y' of "`allname'"
			
	replace name = `"`d'"' if id==`y'
  	
  	}
	
  	
estpost summarize loans_y ///
	pdebt_y er_gr gdp_r_gr cpi_gr ///
	loans_r_gr pdebt_r_gr a_ltrate_gap ///
	loans_y_gr er_gap gdp_r_gap ///
	loans_r_gap pdebt_r_gap ///
	pdebt_y_gap a_pdebt_y_gap rer ///
	loans_y_gap a_stir a_ltrate a_stir_r a_ltrate_r ///
	a_pdebt_y rer_gr a_loans_y a_gdp_r_gr /// 
	a_cpi_gr a_stocks_r_gr a_loans_r_gr a_pdebt_r_gr /// 
	a_loans_y_gr a_gdp_r_gap a_stir_gap a_stir_r_gap ///
	a_ltrate_r_gap a_stocks_r_gap a_loans_r_gap a_pdebt_y_gap ///
	rer_gap a_loans_y_gap er ///
	c_y i_y nx_y c_r_gr i_r_gr ///
	nx_r_gr c_y_gr i_y_gr nx_y_gr c_r_gap ///
	i_r_gap nx_r_gap c_y_gap i_y_gap nx_y_gap ///
	a_c_y a_i_y a_nx_y a_c_r_gr a_i_r_gr ///
	a_nx_r_gr a_c_y_gr a_i_y_gr a_nx_y_gr a_c_r_gap ///
	a_i_r_gap a_nx_r_gap a_c_y_gap a_i_y_gap a_nx_y_gap, detail

*get #observations, mean, s.d., min, max
matrix o = e(count)'
svmat o, names(obs)

matrix m = e(mean)'
svmat m, names(mean)

matrix sd = e(sd)'
svmat sd, names(sd)

matrix min = e(p5)'
svmat min, names(min)

matrix max = e(p95)'
svmat max, names(max)

format mean1 sd1 min1 max1 %4.2fc

sort name

*new observation classifier across countries
gen id2 = 1
replace id2 = id2[_n-1]+1 if (_n>1)


listtab name obs1 mean1 sd1 min1 max1 if (id2 <= 50) using "`path'Written/Indicators1_post70_y.txt", replace end(\\) delimiter(&) begin() head("\newcolumntype{C}{>{\centering\arraybackslash}X}%""\begin{tabularx}{1.175\textwidth}{lCCCCC}""\toprule \\""Indicator & Obs. & Mean & S.D. & 5th perc. & 95th perc. \\ \midrule") foot("\bottomrule""\end{tabularx}")	
listtab name obs1 mean1 sd1 min1 max1 if (id2 > 50 & id <=`vecsize') using "`path'Written/Indicators2_post70_y.txt", replace end(\\) delimiter(&) begin() head("\newcolumntype{C}{>{\centering\arraybackslash}X}%""\begin{tabularx}{1.175\textwidth}{lCCCCC}""\toprule""Indicator & Obs. & Mean & S.D. & 5th perc. & 95th perc. \\ \midrule") foot("\bottomrule""\end{tabularx}")	



*____________________________________________

}



