*-------------------------------------------------------------------------------------------------------------
*
*	Summaries File
*	Felix Ward
*	
*
*-------------------------------------------------------------------------------------------------------------

qui{
clear all

set mem 500m
set more off

local path /Users/felixward/Dropbox/CrisisPrediction/


capture log close
use "`path'Data/prepared_post70_q.dta", clear

*sum



*______________INDICATOR TABLE__________________
n display "Generate indicator table"
local all tloans tloans_r tloans_gr tloans_r_gr tloans_gap ///
 tloans_r_gap cpi cpi_gr a_fliab a_tloans ///
 a_hopr a_stocks a_gdp a_fliab_r a_tloans_r ///
 a_hopr_r a_stocks_r a_gdp_r a_fliab_y a_tloans_y ///
 a_fliab_gr a_tloans_gr a_hopr_gr a_stocks_gr a_gdp_gr ///
 a_fliab_r_gr a_tloans_r_gr a_hopr_r_gr a_stocks_r_gr a_gdp_r_gr ///
 a_fliab_y_gr a_tloans_y_gr a_dif_stir a_dif_ltrate a_dif_stir_r ///
 a_dif_ltrate_r a_stir a_ltrate a_stir_r a_ltrate_r ///
 a_fliab_gap a_tloans_gap a_hopr_gap a_stocks_gap a_gdp_gap ///
 a_fliab_r_gap a_tloans_r_gap a_hopr_r_gap a_stocks_r_gap a_gdp_r_gap ///
 a_fliab_y_gap a_tloans_y_gap a_cpi a_cpi_gr res ///
 res_r res_gr res_r_gr ///
 res_gap res_r_gap a_res a_res_r ///
 a_res_y a_res_gr a_res_r_gr a_res_y_gr a_res_gap ///
 a_res_r_gap a_res_y_gap er_gr rer_gr er_gap ///
 rer_gap


local allname "Loans (n)" "Loans" "Loans (n)(gr)" "Loans (gr)" "Loans (n)(gap)" ///
 "Loans (gap)" "CPI" "Inflation" "Foreign Liabilities (n)(glo)" "Loans (n)(glo)" ///
 "House Prices (n)(glo)" "Stock Prices (n)(glo)" "GDP (n)(glo)" "Foreign Liabilities (glo)" "Loans (glo)" ///
 "House Prices (glo)" "Stock Prices (glo)" "GDP (glo)" "Foreign Liabilities/GDP (glo)" "Loans/GDP (glo)" ///
 "Foreign Liabilities (n)(gr)(glo)" "Loans (n)(gr)(glo)" "House Prices (n)(gr)(glo)" "Stock Prices (n)(gr)(glo)" "GDP (n)(gr)(glo)" ///
 "Foreign Liabilities (gr)(glo)" "Loans (gr)(glo)" "House Prices (gr)(glo)" "Stock Prices (gr)(glo)" "GDP (gr)(glo)" ///
 "Foreign Liabilities/GDP (gr)(glo)" "Loans/GDP (gr)(glo)" "ST Interest Rate Diff. (n)(glo)" "LT Interest Rate Diff. (n)(glo)" "ST Interest Rate Diff. (glo)" ///
 "LT Interest Rate Diff. (glo)" "ST Interest Rate (n)(glo)" "LT Interest Rate (n)(glo)" "ST Interest Rate (glo)" "LT Interest Rate (glo)" ///
 "Foreign Liabilities (n)(gap)(glo)" "Loans (n)(gap)(glo)" "House Prices (n)(gap)(glo)" "Stock Prices (n)(gap)(glo)" "GDP (n)(gap)(glo)" ///
 "Foreign Liabilities (gap)(glo)" "Loans (gap)(glo)" "House Prices (gap)(glo)" "Stock Prices (gap)(glo)" "GDP (gap)(glo)" ///
 "Foreign Liabilities/GDP (gap)(glo)" "Loans/GDP (gap)(glo)" "CPI (glo)" "Inflation (glo)" "Reserves (n)" ///
 "Reserves" "Reserves (n)(gr)" "Reserves (gr)" ///
 "Reserves (n)(gap)" "Reserves (gap)" "Reserves (n)(glo)" "Reserves (glo)" ///
 "Reserves/GDP (glo)" "Reserves (n)(gr)(glo)" "Reserves (gr)(glo)" "Reserves/GDP (gr)(glo)" "Reserves (n)(gap)(glo)" ///
 "Reserves (gap)(glo)" "Reserves/GDP (gap)(glo)" "Exchange Rate (n)(gr)" "Real Exchange Rate (gr)" "Exchange Rate (n)(gap)" ///
 "Real Exchange Rate (gap)"

 
local vecsize : word count `all'  
n display "`vecsize'"
local vecsize2 : word count `allname'
n display "`vecsize2'"

*observation classifier across countries
gen id = 1
replace id = id[_n-1]+1 if (_n>1)


*map variable names onto id
gen str26 name = "v"
forvalues y = 1/`vecsize' {

	local d : word `y' of "`allname'"
			
	replace name = `"`d'"' if id==`y'
  	
  	}
	
  	
estpost summarize tloans tloans_r tloans_gr tloans_r_gr tloans_gap ///
 tloans_r_gap cpi cpi_gr a_fliab a_tloans ///
 a_hopr a_stocks a_gdp a_fliab_r a_tloans_r ///
 a_hopr_r a_stocks_r a_gdp_r a_fliab_y a_tloans_y ///
 a_fliab_gr a_tloans_gr a_hopr_gr a_stocks_gr a_gdp_gr ///
 a_fliab_r_gr a_tloans_r_gr a_hopr_r_gr a_stocks_r_gr a_gdp_r_gr ///
 a_fliab_y_gr a_tloans_y_gr a_dif_stir a_dif_ltrate a_dif_stir_r ///
 a_dif_ltrate_r a_stir a_ltrate a_stir_r a_ltrate_r ///
 a_fliab_gap a_tloans_gap a_hopr_gap a_stocks_gap a_gdp_gap ///
 a_fliab_r_gap a_tloans_r_gap a_hopr_r_gap a_stocks_r_gap a_gdp_r_gap ///
 a_fliab_y_gap a_tloans_y_gap a_cpi a_cpi_gr res ///
 res_r res_gr res_r_gr ///
 res_gap res_r_gap a_res a_res_r ///
 a_res_y a_res_gr a_res_r_gr a_res_y_gr a_res_gap ///
 a_res_r_gap a_res_y_gap er_gr rer_gr er_gap ///
 rer_gap, detail
 
*get #observations, mean, s.d., min, max
matrix o = e(count)'
svmat o, names(obs)

matrix m = e(mean)'
svmat m, names(mean)

matrix sd = e(sd)'
svmat sd, names(sd)

matrix min = e(p5)'
svmat min, names(min)

matrix max = e(p95)'
svmat max, names(max)

format mean1 sd1 min1 max1 %4.2fc

sort name

*new observation classifier across countries
gen id2 = 1
replace id2 = id2[_n-1]+1 if (_n>1)


listtab name obs1 mean1 sd1 min1 max1 if (id2 <= 50) using "`path'Written/Indicators1_post70_q.txt", replace end(\\) delimiter(&) begin() head("\newcolumntype{C}{>{\centering\arraybackslash}X}%""\begin{tabularx}{1.175\textwidth}{lCCCCC}""\toprule \\""Indicator & Obs. & Mean & S.D. & 5th perc. & 95th perc. \\ \midrule") foot("\bottomrule""\end{tabularx}")	
listtab name obs1 mean1 sd1 min1 max1 if (id2 > 50 & id <=`vecsize') using "`path'Written/Indicators2_post70_q.txt", replace end(\\) delimiter(&) begin() head("\newcolumntype{C}{>{\centering\arraybackslash}X}%""\begin{tabularx}{1.175\textwidth}{lCCCCC}""\toprule""Indicator & Obs. & Mean & S.D. & 5th perc. & 95th perc. \\ \midrule") foot("\bottomrule""\end{tabularx}")	


*____________________________________________

}



