*-------------------------------------------------------------------------------------------------------------
*
*	Summaries File
*	Felix Ward
*	
*
*-------------------------------------------------------------------------------------------------------------

qui{
clear all

set mem 500m
set more off

*================= SETTINGS ======================================================================================

* Working directory
local path /Users/felixward/Dropbox/CrisisPrediction/


capture log close
use "`path'Data/prepared.dta", clear

*sum

*________________CRISIS MAPS____________________

**________export csv for R CrisisMap ____________
n display "export CSV data"

order countrynum year b0 
outsheet countrynum year b0 using "`path'Data/R_crisis.csv", comma replace





*______________INDICATOR TABLE__________________
n display "Generate indicator table"
local all dif_ltrate dif_rltrate a_gr_i_y ///
ltrate rltrate ///
c_y loans1_y ///
pdebt gr_er gr_rgdp gr_rc ///
gr_cpi gr_rnarrowm ///
gr_rloans1 gr_rpubdebt ///
gr_c_y gr_loans1_y er_gap ///
rgdp_gap rc_gap ///
ltrate_gap rnarrowm_gap ///
rloans1_gap rpubdebt_gap ///
pdebt_gap c_y_gap ///
loans1_y_gap narrowm_y_gap a_stir a_ltrate a_rstir ///
a_rltrate  a_pdebt a_c_y a_i_y gr_rer ///
a_bassets2_y a_loans1_y a_gr_rgdp a_gr_rc ///
a_gr_ri a_gr_cpi a_gr_rmoney ///
a_gr_rstocks a_gr_rbassets2 a_gr_rloans1 a_gr_rpubdebt a_gr_c_y ///
a_gr_bassets2_y a_gr_loans1_y a_rgdp_gap a_rc_gap ///
a_ri_gap a_stir_gap a_rstir_gap ///
a_rltrate_gap a_rnarrowm_gap a_rmoney_gap a_rstocks_gap a_rbassets2_gap  ///
a_rloans1_gap  a_pdebt_gap a_c_y_gap a_i_y_gap rer_gap ///
a_bassets2_y_gap a_loans1_y_gap er rer ///
rltrate_gap a_gr_rnarrowm a_ltrate_gap a_gr_money_y a_money_y_gap ///
a_pdebt_gap a_money_y



local allname "LT Interest Rate Diff. (n)" "LT Interest Rate Diff." "I/GDP (gr)(glo)" ///
 "LT Interest Rate (n)" "LT Interest Rate" ///
 "C/GDP" "Loans/GDP" ///
 "Public Debt/GDP" "Exchange Rate (gr)" "GDP (gr)" "C (gr)" ///
 "Inflation" "Narrow Money (gr)" ///
 "Loans (gr)" "Public Debt (gr)" ///
 "C/GDP (gr)" "Loans/GDP (gr)" "Exchange Rate (gap)" ///
 "GDP (gap)" "C (gap)" ///
 "LT Interest Rate (n)(gap)" "Narrow Money (gap)" ///
 "Loans (gap)" "Public Debt (gap)" ///
 "Public Debt/GDP (gap)" "C/GDP (gap)" ///
 "Loans/GDP (gap)" "Narrow Money/GDP (gap)" "ST Interest Rate (n)(glo)" "LT Interest Rate (n)(glo)" "ST Interest Rate (glo)" ///
 "LT Interest Rate (glo)" "Public Debt/GDP (glo)" "C/GDP (glo)" "I/GDP (glo)" "Real Exchange Rate (gr)" ///
 "Bank Assets/GDP (glo)" "Loans/GDP (glo)" "GDP (gr)(glo)" "C (gr)(glo)" ///
 "I (gr)(glo)" "Inflation (glo)" "Broad Money (gr)(glo)" ///
 "Stock Prices (gr)(glo)" "Bank Assets (gr)(glo)" "Loans (gr)(glo)" "Public Debt (gr)(glo)" "C/GDP (gr)(glo)" ///
 "Bank Assets/GDP (gr)(glo)" "Loans/GDP (gr)(glo)" "GDP (gap)(glo)" "C (gap)(glo)" ///
 "I (gap)(glo)" "ST Interest Rate (n)(gap)(glo)" "ST Interest Rate (gap)(glo)" ///
 "LT Interest Rate (gap)(glo)" "Narrow Money (gap)(glo)" "Broad Money (gap)(glo)" "Stock Prices (gap)(glo)" "Bank Assets (gap)(glo)"   ///
 "Loans (gap)(glo)" "Public Debt/GDP (gap)(glo)" "C/GDP (gap)(glo)" "I/GDP (gap)(glo)" "Real Exchange Rate (gap)" ///
 "Bank Assets/GDP (gap)(glo)" "Loans/GDP (gap)(glo)" "Exchange Rate (n)" "Real Exchange Rate" ///
 "LT Interest Rate (gap)" "Narrow Money (gr)(glo)" "LT Interest Rate (n)(gap)(glo)" "Broad Money/GDP (gr)(glo)" "Broad Money/GDP (gap)(glo)" ///
 "Public Debt (gap)(glo)" "Broad Money/GDP (glo)" 
 
local vecsize : word count `all'  
n display "`vecsize'"

*observation classifier across countries
gen id = 1
replace id = id[_n-1]+1 if (_n>1)


*map variable names onto id
gen str26 name = "v"
forvalues y = 1/`vecsize' {

	local d : word `y' of "`allname'"
			
	replace name = `"`d'"' if id==`y'
  	
  	}
	
  	
estpost summarize dif_ltrate dif_rltrate a_gr_i_y ///
ltrate rltrate ///
c_y loans1_y ///
pdebt gr_er gr_rgdp gr_rc ///
gr_cpi gr_rnarrowm ///
gr_rloans1 gr_rpubdebt ///
gr_c_y gr_loans1_y er_gap ///
rgdp_gap rc_gap ///
ltrate_gap rnarrowm_gap ///
rloans1_gap rpubdebt_gap ///
pdebt_gap c_y_gap ///
loans1_y_gap narrowm_y_gap a_stir a_ltrate a_rstir ///
a_rltrate  a_pdebt a_c_y a_i_y gr_rer ///
a_bassets2_y a_loans1_y a_gr_rgdp a_gr_rc ///
a_gr_ri a_gr_cpi a_gr_rmoney ///
a_gr_rstocks a_gr_rbassets2 a_gr_rloans1 a_gr_rpubdebt a_gr_c_y ///
a_gr_bassets2_y a_gr_loans1_y a_rgdp_gap a_rc_gap ///
a_ri_gap a_stir_gap a_rstir_gap ///
a_rltrate_gap a_rnarrowm_gap a_rmoney_gap a_rstocks_gap a_rbassets2_gap  ///
a_rloans1_gap  a_pdebt_gap a_c_y_gap a_i_y_gap rer_gap ///
a_bassets2_y_gap a_loans1_y_gap er rer ///
rltrate_gap a_gr_rnarrowm a_ltrate_gap a_gr_money_y a_money_y_gap ///
a_pdebt_gap a_money_y, detail

*get #observations, mean, s.d., min, max
matrix o = e(count)'
svmat o, names(obs)

matrix m = e(mean)'
svmat m, names(mean)

matrix sd = e(sd)'
svmat sd, names(sd)

matrix min = e(p5)'
svmat min, names(min)

matrix max = e(p95)'
svmat max, names(max)

format mean1 sd1 min1 max1 %12.2fc

sort name

*new observation classifier across countries
gen id2 = 1
replace id2 = id2[_n-1]+1 if (_n>1)


listtab name obs1 mean1 sd1 min1 max1 if (id2 <= 50) using "`path'Written/Indicators1.txt", replace end(\\) delimiter(&) begin() head("\newcolumntype{C}{>{\centering\arraybackslash}X}%""\begin{tabularx}{1.175\textwidth}{lCCCCC}""\toprule \\""Indicator & Obs. & Mean & S.D. & 5th perc. & 95th perc. \\ \midrule") foot("\bottomrule""\end{tabularx}")	
listtab name obs1 mean1 sd1 min1 max1 if (id2 > 50 & id <=`vecsize') using "`path'Written/Indicators2.txt", replace end(\\) delimiter(&) begin() head("\newcolumntype{C}{>{\centering\arraybackslash}X}%""\begin{tabularx}{1.175\textwidth}{lCCCCC}""\toprule""Indicator & Obs. & Mean & S.D. & 5th perc. & 95th perc. \\ \midrule") foot("\bottomrule""\end{tabularx}")	

}



