*-------------------------------------------------------------------------------------------------------------
*
*	Prepare File
*	Felix Ward
*	
*
*-------------------------------------------------------------------------------------------------------------


clear all

set more off

version 13


* Working directory

*local path C:\Users\Ward\Dropbox\CrisisPrediction\
local path /Users/felixward/Dropbox/CrisisPrediction/

capture log close

infile using "`path'data/text_post70_q.txt", clear

sum

qui{


*__________________________DECLARE TIME SERIES_______________________
n display "Declare dynamic panel structure"
*create numeric countrydata
encode country, gen(ccode)
numlabel _all, add

*declare time series
tsset ifs date, quarterly

*merge loan variables
gen tloans_bis_gr = log(tloans_bis)-log(l.tloans_bis)
replace tloans = l.tloans*(1+tloans_bis_gr) if (tloans==. & l.tloans!=. & tloans_bis_gr!=.)

drop tloans_bis tloans_bis_gr

*__________________DEFLATE___________________
n display "Deflate"

gen gdp_r = gdp/cpi
gen res_r = res/cpi
gen stocks_r = stocks/cpi
gen fliab_r = fliab/cpi
gen tloans_r = tloans/cpi
gen hopr_r = hopr/cpi


*__________________GDP-RATIOS________________
n display "to-GDP ratios"
*standardized to the mean of 10 in order to avoid problems in the subsequent gap measure calculation
*where low denominator values due to a trend component close to zero would result in extreme indicator values
*which increases the range of the resulting indicator. (This doesn't affect RF results, but would make partial dependence
*function calculation very tedious as far more points have to be calculated across the whole range)

*not comparable across countries -> use standardized by country -> only contains within country rel. level information


sum ccode 
mat max = r(max)
local max = max[1,1]

local togdp fliab tloans res

foreach tgp of local togdp {
	gen `tgp'_y =.
	gen nostd_`tgp'_y = `tgp'/gdp
	forvalues x = 1/`max'{
		sum nostd_`tgp'_y if ccode==`x'
		mat mean = r(mean)
		mat sd = r(sd)
		local mean = mean[1,1]
		local sd = sd[1,1]
		replace `tgp'_y = (nostd_`tgp'_y-`mean')/`sd' +10 if ccode==`x'
		}
	}
	
drop nostd_*


*______________REAL EXCHANGE RATE (rel. to US)________________
n display "Real exchange rate"

sort ccode year quarter

*U.S. CPI
gen cpi_us = cpi if ifs==111
egen cpi_usa = min(cpi_us), by(year quarter)						
drop cpi_us

gen nostd_rer = er*(cpi/cpi_usa)

*standardize
local stdize rer 

sum ccode
mat max = r(max)
local max = max[1,1]

foreach stnd of local stdize { /*standardize as not necessarily comparable across countries (base years etc) -> only within country rer level retained*/
	gen `stnd'=.
	forvalues x = 1/`max' {
		sum nostd_`stnd' if ccode==`x'
		mat mean = r(mean)
		mat sd = r(sd)
		local mean = mean[1,1]
		local sd = sd[1,1]
		replace `stnd' = (nostd_`stnd' - `mean')/`sd' + 10 if ccode==`x'
		}
	}
	
replace rer=10 if ifs==111	
	

*_______________GENERATE LAGS, GROWTH RATES & LAGGED GROWTH RATES___________________
n display "Lags, growth rates and lagged growth rates"

sort ifs date

local org "rer er cpi res fliab tloans hopr stocks gdp res_r fliab_r tloans_r hopr_r stocks_r gdp_r res_y fliab_y tloans_y"
local gro "rer_gr er_gr cpi_gr res_gr fliab_gr tloans_gr hopr_gr stocks_gr gdp_gr res_r_gr fliab_r_gr tloans_r_gr hopr_r_gr stocks_r_gr gdp_r_gr res_y_gr fliab_y_gr tloans_y_gr"
local vecsize : word count `org' 

forvalues x = 1/`vecsize' {
 local v`x' : word `x' of `gro'
 local c : word `x' of `org'
 
   forvalues y=0/5 {
   		gen l`y'_`c' = l`y'.`c'
   		}
   	
   gen d_`c' = d.`c'
   gen `v`x'' = d.`c'/l1_`c'		
   forvalues z=0/5 {
   		gen l`z'_`v`x'' = l`z'.`v`x''
   		}
   	}

*___________REAL INTEREST RATES____________
n display "Real interest rates and interest rate differentials"


gen stir_d = d.stir
gen ltrate_d = d.ltrate
gen tbill_d = d.tbill
gen mrate_d = d.mrate
*generate aggregate ST and LT variables
replace stir_d = tbill_d if stir ==.
replace ltrate_d = mrate_d if ltrate_d==.
replace stir = l.stir + stir_d if (stir==. &l.stir!=.&stir_d!=.)
replace ltrate = l.ltrate + ltrate_d if (ltrate==. &l.ltrate!=.&ltrate_d!=.)

gen stir_r = stir - cpi_gr
gen ltrate_r = ltrate - cpi_gr


*____________INTEREST RATE DIFFERENTIALS (compared to global average)__________
*build numerator and denominator terms
local rates stir ltrate stir_r ltrate_r 

foreach v of local rates {

	gen denom`v' = .
	gen num`v' =.
	
	forvalues y = 1966/2012 {
		forvalues q = 1/4 {

		egen denom_`y'_`q' = count(`v') if(year==`y' & quarter==`q')
		egen num_`y'_`q' = total(`v') if(year==`y' & quarter==`q'), missing
		replace denom`v' = denom_`y'_`q' if (year==`y' & quarter==`q')
		replace num`v' = num_`y'_`q' if (year==`y' & quarter==`q')
		drop denom_`y'_`q' num_`y'_`q'
		
							}
						}
	*world averages						
	gen dif_a_`v' = num`v'/denom`v'
	
	gen dif_`v' = `v' - dif_a_`v'
	
	*drop 
	drop num`v' denom`v' dif_a_`v'
														
						}




*__________GAPS = HP-CYCLE - HP-TREND_____________
* hprescott cannot deal with missing values -> each spell is detrended separately
local det dif_stir dif_ltrate dif_stir_r dif_ltrate_r stir ltrate stir_r ltrate_r er rer cpi res fliab tloans hopr stocks gdp res_r fliab_r tloans_r hopr_r stocks_r gdp_r res_y fliab_y tloans_y
local irates dif_stir dif_ltrate dif_stir_r dif_ltrate_r stir ltrate stir_r ltrate_r
local other er rer cpi res fliab tloans hopr stocks gdp res_r fliab_r tloans_r hopr_r stocks_r gdp_r res_y fliab_y tloans_y

include `path'DoFiles/detrend_mt_q.do /* short-term cycles at business cycle frequency */

	* DEVIATIONS
	foreach v of local other{ /*% - deviations for other level variables*/
		** HP-Filter
		gen `v'_gap = cyc_`v'/tr_`v'*100 if(tr_`v'>0)
		replace `v'_gap = cyc_`v'/(-tr_`v')*100 if(tr_`v'<0) /* mind neg. trend values! */
		** BK-Filter
		gen `v'_mtbkgap = bk_cyc_`v'/bk_tr_`v'*100 if(bk_tr_`v'>0)
		replace `v'_mtbkgap = bk_cyc_`v'/(-bk_tr_`v')*100 if(bk_tr_`v'<0) /* mind neg. trend values! */
		** CF-Filter
		gen `v'_mtcfgap = cf_cyc_`v'/cf_tr_`v'*100 if(cf_tr_`v'>0)
		replace `v'_mtcfgap = cf_cyc_`v'/(-cf_tr_`v')*100 if(cf_tr_`v'<0) /* mind neg. trend values! */
		}
	
	foreach v of local irates{ /*ppts - deviations for interest rate variables*/
		** HP-Filter
		gen `v'_gap = cyc_`v'
		** BK-Filter
		gen `v'_mtbkgap = bk_cyc_`v'
		** CF-Filter
		gen `v'_mtcfgap = cf_cyc_`v'
		}		
		
	** drop helvars
	drop *cyc_* *tr_* *end *seq *spell hmseq* mhp* mseq*
	


*_____________GLOBAL GDP-WEIGHED AVERAGES, all vars, no std_cpi______________
n display "Global indicators"

bys date: egen m_gdp_r = mean(gdp_r)
sort ccode year quarter

gen w = 1 /*too few gdp observations for weighting -> to not loose too many global variables I forgo GDP-weighting here*/

*build (weighed) numerator and denominator terms
local glob res fliab tloans hopr stocks gdp res_r fliab_r tloans_r hopr_r stocks_r gdp_r res_y fliab_y tloans_y ///
			cpi_gr fliab_gr tloans_gr hopr_gr stocks_gr gdp_gr res_gr fliab_r_gr tloans_r_gr hopr_r_gr stocks_r_gr gdp_r_gr res_r_gr res_y_gr fliab_y_gr tloans_y_gr ///
			dif_stir dif_ltrate dif_stir_r dif_ltrate_r stir ltrate stir_r ltrate_r ///
			res_gap fliab_gap tloans_gap hopr_gap stocks_gap gdp_gap res_r_gap fliab_r_gap tloans_r_gap hopr_r_gap stocks_r_gap gdp_r_gap res_y_gap fliab_y_gap tloans_y_gap
			
foreach v of local glob {

	gen denom`v' = .
	gen num`v' =.
	
	forvalues y = 1966/2012 {
		forvalues q = 1/4 {

		egen denom_`y'_`q' = count(`v') if(year==`y' & quarter==`q')
		egen num_`y'_`q' = total(`v'*w) if(year==`y' & quarter==`q'), missing
		replace denom`v' = denom_`y'_`q' if (year==`y' & quarter==`q')
		replace num`v' = num_`y'_`q' if (year==`y' & quarter==`q')
		drop denom_`y'_`q' num_`y'_`q'
		
							}
						}
	*gdp-weighted world averages						
	gen a_`v' = num`v'/denom`v'
	
	*drop 
	drop num`v' denom`v'
														
						}

*drop
drop w 


*________________RECESSION HORIZONS________________
n display "Recession dummies"

sort ifs date 
gen rec = 0
replace rec = 1 if (gdp_r_gr<0 & l.gdp_r_gr<0 & l2.gdp_r_gr>0)
replace rec =. if (l.gdp_r_gr==. | l2.gdp_r_gr==. | gdp_r_gr==.)

foreach v of varlist rec {
	
	*first quarter of rec year
	gen `v'0 = 0
	replace `v'0=1 if `v'==1 & l.`v'==0

	gen `v'1 = 0
	replace `v'1 = 1 if(f.`v'0==1 | f2.`v'0==1 | f3.`v'0==1 |f4.`v'0==1)

	gen `v'2 = `v'1
	replace `v'2 = 1 if(f.`v'1==1 | f2.`v'1==1 | f3.`v'1==1 |f4.`v'1==1)

	gen `v'3 = `v'2
	replace `v'3 = 1 if(f.`v'2==1 | f2.`v'2==1 | f3.`v'2==1 |f4.`v'2==1)
	
	drop `v'
}


*________________CRISES HORIZONS________________
*Schularick & Taylor, 2011/13 systemic crises
n display "Crisis dummies"

sort ifs date 
foreach v of varlist crisisL {
	
	*first quarter of crisis year
	gen `v'0 = 0
	replace `v'0=1 if `v'==1 & l.`v'==0

	gen `v'1 = 0
	replace `v'1 = 1 if(f.`v'0==1 | f2.`v'0==1 | f3.`v'0==1 |f4.`v'0==1)

	gen `v'2 = `v'1
	replace `v'2 = 1 if(f.`v'1==1 | f2.`v'1==1 | f3.`v'1==1 |f4.`v'1==1)

	gen `v'3 = `v'2
	replace `v'3 = 1 if(f.`v'2==1 | f2.`v'2==1 | f3.`v'2==1 |f4.`v'2==1)
	
	drop `v'
}



*give shorter names to avoid variable name limit
forvalues x = 0/3 {
	ren crisisL`x' b`x'
	}

n display "Save prepared dataset"
saveold "`path'Data/prepared_post70_q.dta", replace

*outsheet _all using "`path'Data/ExcelExt.csv", comma replace


*R classification tree
local all  fliab tloans hopr stocks gdp fliab_r tloans_r hopr_r stocks_r ///
 gdp_r fliab_y tloans_y fliab_gr tloans_gr hopr_gr stocks_gr gdp_gr fliab_r_gr tloans_r_gr ///
 hopr_r_gr stocks_r_gr gdp_r_gr fliab_y_gr tloans_y_gr dif_stir dif_ltrate dif_stir_r dif_ltrate_r ///
 stir ltrate stir_r ltrate_r fliab_gap tloans_gap hopr_gap stocks_gap gdp_gap ///
 fliab_r_gap tloans_r_gap hopr_r_gap stocks_r_gap gdp_r_gap fliab_y_gap tloans_y_gap cpi cpi_gr ///
 a_fliab a_tloans a_hopr a_stocks a_gdp a_fliab_r a_tloans_r a_hopr_r a_stocks_r ///
 a_gdp_r a_fliab_y a_tloans_y a_fliab_gr a_tloans_gr a_hopr_gr a_stocks_gr a_gdp_gr a_fliab_r_gr a_tloans_r_gr ///
 a_hopr_r_gr a_stocks_r_gr a_gdp_r_gr a_fliab_y_gr a_tloans_y_gr a_dif_stir a_dif_ltrate a_dif_stir_r a_dif_ltrate_r ///
 a_stir a_ltrate a_stir_r a_ltrate_r a_fliab_gap a_tloans_gap a_hopr_gap a_stocks_gap a_gdp_gap ///
 a_fliab_r_gap a_tloans_r_gap a_hopr_r_gap a_stocks_r_gap a_gdp_r_gap a_fliab_y_gap a_tloans_y_gap a_cpi a_cpi_gr ///	
 res res_r res_y res_gr res_r_gr res_y_gr res_gap res_r_gap res_y_gap ///
 a_res a_res_r a_res_y a_res_gr a_res_r_gr a_res_y_gr a_res_gap a_res_r_gap a_res_y_gap ///
 er_gr rer_gr er_gap rer_gap ///
 b2 b3 b1 rec1 rec2 rec3 year ccode  



outsheet `all' using "`path'Data/R_class_post70_q.csv", comma replace
drop if quarter!=4
outsheet `all' using "`path'Data/R_class_post70_q4.csv", comma replace




drop _all
import excel using "`path'data/AEDE.xlsx", cellrange(B2:I186) firstrow /*macro data*/
destring _all, replace force /*force here to get rid of "..." entries*/
saveold "`path'data/AEDE.dta", replace


use "`path'Data/prepared_post70_q.dta", clear

merge m:1 ifs using "`path'data/AEDE.dta", nogenerate keepusing(AE DE QU big ME)

*R classification tree
local all  fliab tloans hopr stocks gdp fliab_r tloans_r hopr_r stocks_r ///
 gdp_r fliab_y tloans_y fliab_gr tloans_gr hopr_gr stocks_gr gdp_gr fliab_r_gr tloans_r_gr ///
 hopr_r_gr stocks_r_gr gdp_r_gr fliab_y_gr tloans_y_gr dif_stir dif_ltrate dif_stir_r dif_ltrate_r ///
 stir ltrate stir_r ltrate_r fliab_gap tloans_gap hopr_gap stocks_gap gdp_gap ///
 fliab_r_gap tloans_r_gap hopr_r_gap stocks_r_gap gdp_r_gap fliab_y_gap tloans_y_gap cpi cpi_gr ///
 a_fliab a_tloans a_hopr a_stocks a_gdp a_fliab_r a_tloans_r a_hopr_r a_stocks_r ///
 a_gdp_r a_fliab_y a_tloans_y a_fliab_gr a_tloans_gr a_hopr_gr a_stocks_gr a_gdp_gr a_fliab_r_gr a_tloans_r_gr ///
 a_hopr_r_gr a_stocks_r_gr a_gdp_r_gr a_fliab_y_gr a_tloans_y_gr a_dif_stir a_dif_ltrate a_dif_stir_r a_dif_ltrate_r ///
 a_stir a_ltrate a_stir_r a_ltrate_r a_fliab_gap a_tloans_gap a_hopr_gap a_stocks_gap a_gdp_gap ///
 a_fliab_r_gap a_tloans_r_gap a_hopr_r_gap a_stocks_r_gap a_gdp_r_gap a_fliab_y_gap a_tloans_y_gap a_cpi a_cpi_gr ///	
 res res_r res_y res_gr res_r_gr res_y_gr res_gap res_r_gap res_y_gap ///
 a_res a_res_r a_res_y a_res_gr a_res_r_gr a_res_y_gr a_res_gap a_res_r_gap a_res_y_gap ///
 er_gr rer_gr er_gap rer_gap ///
 b2 b3 b1 rec1 rec2 rec3 year ccode AE DE QU big ME



outsheet `all' using "`path'Data/R_class_post70_q_AEDE.csv", comma replace


}


