*-------------------------------------------------------------------------------------------------------------
*
*	DETRENDING - Hodrick-Prescott, Baxter-King, Christiano-Fitzgerald
*	(spell-wise detrending given missing values)
*
*	Felix Ward
*
*-------------------------------------------------------------------------------------------------------------
*================= SETTINGS ========================================================================================

local country ccode /* country-indicator: starting from 1, steps of 1 */

local onesided 1 /* one- or two-sided filtering:
					0 - two-sided
					1 - one-sided */
					
					

*WHICH FILTERS?	
		
local hp 1 /* Hodrick-Prescott
			  0 - no
			  1 - yes */
	local smooth 1600 /* smoothing-factor:
						 monthly optimal - 129,600
						 quarterly optima - 1600
						 annualy optimal - 6.25 */
		
local bk 0 /* Baxter-King
			  0 - no
			  1 - yes */
	local minperiod_bk 8 /* filter minperiod */
	local maxperiod_bk 30 /* filter maxperiod */
	local smaorder_bk 3 /* symmetric moving average order */
	
local cfitz 0 /* Christiano-Fitzgerald
			  0 - no
			  1 - yes */
	local minperiod_cf 8 /* filter minperiod */
	local maxperiod_cf 30 /* filter maxperiod */
	local smaorder_cf 3 /* symmetric moving average order */

*=================================================================================================================

foreach v of local det {
	n display "Detrending `v'"
	
	* SPELLS
	tsspell, cond(`v'!=.) end(`v'_pend) seq(`v'_pseq) spell(`v'_pspell) /*find spells*/
	egen hmseq_`v' = max(`v'_pseq), by(`country' `v'_pspell) /*determine length of each spell*/
	tsspell, cond(`v'!=. & hmseq_`v'>=3) end(`v'_hpend) seq(`v'_hpseq) spell(`v'_hpspell) /*neglect spells too short for detrending*/
	egen mhp_`v' = max(`v'_hpspell), by(`country') /*find max. number of spells per country*/
	egen mseq_`v' = max(`v'_hpseq), by(`country' `v'_hpspell) /*length of each spell*/
	
	* TREND & CYCLE
	gen cyc_`v' = .
	gen tr_`v' = .	
	gen bk_cyc_`v' = .
	gen bk_tr_`v' = .	
	gen cf_cyc_`v' = .
	gen cf_tr_`v' = .
	
	sum `country' /* get number of countries in sample */
	local cnumb `r(max)' 
	
	forvalues x = 1/`cnumb' 	{ /*country-loop*/
		
		*** number of spells by country
		sum mhp_`v' if `country' == `x'
		local max `r(max)'
		
		** Filter for each spell
		forvalues y = 1/`max'		 {	/*spell-loop*/
		
		
		
		*___________________________ HP-Filter _________________________________	
		
			if(`onesided'==1 & `hp'==1)		{ /* one-sided */
				*** length of spell
				sum mseq_`v' if (`country' == `x' & `v'_hpspell == `y')
				local length `r(max)'	
				
					** one-sided HP-Filtering (starting from 3 as HP-filter needs at least 3 consecutive obs)
					forvalues z = 3/`length' {	
					
						hprescott `v' if (`country' == `x' & `v'_hpspell == `y' & `v'_hpseq <= `z'), stub(hp_`x'_`y') smooth(`smooth')
		
						replace cyc_`v' = hp_`x'_`y'_`v'_1 if (`country' == `x' & `v'_hpspell == `y' & `v'_hpseq == `z')
						replace tr_`v' = hp_`x'_`y'_`v'_sm_1 if (`country' == `x' & `v'_hpspell == `y' & `v'_hpseq == `z')
		
						drop hp_`x'_`y'_`v'_1 hp_`x'_`y'_`v'_sm_1 
						
											}
										}
			else {
										}
				
			if(`onesided'==0 & `hp'==1) { /* two-sided */

						hprescott `v' if (`country' == `x' & `v'_hpspell == `y'), stub(hp_`x'_`y') smooth(`smooth')
		
						replace cyc_`v' = hp_`x'_`y'_`v'_1 if (`country' == `x' & `v'_hpspell == `y')
						replace tr_`v' = hp_`x'_`y'_`v'_sm_1 if (`country' == `x' & `v'_hpspell == `y')
		
						drop hp_`x'_`y'_`v'_1 hp_`x'_`y'_`v'_sm_1 			
			
										}
			else {
										}
										
										
		*_____________________________ BK-Filter _______________________________							
					
			if(`onesided'==1 & `bk'==1)		{ /* one-sided */
				*** length of spell
				sum mseq_`v' if (`country' == `x' & `v'_hpspell == `y')
				local length `r(max)'	
				
					** one-sided
					forvalues z = 1/`length' 	{	
					
						tsfilter bk bk_`x'_`y'_`v'_cyc = `v' if (`country' == `x' & `v'_hpspell == `y' & `v'_hpseq <= `z'), smaorder(`smaorder_bk') minperiod(`minperiod_bk') maxperiod(`maxperiod_bk') trend(bk_`x'_`y'_`v'_tr)
		
						replace bk_cyc_`v' = bk_`x'_`y'_`v'_cyc if (`country' == `x' & `v'_hpspell == `y' & `v'_hpseq == `z')
						replace bk_tr_`v' = bk_`x'_`y'_`v'_tr if (`country' == `x' & `v'_hpspell == `y' & `v'_hpseq == `z')
		
						drop bk_`x'_`y'_`v'_cyc bk_`x'_`y'_`v'_tr 
						
											}
										}
			
			else {
										}			

				
			if(`onesided'==0 & `bk'==1) { /* two-sided */

						tsfilter bk bk_`x'_`y'_`v'_cyc = `v' if (`country' == `x' & `v'_hpspell == `y'), smaorder(`smaorder_bk') minperiod(`minperiod_bk') maxperiod(`maxperiod_bk') trend(bk_`x'_`y'_`v'_tr)
		
						replace bk_cyc_`v' = bk_`x'_`y'_`v'_cyc if (`country' == `x' & `v'_hpspell == `y')
						replace bk_tr_`v' = bk_`x'_`y'_`v'_tr if (`country' == `x' & `v'_hpspell == `y')
		
						drop bk_`x'_`y'_`v'_cyc bk_`x'_`y'_`v'_tr  			
			
										}
										
			else {
										}
										
										
		*_____________________________ CF-Filter _______________________________							
					
			if(`onesided'==1 & `cfitz'==1)		{ /* one-sided */
				*** length of spell
				sum mseq_`v' if (`country' == `x' & `v'_hpspell == `y')
				local length `r(max)'	
				
					** one-sided
					forvalues z = 1/`length' 	{	
					
						tsfilter cf cf_`x'_`y'_`v'_cyc = `v' if (`country' == `x' & `v'_hpspell == `y' & `v'_hpseq <= `z'), smaorder(`smaorder_cf') minperiod(`minperiod_cf') maxperiod(`maxperiod_cf') trend(cf_`x'_`y'_`v'_tr)
		
						replace cf_cyc_`v' = cf_`x'_`y'_`v'_cyc if (`country' == `x' & `v'_hpspell == `y' & `v'_hpseq == `z')
						replace cf_tr_`v' = cf_`x'_`y'_`v'_tr if (`country' == `x' & `v'_hpspell == `y' & `v'_hpseq == `z')
		
						drop cf_`x'_`y'_`v'_cyc cf_`x'_`y'_`v'_tr 
						
											}
										}
			
			else {
										}			

				
			if(`onesided'==0 & `cfitz'==1) { /* two-sided */

						tsfilter cf cf_`x'_`y'_`v'_cyc = `v' if (`country' == `x' & `v'_hpspell == `y'), smaorder(`smaorder_cf') minperiod(`minperiod_cf') maxperiod(`maxperiod_cf') trend(cf_`x'_`y'_`v'_tr)
		
						replace cf_cyc_`v' = cf_`x'_`y'_`v'_cyc if (`country' == `x' & `v'_hpspell == `y')
						replace cf_tr_`v' = cf_`x'_`y'_`v'_tr if (`country' == `x' & `v'_hpspell == `y')
		
						drop cf_`x'_`y'_`v'_cyc cf_`x'_`y'_`v'_tr  			
			
										}
										
			else {
										}										
										
								}
						}	
	}
							
	/*
	order `v' `v'_hpspell mhp_`v' `v'_hpseq mseq_`v' cyc_`v' tr_`v'
	*/
	





