 rm(list=ls())
library(psych)
library(graphics)

rm(list=ls())

 
      ## Level Plots ##
###Crisis & Regulation Map
##DATA - open
Daten  <- read.table("/Users/felixward/Dropbox/CrisisPrediction/Data/R_crisis_post70.csv", sep=",", dec=".", header=TRUE)


head(Daten)

##Label
Daten$ccode <- factor(Daten$country)
#levels = c("1. AUS", "2. BEL", "3. CAN", "4. CHE","5. DEU","6. DNK","7. ESP","8. FIN", "9. FRA", "10. GBR", "11. ITA", "12. JPN", "13. NLD", "14. NOR", "15. PRT", "16. SWE", "17. USA"),
#labels = c("Aus", "Bel", "Can", "Che", "Ger", "Den", "Esp", "Fin", "Fra", "UK", "Ita", "Jap", "Nld", "Nor", "Prt", "Swe", "US"))

##DATA-Organize
ccode <- (Daten$country)
year <- (Daten$year)
crisis <- (Daten$b0)

myframe <- data.frame(ccode,year,crisis)


###LATTICE GRAPHICS
#CRISIS MAP

library(lattice)
lattice.options(default.theme = standard.theme(color = FALSE))


pdf('/Users/felixward/Dropbox/CrisisPrediction/Written/CrisisMap_post70.pdf', height=11, width=9)
levelplot(crisis ~ year*rev(ccode), data = myframe, ylim=rev(levels(ccode)),
  col.regions = gray(100:25/100),
	panel=function(...){
		panel.levelplot(...)
		panel.abline (v=1970.5:2012.5, lty=1, lwd=0.5, col="gray") # year raster
		panel.abline (h=1.5:190.5, lty=1, lwd=0.5, col="gray") # country raster
	},
  ylab = expression(scriptstyle("")), 
  cex.ylab=0.4,
  #ylim = c(-1,1),
  region=T, pretty=F,
  colorkey=F,
  xlab=expression(scriptstyle("")),
  cex.xlab=1,
  aspect = 1.35,
  scales=list(rot=c(0), tick.number=10, alternating=1, tck=0.1, cex=0.4, axs="r", x=list(cex=0.75), y=list(cex=.4), xlab=list(cex=0.75), ylab=list(cex=.4)),
)
dev.off()





