      ## Level Plots ##
###Crisis & Regulation Map
##DATA - open
Daten  <- read.table("/Users/felixward/Dropbox/CrisisPrediction/Data/R_crisis.csv", sep=",", dec=".", header=TRUE)


Daten

##Label
Daten$countrynum <- factor(Daten$countrynum,
levels = c("1. AUS", "2. BEL", "3. CAN", "4. CHE","5. DEU","6. DNK","7. ESP","8. FIN", "9. FRA", "10. GBR", "11. ITA", "12. JPN", "13. NLD", "14. NOR", "15. PRT", "16. SWE", "17. USA"),
labels = c("AUS", "BEL", "CAN", "CHE", "DEU", "DNK", "ESP", "FIN", "FRA", "GBR", "ITA", "JPN", "NLD", "NOR", "PRT", "SWE", "USA"))

##DATA-Organize
countrynum <- (Daten$countrynum)
year <- (Daten$year)
crisis <- (Daten$b0)

myframe <- data.frame(countrynum,year,crisis)

###LATTICE GRAPHICS
#CRISIS MAP

library(lattice)
lattice.options(default.theme = standard.theme(color = FALSE))


pdf('/Users/felixward/Dropbox/CrisisPrediction/Written/CrisisMap.pdf', height=5, width=9)
levelplot(crisis ~ year*rev(countrynum), data = myframe, ylim=rev(levels(countrynum)),
  col.regions = gray(100:25/100),
	panel=function(...){
		panel.levelplot(...)
		panel.abline (v=1914.5, col="Black", lty=1, lwd=1.25)
		panel.abline (v=1918.5, col="Black", lty=1, lwd=1.25)
		panel.abline (v=1939.5, col="Black", lty=1, lwd=1.25)
		panel.abline (v=1945.5, col="Black", lty=1, lwd=1.25)
		panel.abline (v=1973.5, col="Black", lty=1, lwd=1.25)
		panel.abline (v=1870.5:2011.5, lty=1, lwd=0.5, col="gray") # year raster
		panel.abline (h=1.5:16.5, lty=1, lwd=0.5, col="gray") # country raster
	},
  ylab = expression(scriptstyle("")), 
  #ylim = c(-1,1),
  region=T, pretty=F,
  colorkey=F,
  xlab=expression(scriptstyle("")),
  aspect = .5,
  scales=list(rot=c(0), tick.number=17, alternating=1, tck=0.3, cex=0.7, axs="r"),
)
dev.off()





