@stdc3.g@
proc (1)=stdc3(x);
@Compute numerically more accurate column standard deviation
  author H. D. Vinod,  March 9, 1999
  References: R. F. Ling,  JASA, vol 69, p.859, 1974.
            McCullough -Vinod, J of Econ Literature, Jun 1999 633-665.
  Input:  x = any matrix.
  Output:  vector of sample standard deviations.
  Note: this proc calls meanc2.g  proc for improved mean.
@
  Local crud,avg, n, p, ane, ssd;
  n=rows(x);p=cols(x); ane=ones(n,1);
  avg=meanc2(x);   @Note this version uses revised column mean proc by vinod@
@"avg=" avg;@
  crud=sumc((x-ane*avg')^2);
@"crud" crud; @
  ssd=crud/(n-1) -(((sumc(x-ane*avg'))^2)/n)/(n-1);
  retp(sqrt(ssd));
  endp;

