@nistuniv.g@
proc (3)=nistuniv(y,cybar,csig,crho1);
@proc to compute the mean std.dev and autocorrelation coefficient
 as done by NIST-StRD to find the no. of accurate digits or NADs
 Input: y=data col.vector
        cybar=certified mean
        csig=certified standard deviation
        crho1=certified 1st order autocorrelatin coeff using NIST formula
 Output:  NADs for mean, std.dev and autocorr. coeff, respectively
@
local  nadmu, nads, n, yi, ym1, rho1, nadr;
format /ld 30,15;
"mean using meanc   " meanc(y);
nadmu=numacc(meanc(y),cybar);
"  ";
"std dev  using stdc " stdc(y);
nads=numacc(stdc(y),csig);
"  ";
"autocorr. next using the NIST definition";
n=rows(y);
yi=y[2:n];
ym1=y[1:n-1];
rho1=((yi-meanc(y))'(ym1-meanc(y)))/((y-meanc(y))'(y-meanc(y)));
nadr=numacc(rho1,crho1);
format /ld 8,1;
" ";
"Summary NADs   " nadmu~nads~nadr;
retp(nadmu, nads, nadr);
endp;


