@ file numacc.g @
proc (1)=numacc(q,c);
@proc to compute the NADs See McCullough, Amer Statistician
      eq.(2) page 360, Nov. 1998 for definition of NAD @
@ input q=observed value (or estimated value)
        c=certified value
  output: NAD number of accurate digits 
  Author:  H. D. Vinod, March 12, 1999
@
local
      absdif, absc, lam;
@q=100.5;c=100;@
@lam=15;@
absdif=abs(q-c);
absc=abs(c);
" Estimated value,  Certified value,  Absolute difference |q-c| ";
format /le 26,15;
q~c~absdif;
format /ld 25,15;
q~c~absdif;
if absc<10e-10;lam=-log(abs(q));endif;
if absdif<10e-15;lam=15;endif;
if absdif>0;if absc>0;lam=-log(absdif./absc);endif;endif;
format /ld 10,4;
if lam>15; lam=15; endif;
if lam<1; lam=0;endif;
"No. of Accurate Digits (NADs)  " lam;
"  ";
format /le 23,15;
retp( lam);
endp;

