@filename:  nistuniv.g@
proc (0)=nistuniv(y,cybar,csig,crho1);
@proc to compute the mean std.dev and autocorrelation coefficient
 as done by NIST-StRD to find the no. of accurate digits or NADs
 Author H. D. Vinod  dated March 12, 1999
 Input: y=data col.vector
        cybar=certified mean
        csig=certified standard deviation
        crho1=certified 1st order autocorrelatin coeff using NIST formula
 Output:  printing of NADs for mean, std.dev and autocorr. coeff
 needs a proc called numacc.g to compute the NADs
@
local  lammu, lams, n, yi, ym1, rho1, lamr;
format /ld 30,15;
"mean using meanc   " meanc(y);
lammu=numacc(meanc(y),cybar);
"  ";
"std dev  using stdc " stdc(y);
lams=numacc(stdc(y),csig);
"  ";
"autocorr. next using the NIST definition";
n=rows(y);
yi=y[2:n];
ym1=y[1:n-1];
rho1=((yi-meanc(y))'(ym1-meanc(y)))/((y-meanc(y))'(y-meanc(y)));
lamr=numacc(rho1,crho1);
format /ld 8,1;
" ";
"Summary NADs   " lammu~lams~lamr;
retp;
endp;


