@filename nistuni2.g@
proc (0)=nistuni2(y,cybar,csig,crho1);
@ uni2=2nd version using numerically superior meanc2 and stdc3  @
@proc to compute the mean std.dev and autocorrelation coefficient
 as done by NIST-StRD to find the no of accurate digits or NADs
 Author: H.D. Vinod dated Dec. 8, 1989
 Input: y=data col.vector
        cybar=certified mean
        csig=certified standard deviation
        crho1=certified 1st order autocorrelatin coeff using NIST formula
 Output:  printing of NADs for mean, std.dev and autocorr. coeff
 needs a proc called numacc.g to compute the accurate digits, NADs
@
local  lammu, lams, n, yi, ym1, rho1, lamr;
format /ld 30,15;

"mean using meanc2   " meanc2(y);
lammu=numacc(meanc2(y),cybar);
"  ";
"std dev  using stdc3 " stdc3(y);
lams=numacc(stdc3(y),csig);
"  ";
"autocorr. next using the NIST definition";
n=rows(y);
yi=y[2:n];
ym1=y[1:n-1];
rho1=((yi-meanc2(y))'(ym1-meanc2(y)))/((y-meanc2(y))'(y-meanc2(y)));
lamr=numacc(rho1,crho1);
format /ld 8,1;
" ";
"Summary NADs   " lammu~lams~lamr;
retp;
endp;


