@File:  nistolsf.g   f => regr. line is forced  through the origin@
Proc (0)=nistolsf(y,x,cb,cstdb,cr2);
@proc to compute the ols tests using NIST -STRD datasets
  Author  H. D. Vinod dated March 12, 1999
  Input: y= col vector for dep. Variable
         X= n x p dimensional matrix of regressors 
         cb=certified values of b the regr coefficients
         cstdb= certified standard errors for b
         cr2=certified R-square
 Output:  printout of NAD results
  needs a proc for NAD calculation of scalars called numacc.g
  another proc for NADs as the minimum from a vector of NADs numaccv2.g
@
local inparen, vnam, m, b, stb, vc, stderr,
      sigma, cx, rsq, resid, dwst, pred, n,
      p, df, ehat, sse, sighat2, ixx, covb,
      ybar, sst, r2, lamb, lamsig, lamr2,ans1,ans2;
__con=0;  @No constant term is added,  line forced thru origin @
inparen=0; do while inparen<=1;

if inparen==0;" "; "Begin estimation using ols";

{vnam, m,b, stb, vc, stderr, sigma,cx, rsq, resid, dwst}= ols("", y, x);
endif;
if inparen==1; "  "; "Begin estimation using olsqr2";
{b, resid, pred}= olsqr2( y, x);
endif;
" ";
n=rows(x);
sse=resid'resid;
ybar=meanc(y);
sst=y'y;  @  This is where you do not subtract n ybar ^2  @
if inparen==0;r2=rsq;endif;
if inparen==1;r2=1-(sse/sst);endif;

lamb=numaccv2(b,cb);
if inparen==0; "NADs for standard errors next";
   lamsig=numaccv2(stderr,cstdb);
endif;
"NAD for estimated R-square next";
lamr2=numacc(r2,cr2);
if inparen==0;
format /ld 15,4;
"NAD's for regr coeff,  SEs and  R-sq   summary ***" ;
ans1=lamb~lamsig~lamr2;ans1;
endif;
if inparen==1;
format /ld 15,4;
"NAD's for regr coeff,  R-sq (SE missing when olsqr2 called)  ***" ;
ans2=lamb~lamr2;ans2;
"  ";
endif;

inparen=inparen+1;endo;
format /ld 6,1;
"Final NADs by ols are:     " ans1;
"Final NADs by olsqr2 are:   " ans2;
format /le 23,15;
__con=1;  @reset the intercept choice to default value @
retp;
endp;
