@ --- Begin file called  anov2.g  for numerically immproved ANOVA  @
proc (3)=anov2(x);
@Compute analysis of variance ratio
  F statistic= (mean square between group means)/(mean sq within groups)
  ssd2 is called which uses meanc2  see reference to Ling JASA there
Input:  x  = n x p matrix  of (Xij) elements
       row i has i=1,2,..,n replicates.
       column j has j=1,2,...,p  treatments.
Output: 
       within ss
       between ss
       F statistic
  author H. D. Vinod,  March 9, 1999
@
  Local
      n, p, avg, grand, betw, within, xvec, grand1, betdf,
      i, sumwi, withidf, msb, msw, f;

  format /ld 25,15;
  n=rows(x);p=cols(x);xvec=reshape(x,n*p,1);
  avg=meanc2(x);  @group means@
  grand1=meanc2(avg);
"Individual column (group) means"  avg';
"Grand mean as mean of column (group) means " grand1;
  grand=meanc2(xvec);
"Grand mean from vecorization of original data " grand;
"Discrepancy in grand means " (grand1-grand);

@  Now between treatment calculations @
betw=n*ssd2(avg);
"Between sum of squared deviations " betw;
betdf=p-1;
" between degrees of freedom" betdf;
msb=betw/betdf;

@  Now Within treatment (column) calculations @

within=zeros(p,1);
i=1;do while i<=p;
within[i]=ssd2(x[.,i]);
i=i+1;endo;
sumwi= sumc(within);
withidf=p*(n-1);
" within degrees of freedom" withidf;
msw=sumwi/withidf;
"Mean squares: msb~msw" msb~msw;
f=msb/msw;
"F statistic " f;
  retp(sumwi, betw, f);
  endp;
@ --- End file called  anov2.g for numerically improved anova   @


