@File: nistols.g    NIST and ols @
Proc (1)=nistols(y,x,cb,cstdb,cr2);
@proc to compute the ols tests using NIST -STRD datasets
  Input: y= col vector for dep. Variable
         X= n x p dimensional matrix of regressors 
           (DO NOT include col of ones for the intercept, it is automatic)
         cb=certified values of b the regr coefficients
         cstdb= certified standard errors for b
         cr2=certified R-square
 Output:   NAD no of accurate digits results
  needs a proc for NAD calculation of scalars called numacc.g
  another proc for NADs as the minimum from a vector of NADs numacc2.g
@
local   vnam, m, b, stb, vc, stderr,
      sigma, cx, rsq, resid, dwst, pred, ybar,
      sst, r2, sse, lamb, lamsig, lamr2, ans1;

" "; "Begin estimation using ols";
__con=1;
 {vnam, m,b, stb, vc, stderr, sigma,cx, rsq, resid, dwst}= ols("", y, x);
" ";
r2=rsq; @r-square is output of ols routine@
lamb=numaccv2(b,cb);
 "NADs for standard errors next";
   lamsig=numaccv2(stderr,cstdb);

"NAD for estimated R-square next";
lamr2=numacc(r2,cr2);
format /ld 15,4;
"NAD's for regr coeff,  SEs and  R-sq   summary ***" ;
ans1=lamb~lamsig~lamr2;ans1;
format /ld 6,1;
"Final NADs by ols are:     " ans1;
format /le 23,15;
retp(ans1);
endp;
