@File:  nisoqr2f.g  olsqr2 used f => regr. line is forced  through the origin@
Proc (1)=nisoqr2f(y,x,cb,cstdb,cr2);
@proc to compute the ols tests using NIST -STRD datasets
  Input: y= col vector for dep. Variable
         X= n x p dimensional matrix of regressors 
         cb=certified values of b the regr coefficients
         cstdb= certified standard errors for b
         cr2=certified R-square
 Output:  NAD no of accurate digits results using olsqr2
        for coefficients and for R-square  (nothing for standard errors)
  needs a proc for NAD calculation of scalars called numacc.g
  another proc for NADs as the minimum from a vector of NADs numaccv2.g
@
local  vnam, m, b, stb, vc, stderr,
      sigma, cx, rsq, resid, dwst, pred, n,
      p, df, ehat, sse, sighat2, ixx, covb,
      ybar, sst, r2, lamb, lamsig, lamr2,ans1,ans2;
"  "; "Begin estimation using olsqr2";
{b, resid, pred}= olsqr2( y, x);
" ";
n=rows(x);
sse=resid'resid;
ybar=meanc(y);
sst=y'y;  @  This is where you do not subtract n ybar ^2  @
r2=1-(sse/sst);

lamb=numaccv2(b,cb);

"NAD for estimated R-square next";
lamr2=numacc(r2,cr2);
format /ld 15,4;
"NAD's for regr coeff,  R-sq (SE missing when olsqr2 called)  ***" ;
ans2=lamb~lamr2;ans2;
"  ";
format /ld 6,1;
"Final NADs by olsqr2 are:   " ans2;
format /le 23,15;
retp(ans2);
endp;
