@File: niolsqr2.g    NIST and ols using olsqr2 @
Proc (1)=niolsqr2(y,x,cb,cstdb,cr2);
@proc to compute the ols tests using NIST -STRD datasets
  Input: y= col vector for dep. Variable
         X= n x p dimensional matrix of regressors 
           (DO NOT include col of ones for the intercept, it is automatic)
         cb=certified values of b the regr coefficients
         cstdb= certified standard errors for b
         cr2=certified R-square
 Output:  NAD (no of accurate digits) results using olsqr2
        coeffcients, R-square  
        No results for standard errors since olsqr2 does not give them.
  needs a proc for NAD calculation of scalars called numacc.g
  another proc for NADs as the minimum from a vector of NADs numaccv2.g
@
local  vnam, m, b, stb, vc, stderr,
      sigma, cx, rsq, resid, dwst, pred, ybar,
      sst, r2, sse, lamb, lamsig, lamr2, ans1,
      ans2,n, ane, ncb;
n=rows(x);m=cols(x);ncb=rows(cb);
ane=ones(n,1);
"  "; "Begin estimation using olsqr2";
  if m<ncb;{b, resid, pred}= olsqr2( y, ane~x);endif;
  if m==ncb;{b, resid, pred}= olsqr2( y, x);endif;

" ";
n=rows(x);
ybar=meanc(y);
sst=y'y-n*(ybar^2);
sse=resid'resid; r2=1-(sse/sst);
lamb=numaccv2(b,cb);
"NAD for estimated R-square next";
lamr2=numacc(r2,cr2);
format /ld 15,4;
"NAD's for regr coeff,  R-sq (SE missing when olsqr2 called)  ***" ;
ans2=lamb~lamr2;ans2;
"  ";

format /ld 6,1;
"Final NADs by olsqr2 are:   " ans2;
format /le 23,15;
retp(ans2);
endp;
