**************************************************************
************************ PANEL CREATION **********************
**************************************************************

*Set the base directory
local maindir  "/path/to/folder"

*Set ado file location
*sysdir set PERSONAL "//client/c$/stataado"

************************
use "`maindir'/data/intermediate/processed/1997/fieldfertloc97_cleaned.dta", clear
merge 1:1 hhid field using "`maindir'/data/intermediate/processed/1997/croplev97_cleaned.dta", keep(match) nogenerate
merge m:1 hhid using "`maindir'/data/intermediate/processed/1997/demographics97_cleaned.dta", keep(match) nogenerate
merge m:1 hhid using "`maindir'/data/intermediate/processed/1997/labour97_hhid.dta", keep(match) nogenerate
merge m:1 hhid using "`maindir'/data/intermediate/processed/1997/fertdist97.dta", keep(match) nogenerate
drop lpcost
merge m:1 hhid using "`maindir'/data/intermediate/processed/1997/lpcost97_cleaned.dta", keep(match) nogenerate
save "`maindir'/data/cleaned/1997.dta", replace

************************
use "`maindir'/data/intermediate/processed/2000/croplev00_cleaned.dta", clear
*create new field ID if green maize, gets aggregated below
replace field=real(string(field) + string(999)) if crop=="green maize"
merge 1:1 hhid field harvest using "`maindir'/data/intermediate/processed/2000/field00_cleaned.dta", keep(match) nogenerate
merge 1:1 hhid field harvest using "`maindir'/data/intermediate/processed/2000/fert00_cleaned.dta", nogenerate
merge m:1 hhid using "`maindir'/data/intermediate/processed/2000/demographics00_cleaned.dta", keep(match) nogenerate
merge m:1 hhid using "`maindir'/data/intermediate/processed/2000/hhidfinal00_cleaned.dta", keep(match) nogenerate
save "`maindir'/data/cleaned/2000.dta", replace

************************
use "`maindir'/data/intermediate/processed/2004/croplev04_cleaned.dta", clear
*create new field ID if green maize, gets aggregated below
replace field=real(string(field) + string(999)) if crop=="green maize"
merge m:1 hhid field using "`maindir'/data/intermediate/processed/2004/field04_cleaned.dta", keep(match) nogenerate
merge 1:1 hhid field using "`maindir'/data/intermediate/processed/2004/fert04_cleaned.dta", keep(master match) nogenerate
merge m:1 hhid using "`maindir'/data/intermediate/processed/2004/labour04_hhid.dta", keep(match) nogenerate
merge m:1 hhid using "`maindir'/data/intermediate/processed/2004/demographics04_cleaned.dta", keep(match) nogenerate
merge m:1 hhid using "`maindir'/data/intermediate/processed/2004/hhidfinal04_cleaned.dta", keep(match) nogenerate
drop lpcost
merge m:1 hhid using "`maindir'/data/intermediate/processed/2004/lpcost04_cleaned.dta", keep(match) nogenerate
merge m:1 hhid using "`maindir'/data/intermediate/processed/2004/fertskm04.dta", keep(match) nogenerate
save "`maindir'/data/cleaned/2004.dta", replace

************************
use "`maindir'/data/intermediate/processed/2007/croplev07_cleaned.dta", clear
*create new field ID if green maize, gets aggregated below
replace field=real(string(field) + string(999)) if crop=="green maize"
merge 1:1 hhid field using "`maindir'/data/intermediate/processed/2007/field07_cleaned.dta", keep(match) nogenerate
merge m:1 hhid using "`maindir'/data/intermediate/processed/2007/demographics07_cleaned.dta", keep(match) nogenerate
merge 1:1 hhid field using "`maindir'/data/intermediate/processed/2007/fert07_cleaned.dta", keep(match) nogenerate
merge m:1 hhid using "`maindir'/data/intermediate/processed/2007/hhidfinal07_cleaned.dta", keep(match) nogenerate
merge m:1 hhid using "`maindir'/data/intermediate/processed/2007/labour07_hhid.dta", keep(match) nogenerate
drop lpcost
merge m:1 hhid using "`maindir'/data/intermediate/processed/2007/lpcost07_cleaned.dta", keep(match) nogenerate
save "`maindir'/data/cleaned/2007.dta", replace

************************
use "`maindir'/data/intermediate/processed/2010/croplev10_cleaned.dta", clear
*create new field ID if green maize, gets aggregated below
replace field=real(string(field) + string(999)) if crop=="green maize"
merge 1:1 hhid field using "`maindir'/data/intermediate/processed/2010/fert10_cleaned.dta", keep(match) nogenerate
merge 1:1 hhid field using "`maindir'/data/intermediate/processed/2010/field10_cleaned.dta", keep(match) nogenerate
merge m:1 hhid using "`maindir'/data/intermediate/processed/2010/labour10_cleaned.dta", keep(match) nogenerate
merge m:1 hhid using "`maindir'/data/intermediate/processed/2010/demographics10_cleaned.dta", keep(match) nogenerate
merge m:1 hhid using "`maindir'/data/intermediate/processed/2010/hhidfinal10_cleaned.dta", keep(match) nogenerate
drop lpcost
merge m:1 hhid using "`maindir'/data/intermediate/processed/2010/lpcost10_cleaned.dta", keep(match) nogenerate
save "`maindir'/data/cleaned/2010.dta", replace

**************
** EXTENDED SURI PANEL **
**************
clear
use "`maindir'/data/cleaned/1997.dta", clear

append using "`maindir'/data/cleaned/2000.dta"
append using "`maindir'/data/cleaned/2004.dta"
append using "`maindir'/data/cleaned/2007.dta"
append using "`maindir'/data/cleaned/2010.dta"

order year, first
*harmonizing variable names
replace kg_harv = qprod if (year == 1997)
replace kg_harv = kgharv if (year == 2007 | year == 2010)

gen importantmissing = 0
replace importantmissing = 1 if missing(kg_harv)
replace importantmissing = 1 if missing(sdtype)

drop if importantmissing == 1
drop importantmissing


gen is1997 = cond(year==1997, 1, 0)
gen is2000 = cond(year==2000, 1, 0)
gen is2004 = cond(year==2004, 1, 0)
bys hhid: egen has1997 = max(is1997)
bys hhid: egen has2000 = max(is2000)
bys hhid: egen has2004 = max(is2004)
gen bothyears = has1997*has2000*has2004
drop if bothyears==0
drop if year==2000

replace sdtype=lower(sdtype)
gen hybrid = (strpos(sdtype,"hybrid") & strpos(sdtype,"purch"))

collapse (sum) acres kg_harv DAP MAP CAN totfertexp seedkg (max) hybrid lpcost boys girls men women oldermen familylabor_S hiredlabor_S fertskm hhsize (first) prov (first) dist (first) vil, by(hhid year)


replace DAP = DAP/acres
replace MAP = MAP/acres
replace CAN = CAN/acres
replace totfertexp = totfertexp/acres
replace seedkg = seedkg/acres

*Merge in Suri Rain
merge 1:1 hhid year using "`maindir'/data/intermediate/processed/rainfall.dta", keep(match) nogenerate

*Merge in CPI
merge m:1 year using "`maindir'/data/cleaned/CPI.dta", keep(match) nogenerate

replace cpi=1 if year==2010

foreach var in totfertexp lpcost hiredlabor_S{
	replace `var' = `var'/cpi
}

gen dep = log(kg_harv/acres)

rename rainfall main
rename avgrainfall avg_main

tab year, sum(acres)
tab year, sum(hhsize)
tab year, sum(main)
tab year, sum(dep)
tab year, sum(acres)
tab year, sum(DAP)
tab year, sum(MAP)
tab year, sum(CAN)
tab year, sum(fertskm)
tab year, sum(familylabor_S)
tab year, sum(hiredlabor_S)

xtset hhid year

tab prov, gen(provi)

save "`maindir'/data/panels/SuriPanel_extended.dta", replace

********************************************************************************
******************************** FINISH FILE ***********************************
********************************************************************************
