# This script presents an example of how the estimations in the paper can be carried out.


# Setup ----
library(tictoc)
library(data.table)
library(copula)
library(wrapr)
library(nloptr)
library(sn)
library(Matrix)
library(numDeriv)
library(matrixcalc)
library(bbmle)

# Load user-written functions for the models' implementation
source("functions.R")

# Model definition ----

# Data to be used: single/married/child.
db <- "single"

# Demand system to be used: aids/aids_r/quaids/quaids_r/ml/ml_r
# "_r" denotes models with curvature impositions. 
model <- "ml"

# Copula to be used: normal/clayton/frank/gumbel
cop <- "clayton"

# Pair of goods that will be directly modeled: c(1,2)/c(1,3)/c(3,2)
sel <- c(1,2)

# Marginals used for the residuals of modeled goods: c("n","n")/c("sn","n")/c("n","sn")/c("sn","sn")
# This vector should match "sel", so that residuals of Good sel[i] have a marginal margs[i].
margs <- c("n","n")

# Should a transformation be applied?: yes/no
transf <- "yes"

# Estimation ----

# We use a wrapper function that adjusts the specified model to the selected dataset.
result <-wraper_est(db = db, model = model,
                    m1 = margs[1], m2 = margs[2],
                    cop_fam = cop,
                    sel1 = sel[1], sel2 = sel[2],
                    transform = transf,
                    quiet = F)

# Result analysis ----

# The resulting object contains:

# Coefficients
print(result@fullcoef)
# Covariance matrix
print(result@vcov)

# Which can be formatted using built in summaries from bbmle
print(summary(result))

# Price elasticities
print(result@Marsh_elast)
# Income elasticities
print(result@Income_elast)
# Elasticities' standard errors using the (delta method)
print(result@Elast_SE)

# Regularity checks (presented as the number of violations)
print(result@Reg_vio)

# And the reported goodness-of-fit measures
print(result@BIC)
print(result@copfit)
