/*
 * loadmat.cpp


 *
 *  Created on: Jun 3, 2013
 *      Author: Aico van Vuuren
 */
#ifndef SAVEMAT_INCLUDED
#define SAVEMAT_INCLUDED

#include <iostream>
#include <string>
#include <fstream>
#include "loadmat.cpp"

using namespace std;

class SaveData {

	public : SaveData(){

	}

	public: void SaveTxt(string vp_string, double** data, int m, int n)
	{
		char outfile[100];


		int hulp = vp_string.copy(outfile, vp_string.length(), 0);
		outfile[hulp] = '\0';

		ofstream outf(outfile);


		if (!outf)     {
			// Print an error and exit
			throw IOException(outfile);
		}

		outf.precision(15);


		// While there's still stuff left to read
		int i;

		outf << m << "\t";
		outf << n << endl;

		for(i=0;i<m;i++)
		{
			int j;
			for(j=0;j<n;j++)
			{
				//cout << i << "\t" << j << endl;
				double x1 = data[i][j];
				outf << x1 << "\t";
			}
			outf << endl;
		}
	}

	public: void SaveTxt_vector(string vp_string, double* data, int m)
		{
			char outfile[100];


			int hulp = vp_string.copy(outfile, vp_string.length(), 0);
			outfile[hulp] = '\0';

			ofstream outf(outfile);


			if (!outf)     {
				// Print an error and exit
				throw IOException(outfile);
				return;
			}


			// While there's still stuff left to read
			int i;

			outf << m << "\t";
			outf << 1 << endl;
			outf.precision(20);

			for(i=0;i<m;i++)
			{
				double x1 = data[i];
				outf << x1 << endl;
			}
			outf.close();
		}
	
	public: void SaveTxt_vector(string vp_string, int* data, int m)
		{
			char outfile[100];


			int hulp = vp_string.copy(outfile, vp_string.length(), 0);
			outfile[hulp] = '\0';

			ofstream outf(outfile);


			if (!outf)     {
				// Print an error and exit
				throw IOException(outfile);
				return;
			}


			// While there's still stuff left to read
			int i;

			outf << m << "\t";
			outf << 1 << endl;
			outf.precision(30);

			for(i=0;i<m;i++)
			{
				int x1 = data[i];
				outf << x1 << endl;
			}
			outf.close();
		}
};

#endif




