/*
 * sample_0.cpp
 *
 *  Created on: Jun 4, 2013
 *      Author: Aico van Vuuren
 */
#ifndef SAMPLE_INCLUDED
#define SAMPLE_INCLUDED

#include "loadmat.cpp"
#include "maximize.cpp"
#include "NormalDistribution.cpp"
#include "BisectionSolver.cpp"
#include "savemat.cpp"

#include <stdlib.h>

#if _MSC_VER > 1500
#define isinf(x) (!_finite(x))
#define isnan(x) (_isnan(x))
#endif
using namespace std;

class SampleException {
	public : string ExceptionText;
	SampleException(string ExceptionText){
		this->ExceptionText = ExceptionText;
	}
};

class Function5 : public Maximize {
	double Mu_w, Sigma, B, Rho, Delta, Lambda;

	public: Function5(double Lambda, double Delta, double Rho, double B, double Mu_w, double Sigma) {
			this->Lambda = Lambda;
			this->Sigma = Sigma;
			this->Delta = Delta;
			this->B = B;
			this->Rho = Rho;
			this->Mu_w = Mu_w;
			cp = 1;

	}
	public: virtual double Function(double* variable_list) throw(RuntimeException)
	{
		double f1 = Psi_phi_new(variable_list[0]);
		return -f1 * f1;
	}

	public: virtual double* dFunction(double* variable_list) throw(RuntimeException)
	{
		double phi = variable_list[0];
		double f1 = Psi_phi_new(phi);
		double df =  dPsi_phi_new(phi);
		double* df1 = (double*)malloc(sizeof(double));
		df1[0] = -2 * f1 * df;
		return df1;
	}

	double Psi_phi_new(double phi)
	{
		NormalDistribution normal(Mu_w, Sigma);
		double hulp1 = log(phi);
		double hulp2 = hulp1 - Sigma * Sigma;
		double hulp_1 = exp(Mu_w + 0.5 * Sigma * Sigma) * ((1-normal.cumulativeProbability(hulp2)) / (1-normal.cumulativeProbability(hulp1)));
		double aresult1 = (1-normal.cumulativeProbability(hulp1)) * (hulp_1 - phi);

		return phi - B - (Lambda / (Rho + Delta)) * aresult1;
	}

	double dPsi_phi_new(double phi)
	{
		NormalDistribution normal(Mu_w, Sigma);
		double hulp1 = log(phi);
		double aresult1 = 1-normal.cumulativeProbability(hulp1);

		return 1 + (Lambda / (Rho + Delta)) * aresult1;
	}
};

class Function1a : public Maximize {

	double Mu, Sigma, Rho, Delta, K, Lambda, P, B, Tau, Eta;
//	NormalDistribution* normal;

	public : Function1a(double Mu, double Sigma, double Rho, double Delta, double K, double Lambda, double P, double B, double Tau, 
					double Eta)
	{
		this->Mu = Mu;
		this->Sigma = Sigma;
		this->Rho = Rho;
		this->Delta = Delta;
		this->K =K;
		this->Lambda = Lambda;
		this->P = P;
		this->B = B;
		this->cp = 2;
		this->Tau = Tau;
		this->Eta = Eta;
	}

	~Function1a()
	{
		//delete normal;
	}

	public: virtual double* value(double Phi_1, double Phi_2) throw(RuntimeException) {
		return Psi_phia_1_new(Phi_1, Phi_2);
	}

	public: virtual double Function(double* variable_list) throw(RuntimeException)
	{
		double* f1 = value(variable_list[0], variable_list[1]);
		double result = -f1[0] * f1[0] - f1[1] * f1[1];
		free(f1);
		return result;
	}

	public: virtual double* dFunction(double* variable_list) throw(RuntimeException)
	{
		double* f1 = value(variable_list[0], variable_list[1]);
		double** df = dPsi_phia_1_new(variable_list[0], variable_list[1]);
		double* df1 = (double*)malloc(sizeof(double) * 2);
		df1[0] = -2 * f1[0] * df[0][0] - 2 * f1[1] * df[1][0];
		df1[1] = -2 * f1[0] * df[0][1] - 2 * f1[1] * df[1][1];
		
		free(f1);
		free(df[0]);
		free(df[1]);
		free(df);
		
		return df1;
	}

	private : double* Psi_phia_1_new(double Phi_0, double Phi_1)
	{
		double phi0 = max(Phi_0, 1E-7);
		double phi1 = max(Phi_1, 1E-7);
		
		double sigma2 = Sigma * Sigma;
		double rho1 = Rho + Delta + Tau;
		NormalDistribution normal(Mu, Sigma);
		double hulp_normal = normal.cumulativeProbability(log(phi0));
		double hulp_normal_a = normal.cumulativeProbability(log(phi0) - sigma2);
		double hulp_normal_1 = normal.cumulativeProbability(log(phi1));
		double hulp_normal_1_a = normal.cumulativeProbability(log(phi1) - sigma2);
		double hulp_normal_2 = normal.cumulativeProbability(log(phi1 + (Rho + Delta) * K));
		double hulp_normal_2_a = normal.cumulativeProbability(log(phi1 + (Rho + Delta) * K) - sigma2);

		double expression1 = exp(Mu + Sigma * Sigma / 2);

		double aresult;

		if (hulp_normal_a == 1)
			aresult = 0;
		else
		{
			double hulp2b =  expression1 * (1-hulp_normal_a);
			aresult = hulp2b - (1 - hulp_normal) * Phi_0;
		}

		double aresult1;

		if (hulp_normal_1_a == 1)
			aresult1 = 0;
		else
		{
			double hulp2a_1 = expression1 * (1-hulp_normal_1_a);
			aresult1 = hulp2a_1  - (1-hulp_normal_1) * Phi_1;
		}

		double aresult2;
		if (hulp_normal_2 == 1)
			aresult2 = 0;
		else
		{
			double hulp2a_2 = expression1 * (1-hulp_normal_2_a);
			aresult2 = hulp2a_2  - (1-hulp_normal_2) * (Phi_1 + (Rho + Delta) * K);
		}

		double adfunc1 = Phi_0 - (B - Eta) * ((Rho+Delta)/Rho) + (Delta / Rho) * Phi_1 - (Lambda / Rho) * aresult - K * (Rho+Delta);
		double adfunc2 = Phi_1 - Tau * Phi_0 / rho1 - (B-Tau * K) * (Rho + Delta) / rho1 - (Lambda * P / rho1) * aresult1
					- (Lambda * (1-P) / rho1) * aresult2;
		double* result = (double*)malloc(sizeof(double) * 2);

		
		result[0] = adfunc1;
		result[1] =  adfunc2;

		return result;
	}

	private: double** dPsi_phia_1_new(double Phi_0, double Phi_1)
	{
		double** result = (double**)malloc(sizeof(double*)*2);
		result[0] = (double*)malloc(sizeof(double)*2);
		result[1] = (double*)malloc(sizeof(double)*2);

		double phi0 = max(Phi_0, 1E-7);
		double phi1 = max(Phi_1, 1E-7);
		double rho1 = Rho + Delta + Tau;
		NormalDistribution normal(Mu, Sigma);
		double hulp_normal = normal.cumulativeProbability(log(phi0));
		double hulp_normal_1 = normal.cumulativeProbability(log(phi1));
		double hulp_normal_2 = normal.cumulativeProbability(log(phi1) + (Rho + Delta) * K);

		result[0][0] = 1 + (Lambda / Rho) * (1 - hulp_normal);
		result[0][1] = Delta / Rho;
		result[1][0] = -Tau / rho1;
		result[1][1] = 1 +  (Lambda * P / rho1) * (1-hulp_normal_1) + (Lambda * (1-P) / rho1) * (1-hulp_normal_2);

		return result;
	}
};


class Function3 : public BisectionSolver, public Maximize {

		double u;
		double Theta_2;
		double Theta_1;
		double Tau;

		public : Function3(double u, double Theta_1, double Theta_2, double Tau)
		{
			this->u = u;
			this->Tau = Tau;
			this->Theta_2 = Theta_2;
			this->Theta_1 = Theta_1;
			this->cp = 1;
		}

		public : virtual double value(double t0)  throw(RuntimeException) {
			return Fie3b(t0, u);
		}

		public: virtual double Function(double* variable_list) throw(RuntimeException)
		{
			double f1 = value(variable_list[0]);
			return -f1 * f1;
		}

		public: virtual double* dFunction(double* variable_list) throw(RuntimeException)
		{
			double t0 = variable_list[0];
			double f1 = value(t0);
			double df =  dFie3b(t0, u);
			double* df1 = (double*)malloc(sizeof(double));
			df1[0] = -2 * f1 * df;
			return df1;
		}

		double dFie3b(double t0, double u)
		{
			return Theta_2 *  exp(-Theta_2 * t0) * Tau  + (Theta_1 - Theta_2)
					* (Theta_1+Tau)  * exp(-(Theta_1+Tau) * t0);
		}

		virtual ~Function3()
		{
		}

		double  Fie3b(double t0, double u)
		{
			//cout << t0 << "\t" << exp(-(Theta_2+Tau) * t0)<< "\t" << Theta_1 << endl;

			return u * (Theta_1-Theta_2+Tau)  -  exp(-Theta_2 * t0) * Tau
					- (Theta_1 - Theta_2)  * exp(-(Theta_1+Tau) * t0);
		}
	};

class Function1 : public Maximize, public BisectionSolver {

	double Mu, Sigma, Rho, Delta, K, Lambda, P, B;
	NormalDistribution* normal;

	public : Function1(double Mu, double Sigma, double Rho, double Delta, double K, double Lambda, double P, double B)
	{
		this->Mu = Mu;
		this->Sigma = Sigma;
		this->Rho = Rho;
		this->Delta = Delta;
		this->K =K;
		this->Lambda = Lambda;
		this->P = P;
		this->B = B;
		normal = new NormalDistribution(Mu, Sigma);
		this->cp = 1;
	}

	~Function1()
	{
		delete normal;
	}

	public: virtual double value(double Phi_1) throw(RuntimeException) {
		return Psi_phia_1_new(Phi_1);
	}

	public: virtual double Function(double* variable_list) throw(RuntimeException)
	{
		double f1 = value(variable_list[0]);
		return -f1 * f1;
	}

	public: virtual double* dFunction(double* variable_list) throw(RuntimeException)
	{
		double f1 = value(variable_list[0]);
		double df = dPsi_phia_1_new(variable_list[0]);
		double* df1 = (double*)malloc(sizeof(double));
		df1[0] = -2 * f1 * df;
		return df1;
	}

	double Psi_phia_1_new(double Phi_1)
	{
		double phi1 =  1e-7 > Phi_1 ? 1e-7 : Phi_1;
		double sigma2 = Sigma * Sigma;
		double rho1 = Rho + Delta;
		double hulp_normal_1 = normal->cumulativeProbability(log(phi1));
		double hulp_normal_1_a = normal->cumulativeProbability(log(phi1) - sigma2);
		double hulp_normal_2 = normal->cumulativeProbability(log(phi1 + (Rho + Delta) * K));
		double hulp_normal_2_a = normal->cumulativeProbability(log(phi1 + (Rho + Delta) * K) - sigma2);

		double expression1 = exp(Mu + Sigma * Sigma / 2);

		double hulp2a_1 = expression1 * (1-hulp_normal_1_a);
		double aresult1 = hulp2a_1 - (1-hulp_normal_1) * phi1;
		double hulp2a_2 = expression1 * (1-hulp_normal_2_a);
		double aresult2 = hulp2a_2 - (1-hulp_normal_2) * (phi1 + (Rho + Delta) * K);
		return Phi_1  - B - (Lambda * P / rho1) * aresult1 - (Lambda * (1-P) / rho1) * aresult2;
	}

	double dPsi_phia_1_new(double Phi_1)
	{
		double phi1 =  1e-7 > Phi_1 ? 1e-7 : Phi_1;
		double rho1 = Rho + Delta;
		double hulp_normal_1 = normal->cumulativeProbability(log(phi1));
		double hulp_normal_2 = normal->cumulativeProbability(log(phi1) + (Rho + Delta) * K);
		double avscore22 = 1 +  (Lambda * P / rho1) * (1-hulp_normal_1) + (Lambda * (1-P) / rho1) * (1-hulp_normal_2);
		return avscore22;
	}
};


class Sample {
	public : double Mu, Sigma, B, Rho, Delta, Lambda, mu_v1, mu_v2, sigma_v1, sigma_v2, Rho_1, Mu_u, Sigma_u, K, U, P, 
			Tau;
	double* Beta1;
	double* Beta2;

	private : double Theta_1, Theta_2;
	private : static constexpr double Lambda_T = 5;
	public : double Lambda_H;
	private : int N;
	private : int numprocs;
	private : NormalDistribution *normal;
	private : double** T_1_totaal_a;
	private : double** T_1_totaal_b;
	private : double** D_1_totaal_a;
	private : double** D_1_totaal_b;
	private : double** H_1_totaal;
	private : double** D_2_totaal;
	private : double** T_2_totaal;
	private : double** H_2_totaal;
	private : double** X;
	private : double* G1;
	private : double* G2;
	private : double* G3;
	private : double* G4;
	private : double* G5;
	private : double* W;
	private : int k;
	private : int k1;
	private : double* u2;
	private : double* u2_1;
	private : double* u3;
	private : double* u_x;
	private : double** u16;
	private : double** u17;
	private : double** u14;
	private : double** u14a;
	private : double** u14b;
	private : double** u15;
	private : double** u15a;
	private : double** u_u_spells;
	private : double** u_e_spells;
	private : int n_u[10];
	private : int n_e[10];
	private : double* Beta_U;
	private: int* U_spells_totaal;
	private : int* E_spells_totaal;
	private : double hulp_g1[10];
	private : double hulp_g2[10];
	private : double hulp_g3[10];
	private : double hulp_g4[10];
	private : double hulp_g5[10];
	private : double* u_w;
	private : double Mu_W;
	private : double** g_all;
	private : double* Beta_W;
	
	public : Sample(double Mu, double* Beta_W, double Sigma, double B, double K, double Rho, double* Beta1, double* Beta2,
					double mu_v1, double mu_v2, double sigma_v1,
					double sigma_v2, double Mu_u, double* Beta_U, double Sigma_u,  double P, double Rho_1, double Tau,
						int* n_employment_spells, int* n_unemployment_spells, int k, int k1,
							double* u2,
								double* u2_1,
									double* u3,
									double* u_x,
									double** u16,
									double** u17,
									double** u14,
									double** u14a,
									double** u14b,
									double** u15,
									double** u15a,
									double** u_u_spells,
									double** u_e_spells,
									double** g_all,
									double* u_w,
									int Min, int Max, int numprocs) throw (SampleException)
	{

		n_u[0] =  19869;
		n_u[1] =  10972;
		n_u[2] =  6817;
		n_u[3] =  4290;
		n_u[4] =  2672;
		n_u[5] = 1572;
		n_u[6] = 825;
		n_u[7] = 448;
		n_u[8] = 250;
		n_u[9] = 135;
		this->numprocs = numprocs;

		n_e[0] = 140082;
		n_e[1] = 47008;
		n_e[2] = 21298;
		n_e[3] = 11480;
		n_e[4] = 6730;
		n_e[5] = 6730;
		n_e[6] = 2819;
		n_e[7] = 1955;
		n_e[8] = 1172;
		n_e[9] = 914;

	
		this->u2 = u2;
		this->u2_1 = u2_1;
		this->u3 = u3;
		this->u_x = u_x;
		this->u16 = u16;
		this->u17 = u17;
		this->u14 = u14;
		this->u14a = u14a;
		this->u14b = u14b;
		this->u15 = u15;
		this->u15a = u15a;
		this->u_u_spells =u_u_spells;
		this->u_e_spells = u_e_spells;
		this->u_w = u_w;

		this->g_all = g_all;
		this->k = k;
		this->Mu = Mu;
		this->Beta_W = Beta_W;
		this->Sigma = Sigma;
		this->B = B;
		this->Rho = Rho;
		this->Beta1 = Beta1;
		this->Beta2 = Beta2;
		this->mu_v1 = mu_v1;
		this->K = K;
		this->mu_v2 = mu_v2;
		this->sigma_v1 = sigma_v1;
		this->sigma_v2 = sigma_v2;
		this->Rho_1 = Rho_1;
		this->P = P;
		this->Mu_u = Mu_u;
		this->Sigma_u = Sigma_u;
		this->k1 = k1;
		this->Beta_U = Beta_U;
		this->Tau = Tau;
		
		Lambda_H = 10.;
		N = max(n_employment_spells[0], n_unemployment_spells[0]);
		hulp_g1[0] = - 0.6559082;
		hulp_g1[1] = - 0.8914497;
		hulp_g1[2] = - 1.14313;
		hulp_g1[3] = - .6237157;
		hulp_g1[4] = - .7913911;
		hulp_g1[5] = -  .484849;
		hulp_g1[6] = 0.9484849;
		hulp_g1[7] = 0.0521926;
		hulp_g1[8] = 0.1935708;
		hulp_g1[9] =  -.7256228;

		hulp_g2[0] = 0.210;
		hulp_g2[1] = 0.456;
		hulp_g2[2] = 1.224;
		hulp_g2[3] = - 0.077;
		hulp_g2[4] = - 0.031;
		hulp_g2[5] = 0.030;
		hulp_g2[6] = 0.193;
		hulp_g2[7] = 0.145;
		hulp_g2[8] = - 0.055;
		hulp_g2[9] = 0.023;
				
		hulp_g3[0] = 0.355;
		hulp_g3[1] = 1.279;
		hulp_g3[2] = 2.351;
		hulp_g3[3] = 0.796;
		hulp_g3[4] = 0.706;
		hulp_g3[5] = 0.627;
		hulp_g3[6] = - 0.578;
		hulp_g3[7] = - 0.545;
		hulp_g3[8] = - 0.124;
		hulp_g3[9] = -0.977;
				
		hulp_g4[0] = 0.666;
		hulp_g4[1] = 0.383;
		hulp_g4[2] = - 0.207;
		hulp_g4[3] = 0;
		hulp_g4[4] = 0.005;
		hulp_g4[5] = - 0.009;
		hulp_g4[6] = 0.178;
		hulp_g4[7] = 0.730;
		hulp_g4[8] = - 0.371;
		hulp_g4[9] = -0.020;

				
		hulp_g5[0] = - .3409135;
		hulp_g5[1] = -  .4507015;
		hulp_g5[2] =  -  .2824837 ;
		hulp_g5[3] = - .9211633 ;
		hulp_g5[4] =  -  1.096131 ;
		hulp_g5[5] =  -  .6617068  ;
		hulp_g5[6] = -  .6572017;
		hulp_g5[7] = -   .265853 ;
		hulp_g5[8] = .161899;

		T_1_totaal_a = (double**)malloc(sizeof(double*) * N);
		T_1_totaal_b = (double**)malloc(sizeof(double*) * N);
		D_1_totaal_a = (double**)malloc(sizeof(double*) * N);
		D_1_totaal_b = (double**)malloc(sizeof(double*) * N);
		H_1_totaal = (double**)malloc(sizeof(double*) * N);
		D_2_totaal = (double**)malloc(sizeof(double*) * N);
		T_2_totaal = (double**)malloc(sizeof(double*) * N);
		H_2_totaal = (double**)malloc(sizeof(double*) * N);
		X = (double**)malloc(sizeof(double*) * N);
		
		U_spells_totaal = (int*)malloc(sizeof(int) * N);
		E_spells_totaal = (int*)malloc(sizeof(int) * N);
		G1 = (double*)malloc(sizeof(double) * N);
		G2 = (double*)malloc(sizeof(double) * N);
		G3 = (double*)malloc(sizeof(double) * N);
		G4 = (double*)malloc(sizeof(double) * N);
		G5 = (double*)malloc(sizeof(double) * N);
		W = (double*)malloc(sizeof(double) * N);
		
		try {
			GetSample(Min, Max);
		}
		catch (SampleException &e)
		{
			throw SampleException(e.ExceptionText);
		}
		

	}

	~Sample()
	{
	}


	public : void GetSample(int Min, int Max) throw (SampleException)
/* Sampling function - makes the sampling for the indirect inference method
*/
	{

		int i;


		double** t_hulp;
		double** t_hulp1;
		double** t_hulp2;

		if (numprocs == 1)
		{
			t_hulp = (double**)malloc(N * sizeof(double*));
			t_hulp1 = (double**)malloc(N * sizeof(double*));
			t_hulp2 = (double**)malloc(N * sizeof(double*));
		}


		for(i=Min;i<=Max;i++)
		{
			int e_spells = 0;
			int u_spells = 0;

			
			double* hulp_x1 = g_all[i];
			double* x = (double*)malloc(sizeof(double)*k1);
			memcpy(x, hulp_x1, k1 * sizeof(double));
		
			
			int i_g;
			
			Mu_W = Mu + Maximize::internal_product(x, Beta_W, k1);
			normal = new NormalDistribution(Mu_W, Sigma);
	
			double u2 = this->u2[i];			
			double u2_1 = this->u2_1[i];
			double v1 = mu_v1 + u2 * sigma_v1;
			
			double v2 = mu_v2 + sigma_v2 * (u2 * Rho_1 + u2_1 * sqrt(1-Rho_1 * Rho_1));
			double hulp_x = Maximize::internal_product(x, Beta1, k1);

			Lambda = exp(hulp_x + v1);
			double x_beta2 = Maximize::internal_product(x, Beta2, k1); 
			double factor_delta =  x_beta2 + v2;
			Delta = exp(x_beta2 + v2);

			double* result_d1_1a = (double*)malloc(sizeof(double) * k);
			double* result_d1_1b = (double*)malloc(sizeof(double) * k);
			double* result_t1_a_1 = (double*)malloc(sizeof(double) * k);
			double* result_t1_b_1 = (double*)malloc(sizeof(double) * k);
			double* result_d2_1 = (double*)malloc(sizeof(double) * k);
			double* result_t2_1 = (double*)malloc(sizeof(double) * k);
			double* result_h1_1 = (double*)malloc(sizeof(double) * k);
			double* result_h2_1 = (double*)malloc(sizeof(double) * k);
			double phi;

			try {
				phi = BerekenPhi0();
			}
			catch (RuntimeException &e)
			{
				throw SampleException("Sampling failed here ");
			}

			double hulp_normal = normal->cumulativeProbability(log(phi));
			double w = normal->Normal_Inverse(hulp_normal + u_w[i] * (1 - hulp_normal));
			
			//cout << w  << "\t" << hulp_normal << "\t" << phi << "\t" << Mu_W <<  endl;

			int j;



			double** hulp_phi1 = new double*[k];
			for (j=0;j<k;j++)
			{

				double Mu_u1 =  Mu_u + Maximize::internal_product(x, Beta_U, k1);;
				U = exp(Mu_u1 + u16[i][j] * Sigma_u);

				double* phi1;
				
				try {
					phi1 = BerekenPhi1();
				}
				catch (RuntimeException &e)
				{
					throw SampleException(e.ExceptionText);
				}
				
				hulp_phi1[j] = phi1;
				
				double h1 = U - ((Delta / (Rho + Delta)) * (phi-phi1[1]) + Rho * K);
				
				h1 = min(h1, 1000.);
				h1 = max(h1, -1000.);

				double h1a = exp(h1 / Lambda_H) / (1+exp(h1 / Lambda_H));
				double u14 = this->u14[i][j];
				double u15 = this->u15[i][j];
				double* t = Simul_T(phi, u14, u15);
				double* t_1;

				try {
					t_1 = Simul_T1(phi1, u14, u15, i);
				}
				catch (RuntimeException &e) {
					throw SampleException("T_1 failed");
				}

				if (std::isnan(t[0]))
					throw SampleException("t[0] is NaN");
				if (std::isnan(t[1]))
					throw SampleException("t[1] is NaN");
				if (std::isnan(t_1[0]))
					throw SampleException("t_1[0] is NaN");
				if (std::isnan(t_1[1]))
					throw SampleException("t_1[1] is NaN");

				if (std::isinf(t[0]))
					t[0] = 1E+7;
				if (std::isinf(t[1]))
					t[1] = 1E+7;
				if (std::isinf(t_1[0]))
					t_1[0] = 1E+7;
				if (std::isinf(t_1[1]))
					t_1[1] = 1E+7;

				if (t[0] < 0)
					throw SampleException("t[0] is negative");
				if (t[1] < 0)
					throw SampleException("t[1] is negative");
				if (t_1[0] < 0)
					throw SampleException("t_1[0] is negative");
				if (t_1[1] < 0)
					throw SampleException("t_1[1] is negative");

				t_1[0] = min(t_1[0], 1E+7);
				t_1[1] = min(t_1[1], 1E+7);


				if ((j == 0) && (numprocs == 1))
				{
					t_hulp[i] = (double*)malloc(2 * sizeof(double));
					t_hulp1[i] = (double*)malloc(2 * sizeof(double));

					memcpy(t_hulp[i], t, 2 * sizeof(double));
					memcpy(t_hulp1[i], t_1, 2 * sizeof(double));;
				//	cout << t[0] << "\t" << t_hulp1[i][0] << endl;
				//	cout << t[0] << "\t";
				}

				t[0] = t_1[0] * h1a + t[0] * (1-h1a);
				t[1] = t_1[1] * h1a + t[1] * (1-h1a);

				if ((j == 0) && (numprocs == 1))
					{
						t_hulp2[i] = (double*)malloc(3 * sizeof(double));
						memcpy(t_hulp2[i], t, 2 * sizeof(double));
						t_hulp2[i][2] = h1a;
					}
				//cout << t[0] << endl;
				double psi3 = 3. / (10000.);
				double psi4 = -2. / (1000000.);

				double psi[2] = {0.,0.};
				double tmin[2] = {t[0] - 10000., t[1] - 10000.};
				double tmin2[2] = {tmin[0] * tmin[0], tmin[1] * tmin[1]};
				double tmin3[2] = {tmin2[0] * tmin[0], tmin2[1] * tmin[1]};

				if (t[0] > 10000)
				{
					if (t[0] < 10100)
						psi[0] = psi3 * tmin2[0] + psi4 * tmin3[0];
					else
						psi[0] = 1.;
				}



				if (t[1] > 10000)
				{
					if (t[1] < 10100)
					{
						psi[1] = psi3 * tmin2[1] + psi4 * tmin3[1];
					}
					else
						psi[1] = 1.;
				}

				if (u_u_spells[i][j] < (double)n_u[j]/ (double)n_e[0])
				{
					result_d1_1a[u_spells] = psi[0];
					result_d1_1b[u_spells] = psi[1];
					result_h1_1[u_spells] = h1;
					double t1a = (1-psi[0]) * t[0] + 10000 * psi[0];
					double t1b = (1-psi[1]) * t[1] + 10000 * psi[1];
					double hulp_t = (t1b - t1a) / Lambda_T;
					hulp_t = hulp_t > 100? 100:hulp_t;
					hulp_t = hulp_t < -100?100:hulp_t;
					result_d1_1a[u_spells] = exp(-hulp_t) / (1 + exp(-hulp_t));
					result_d1_1b[u_spells] = exp(hulp_t) / (1 +exp(hulp_t));
					result_t1_a_1[u_spells] = t1a * result_d1_1b[u_spells] + t1b * (1 - result_d1_1b[u_spells]);
					result_t1_b_1[u_spells] = t1a * result_d1_1b[u_spells] + t1b * (1 - result_d1_1b[u_spells]);
					u_spells++;
				}
				free(t_1);
				free(t);
			}


			for (j=0;j<k;j++)
			{
				double Mu_u1 =  Mu_u + Maximize::internal_product(x, Beta_U, k1);;
				U = exp(Mu_u1 + u16[i][j] * Sigma_u);
				double* phi1;
				try {
					phi1 = hulp_phi1[j];
				}
				catch (RuntimeException &e) {
					throw SampleException(e.ExceptionText);
				}
				
				double t2 = Simul_T2(u14[i][j]);


				if (std::isnan(t2))
					throw SampleException("t2 is NaN");
				if (t2 < 0)
					throw SampleException("t2 is negative");

				double psi3 = 3 / (10000);
				double psi4 = -2 / (1000000);
				double psi = 0.;
				double tmin = t2 - 10000;
				double tmin2 = tmin * tmin;
				double tmin3 = tmin2 * tmin;


				if (t2 > 10000)
				{
					if (t2 < 10100)
						psi = psi3 * tmin2 + psi4 * tmin3;
					else
						psi = 1.;
				}
				U = exp(Mu_u1 + u17[i][j] * Sigma_u);
				
				double h2 = U - ((Delta / (Rho + Delta)) * (phi-phi1[1]) + Rho * K);


				h2 = min(h2,1000.);
				h2 = max(h2,-1000.);
				if (u_e_spells[i][j] < (double)n_e[j]/ (double)n_e[0])
				{
					result_h2_1[e_spells] = h2;
					double t2_1 = (1-psi) * t2 + 10000 * psi;
					result_t2_1[e_spells] = t2_1;
					result_d2_1[e_spells] = psi;
					e_spells++;
				}
				//free(phi1);
			}

			for(j=u_spells;j<k;j++)
			{
				result_d1_1a[j] = -1;
				result_d1_1b[j] = -1;
				result_h1_1[j] = -1;
				result_t1_a_1[j] = -1;
				result_t1_b_1[j] = -1;
			}

			for(j=e_spells;j<k;j++)
			{
				result_h2_1[j] = -1;
				result_t2_1[j] = -1;
				result_d2_1[j] = -1;
			}

			for(j=0;j<k;j++)
			{
				free(hulp_phi1[j]);
			}
			

			free(hulp_phi1);
			T_1_totaal_a[i] = result_t1_a_1;
			T_1_totaal_b[i] =  result_t1_b_1;
			D_1_totaal_a[i] =  result_d1_1a;
			D_1_totaal_b[i] =  result_d1_1b;
			H_1_totaal[i] =  result_h1_1;
			T_2_totaal[i] =  result_t2_1;
			D_2_totaal[i] =  result_d2_1;
			H_2_totaal[i] =  result_h2_1;
			U_spells_totaal[i] =  u_spells;
			E_spells_totaal[i] =  e_spells;
			double* x1 = (double*)malloc(sizeof(double) * (k1+1));
			x1[0] = 1.;
			memcpy(&x1[1], x, sizeof(double) * k1);

			free(x);
			delete normal;
			X[i] =  x1;
			W[i] = w;
			G1[i] = 0;
			G2[i] = 0;
			G3[i] = 0;
			G4[i] = 0;
			G5[i] = 0;
			
		}


		if (numprocs == 1)
		{
			SaveData save;

			save.SaveTxt("t_hulp.txt", t_hulp, N, 2);
			save.SaveTxt("t_hulp1.txt", t_hulp1, N, 2);
			save.SaveTxt("t_hulp2.txt", t_hulp2, N, 3);


			int i;
			for(i=0;i<N;i++)
			{
				free(t_hulp[i]);
				free(t_hulp1[i]);
				free(t_hulp2[i]);

			}
			free(t_hulp);
			free(t_hulp1);
			free(t_hulp2);
		}
/*
		SaveData save;


		try {
			save.SaveTxt("T_1_totaal_a.txt", T_1_totaal_a, N, k);
			save.SaveTxt_vector("U_spells_totaal.txt", U_spells_totaal, N);
			save.SaveTxt_vector("E_spells_totaal.txt", E_spells_totaal, N);
			save.SaveTxt("T_1_totaal_b.txt", T_1_totaal_b, N,k);
			save.SaveTxt("T_1_totaal_a.txt", T_1_totaal_a, N,k);
			save.SaveTxt("T_2_totaal.txt", T_2_totaal, N,k);
			save.SaveTxt("D_1_totaal_b.txt", D_1_totaal_b, N,k);
			save.SaveTxt("D_1_totaal_a.txt", D_1_totaal_a, N,k);
			save.SaveTxt("D_2_totaal.txt", D_2_totaal, N,k);
			save.SaveTxt("H_1_totaal.txt", H_1_totaal, N,k);
			save.SaveTxt("H_2_totaal.txt", H_2_totaal, N,k);
			save.SaveTxt_vector("G1.txt", G1, N);
			save.SaveTxt_vector("G2.txt", G2, N);
			save.SaveTxt_vector("G3.txt", G3, N);
			save.SaveTxt_vector("G4.txt", G4, N);
			save.SaveTxt_vector("G5.txt", G5, N);
			save.SaveTxt_vector("U_spells_totaal.txt", U_spells_totaal, N);
			save.SaveTxt_vector("E_spells_totaal.txt", E_spells_totaal, N);	
			save.SaveTxt("X_totaal.txt", X, N,5);
			save.SaveTxt_vector("W_totaal.txt", W, N);
		}
		catch (IOException &e) {
			cerr << "Could not write to " << e.filename;
			exit(-1);
		}

		exit(-1);*/
	}

	public : double** Get_X()
	{
		return X;
	}

	public : double** Get_T_1_totaal_a()
	{
		return T_1_totaal_a;
	}

	public : double** Get_T_1_totaal_b()
	{
		return T_1_totaal_b;
	}

	public : double** Get_T_2_totaal()
	{
		return T_2_totaal;
	}

	public : double** Get_D_2_totaal()
	{
		return D_2_totaal;
	}

	public : double** Get_D_1_totaal_a()
	{
		return D_1_totaal_a;
	}

	public : double** Get_D_1_totaal_b()
	{
		return D_1_totaal_b;
	}

	public : double** Get_H_1_totaal()
	{
		return H_1_totaal;
	}

	public : double** Get_H_2_totaal()
	{
		return H_2_totaal;
	}

	public : int* Get_U_spells_totaal()
	{
		return U_spells_totaal;
	}

	public : int* Get_E_spells_totaal()
	{
		return E_spells_totaal;
	}

	public : double* Get_G1()
	{
		return G1;
	}

	public : double* Get_G2()
	{
		return G2;
	}

	public : double* Get_G3()
	{
		return G3;
	}

	public : double* Get_G4()
	{
		return G4;
	}

	public : double* Get_G5()
	{
		return G5;
	}

	public : double* Get_W()
	{
		return W;
	}
	
	double Simul_T2(double u14)
	{
		return - (1 / Delta) * log(1-u14);
	}
	
	double BerekenPhi0()
	{
		Function5 f(Lambda, Delta, Rho, B, Mu_W, Sigma);

		double* avp = new double[1];
		avp[0] = 0;
		f.Set_Print(0);
		double* result = f.MaxBFGS(avp);
		double phi0_0 = result[0];
		if (abs(f.Function(result)) > 1e-7)
			throw RuntimeException("Not zero BerekenPhi0");

		delete [] result;
		delete [] avp;
		return phi0_0;
	}

	private: double* Simul_T1(double* phi, double u14, double u15, int i)
	{
		double phi0 = max(phi[0], 1E-7);
		double phi1 = max(phi[1], 1E-7);
		double phi2 = max(phi[1] + (Rho + Delta) * K, 1E-7);


		double hulp_normal = normal[0].cumulativeProbability(log(phi1));
		double hulp_normal_1 = normal[0].cumulativeProbability(log(phi0));
		double hulp_normal_2 = normal[0].cumulativeProbability(log(phi2));

		Theta_1 = Lambda * P * (1-hulp_normal);
		Theta_2 = Lambda * P * (1-hulp_normal_1);

		double t = -(1 / Theta_1) * log(u14);


		Function3 f1(u14, Theta_1, Theta_2, Tau);
		bool check = f1.Fie3b(1E+6, u14) >= 0 && f1.Fie3b(0, u14) <= 0;
		bool check1 = f1.Fie3b(1E+6, u14) <= 0 && f1.Fie3b(0, u14) >= 0;


		if (check || check1)
		{
			try {
				 t = f1.doSolve(0., 1000000);
			}
			catch (RuntimeException &e){
				throw RuntimeException("Simul T1 failed");
			}


			double* t1 = (double*)malloc(sizeof(double));
			t1[0] = t;
			f1.Set_Print(0);
			try {
				double* avp = f1.MaxBFGS(t1);
				t =  avp[0];
				free(avp);
				free(t1);
			}
			catch (RuntimeException &e) {
				throw RuntimeException("Simul_T1 failed");
			}


		}
		else
		{
			t = 1E+7;
		}


		Theta_1 = Lambda * (1-P) * (1-hulp_normal_2);
		Theta_2 = Lambda * (1-P) * (1-hulp_normal_1);
		double t_1 = -(1 / Theta_1) * log(u15);

		Function3 f2(u15, Theta_1, Theta_2, Tau);
		check = f2.Fie3b(1E+6, u15) > 0 && f2.Fie3b(1e-5, u15) < 0;
		check1 = f2.Fie3b(1E+6, u15) < 0 && f2.Fie3b(1e-5, u15) > 0;

		if (check || check1)
		{
			try {
				 t_1 = f2.doSolve(0., 1000000);
			}
			catch (RuntimeException &e){
				throw RuntimeException("BerekenPhi1 failed");
			}
			double* t1 = (double*)malloc(sizeof(double));
			t1[0] = t_1;
			f2.Set_Print(0);
			try {
				double* avp = f2.MaxBFGS(t1);
				t_1 =  avp[0];

				free(avp);
				free(t1);
			}
			catch (RuntimeException &e) {
				throw RuntimeException("BerekenPhi1 failed");
			}
		}
		else
		{
			t_1 = 1E+7;
		}

		double* result = (double*)malloc(sizeof(double)*2);
		result[0] = t;
		result[1] = t_1;

		return result;
	}

	double* Simul_T(double phi0, double u14, double u15)
	{
		double hulp_normal = normal[0].cumulativeProbability(log(phi0));
		double theta = Lambda * P * (1-hulp_normal);

//		cout << Sigma << endl;
//		cout << 1-hulp_normal << endl;

		double theta1 = Lambda * (1-P) * (1-hulp_normal);
		double result1 = - (1 / theta) * log(u14);
		double result2 = -(1 / theta1) * log(u15);
		double* result = (double*)malloc(sizeof(double) * 2);

		result[0] = result1;
		result[1] = result2;

		return result;
	}

	double dPsi_phia_1_new(double Phi_1)
	{
		double phi1 = max(Phi_1, 1E-7);
		double rho1 = Rho + Delta;
		double hulp_normal_1 = normal[0].cumulativeProbability(log(phi1));
		double hulp_normal_2 = normal[0].cumulativeProbability(log(phi1) + (Rho + Delta) * K);

		double avscore22 = 1 +  (Lambda * P / rho1) * (1-hulp_normal_1) + (Lambda * (1-P) / rho1) * (1-hulp_normal_2);

		return avscore22;
	}

	private : double** inverse(double** x)
	{
		double** result = (double**)malloc(sizeof(double*)*2);
		result[0] = (double*)malloc(sizeof(double)*2);
		result[1] = (double*)malloc(sizeof(double)*2);
		double det = x[0][0] * x[1][1] - x[1][0] * x[0][1];
		result[0][0] = x[1][1] / det;
		result[1][0] = -x[1][0] / det;
		result[0][1] = -x[0][1] / det;
		result[1][1] = x[0][0] / det;
		return result;
	}

	private: double** dPsi_phia_1_new(double Phi_0, double Phi_1)
	{
		double** result = (double**)malloc(sizeof(double*)*2);
		result[0] = (double*)malloc(sizeof(double)*2);
		result[1] = (double*)malloc(sizeof(double)*2);

		double phi0 = max(Phi_0, 1E-7);
		double phi1 = max(Phi_1, 1E-7);
		double rho1 = Rho + Delta + Tau;
		double hulp_normal = normal[0].cumulativeProbability(log(phi0));
		double hulp_normal_1 = normal[0].cumulativeProbability(log(phi1));
		double hulp_normal_2 = normal[0].cumulativeProbability(log(phi1) + (Rho + Delta) * K);

		result[0][0] = 1 + (Lambda / Rho) * (1 - hulp_normal);
		result[0][1] = Delta / Rho;
		result[1][0] = -Tau / rho1;
		result[1][1] = 1 +  (Lambda * P / rho1) * (1-hulp_normal_1) + (Lambda * (1-P) / rho1) * (1-hulp_normal_2);

		return result;
	}
	
	private : double* times(double** x, double* y)
	{
		double* result = (double*)malloc(sizeof(double)*2);
		result[0] = x[0][0] * y[0] + x[0][1] * y[1];
		result[1] = x[1][0] * y[0] + x[1][1] * y[1];
		return result;
	}

	private : double* times(double* x, double y)
	{
		double* result = (double*)malloc(sizeof(double)*2);
		result[0] = x[0] * y;
		result[1] = x[1] * y;
		return result;
	}
	private : void minus_to(double* x, double* y)
	{
		x[0] = x[0] - y[0];
		x[1] = x[1] - y[1];
	}

	private : double* minus(double* x, double* y)
	{
		double* result = (double*)malloc(sizeof(double)*2);
		result[0] = x[0] - y[0];
		result[1] = x[1] - y[1];
		return result;
	}

	private : double* Psi_phia_1_new(double Phi_0, double Phi_1)
	{
		double phi0 = max(Phi_0, 1E-7);
		double phi1 = max(Phi_1, 1E-7);
		double Eta = U;
		double sigma2 = Sigma * Sigma;
		double rho1 = Rho + Delta + Tau;
		double hulp_normal = normal[0].cumulativeProbability(log(phi0));
		double hulp_normal_a = normal[0].cumulativeProbability(log(phi0) - sigma2);
		double hulp_normal_1 = normal[0].cumulativeProbability(log(phi1));
		double hulp_normal_1_a = normal[0].cumulativeProbability(log(phi1) - sigma2);
		double hulp_normal_2 = normal[0].cumulativeProbability(log(phi1 + (Rho + Delta) * K));
		double hulp_normal_2_a = normal[0].cumulativeProbability(log(phi1 + (Rho + Delta) * K) - sigma2);

		double expression1 = exp(Mu_W + Sigma * Sigma / 2);

		double aresult;

		if (hulp_normal_a == 1)
			aresult = 0;
		else
		{
			double hulp2b =  expression1 * (1-hulp_normal_a);
			aresult = hulp2b - (1 - hulp_normal) * Phi_0;
		}

		double aresult1;

		if (hulp_normal_1_a == 1)
			aresult1 = 0;
		else
		{
			double hulp2a_1 = expression1 * (1-hulp_normal_1_a);
			aresult1 = hulp2a_1  - (1-hulp_normal_1) * Phi_1;
		}

		double aresult2;
		if (hulp_normal_2 == 1)
			aresult2 = 0;
		else
		{
			double hulp2a_2 = expression1 * (1-hulp_normal_2_a);
			aresult2 = hulp2a_2  - (1-hulp_normal_2) * (Phi_1 + (Rho + Delta) * K);
		}

		double adfunc1 = Phi_0 - (B - Eta) * ((Rho+Delta)/Rho) + (Delta / Rho) * Phi_1 - (Lambda / Rho) * aresult - K * (Rho+Delta);
		double adfunc2 = Phi_1 - Tau * Phi_0 / rho1 - (B-Tau * K) * (Rho + Delta) / rho1 - (Lambda * P / rho1) * aresult1
					- (Lambda * (1-P) / rho1) * aresult2;
		double* result = (double*)malloc(sizeof(double) * 2);

		
		result[0] = adfunc1 ;
		result[1] =  adfunc2 ;
		return result;
	}


	private : double Bereken_adfunc2(double phi0, double phi1)
	{
		double* adfunc = Psi_phia_1_new(phi0, phi1);
		return adfunc[0] * adfunc[0] + adfunc[1] * adfunc[1];
	}


	private: double*  BerekenPhi1()
	{
		double* adfunc;
		double* phi0_0 = (double*)malloc(sizeof(double)*2);

		phi0_0[0] = 1000;
		phi0_0[1] = 1000;
		
		Function1a f(Mu_W, Sigma, Rho, Delta, K, Lambda, P, B, Tau, U);

		double* result;
		try {
			f.Set_Print(0);
			result = f.MaxBFGS(phi0_0);
		}
		catch (RuntimeException &e) {
			throw RuntimeException(e.ExceptionText);
		}
		
		if (f.Function(result) > 1E-7)
		{
			throw RuntimeException("Not zero");
		}
		
		free(phi0_0);
		
		return result;/*
		
		adfunc = Psi_phia_1_new(phi0_0[0], phi0_0[1]);
		
		double adfunc2 = adfunc[0] * adfunc[0] + adfunc[1] * adfunc[1];
		

		int i=0;
		int max_iter = 1000;
		while ((adfunc2 > 1E-15) && (i < max_iter))
		{
			i++;
			double** hulp = dPsi_phia_1_new(phi0_0[0], phi0_0[1]);
			double** hulp1 = inverse(hulp);
			double* hulp2 = times(hulp1, adfunc);

			double* phi0_prev = (double*)malloc(sizeof(double)*2);
			memcpy(phi0_prev, phi0_0, 2 * sizeof(double));
			minus_to(phi0_0, hulp2);
			free(adfunc);
			adfunc =  Psi_phia_1_new(phi0_0[0], phi0_0[1]);
			double adfunc2_prev = adfunc2;

			adfunc2 = adfunc[0] * adfunc[0] + adfunc[1] * adfunc[1];
			if (adfunc2_prev < adfunc2)
			{
				double lambda = 1.;
				while ((lambda > 1E-15) && (adfunc2_prev < adfunc2))
				{
					lambda /= 2;
					double* hulp3 = times(hulp2, lambda);
					free(phi0_0);
					phi0_0 = minus(phi0_prev, hulp3);
					free(adfunc);
					adfunc = Psi_phia_1_new(phi0_0[0], phi0_0[1]);
					adfunc2 = adfunc[0] * adfunc[0] + adfunc[1] * adfunc[1];
					free(hulp3);
				}

				if (lambda < 1E-15)
				{
					
					lambda = 1;
					adfunc2 = adfunc2_prev+1;
					
					while ((lambda > 1E-15) && (adfunc2_prev < adfunc2))
					{
						lambda /= 2;
						double* hulp3 = times(hulp2, -lambda);
						free(phi0_0);
						phi0_0 = minus(phi0_prev, hulp3);
						free(adfunc);
						adfunc = Psi_phia_1_new(phi0_0[0], phi0_0[1]);
						adfunc2 = adfunc[0] * adfunc[0] + adfunc[1] * adfunc[1];
						free(hulp3);
					}
				}
				
				if (lambda < 1E-15)
				{
					throw RuntimeException("Unable to calculate reservation wage");
				}
			}
			free(hulp[0]);
			free(hulp[1]);
			free(hulp1[0]);
			free(hulp1[1]);
			free(hulp);
			free(hulp1);
			free(hulp2);
			free(phi0_prev);
		}
		
		//cout << i << endl;
		//cout << phi0_0[0] << endl;
		//exit(-1);
		//cout << "adfunc2" << adfunc2 << endl;

		if ((i==max_iter) && (adfunc2> 1E-6))
		{
			throw RuntimeException("Unable to calculate reservation wage");
		}
		free(adfunc);
		return phi0_0;*/
	}


	double Psi_phi_new(double phi)
	{

		double hulp1 = log(phi);
		double hulp2 = hulp1 - Sigma * Sigma;
		double hulp_1 = exp(Mu_W + 0.5 * Sigma * Sigma) * ((1-normal[0].cumulativeProbability(hulp2)) / (1-normal[0].cumulativeProbability(hulp1)));
		double aresult1 = (1-normal[0].cumulativeProbability(hulp1)) * (hulp_1 - phi);

		return phi - B - (Lambda / (Rho + Delta)) * aresult1;
	}

	double dPsi_phi_new(double phi)
	{
		double hulp1 = log(phi);
		double aresult1 = 1-normal[0].cumulativeProbability(hulp1);

		return 1 + (Lambda / (Rho + Delta)) * aresult1;
	}

	int max(int x, int y)
	{
		return x > y ? x : y;
	}

	double max(double x, double y)
	{
		return x > y ? x : y;
	}

	double min(double x, double y)
	{
		return x < y ? x : y;
	}
/*
	double* smaller_than(double* x, double y)
	{
		double* result = new double*();

		int i;
		for(i=0;i<x.size();i++)
		{
			double hulp = x[i] < y ? 1.: 0.;
			result.add(hulp);
		}
		return result;
	}

	double* rann(int n)
	{
		int i;
		double* result = new double*();
		for(i=0;i<n;i++)
		{
			result.add(generator.nextGaussian());
		}
		return result;
	}

	double* ranu(int n)
	{
		int i;
		double* result = new double*();
		for(i=0;i<n;i++)
		{
			result.add(generator.nextDouble());
		}
		return result;
	}
*/
};

#endif






