/*
 * probit.cpp
 *
 *  Created on: Jun 5, 2013
 *      Author: Aico van Vuuren
 */

#ifndef LOGIT_INCLUDED
#define LOGIT_INCLUDED

using namespace std;
#include <iostream>
#include "maximize1.cpp"
#include "NormalDistribution.cpp"
#include <mpi.h>
#include <stdlib.h>

class Logit : public Maximize1 {
	double* Y;
	double ** X;
	double* Beta;
	double* W;
	int n, k;
	private : NormalDistribution* normal;
	

	int myid, numprocs, increment;
	MPI_Status status;
	int Min, Max;

	public : Logit(double* Y, double** X, double* W, int n, int k, int myid, int numprocs, MPI_Status status)
	{
		this->Y = Y;
		this->X = X;
		this->W = W;
		this->n = n;
		this->k = k;
		this->status = status;
		this->numprocs = numprocs;
		this->myid = myid;
		
		cp = k;
		
		Beta = new double[k];
		int increment = n/numprocs;
		Min = myid * increment;
		Max = myid < numprocs-1? (myid+1) * increment-1 : n-1;
		
		normal = new NormalDistribution(0.,1.);
	}

	~Logit()
	{
		free(Beta);
		delete normal;
	}
	

	public: virtual double* dFunction(double* vP) throw(RuntimeException)
	{
		double* total;
		double* avscore0 = dFunctionThread(vP);
		total = avscore0;

		int i;
		int tag = 8;

			if (myid == 0)
			{
			 	for(i=1;i<numprocs;i++)
			   	{
			 		double* avscore1 = (double*)malloc(sizeof(double) * cp);

					int rc = MPI_Recv(avscore1, cp, MPI_DOUBLE, i, tag, MPI_COMM_WORLD,
				 								&status);
			   		add_to(total, avscore1);
			   		free(avscore1);
			   	}

			   	for(i=1;i<numprocs;i++)
			   	{

			   		MPI_Send(total, cp, MPI_DOUBLE, i, tag, MPI_COMM_WORLD);
			    }
			 }
			 else
			 {
				 MPI_Send(avscore0, cp, MPI_DOUBLE, 0, tag, MPI_COMM_WORLD);

				 double* hulp1 = (double*)malloc(sizeof(double) * cp);

				 int rc = MPI_Recv(hulp1, cp, MPI_DOUBLE, 0, tag, MPI_COMM_WORLD,
					 		 								&status);

				 free(total);
				 total = hulp1;

			}

			return total;
	}

	public: virtual double Function(double* vP) throw(RuntimeException)
	{
		double adfunc = FunctionThread(vP);
		double total = 0;

		int tag = 7;
		if (myid == 0)
		{
			total = adfunc;
			int i;
			for(i=1;i<numprocs;i++)
			{
				double adfunc1;

			 	int rc = MPI_Recv(&adfunc1, 1, MPI_DOUBLE, i, tag, MPI_COMM_WORLD,
			 								&status);
			   	total += adfunc1;
			}

		    for(i=1;i<numprocs;i++)
		    {
		    	double hulp = total;
		    	MPI_Send(&hulp, 1, MPI_DOUBLE, i, tag, MPI_COMM_WORLD);
		    }
		}
		else
		{
			MPI_Send(&adfunc, 1, MPI_DOUBLE, 0, tag, MPI_COMM_WORLD);

			double hulp1;
			int rc = MPI_Recv(&hulp1, 1, MPI_DOUBLE, 0, tag, MPI_COMM_WORLD,
				 		 								&status);
			total = hulp1;
		}

		

		return total;
	}
	

	public: double FunctionThread(double* variable_list) throw(RuntimeException) {
		
		Initialize(variable_list);
				
	  	double result = 0;
		int i;
	
	  	for(i=Min;i<=Max;i++)
		{
	  		double hulp = internal_product(X[i], Beta);
	  		//double hulp1 = normal->cumulativeProbability(hulp);
	  		double hulp1 = exp(hulp) / (1 + exp(hulp));
	  		result += W[i] * (Y[i] * log(hulp1) + (1 - Y[i]) * log(1-hulp1));
	  	}

	    return result / n;
	}
	
	public: double* dFunctionThread(double* variable_list) throw(RuntimeException) {
		
		Initialize(variable_list);
				
	  	double* result1 = zeros(cp);
		int i;
	
	  	for(i=Min;i<=Max;i++)
		{
	  		double hulp = internal_product(X[i], Beta);
	  		double hulp1 = exp(hulp) / (1 + exp(hulp));
	  		double hulp2 = hulp1 * (1 - hulp1);
	  		double result = hulp2 * ((double)Y[i] / hulp1) - ((double)(1 - Y[i]) / (1-hulp1)) * hulp2;
	  		int j;
	  		for(j=0;j<cp;j++)
	  		{
	  			result1[j] += W[i] * (result * X[i][j]) / n;
	  		}
	  	}

	    return result1;
	}
	
	private : void Initialize(double* variable_list)
	{
		memcpy(Beta, variable_list, sizeof(double) * k);
	}
};
#endif






