/*
 * loadmat.cpp


 *
 *  Created on: Jun 3, 2013
 *      Author: Aico van Vuuren
 */

#ifndef LOADMAT_INCLUDED
#define LOADMAT_INCLUDED

#include <iostream>
#include <string>
#include <fstream>
#include <stdlib.h>

using namespace std;

class IOException {
	public : string filename;
	IOException(string filename){
		this->filename = filename;
	}
};

class LoadData {

	public: int m, n;

	public: LoadData()
	{
		m = 0;
		n = 0;
	}

	public: double** LoadTxt(string vp_string)
	{
		char infile[100];


		int hulp = vp_string.copy(infile, vp_string.length(), 0);
		infile[hulp] = '\0';

		ifstream inf(infile);


		if (!inf)     {
			// Print an error and exit
			throw IOException(infile);
			return NULL;
		}


		// While there's still stuff left to read
		int i;

		inf >> m;
		inf >> n;

		double** result = (double**)malloc(sizeof(double*) * m);;
		for(i=0;i<m;i++)
		{
			double* result1 = (double*)malloc(sizeof(double) * n);
			int j;
			for(j=0;j<n;j++)
			{
				double x1;
				inf >> x1;
				result1[j] = x1;
			}
			result[i] = result1;
		}


		return result;
	}


	public: double** LoadTxt(string vp_string, int m1)
	{
		char infile[100];


		int hulp = vp_string.copy(infile, vp_string.length(), 0);
		infile[hulp] = '\0';

		ifstream inf(infile);


		if (!inf)     {
			// Print an error and exit
			throw IOException(infile);
			return NULL;
		}


		// While there's still stuff left to read
		int i;

		inf >> m;
		inf >> n;
		
		if (m < m1)
		{
			cout << m1 << endl;
			cout << vp_string << endl;
			throw IOException("Number of observations in file too low.\t:");
		}
		double** result = (double**)malloc(sizeof(double*) * m);;
		for(i=0;i<m1;i++)
		{
			double* result1 = (double*)malloc(sizeof(double) * n);
			int j;
			for(j=0;j<n;j++)
			{
				double x1;
				inf >> x1;
				result1[j] = x1;
			}
			result[i] = result1;
		}


		return result;
	}
	
	double* LoadTxt_vector(string vp_string)
	{
		char infile[100];
		int hulp = vp_string.copy(infile, vp_string.length(), 0);
		infile[hulp] = '\0';

		ifstream inf(infile);


		if (!inf)     {
			// Print an error and exit
			throw IOException(infile);
			return NULL;
		}

		// While there's still stuff left to read
		int i;

		inf >> m;
		inf >> n;

		double* result = (double*)malloc(sizeof(double) * m);
		for(i=0;i<m;i++)
		{
			double x1;
			inf >> x1;
			result[i] = x1;
		}

		return result;
	}

	double* LoadTxt_vector(string vp_string, int m1)
	{
		char infile[100];


		int hulp = vp_string.copy(infile, vp_string.length(), 0);
		infile[hulp] = '\0';

		ifstream inf(infile);


		if (!inf)     {
			// Print an error and exit
			throw IOException(infile);
			return NULL;
		}

		// While there's still stuff left to read
		int i;

		inf >> m;
		inf >> n;
		
		if (m < m1)
		{
			cout << m1 << endl;
			throw IOException("Too little observations in file.");
		}

		double* result = (double*)malloc(sizeof(double) * m);
		for(i=0;i<m1;i++)
		{
			double x1;
			inf >> x1;
			result[i] = x1;
		}

		return result;
	}

	int* LoadTxt_vector_int(string vp_string)
	{
		char infile[100];


		int hulp = vp_string.copy(infile, vp_string.length(), 0);
		infile[hulp] = '\0';

		ifstream inf(infile);


		if (!inf)     {
			// Print an error and exit
			throw IOException(infile);
			return NULL;
		}

		// While there's still stuff left to read
		int i;

		inf >> m;
		inf >> n;

		int* result = (int*)malloc(sizeof(int) * m);
		for(i=0;i<m;i++)
		{
			int x1;
			inf >> x1;
			result[i] = x1;
		}

		return result;
	}
	
	public: int* LoadTxt_vector_int(string vp_string, int m1)
	{
		char infile[100];


		int hulp = vp_string.copy(infile, vp_string.length(), 0);
		infile[hulp] = '\0';

		ifstream inf(infile);


		if (!inf)     {
			// Print an error and exit
			throw IOException(infile);
			return NULL;
		}

		// While there's still stuff left to read
		int i;

		inf >> m;
		inf >> n;

		int* result = (int*)malloc(sizeof(int) * m);
		for(i=0;i<m;i++)
		{
			int x1;
			inf >> x1;
			result[i] = x1;
		}

		return result;
	}
};

#endif



