/*
 * hazards_function.cpp
 *
 *  Created on: May 28, 2013
 *      Author: Aico van Vuuren
 */

#ifndef HAZARDSFUNCTION_INCLUDED
#define HAZARDSFUNCTION_INCLUDED


#include "maximize1.cpp"
#include "maxsan.cpp"
#include "NormalDistribution.cpp"
#include <mpi.h>
#include <stdlib.h>
#include <string.h>

using namespace std;

class HazardsFunction : public Maximize1 {

	static const int c_all_n = 5;
	public: static const int x_size = 12;
	public: static const int x_size_1 = 12;
	public: static const int x_size_2 = 11;
	double** T_1_totaal_a;	 // unemployment spells	 that end in local labor market per spell
	double** T_1_totaal_b;	 // unemployment spells that end in non-local labor market per spell
	double** D_1_totaal_a;	 // dummy for local labor market per spell
	double** D_1_totaal_b;	// dummy for non-local labor market	per spell
	double** D_2_totaal;	// dummy for right censoring per spell
	double** T_2_totaal;	  // employment spells	per spell
	double** H2_totaal;		// dummy for homeownership of the unemployed per spell
	double** H4_totaal;		// dummy for homeownership of the employed per spell
	double** X;			// x variables
	double**  H1_hulp;
	double**  H2_hulp;
	double** a13;
	double**  a14;
	vector<double> t_all;
	vector<double> t_all2;
	vector<double> t_all3;
	vector<double> t_all4;
	double* vP_Theta;
	private : double tend;
	private : double tmid;
	private : double tmid1;
	private : double tmid2;
	private : double tmid3;
	private : double tbeg;
	double* beta1_a;
	double* beta2_a;
	double* beta3_a;
	private : double* Loglik1;
	private : double* Loglik2;
	private : double* Loglik3;
	private : double* Loglik4;
	private : double* Loglik5;
	private : double* Loglik6;
	private : double* Loglik7;
	private : double* Loglik8;
	private : double* Loglik9;
	private : double* Loglik10;
	private : double* Loglik11;
	private : double* Loglik12;
	private : double* Loglik13;
	private : double* Loglik14;
	private : double* Loglik15;
	private : double* Loglik16;
	private : double** theta_1_1a;
	private : double**  theta_1_2a;
	private : double** theta_1_3a;
	private :  double** theta_1_1b;
	private : double** theta_1_2b;
	private : double** theta_1_3b;
	private : double V00,V01, V10, V11, V20, V21, V30, V31;
	private : double P0000, P1000, P0100, P0010, P1100, P1010, P0110, P1110;
	private : double P0001, P1001, P0101, P0011, P1101, P1011, P0111, P1111;
	private : double Gamma1,Gamma2,Gamma3;	// coefficient of homeowneship - local / nonlocal labor market and employment
	private : double* Beta0;   // coefficients for homeownership
	private : double* Beta1;   // coefficients for local labor market
	private : double* Beta2;	// coefficients for non-local labor market
	private : double* Beta3;  // coefficients for employment
	private : double* Psi1a;   // baseline hazard for local labor market - homeowners
	private : double* Psi2a;  //  baseline hazard for non-local labor market -homeowners
	private : double* Psi3a;   // baseline hazard for employment - homeowners
	private : double* Psi1b;  // baseline hazard for local labor market - renters
	private : double*  Psi2b;  // baseline hazard for non-local labor market - renters
	private : double* Psi3b;   // baseline hazard for employment - renters
	private : double p0min, p1min, p2min, p3min;
	private : double factor1, factor2, factor3, factor4;
	//private : double a1[16], a2[16], a3[16], a4[16], a5[16];
	double a1a[4][4], a2a[4][4], a3a[4][4], a4a[4][4], a5a[4][4];
	int n, k;
	double p_0, p_1, p_2, p_3;
	int myid, numprocs, increment;
	MPI_Status status;
	int Min, Max;
	bool* variables;
	private: int* U_spells_totaal;
	private : int* E_spells_totaal;
	double* lambda1_array;
	double* lambda2_array;
	double* lambda3_array;
	double* theta1_array;
	double* theta2_array;
	double* theta3_array;
	double** hulp1_array;
	double** hulp2_array;
	double** hulp3_array;
	double** hulp4_array;
	double** hulp5_array;
	double** hulp6_array;
	double* psi1_array;
	double* psi2_array;
	double* psi3_array;
	double* psi1a_array;
	double* psi2a_array;
	double* psi3a_array;
	int cp1;
	double* G2;
	double* G3;
	double* G4;


	public : HazardsFunction( double** T_1_totaal_a,  double** T_1_totaal_b,  double** D_1_totaal_a,
						double** D_1_totaal_b,
				 double** D_2_totaal,  double** T_2_totaal,  double** H2_totaal,
				 double** H4_totaal,
				 double** X, double* vP_Theta, int n, int k, int cp1, bool* variables,
				 int myid, int numprocs, MPI_Status status,
				 int* U_spells_totaal,
				 				 int* E_spells_totaal, double* G2, double* G3, double* G4, int Min, int Max, double Lambda_H)
		{
		
			this->vP_Theta = vP_Theta;
			this->T_1_totaal_a = T_1_totaal_a;
			this->T_1_totaal_b = T_1_totaal_b;
			this->D_1_totaal_a = D_1_totaal_a;
			this->D_1_totaal_b = D_1_totaal_b;
			this->D_2_totaal = D_2_totaal;
			this->T_2_totaal = T_2_totaal;
			this->H2_totaal = H2_totaal;
			this->cp1 = cp1;
			this->variables = variables;
			

			cp = 0;
			int i;
		
			
			for(i=0;i<cp1;i++)
			{
				if (variables[i])
					cp++;
			}
			
			
			this->H4_totaal = H4_totaal;
			this->X = X;
			this->n = n;
			this->k = k;
			this->Min = Min;
			this->Max = Max;
			this->U_spells_totaal = U_spells_totaal;
			this->E_spells_totaal = E_spells_totaal;
			this->G2 = G2;
			this->G3 = G3;
			this->G4 = G4;
			tend = 16.5;
			tmid = 4.5;
			tmid1 = 7.5;
			tmid2 = 10.5;
			tmid3 = 13.5;
			tbeg = 1.5;
			Loglik1 = Loglik2 = Loglik3 = Loglik4 = Loglik5 = Loglik6 = Loglik7 = Loglik8 = NULL;

			
	
			a1a[0][0] = 0.0;
			a1a[0][1] = -3.375;
			a1a[0][2] = 1.0;
			a1a[0][3] = -1.125;
			a1a[1][0] = 1.5;
			a1a[1][1] = 3.75;
			a1a[1][2] = -1.5;
			a1a[1][3] = 1.75;
			a1a[2][0] = -0.6666666666666666;
			a1a[2][1] = -1.1666666666666667;
			a1a[2][2] = 0.6666666666666666;
			a1a[2][3] = -0.8333333333333334;
			a1a[3][0] = 0.07407407407407407;
			a1a[3][1] = 0.1111111111111111;
			a1a[3][2] = -0.07407407407407407;
			a1a[3][3] = 0.1111111111111111;


			a2a[0][0] = -12.5;
			a2a[0][1] = -28.125;
			a2a[0][2] = 13.5;
			a2a[0][3] = -16.875;
			a2a[1][0] = 7.5;
			a2a[1][1] = 13.75;
			a2a[1][2] = -7.5;
			a2a[1][3] =  9.75;
			a2a[2][0] = -1.3333333333333333;
			a2a[2][1] = -2.1666666666666665;
			a2a[2][2] = 1.3333333333333333;
			a2a[2][3] = -1.8333333333333333;
			a2a[3][0] = 0.07407407407407407;
			a2a[3][1] = 0.1111111111111111;
			a2a[3][2] = -0.07407407407407407;
			a2a[3][3] = 0.1111111111111111;


			a3a[0][0] = -48.999999999999986;
			a3a[0][1] = -91.875;
			a3a[0][2] = 49.999999999999986;
			a3a[0][3] = -65.625;
			a3a[1][0] = 17.499999999999996;
			a3a[1][1] = 29.75;
			a3a[1][2] = -17.499999999999996;
			a3a[1][3] = 23.75;
			a3a[2][0] = -1.9999999999999998;
			a3a[2][1] =-3.1666666666666665;
			a3a[2][2] = 1.9999999999999998;
			a3a[2][3] = -2.8333333333333335;
			a3a[3][0] = 0.07407407407407407;
			a3a[3][1] = 0.1111111111111111;
			a3a[3][2] = -0.07407407407407407;
			a3a[3][3] = 0.1111111111111111;

			a4a[0][0] = -121.5;
			a4a[0][1] = -212.62499999999994;
			a4a[0][2] =  122.5;
			a4a[0][3] =  -165.375;
			a4a[1][0] = 31.5;
			a4a[1][1] = 51.75;
			a4a[1][2] = -31.5;
			a4a[1][3] = 43.75;
			a4a[2][0] = -2.6666666666666665;
			a4a[2][1] = -4.166666666666667;
			a4a[2][2] = 2.6666666666666665;
			a4a[2][3] = -3.8333333333333335;
			a4a[3][0] = 0.07407407407407407;
			a4a[3][1] = 0.1111111111111111;
			a4a[3][2] = -0.07407407407407407;
			a4a[3][3] = 0.1111111111111111;

			a5a[0][0] = -242.0;
			a5a[0][1] = -408.375;
			a5a[0][2] = 243.0;
			a5a[0][3] = -334.125;
			a5a[1][0] = 49.5;
			a5a[1][1] = 79.75;
			a5a[1][2] = -49.5;
			a5a[1][3] = 69.75;
			a5a[2][0] = -3.3333333333333335;
			a5a[2][1] = -5.166666666666667;
			a5a[2][2] = 3.3333333333333335;
			a5a[2][3] = -4.833333333333333;
			a5a[3][0] = 0.07407407407407407;
			a5a[3][1] = 0.1111111111111111;
			a5a[3][2] = -0.07407407407407407;
			a5a[3][3] = 0.1111111111111111;

			t_all.push_back(tbeg);
			t_all.push_back(tmid);
			t_all.push_back(tmid1);
			t_all.push_back(tmid2);
			t_all.push_back(tmid3);
			t_all.push_back(tend);

			t_all2.push_back(tbeg * tbeg);
			t_all2.push_back(tmid * tmid);
			t_all2.push_back(tmid1 * tmid1);
			t_all2.push_back(tmid2 * tmid2);
			t_all2.push_back(tmid3 * tmid3);
			t_all2.push_back(tend * tend);

			t_all3.push_back(tbeg * tbeg * tbeg);
			t_all3.push_back(tmid * tmid * tmid);
			t_all3.push_back(tmid1 * tmid1 * tmid1);
			t_all3.push_back(tmid2 * tmid2 * tmid2);
			t_all3.push_back(tmid3 * tmid3 * tmid3);
			t_all3.push_back(tend * tend * tend);

			t_all4.push_back(tbeg * tbeg * tbeg * tbeg);
			t_all4.push_back(tmid * tmid * tmid * tmid);
			t_all4.push_back(tmid1 * tmid1 * tmid1 * tmid1);
			t_all4.push_back(tmid2 * tmid2 * tmid2 * tmid2);
			t_all4.push_back(tmid3 * tmid3 * tmid3 * tmid3);
			t_all4.push_back(tend * tend * tend * tend);


			
			H1_hulp = (double**)malloc(sizeof(double*) * n);
			H2_hulp = (double**)malloc(sizeof(double*) * n);
			for(i=Min;i<=Max;i++)
			{
				int j;

				double* h1_hulp  = (double*)malloc(sizeof(double) * k);
				double* h2_hulp  = (double*)malloc(sizeof(double) * k);

				for(j=0;j<k;j++)
				{
					if (H2_totaal[i][j] < 700)
						h1_hulp[j] = (exp(H2_totaal[i][j] / Lambda_H) / (1 + exp(H2_totaal[i][j] / Lambda_H)));
					else
						h1_hulp[j] =1;
					if (H4_totaal[i][j] < 700)
						h2_hulp[j] = (exp(H4_totaal[i][j] / Lambda_H) / (1 + exp(H4_totaal[i][j] / Lambda_H)));
					else
						h2_hulp[j] = 1;
				}

				H1_hulp[i] = h1_hulp;
				H2_hulp[i] = h2_hulp;
			}

			int x_size1 = x_size+1;

			Beta1  = (double*)malloc(sizeof(double) * x_size);
			Beta2  = (double*)malloc(sizeof(double) * x_size);
			Beta3  = (double*)malloc(sizeof(double) * x_size);
			Beta0  = (double*)malloc(sizeof(double) * x_size);
			beta1_a  = (double*)malloc(sizeof(double) * x_size1);
			beta2_a  = (double*)malloc(sizeof(double) * x_size1);
			beta3_a  = (double*)malloc(sizeof(double) * x_size1);

			Psi1a  = (double*)malloc(sizeof(double) * c_all_n);
			Psi2a  = (double*)malloc(sizeof(double) * c_all_n);
			Psi3a  = (double*)malloc(sizeof(double) * c_all_n);
			Psi1b  = (double*)malloc(sizeof(double) * c_all_n);
			Psi2b  = (double*)malloc(sizeof(double) * c_all_n);
			Psi3b  = (double*)malloc(sizeof(double) * c_all_n);

			double* a13_hulp = (double*)malloc(sizeof(double)* 4);

			a13_hulp[0] =a1a[0][2];
			a13_hulp[1] =a1a[1][2];
			a13_hulp[2] =a1a[2][2];
			a13_hulp[3] =a1a[3][2];

			double* a13_hulp1 = (double*)malloc(sizeof(double)* 4);

			a13_hulp1[0] =a2a[0][2];
			a13_hulp1[1] =a2a[1][2];
			a13_hulp1[2] =a2a[2][2];
			a13_hulp1[3] =a2a[3][2];

			double* a13_hulp2 = (double*)malloc(sizeof(double)* 4);

			a13_hulp2[0] =a3a[0][2];
			a13_hulp2[1] =a3a[1][2];
			a13_hulp2[2] =a3a[2][2];
			a13_hulp2[3] =a3a[3][2];

			double* a13_hulp3 = (double*)malloc(sizeof(double)* 4);

			a13_hulp3[0] =a4a[0][2];
			a13_hulp3[1] =a4a[1][2];
			a13_hulp3[2] =a4a[2][2];
			a13_hulp3[3] =a4a[3][2];
			double* a13_hulp4 = (double*)malloc(sizeof(double)* 4);

			a13_hulp4[0] =a5a[0][2];
			a13_hulp4[1] =a5a[1][2];
			a13_hulp4[2] =a5a[2][2];
			a13_hulp4[3] =a5a[3][2];

			a13 = (double**)malloc(sizeof(double*)* 5);

			a13[0] =a13_hulp;
			a13[1] =a13_hulp1;
			a13[2] =a13_hulp2;
			a13[3] =a13_hulp3;
			a13[4] =a13_hulp4;

			double* a14_hulp = (double*)malloc(sizeof(double)* 4);

			a14_hulp[0] =a2a[0][0];
			a14_hulp[1] =a2a[1][0];
			a14_hulp[2] =a2a[2][0];
			a14_hulp[3] =a2a[3][0];

			double* a14_hulp1 = (double*)malloc(sizeof(double)* 4);

			a14_hulp1[0] =a3a[0][0];
			a14_hulp1[1] =a3a[1][0];
			a14_hulp1[2] =a3a[2][0];
			a14_hulp1[3] =a3a[3][0];

			double* a14_hulp2 = (double*)malloc(sizeof(double)* 4);

			a14_hulp2[0] =a4a[0][0];
			a14_hulp2[1] =a4a[1][0];
			a14_hulp2[2] =a4a[2][0];
			a14_hulp2[3] =a4a[3][0];

			double* a14_hulp3 = (double*)malloc(sizeof(double)* 4);

			a14_hulp3[0] =a5a[0][0];
			a14_hulp3[1] =a5a[1][0];
			a14_hulp3[2] =a5a[2][0];
			a14_hulp3[3] =a5a[3][0];

			a14 = (double**)malloc(sizeof(double*)* 4);
			a14[0] =a14_hulp;
			a14[1] =a14_hulp1;
			a14[2] =a14_hulp2;
			a14[3] =a14_hulp3;
			this->myid = myid;
			this->numprocs = numprocs;
		    increment = n/numprocs;
		    this->status = status;
		    this->Min = Min;
		    this->Max = Max;
			lambda1_array = (double*)malloc(sizeof(double) * k);
			lambda2_array = (double*)malloc(sizeof(double) * k);
			lambda3_array = (double*)malloc(sizeof(double) * k);
			theta1_array = (double*)malloc(sizeof(double) * k);
			theta2_array = (double*)malloc(sizeof(double) * k);
			theta3_array = (double*)malloc(sizeof(double) * k);
			hulp1_array = (double**)malloc(sizeof(double*) * k);
			hulp2_array = (double**)malloc(sizeof(double*) * k);
			hulp3_array = (double**)malloc(sizeof(double*) * k);
			hulp4_array = (double**)malloc(sizeof(double*) * k);
			hulp5_array = (double**)malloc(sizeof(double*) * k);
			hulp6_array = (double**)malloc(sizeof(double*) * k);
			for(i=0;i<k;i++)
			{
				double* hulp1 = zeros(20);
				double* hulp2 = zeros(20);
				double* hulp3 = zeros(20);
				double* hulp4 = zeros(20);
				double* hulp5 = zeros(20);
				double* hulp6 = zeros(20);

				hulp1_array[i] = hulp1;
				hulp2_array[i] = hulp2;
				hulp3_array[i] = hulp3;
				hulp4_array[i] = hulp4;
				hulp5_array[i] = hulp5;
				hulp6_array[i] = hulp6;
			}
	}
	
	~HazardsFunction()
	{
		

		free(Beta1);
		free(Beta2);
		free(Beta3);
		free(Psi1a);
		free(Psi2a);
		free(Psi3a);
		free(Psi1b);
		free(Psi2b);
		free(Psi3b);
		free(beta1_a);
		free(beta2_a);
		free(beta3_a);
		if (!(Loglik1 == NULL))
		{
			free(Loglik1);
			free(Loglik2);
			free(Loglik3);
			free(Loglik4);
			free(Loglik5);
			free(Loglik6);
			free(Loglik7);
			free(Loglik8);
			free(Loglik9);
			free(Loglik10);
			free(Loglik11);
			free(Loglik12);
			free(Loglik13);
			free(Loglik14);
			free(Loglik15);
			free(Loglik16);
		}
		int i;	 

    	free(lambda1_array);
    	free(lambda2_array);
    	free(lambda3_array);
    	free(theta1_array);
    	free(theta2_array);
    	free(theta3_array);
    	
    	for(i=Min;i<=Max;i++)
    	{
    		free(H2_hulp[i]);
    		free(H1_hulp[i]);
    	}
    	free(H2_hulp);
    	free(H1_hulp);

    	for(i=0;i<k;i++)
    	{
    		free(hulp1_array[i]);
    		free(hulp2_array[i]);
    		free(hulp3_array[i]);
    		free(hulp4_array[i]);
    		free(hulp5_array[i]);
    		free(hulp6_array[i]);
    	}

    	free(hulp1_array);
     	free(hulp2_array);
     	free(hulp3_array);
     	free(hulp4_array);
     	free(hulp5_array);
     	free(hulp6_array);
     	
     	
     	for(i=0;i<4;i++)
     	{
     		free(a13[i]);
     		free(a14[i]);
     	}
     	free(a13);
     	free(a14);
	}

	public: virtual double Function(double* variable_list) throw(RuntimeException)
	{
		if(!(Loglik1 == NULL))
		{
			free(Loglik1);
			free(Loglik2);
			free(Loglik3);
			free(Loglik4);
			free(Loglik5);
			free(Loglik6);
			free(Loglik7);
			free(Loglik8);
			free(Loglik9);
			free(Loglik10);
			free(Loglik11);
			free(Loglik12);
			free(Loglik13);
			free(Loglik14);
			free(Loglik15);
			free(Loglik16);
		}

		Loglik1 = (double*)malloc(n * sizeof(double));
		Loglik2 = (double*)malloc(n * sizeof(double));
		Loglik3 = (double*)malloc(n * sizeof(double));
		Loglik4 = (double*)malloc(n * sizeof(double));
		Loglik5 = (double*)malloc(n * sizeof(double));
		Loglik6 = (double*)malloc(n * sizeof(double));
		Loglik7 = (double*)malloc(n * sizeof(double));
		Loglik8 = (double*)malloc(n * sizeof(double));
		Loglik9 = (double*)malloc(n * sizeof(double));
		Loglik10 = (double*)malloc(n * sizeof(double));
		Loglik11 = (double*)malloc(n * sizeof(double));
		Loglik12 = (double*)malloc(n * sizeof(double));
		Loglik13 = (double*)malloc(n * sizeof(double));
		Loglik14 = (double*)malloc(n * sizeof(double));
		Loglik15 = (double*)malloc(n * sizeof(double));
		Loglik16 = (double*)malloc(n * sizeof(double));

		double total = 0;
		int i;

		double adfunc0 = FunctionThread(variable_list, Min, Max);
		int tag = 7;
		
	

		if (myid == 0)
		{
		  	total = adfunc0;

		 	for(i=1;i<numprocs;i++)
		   	{
		 		double adfunc1;

		 		int rc = MPI_Recv(&adfunc1, 1, MPI_DOUBLE, i, tag, MPI_COMM_WORLD,
		 								&status);
		   		total += adfunc1;
		   	}
		 	
	    	for(i=1;i<numprocs;i++)
	    	{
	    		double hulp = total;
	    		MPI_Send(&hulp, 1, MPI_DOUBLE, i, tag, MPI_COMM_WORLD);
		    }
		 }
		 else
		 {			
			 MPI_Send(&adfunc0, 1, MPI_DOUBLE, 0, tag, MPI_COMM_WORLD);

			 double hulp1;
			 int rc = MPI_Recv(&hulp1, 1, MPI_DOUBLE, 0, tag, MPI_COMM_WORLD,
			 		 								&status);
			 total = hulp1;
		}

		if (std::isnan(total))
		{
			throw RuntimeException("Value is NaN");
		}
		if (std::isinf(-total))
		{
			throw RuntimeException("Value is INf");
		}


		return total / (n * k);
	}


	public: virtual double* dFunction(double* variable_list) throw(RuntimeException)
	{
		double* total;
		int i;

		double* avscore0 = dFunctionThread(variable_list, Min, Max);
		total = avscore0;
		int tag = 8;

		if (myid == 0)
		{
		 	for(i=1;i<numprocs;i++)
		   	{
		 		double* avscore1 = (double*)malloc(sizeof(double) * cp);

				int rc = MPI_Recv(avscore1, cp, MPI_DOUBLE, i, tag, MPI_COMM_WORLD,
			 								&status);
		   		add_to(total, avscore1);
		   		free(avscore1);
		   	}

		   	for(i=1;i<numprocs;i++)
		   	{

		   		MPI_Send(total, cp, MPI_DOUBLE, i, tag, MPI_COMM_WORLD);
		    }
		 }
		 else
		 {
			 MPI_Send(avscore0, cp, MPI_DOUBLE, 0, tag, MPI_COMM_WORLD);

			 double* hulp1 = (double*)malloc(sizeof(double) * cp);

			 int rc = MPI_Recv(hulp1, cp, MPI_DOUBLE, 0, tag, MPI_COMM_WORLD,
				 		 								&status);

			 free(total);
			 total = hulp1;

		}

		multiply_to(total, 1. / (double)(n * k));
		return total;
	}


	double FunctionThread(double* variable_list, int min, int max) throw(RuntimeException)
	{
		int i;
		
		Initialize(variable_list);
		
		double result = 0;
		int hulp1 = 0;
		
		//cout << min << endl;
  		for(i=min;i<=max;i++)
		{
	 		double hulp = FLoglik10(T_1_totaal_a[i], T_1_totaal_b[i], D_1_totaal_a[i], D_1_totaal_b[i],
						D_2_totaal[i], T_2_totaal[i], H1_hulp[i], H2_hulp[i], X[i],
						U_spells_totaal[i], E_spells_totaal[i], G2[i], G3[i], G4[i], i);
  			
  			result += log(hulp);

  		}
  		
  		Finalize();

  		return result;
	}
	

	public: virtual double* dFunctionThread(double* variable_list, int min, int max) throw(RuntimeException)
	{
		int i;
		
		Initialize(variable_list);
		double* result = zeros(cp);

  		for(i=min;i<=max;i++)
  		{
  			double* hulp = dFLoglik10(T_1_totaal_a[i], T_1_totaal_b[i], D_1_totaal_a[i], D_1_totaal_b[i],
						D_2_totaal[i], T_2_totaal[i], H1_hulp[i], H2_hulp[i], X[i],
						U_spells_totaal[i], E_spells_totaal[i], G2[i], G3[i], G4[i], i);
  			add_to(result, hulp);

  			free(hulp);
  		}

  		Finalize();
  		return result;
	}

	public: virtual double** FScoreThread(double* variable_list, int min, int max) throw(RuntimeException)
	{
		int i;
		
		Initialize(variable_list);
		double** result = (double**)malloc((max - min + 1) * sizeof(double*));
		
  		for(i=min;i<=max;i++)
		{
  			double* hulp = dFLoglik10(T_1_totaal_a[i], T_1_totaal_b[i], D_1_totaal_a[i], D_1_totaal_b[i],
						D_2_totaal[i], T_2_totaal[i], H1_hulp[i], H2_hulp[i], X[i],
						U_spells_totaal[i], E_spells_totaal[i], G2[i], G3[i], G4[i], i);
  			multiply_to(hulp, 1. / (double)(n * k));
  			result[i-min] = hulp;
  		}

  		Finalize();
  		return result;
	}

	double Survival1b(double t,  double** c_all)
	{
		double result = 0;

		if (t < tbeg)
			return t;
		else
			result += tbeg;

		int i;
		for(i=0;i<5;i++)
		{
			double hulp = c_all[i][0] * t_all[i]  + 0.5 * c_all[i][1] * t_all2[i] + (1. / 3.) * c_all[i][2] * t_all3[i]
									+ 0.25 * c_all[i][3] * t_all4[i];

			if (t < t_all[i+1])
				return result + c_all[i][0] * t + 0.5 * c_all[i][1] * t * t + (1. / 3.) * c_all[i][2] * t * t * t
							+ 0.25 * c_all[i][3] * t * t * t * t - hulp;
			else
				result += c_all[i][0] * t_all[i+1]
							+ 0.5 * c_all[i][1] * t_all2[i+1] + (1. / 3.) * c_all[i][2] * t_all3[i+1]
							+ 0.25 * c_all[i][3] * t_all4[i+1] - hulp;
		}

		return result + (c_all[c_all_n-1][0] + c_all[c_all_n-1][1] * tend + c_all[c_all_n-1][2] * tend * tend
						+ c_all[c_all_n-1][3] * tend*tend*tend) * (t-tend);
	}

	double  Survival1a(double t, double** c_all)
	{
		int i;
		if (t < t_all[0])
			return 1.;

		for(i=0;i<c_all_n;i++)
		{
			double theta = c_all[i][0] + t * c_all[i][1] + t * t * c_all[i][2] + c_all[i][3] * t*t*t;

			if (i == 0)
			{
				if (t < t_all[1])
					return theta;
			}
			else {
				if (i == c_all_n - 1)
				{
					if (t < t_all[i+1])
						return theta;
				}
				else {
					if ((t > t_all[i]) && (t < t_all[i+1]))
						return theta;
				}
			}
		}

		return  c_all[c_all_n-1][0] + c_all[c_all_n-1][1] * tend + c_all[c_all_n-1][2] * tend * tend
					+ c_all[c_all_n-1][3] * tend*tend*tend;
	}


	double* GetPsi1a(double* T, double* H, double** theta_1a,  double** theta_1b, int spells)
	{
		int i;
		double* result  = (double*)malloc(sizeof(double) * spells);
		for(i=0;i<spells;i++)
		{
			double psi1a = Survival1a(T[i], theta_1a);
			double psi1b = Survival1a(T[i], theta_1b);
			result[i] = psi1a * H[i] + (1-H[i]) * psi1b;
		}
		return result;
	}

	double* GetPsi1(double* T, double* H,  double** theta_1a,  double** theta_1b, int spells)
	{
		int i;
		double* result  = (double*)malloc(sizeof(double) * spells);
		for(i=0;i<spells;i++)
		{
			double psi1_a = Survival1b(T[i], theta_1a);
			double psi1_b = Survival1b(T[i], theta_1b);
			result[i] = psi1_a * H[i] + psi1_b * (1-H[i]);
		}
		return result;
	}

	double FLoglik10(double* T_1_a, double* T_1_b, double* D_1_a, double* D_1_b, double* D_2,
			double* T_2, double* H2, double* H4, double* x, int u_spells, int e_spells, double g2, double g3, double g4, int i)
	{
		double floglik1, floglik2, floglik3, floglik4, floglik5, floglik6, floglik7, floglik8, floglik9,
		floglik10, floglik11, floglik12, floglik13, floglik14, floglik15, floglik16;

		floglik1 = floglik2 = floglik3 = floglik4 = floglik5 = floglik6 =floglik7 = floglik8 = 0;
		floglik9 = floglik10 = floglik11 = floglik12 = floglik13 = floglik14 =floglik15 = floglik16 = 0;
		psi1_array = GetPsi1(T_1_a, H2, theta_1_1a, theta_1_1b, u_spells);
		psi2_array = GetPsi1(T_1_b, H2, theta_1_2a, theta_1_2b, u_spells);
		psi3_array = GetPsi1(T_2, H4, theta_1_3a, theta_1_3b, e_spells);
		psi1a_array = GetPsi1a(T_1_a, H2, theta_1_1a, theta_1_1b, u_spells);
		psi2a_array = GetPsi1a(T_1_b, H2, theta_1_2a, theta_1_2b, u_spells);
		psi3a_array = GetPsi1a(T_2, H4, theta_1_3a, theta_1_3b, e_spells);
		double* hulp_x = (double*)malloc(sizeof(double) * (x_size+1));
		
		memcpy(&hulp_x[1], x, sizeof(double) * x_size);

		int j;

		for(j=0;j<u_spells;j++)
		{
			hulp_x[0] = H2[j];
			
			double hulp_beta1a = exp(internal_product(hulp_x, beta1_a, x_size+1) + g2);
			double hulp_beta2a = exp(internal_product(hulp_x, beta2_a, x_size+1) + g3);
			double lambda1 = hulp_beta1a * psi1_array[j];
			double lambda2 = hulp_beta2a * psi2_array[j];


			double theta1 =  hulp_beta1a * psi1a_array[j];
			double theta2 =  hulp_beta2a * psi2a_array[j];
			
			lambda1_array[j] = lambda1;
			lambda2_array[j] = lambda2;

			theta1_array[j] = theta1;
			theta2_array[j] = theta2;
		}

		for(j=0;j<e_spells;j++)
		{
			hulp_x[0] = H4[j];

			double hulp_beta3a = exp(internal_product(hulp_x, beta3_a, x_size+1) + g4);
			
			double lambda3 = hulp_beta3a * psi3_array[j];
			double theta3 =  hulp_beta3a * psi3a_array[j];

			lambda3_array[j] = lambda3;
			theta3_array[j] = theta3;
		}

		if (P0000 > 1E-6)
			floglik1 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V00, V10, V20, V30, u_spells, e_spells, x, H2, H4);
		if (P1000 > 1E-6)
			floglik2 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V01, V10, V20, V30, u_spells, e_spells, x, H2, H4);
		if (P0100 > 1E-6)
			floglik3 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V00, V11, V20, V30, u_spells, e_spells, x, H2, H4);
		if (P1100 > 1E-6)
			floglik4 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V01, V11, V20, V30, u_spells, e_spells, x, H2, H4);
		if (P0010 > 1E-6)
			floglik5 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V00, V10, V21, V30, u_spells, e_spells, x, H2, H4);
		if (P1010 > 1E-6)
			floglik6 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V01, V10, V21, V30, u_spells, e_spells, x, H2, H4);
		if (P0110 > 1E-6)
			floglik7 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V00, V11, V21, V30, u_spells, e_spells, x, H2, H4);
		if (P1110 > 1E-6)
			floglik8 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V01, V11, V21, V30, u_spells, e_spells, x, H2, H4);
		if (P0001 > 1E-6)
			floglik9 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V00, V10, V20, V31, u_spells, e_spells, x, H2, H4);
		if (P1001 > 1E-6)
			floglik10 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V01, V10, V20, V31, u_spells, e_spells, x, H2, H4);
		if (P0101 > 1E-6)
			floglik11 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V00, V11, V20, V31, u_spells, e_spells, x, H2, H4);
		if (P1101 > 1E-6)
			floglik12 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V01, V11, V20, V31, u_spells, e_spells, x, H2, H4);
		if (P0011 > 1E-6)
			floglik13 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V00, V10, V21, V31, u_spells, e_spells, x, H2, H4);
		if (P1011 > 1E-6)
			floglik14 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V01, V10, V21, V31, u_spells, e_spells, x, H2, H4);
		if (P0111 > 1E-6)
			floglik15 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V00, V11, V21, V31, u_spells, e_spells, x, H2, H4);
		if (P1111 > 1E-6)
			floglik16 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V01, V11, V21, V31, u_spells, e_spells, x, H2, H4);

    	double floglik = P0000 * floglik1 + P1000 * floglik2 + P0100 * floglik3 + P1100 * floglik4 + P0010 * floglik5 + P1010 * floglik6
    			+ P0110 * floglik7 + P1110 * floglik8
				+ P0001 * floglik9 + P1001 * floglik10 + P0101 * floglik11 + P1101 * floglik12 + P0011 * floglik13 + P1011 * floglik14
    			+ P0111 * floglik15 + P1111 * floglik16;


    	Loglik1[i] = floglik1;
    	Loglik2[i] = floglik2;
    	Loglik3[i] = floglik3;
    	Loglik4[i] = floglik4;
    	Loglik5[i] = floglik5;
    	Loglik6[i] = floglik6;
    	Loglik7[i] = floglik7;
    	Loglik8[i] = floglik8;
    	Loglik9[i] = floglik9;
    	Loglik10[i] = floglik10;
    	Loglik11[i] = floglik11;
    	Loglik12[i] = floglik12;
    	Loglik13[i] = floglik13;
    	Loglik14[i] = floglik14;
    	Loglik15[i] = floglik15;
    	Loglik16[i] = floglik16;

    	free(psi1_array);
    	free(psi2_array);
    	free(psi3_array);
    	free(psi1a_array);
    	free(psi2a_array);
    	free(psi3a_array);
    	free(hulp_x);

		return floglik;
	}

	private : double FLoglik2(double H1, double H2, double* x1, double v, double t1, double t2)
	{
			int i;
			double result = 1.;
			double hulp = internal_product(x1, Beta0, x_size) + v;

			NormalDistribution normal(0,1);
			double hulp1 = normal.cumulativeProbability(hulp);
				if (t1 > 0)
				{
					double h2 = H1;
					double expression1 = exp(h2 * log(hulp1));
					double expression2 = exp((1-h2) * log(1-hulp1));

					result *=  expression1 * expression2;
				}
				if (t2 > 0)
				{
					double h2 = H2;
					double expression1 = exp(h2 * log(hulp1));
					double expression2 = exp((1-h2) * log(1-hulp1));

					result *=  expression1 * expression2;
				}
		//	}

			return result;
	}

	double FLoglik10a(double* T_1_a, double* T_1_b, double* D_1_a, double* D_1_b, double* D_2,
			double* T_2, double V0, double V1, double V2, double V3,
			int u_spells, int e_spells, double* x1, double* H1, double* H2) {

		double result = 1;
		int i;


		int k1 = max(u_spells, e_spells);
		for(i=0;i<k1;i++) {
			result *= FLoglik1(T_1_a[i], T_1_b[i], D_1_a[i], D_1_b[i], D_2[i], T_2[i],
					exp(V0), exp(V1), exp(V2), i) * FLoglik2(H1[i], H2[i], x1, V3, T_1_a[i], T_2[i]);
		 
		}

	
		return result;
	}

	double FLoglik1(double T_1_a, double T_1_b, double D_1_a, double D_1_b, double D_2,
			double T_2, double V0, double V1, double V2, int i)
	{
		if ((T_1_a < 0) && (T_2 < 0))
			return 1;

		if ((T_1_a > 0) && (T_2 > 0))
			return FLoglik1a(D_1_a, D_1_b, D_2, V0, V1, V2, i);
		if (T_2 > 0)
			return FLoglik1b(D_2, V2, i);

		return FLoglik1c(D_1_a, D_1_b, V0, V1, i);
	}


	double FLoglik1a(double D_1_a, double D_1_b, double D_2,
			double V0, double V1, double V2, int i)
	{
		double lambda1 = lambda1_array[i] * V0;
		double lambda2 = lambda2_array[i] * V1;
		double lambda3 = lambda3_array[i] * V2;

		double theta1 =  theta1_array[i] * V0;
		double theta2 =  theta2_array[i] * V1;
		double theta3 =  theta3_array[i] * V2;

		
		
		double part1;
		if (D_1_a > 1E-7)
			part1 = theta1 > 1e-9 ? exp((1-D_1_a) * log(theta1) - lambda1): exp(-lambda1);
		else
			part1 = theta1 * exp(-lambda1);

	
		double part2;
		if (D_1_b > 1E-7)
			part2 = theta2 > 1e-9 ? exp((1-D_1_b) * log(theta2) - lambda2): exp(-lambda2);
		else
			part2 = theta2 * exp(-lambda2);

		double part3;
		if (D_2 > 1E-7)
			part3 = theta3 > 1e-9 ? exp((1-D_2) * log(theta3) - lambda3) : exp(-lambda3);
		else
			part3 = theta3 * exp(-lambda3);

		//cout << part1 * part2 * part3 <<  "\t"<<theta1 << "\t"<< lambda1 << endl;
		return part1 * part2 * part3;
	}

	double FLoglik1b(double D_2, double V2, int i)
	{
		double lambda3 = lambda3_array[i] * V2;
		double theta3 =  theta3_array[i] * V2;

		double part3;
		if (D_2 > 1E-7)
			part3 = theta3 > 1e-9 ? exp((1-D_2) * log(theta3) - lambda3) : exp(-lambda3);
		else
			part3 = theta3 * exp(-lambda3);


		return part3;
	}

	double FLoglik1c(double D_1_a, double D_1_b, double V0, double V1, int i)
	{
		double lambda1 = lambda1_array[i] * V0;
		double lambda2 = lambda2_array[i] * V1;

		double theta1 =  theta1_array[i] * V0;
		double theta2 =  theta2_array[i] * V1;

		double part1;
		if (D_1_a > 1E-7)
			part1 = theta1 > 1e-9 ? exp((1-D_1_a) * log(theta1) - lambda1): exp(-lambda1);
		else
			part1 = theta1 * exp(-lambda1);

	
		double part2;
		if (D_1_b > 1E-7)
			part2 = theta2 > 1e-9 ? exp((1-D_1_b) * log(theta2) - lambda2): exp(-lambda2);
		else
			part2 = theta2 * exp(-lambda2);

		return part1 * part2;
	}

	double* dSurvival(double t)
	{
		if (t < tbeg)
			return zeros(20);

		if (t < tmid)
		{
			double* result = (double*)malloc(sizeof(double) * 20);
			result[0] = 1;
			result[1] = t;
			result[2] = t*t;
			result[3] = t * t* t;

			int i;
			for(i=4;i<20;i++)
				result[i] = 0;
			return result;
		}

		if (t < tmid1)
		{
			int i ;

			double* result = (double*)malloc(sizeof(double) * 20);
			for(i=0;i<4;i++)
					result[i] = 0;
			result[4] = 1;
			result[5] = t;
			result[6] = t*t;
			result[7] = t * t* t;
			for(i=8;i<20;i++)
					result[i] = 0;

			return result;
		}

		if (t < tmid2)
		{
			int i ;

			double* result = (double*)malloc(sizeof(double) * 20);
			for(i=0;i<8;i++)
					result[i] = 0;
			result[8] = 1;
			result[9] = t;
			result[10] = t*t;
			result[11] = t * t* t;
			for(i=12;i<20;i++)
					result[i] = 0;

			return result;
		}

		if (t < tmid3)
		{
			int i ;

			double* result = (double*)malloc(sizeof(double) * 20);
			for(i=0;i<12;i++)
					result[i] = 0;
			result[12] = 1;
			result[13] = t;
			result[14] = t*t;
			result[15] = t * t* t;
			for(i=16;i<20;i++)
					result[i] = 0;

			return result;
		}

		if (t < tend)
		{
			int i ;

			double* result = (double*)malloc(sizeof(double) * 20);
			for(i=0;i<16;i++)
					result[i] = 0;
			result[16] = 1;
			result[17] = t;
			result[18] = t*t;
			result[19] = t * t* t;

			return result;
		}


		int i ;

		double* result = (double*)malloc(sizeof(double) * 20);
		for(i=0;i<16;i++)
				result[i] = 0;
		result[16] = 1;
		result[17] = tend;
		result[18] = tend*tend;
		result[19] = tend * tend* tend;

		return result;
	}

	double* dSurvival1b(double t)
	{
		if (t < tbeg)
			return zeros(20);

		double* result = (double*)malloc(sizeof(double) * 20);

		int i;
		double* hulp = (double*)malloc(sizeof(double) * 4);
		int index = 0;
		for(i=0;i<5;i++)
		{
			hulp[0] = t_all[i];
			hulp[1] = 0.5 * t_all2[i];
			hulp[2] = (1. / 3.) * t_all3[i];
			hulp[3] = 0.25 *  t_all4[i];


			if (t < t_all[i+1])
			{
				double* hulp1 = (double*)malloc(sizeof(double) * 4);
				hulp1[0] = t;
				hulp1[1] = 0.5 * t * t;
				hulp1[2] = (1. / 3.) * t * t * t;
				hulp1[3] = 0.25 *  t * t * t * t;

				subtract_to(hulp1, hulp, 4);
				result[index] = hulp1[0];
				result[index+1] = hulp1[1];
				result[index+2] = hulp1[2];
				result[index+3] = hulp1[3];

				index += 4;

				for(i=index;i<20;i++)
						result[i] = 0;

				free(hulp);
				free(hulp1);
				return result;
			}
			else
			{
				double* hulp1 = (double*)malloc(sizeof(double) * 4);


				hulp1[0] = t_all[i+1];
				hulp1[1] = 0.5 * t_all2[i+1];
				hulp1[2] = (1. / 3.) * t_all3[i+1];
				hulp1[3] = 0.25 *  t_all4[i+1];

				subtract_to(hulp1, hulp, 4);

				result[index] = hulp1[0];
				result[index+1] = hulp1[1];
				result[index+2] = hulp1[2];
				result[index+3] = hulp1[3];

				free(hulp1);
				index += 4;
			}
		}

		result[16] = result[16] + t-tend;
		result[17] = result[17] + (t-tend) * tend;
		result[18] = result[18] + (t-tend) * tend * tend;
		result[19] = result[19] + (t-tend) * tend * tend * tend;
		free(hulp);
		return result;
	}

	double* dFLoglik10(double* T_1_a, double* T_1_b, double* D_1_a, double* D_1_b, double* D_2,
				double* T_2, double* H2, double* H4, double* x, int u_spells, int e_spells, double g2, double g3, double g4, int i)
		{

	    	int k1 = x_size;
	    
	    	double* result = (double*)malloc(sizeof(double) * (cp1+5));
	    	double* result_0 = (double*)malloc(sizeof(double) * cp1);
	    	double* result_1 = (double*)malloc(sizeof(double) * cp);

	    	int i1;
	    	for(i1 = 0; i1 <3+4 * k1+44;i1++)
	    		result[i1] = 0;

	    	
	    	double* dfloglik1;
	    	double* dfloglik2;
	    	double* dfloglik3;
	    	double* dfloglik4;
	    	double* dfloglik5;
	    	double* dfloglik6;
	    	double* dfloglik7;
	    	double* dfloglik8;
	    	double* dfloglik9;
	    	double* dfloglik10;
	    	double* dfloglik11;
	    	double* dfloglik12;
	    	double* dfloglik13;
	    	double* dfloglik14;
	    	double* dfloglik15;
	    	double* dfloglik16;

			psi1_array = GetPsi1(T_1_a, H2, theta_1_1a, theta_1_1b, u_spells);
			psi2_array = GetPsi1(T_1_b, H2, theta_1_2a, theta_1_2b, u_spells);
			psi3_array = GetPsi1(T_2, H4, theta_1_3a, theta_1_3b, e_spells);
			psi1a_array = GetPsi1a(T_1_a, H2, theta_1_1a, theta_1_1b, u_spells);
			psi2a_array = GetPsi1a(T_1_b, H2, theta_1_2a, theta_1_2b, u_spells);
			psi3a_array = GetPsi1a(T_2, H4, theta_1_3a, theta_1_3b, e_spells);
			double* x_g2 = (double*)malloc(sizeof(double) * (x_size));
			double* hulp_x_g2 = (double*)malloc(sizeof(double) * (x_size+1));

			memcpy(x_g2, x, sizeof(double) * x_size);

			memcpy(&hulp_x_g2[1], x, sizeof(double) * x_size);

			int j;

			x = hulp_x_g2;

			for(j=0;j<u_spells;j++)
			{
				hulp_x_g2[0] = H2[j];

				double hulp_beta1a = exp(internal_product(hulp_x_g2, beta1_a, x_size+1) + g2);
				double hulp_beta2a = exp(internal_product(hulp_x_g2, beta2_a, x_size+1) + g3);

				double lambda1 = hulp_beta1a * psi1_array[j];
				double lambda2 = hulp_beta2a * psi2_array[j];

				double theta1 =  hulp_beta1a * psi1a_array[j];
				double theta2 =  hulp_beta2a * psi2a_array[j];

				lambda1_array[j] = lambda1;
				lambda2_array[j] = lambda2;

				theta1_array[j] = theta1;
				theta2_array[j] = theta2;
			}

			for(j=0;j<e_spells;j++)
			{
				hulp_x_g2[0] = H4[j];

				double hulp_beta3a = exp(internal_product(hulp_x_g2, beta3_a, x_size+1) + g4);
				double lambda3 = hulp_beta3a * psi3_array[j];
				double theta3 =  hulp_beta3a * psi3a_array[j];

				lambda3_array[j] = lambda3;
				theta3_array[j] = theta3;
			}

			for(j=0;j<u_spells;j++)
			{
				double* hulp2 = dSurvival(T_1_a[j]);
				double* hulp1 = dSurvival1b(T_1_a[j]);
				double* hulp4 = dSurvival(T_1_b[j]);
				double* hulp3 = dSurvival1b(T_1_b[j]);
				memcpy(hulp1_array[j], hulp1, 20 * sizeof(double));
				memcpy(hulp2_array[j], hulp2, 20 * sizeof(double));
				memcpy(hulp3_array[j], hulp3, 20 * sizeof(double));
				memcpy(hulp4_array[j], hulp4, 20* sizeof(double));
				free(hulp1);
				free(hulp2);
				free(hulp3);
				free(hulp4);
			}

			for(j=0;j<e_spells;j++)
			{
				double* hulp6 = dSurvival(T_2[j]);
				double* hulp5 = dSurvival1b(T_2[j]);
				memcpy(hulp5_array[j], hulp5, 20* sizeof(double));
				memcpy(hulp6_array[j], hulp6, 20* sizeof(double));

				free(hulp5);
				free(hulp6);
			}


	    	if (P0000 > 1E-6)
	    		dfloglik1 = dFLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, H2, H4, x_g2, V00, V10, V20, V30, u_spells, e_spells);
	    	else
	    		dfloglik1 = zeros(3+4 * k1+33);

	    	if (P1000 > 1E-6)
	    		dfloglik2 = dFLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, H2, H4, x_g2, V01, V10, V20, V30, u_spells, e_spells);
	    	else
	    		dfloglik2 = zeros(3+4 * k1+33);

	    	if (P0100 > 1E-6)
	    		dfloglik3 = dFLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, H2, H4, x_g2, V00, V11, V20, V30, u_spells, e_spells);
	    	else
	    		dfloglik3 = zeros(3+4 * k1+33);

	    	if (P1100 > 1E-6)
	    		dfloglik4 = dFLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, H2, H4, x_g2, V01, V11, V20, V30, u_spells, e_spells);
	    	else
	    		dfloglik4 = zeros(3+4 * k1+33);

	    	if (P0010 > 1E-6)
	    		dfloglik5 = dFLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, H2, H4, x_g2, V00, V10, V21, V30, u_spells, e_spells);
	    	else
	    		dfloglik5 = zeros(3+4 * k1+33);

	    	if (P1010 > 1E-6)
	    		dfloglik6 = dFLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, H2, H4, x_g2, V01, V10, V21, V30, u_spells, e_spells);
	    	else
	    		dfloglik6 = zeros(3+4 * k1+33);

	    	if (P0110 > 1E-6)
	    		dfloglik7 = dFLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, H2, H4, x_g2, V00, V11, V21, V30,  u_spells, e_spells);
	    	else
	    		dfloglik7 = zeros(3+4 * k1+33);

	    	if (P1110 > 1E-7)
	    		dfloglik8 = dFLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, H2, H4, x_g2, V01, V11, V21, V30, u_spells, e_spells);
	    	else
	    		dfloglik8 = zeros(3+4 * k1+33);

	    	if (P0001 > 1E-6)
	    		dfloglik9 = dFLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, H2, H4, x_g2, V00, V10, V20, V31, u_spells, e_spells);
	    	else
	    		dfloglik9 = zeros(3+4 * k1+33);

	    	if (P1001 > 1E-6)
	    		dfloglik10 = dFLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, H2, H4, x_g2, V01, V10, V20, V31, u_spells, e_spells);
	    	else
	    		dfloglik10 = zeros(3+4 * k1+33);

	    	if (P0101 > 1E-6)
	    		dfloglik11 = dFLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, H2, H4, x_g2, V00, V11, V20, V31, u_spells, e_spells);
	    	else
	    		dfloglik11 = zeros(3+4 * k1+33);

	    	if (P1101 > 1E-6)
	    		dfloglik12 = dFLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, H2, H4, x_g2, V01, V11, V20, V31, u_spells, e_spells);
	    	else
	    		dfloglik12 = zeros(3+4 * k1+33);

	    	if (P0011 > 1E-6)
		    		dfloglik13 = dFLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, H2, H4, x_g2, V00, V10, V21, V31, u_spells, e_spells);
		    else
		    		dfloglik13 = zeros(3+4 * k1+33);

	    	if (P1011 > 1E-6)
	    		dfloglik14 = dFLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, H2, H4, x_g2, V01, V10, V21, V31, u_spells, e_spells);
	    	else
	    		dfloglik14 = zeros(3+4 * k1+33);

	    	if (P0111 > 1E-6)
	    		dfloglik15 = dFLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, H2, H4, x_g2, V00, V11, V21, V31,  u_spells, e_spells);
	    	else
	    		dfloglik15 = zeros(3+4 * k1+33);

	    	if (P1111 > 1E-7)
	    		dfloglik16 = dFLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, H2, H4, x_g2, V01, V11, V21, V31, u_spells, e_spells);
	    	else
	    		dfloglik16 = zeros(3+4 * k1+33);

			double floglik1, floglik2, floglik3, floglik4, floglik5, floglik6, floglik7, floglik8,
					floglik9, floglik10, floglik11, floglik12, floglik13, floglik14, floglik15, floglik16;


			if (Loglik1 == NULL)
			{
				floglik1 = floglik2 = floglik3 = floglik4 = floglik5 = floglik6 =floglik7 = floglik8 = 0;
				floglik9 = floglik10 = floglik11 = floglik12 = floglik13 = floglik14 =floglik15 = floglik16 = 0;
				if (P0000 > 1E-6)
					floglik1 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V00, V10, V20, V30, u_spells, e_spells, x, H2, H4);
				if (P1000 > 1E-6)
					floglik2 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V01, V10, V20, V30, u_spells, e_spells, x, H2, H4);
				if (P0100 > 1E-6)
					floglik3 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V00, V11, V20, V30, u_spells, e_spells, x, H2, H4);
				if (P1100 > 1E-6)
					floglik4 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V01, V11, V20, V30, u_spells, e_spells, x, H2, H4);
				if (P0010 > 1E-6)
					floglik5 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V00, V10, V21, V30, u_spells, e_spells, x, H2, H4);
				if (P1010 > 1E-6)
					floglik6 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V01, V10, V21, V30, u_spells, e_spells, x, H2, H4);
				if (P0110 > 1E-6)
					floglik7 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V00, V11, V21, V30, u_spells, e_spells, x, H2, H4);
				if (P1110 > 1E-6)
					floglik8 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V01, V11, V21, V30, u_spells, e_spells, x, H2, H4);
				if (P0001 > 1E-6)
					floglik9 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V00, V10, V20, V31, u_spells, e_spells, x, H2, H4);
				if (P1001 > 1E-6)
					floglik10 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V01, V10, V20, V31, u_spells, e_spells, x, H2, H4);
				if (P0101 > 1E-6)
					floglik11 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V00, V11, V20, V31, u_spells, e_spells, x, H2, H4);
				if (P1101 > 1E-6)
					floglik12 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V01, V11, V20, V31, u_spells, e_spells, x, H2, H4);
				if (P0011 > 1E-6)
					floglik13 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V00, V10, V21, V31, u_spells, e_spells, x, H2, H4);
				if (P1011 > 1E-6)
					floglik14 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V01, V10, V21, V31, u_spells, e_spells, x, H2, H4);
				if (P0111 > 1E-6)
					floglik15 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V00, V11, V21, V31, u_spells, e_spells, x, H2, H4);
				if (P1111 > 1E-6)
					floglik16 = FLoglik10a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, V01, V11, V21, V31, u_spells, e_spells, x, H2, H4);
			}
			else
			{
				floglik1 = Loglik1[i];
				floglik2 = Loglik2[i];
				floglik3 = Loglik3[i];
				floglik4 = Loglik4[i];
				floglik5 = Loglik5[i];
				floglik6 = Loglik6[i];
				floglik7 = Loglik7[i];
				floglik8 = Loglik8[i];
				floglik9 = Loglik9[i];
				floglik10 = Loglik10[i];
				floglik11 = Loglik11[i];
				floglik12 = Loglik12[i];
				floglik13 = Loglik13[i];
				floglik14 = Loglik14[i];
				floglik15 = Loglik15[i];
				floglik16 = Loglik16[i];
			}

	    	double floglik = P0000 * floglik1 + P1000 * floglik2 + P0100 * floglik3 + P1100 * floglik4 + P0010 * floglik5 + P1010 * floglik6
	    			+ P0110 * floglik7 + P1110 * floglik8
					+ P0001 * floglik9 + P1001 * floglik10 + P0101 * floglik11 + P1101 * floglik12 + P0011 * floglik13 + P1011 * floglik14
	    			+ P0111 * floglik15 + P1111 * floglik16;


	    	multiply_to(dfloglik1, floglik1, 3 + 4 * k1 + 34);
	    	multiply_to(dfloglik2, floglik2, 3 + 4 * k1 + 34);
	    	multiply_to(dfloglik3, floglik3, 3 + 4 * k1 + 34);
	    	multiply_to(dfloglik4, floglik4, 3 + 4 * k1 + 34);
	    	multiply_to(dfloglik5, floglik5, 3 + 4 * k1 + 34);
	    	multiply_to(dfloglik6, floglik6, 3 + 4 * k1 + 34);
	    	multiply_to(dfloglik7, floglik7, 3 + 4 * k1 + 34);
	    	multiply_to(dfloglik8, floglik8, 3 + 4 * k1 + 34);
	    	multiply_to(dfloglik9, floglik9, 3 + 4 * k1 + 34);
	    	multiply_to(dfloglik10, floglik10, 3 + 4 * k1 + 34);
	    	multiply_to(dfloglik11, floglik11, 3 + 4 * k1 + 34);
	    	multiply_to(dfloglik12, floglik12, 3 + 4 * k1 + 34);
	    	multiply_to(dfloglik13, floglik13, 3 + 4 * k1 + 34);
	    	multiply_to(dfloglik14, floglik14, 3 + 4 * k1 + 34);
	    	multiply_to(dfloglik15, floglik15, 3 + 4 * k1 + 34);
	    	multiply_to(dfloglik16, floglik16, 3 + 4 * k1 + 34);


	    	multiply_to_range(dfloglik1, P0000,  3+4 * k1+30);
	    	multiply_to_range(dfloglik2, P1000,  3+4 * k1+30);
	    	multiply_to_range(dfloglik3, P0100,  3+4 * k1+30);
	    	multiply_to_range(dfloglik4, P1100,  3+4 * k1+30);
	    	multiply_to_range(dfloglik5, P0010,  3+4 * k1+30);
	    	multiply_to_range(dfloglik6, P1010,  3+4 * k1+30);
	    	multiply_to_range(dfloglik7, P0110,  3+4 * k1+30);
	    	multiply_to_range(dfloglik8, P1110,  3+4 * k1+30);
	    	multiply_to_range(dfloglik9, P0001,  3+4 * k1+30);
	    	multiply_to_range(dfloglik10, P1001,  3+4 * k1+30);
	    	multiply_to_range(dfloglik11, P0101,  3+4 * k1+30);
	    	multiply_to_range(dfloglik12, P1101,  3+4 * k1+30);
	    	multiply_to_range(dfloglik13, P0011,  3+4 * k1+30);
	    	multiply_to_range(dfloglik14, P1011,  3+4 * k1+30);
	    	multiply_to_range(dfloglik15, P0111,  3+4 * k1+30);
	    	multiply_to_range(dfloglik16, P1111,  3+4 * k1+30);

			add_to(result, dfloglik1, 3 + 4 * k1 + 33);
			add_to(result, dfloglik2, 3 + 4 * k1 + 33);
			add_to(result, dfloglik3, 3 + 4 * k1 + 33);
			add_to(result, dfloglik4, 3 + 4 * k1 + 33);
			add_to(result, dfloglik5, 3 + 4 * k1 + 33);
			add_to(result, dfloglik6, 3 + 4 * k1 + 33);
			add_to(result, dfloglik7, 3 + 4 * k1 + 33);
			add_to(result, dfloglik8, 3 + 4 * k1 + 33);
			add_to(result, dfloglik9, 3 + 4 * k1 + 33);
			add_to(result, dfloglik10, 3 +4  * k1 + 33);
			add_to(result, dfloglik11, 3 + 4 * k1 + 33);
			add_to(result, dfloglik12, 3 + 4 * k1 + 33);
			add_to(result, dfloglik13, 3 + 4 * k1 + 33);
			add_to(result, dfloglik14, 3 + 4 * k1 + 33);
			add_to(result, dfloglik15, 3 + 4 * k1 + 33);
			add_to(result, dfloglik16, 3 + 4 * k1 + 33);


			multiply_to(result, 1 / floglik, 3 + 4 * k1 + 33);

			double result0 = 0;

			double result1 = P0000 * dfloglik1[3+4 * k1+30] + P0100 * dfloglik3[3+4 * k1+30] + P0010 * dfloglik5[3+4 * k1+30]
														+ P0110 * dfloglik7[3+4 * k1+30]
							 + P0001 * dfloglik9[3+4 * k1+30] + P0101 * dfloglik11[3+4 * k1+30]
															+ P0011 * dfloglik13[3+4 * k1+30] + P0111 * dfloglik15[3+4 * k1+30];
			double result2 = P0000 * dfloglik1[3+4 * k1+31] + P1000 * dfloglik2[3+4 * k1+31] + P0010 * dfloglik5[3+4 * k1+31]
													+ P1010 * dfloglik6[3+4 * k1+31]
								+ P0001 * dfloglik9[3+4 * k1+31] + P1001 * dfloglik10[3+4 * k1+31]
										+ P0011 * dfloglik13[3+4 * k1+31] + P1011 * dfloglik14[3+4 * k1+31];
			double result3 = P0000 * dfloglik1[3+4 * k1+32] + P1000 * dfloglik2[3+4 * k1+32]
										+ P0100 * dfloglik3[3+4 * k1+32] + P1100 * dfloglik4[3+4 * k1+32]
							 + P0001 * dfloglik9[3+4 * k1+32] + P1001 * dfloglik10[3+4 * k1+32]
										+ P0101 * dfloglik11[3+4 * k1+32] + P1101 * dfloglik12[3+4 * k1+32];
			double result4 = P0000 * dfloglik1[3+4 * k1+33] + P1000 * dfloglik2[3+4 * k1+33] + P0100 * dfloglik3[3+4 * k1+33]
																								+ P1100 * dfloglik4[3+4 * k1+33]
																	 + P0010 * dfloglik5[3+4 * k1+33] + P1010 * dfloglik6[3+4 * k1+33]
																					+ P0110 * dfloglik7[3+4 * k1+33]
																						+ P1110 * dfloglik8[3+4 * k1+33];
			double result1a = P1000 * dfloglik2[3+4 * k1+30] + P1100 * dfloglik4[3+4 * k1+30] + P1010 * dfloglik6[3+4 * k1+30] + P1110 * dfloglik8[3+4 * k1+30]
						+  P1001 * dfloglik10[3+4 * k1+30] + P1101 * dfloglik12[3+4 * k1+30] + P1011 * dfloglik14[3+4 * k1+30]
																									+ P1111 * dfloglik16[3+4 * k1+30];
			double result2a = P0100 * dfloglik3[3+4 * k1+31] + P1100 * dfloglik4[3+4 * k1+31]
											+ P0110 * dfloglik7[3+4 * k1+31] + P1110 * dfloglik8[3+4 * k1+31]
									+ P0101 * dfloglik11[3+4 * k1+31] + P1101 * dfloglik12[3+4 * k1+31]
											+ P0111 * dfloglik15[3+4 * k1+31] + P1111 * dfloglik16[3+4 * k1+31];;
			double result3a = P0010 * dfloglik5[3+4 * k1+32] + P1010 * dfloglik6[3+4 * k1+32]
										+ P0110 * dfloglik7[3+4 * k1+32] + P1110 * dfloglik8[3+4 * k1+32]
									+ P0011 * dfloglik13[3+4 * k1+32] + P1011 * dfloglik14[3+4 * k1+32]
								+ P0111 * dfloglik15[3+4 * k1+32] + P1111 * dfloglik16[3+4 * k1+32];
			double result4a = P0001 * dfloglik9[3+4 * k1+33] + P1001 * dfloglik10[3+4 * k1+33] + P0101 * dfloglik11[3+4 * k1+33]
									+ P1101 * dfloglik12[3+4 * k1+33]
																						 + P0011 * dfloglik13[3+4 * k1+33]
																	+ P1011 * dfloglik14[3+4 * k1+33]
																+ P0111 * dfloglik15[3+4 * k1+33]
																+ P1111 * dfloglik16[3+4 * k1+33];

			double avscore_7 = floglik1 - floglik16; // P0000 +
			double avscore_8 = floglik2 - floglik16; // P1000 +
			double avscore_9 = floglik3 - floglik16; // P0100+
			double avscore_10 = floglik4 - floglik16; // P1100+
			double avscore_11 = floglik5 - floglik16; // P0010
			double avscore_12 = floglik6 - floglik16; // P1010
			double avscore_13 = floglik7 - floglik16; // P0110
			double avscore_14 = floglik8 - floglik16; // P1110
			double avscore_15 = floglik9 - floglik16; // P0001
			double avscore_16 = floglik10 - floglik16; // P1001
			double avscore_17 = floglik11 - floglik16; // P0101
			double avscore_18 = floglik12 - floglik16; // P1101
			double avscore_19 = floglik13 - floglik16; // P0011 +
			double avscore_20 = floglik14 - floglik16; // P1011+
			double avscore_21 = floglik15 - floglik16; // P0111 +
			//double avscore_22 = floglik16 - floglik16; // P1111


			avscore_7 +=  factor1 * result1a;
			avscore_9 +=  factor1 * result1a;
			avscore_11 += factor1 * result1a;
			avscore_13 += factor1 * result1a;
			avscore_15 += factor1 * result1a;
			avscore_17 += factor1 * result1a;
			avscore_19 += factor1 * result1a;
			avscore_21 += factor1 * result1a;

			avscore_7 += factor2 * result2a;
			avscore_8 += factor2 * result2a;
			avscore_11 += factor2 * result2a;
			avscore_12 += factor2 * result2a;
			avscore_15 += factor2 * result2a;
			avscore_16 += factor2 * result2a;
			avscore_19 += factor2 * result2a;
			avscore_20 += factor2 * result2a;

			avscore_7 += factor3 * result3a;
			avscore_8 += factor3 * result3a;
			avscore_9 += factor3 * result3a;
			avscore_10 += factor3 * result3a;
			avscore_15 += factor3 * result3a;
			avscore_16 += factor3 * result3a;
			avscore_17 += factor3 * result3a;
			avscore_18 += factor3 * result3a;

			avscore_7 += factor4 * result4a;
			avscore_8 += factor4 * result4a;
			avscore_9 += factor4 * result4a;
			avscore_10 += factor4 * result4a;
			avscore_11 += factor4 * result4a;
			avscore_12 += factor4 * result4a;
			avscore_13 += factor4 * result4a;
			avscore_14 += factor4 * result4a;

			double avscore_5a = avscore_7 * P0000 * (1-P0000) - P1000 * P0000 * avscore_8
						- P0100 * P0000 * avscore_9 - P1100 * P0000 * avscore_10
						- P0010 * P0000 * avscore_11 - P1010 * P0000 * avscore_12
						- P0110 * P0000 * avscore_13 - P1110 * P0000 * avscore_14
						- P0001 * P0000 * avscore_15 - P1001 * P0000 * avscore_16
						- P0101 * P0000 * avscore_17 - P1101 * P0000 * avscore_18
						- P0011 * P0000 * avscore_19 - P1011 * P0000 * avscore_20
						- P0111 * P0000 * avscore_21;
			double avscore_6a = -avscore_7 * P0000 * P1000 + P1000 * (1-P1000) * avscore_8
						- P0100 * P1000 * avscore_9 - P1100 * P1000 * avscore_10
						- P0010 * P1000 * avscore_11 - P1010 * P1000 * avscore_12
						- P0110 * P1000 * avscore_13 - P1110 * P1000 * avscore_14
						- P0001 * P1000 * avscore_15 - P1001 * P1000 * avscore_16
						- P0101 * P1000 * avscore_17 - P1101 * P1000 * avscore_18
						- P0011 * P1000 * avscore_19 - P1011 * P1000 * avscore_20
						- P0111 * P1000 * avscore_21;
			double avscore_7a = -avscore_7 * P0000 * P0100 - P1000 * P0100 * avscore_8
						+ P0100 * (1-P0100) * avscore_9 - P1100 * P0100 * avscore_10
						- P0010 * P0100 * avscore_11 - P1010 * P0100 * avscore_12
						- P0110 * P0100 * avscore_13 - P1110 * P0100 * avscore_14
						- P0001 * P0100 * avscore_15 - P1001 * P0100 * avscore_16
						- P0101 * P0100 * avscore_17 - P1101 * P0100 * avscore_18
						- P0011 * P0100 * avscore_19 - P1011 * P0100 * avscore_20
						- P0111 * P0100 * avscore_21;
			double avscore_8a = -avscore_7 * P0000 * P1100 - P1000 * P1100 * avscore_8
						- P0100 * P1100 * avscore_9 + P1100 * (1-P1100) * avscore_10
						- P0010 * P1100 * avscore_11 - P1010 * P1100 * avscore_12
						- P0110 * P1100 * avscore_13 - P1110 * P1100 * avscore_14
						- P0001 * P1100 * avscore_15 - P1001 * P1100 * avscore_16
						- P0101 * P1100 * avscore_17 - P1101 * P1100 * avscore_18
						- P0011 * P1100 * avscore_19 - P1011 * P1100 * avscore_20
						- P0111 * P1100 * avscore_21;
			double avscore_9a = -avscore_7 * P0000 * P0010 - P1000 * P0010 * avscore_8
						- P0100 * P0010 * avscore_9 - P1100 * P0010 * avscore_10
						+ P0010 * (1-P0010) * avscore_11 - P1010 * P0010 * avscore_12
						- P0110 * P0010 * avscore_13 - P1110 * P0010 * avscore_14
						- P0001 * P0010 * avscore_15 - P1001 * P0010 * avscore_16
						- P0101 * P0010 * avscore_17 - P1101 * P0010 * avscore_18
						- P0011 * P0010 * avscore_19 - P1011 * P0010 * avscore_20
						- P0111 * P0010 * avscore_21;
			double avscore_10a = -avscore_7 * P0000 * P1010 - P1000 * P1010 * avscore_8
						- P0100 * P1010 * avscore_9 - P1100 * P1010 * avscore_10
						- P0010 * P1010 * avscore_11 + P1010 * (1-P1010) * avscore_12
						- P0110 * P1010 * avscore_13 - P1110 * P1010 * avscore_14
						- P0001 * P1010 * avscore_15 - P1001 * P1010 * avscore_16
						- P0101 * P1010 * avscore_17 - P1101 * P1010 * avscore_18
						- P0011 * P1010 * avscore_19 - P1011 * P1010 * avscore_20
						- P0111 * P1010 * avscore_21;
			double avscore_11a = -avscore_7 * P0000 * P0110 - P1000 * P0110 * avscore_8
						- P0100 * P0110 * avscore_9 - P1100 * P0110 * avscore_10
						- P0010 * P0110 * avscore_11 - P1010 * P0110 * avscore_12
						+ P0110 * (1-P0110) * avscore_13 - P1110 * P0110 * avscore_14
						- P0001 * P0110 * avscore_15 - P1001 * P0110 * avscore_16
						- P0101 * P0110 * avscore_17 - P1101 * P0110 * avscore_18
						- P0011 * P0110 * avscore_19 - P1011 * P0110 * avscore_20
						- P0111 * P0110 * avscore_21;
			double avscore_12a = -avscore_7 * P0000 * P1110 - P1000 * P1110 * avscore_8
						- P0100 * P1110 * avscore_9 - P1100 * P1110 * avscore_10
						- P0010 * P1110 * avscore_11 - P1010 * P1110 * avscore_12
						- P0110 * P1110 * avscore_13 + P1110 * (1-P1110) * avscore_14
						- P0001 * P1110 * avscore_15 - P1001 * P1110 * avscore_16
						- P0101 * P1110 * avscore_17 - P1101 * P1110 * avscore_18
						- P0011 * P1110 * avscore_19 - P1011 * P1110 * avscore_20
						- P0111 * P1110 * avscore_21;
			double avscore_13a = -avscore_7 * P0000 * P0001 - P1000 * P0001 * avscore_8
						- P0100 * P0001 * avscore_9 - P1100 * P0001 * avscore_10
						- P0010 * P0001 * avscore_11 - P1010 * P0001 * avscore_12
						- P0110 * P0001 * avscore_13 - P1110 * P0001 * avscore_14
						+ P0001 * (1-P0001) * avscore_15 - P1001 * P0001 * avscore_16
						- P0101 * P0001 * avscore_17 - P1101 * P0001 * avscore_18
						- P0011 * P0001 * avscore_19 - P1011 * P0001 * avscore_20
						- P0111 * P0001 * avscore_21;
			double avscore_14a = -avscore_7 * P0000 * P1001 - P1000 * P1001 * avscore_8
						- P0100 * P1001 * avscore_9 - P1100 * P1001 * avscore_10
						- P0010 * P1001 * avscore_11 - P1010 * P1001 * avscore_12
						- P0110 * P1001 * avscore_13 - P1110 * P1001 * avscore_14
						- P0001 * P1001 * avscore_15 + P1001 * (1-P1001) * avscore_16
						- P0101 * P1001 * avscore_17 - P1101 * P1001 * avscore_18
						- P0011 * P1001 * avscore_19 - P1011 * P1001 * avscore_20
						- P0111 * P1001 * avscore_21;
			double avscore_15a = -avscore_7 * P0000 * P0101 - P1000 * P0101 * avscore_8
							- P0100 * P0101 * avscore_9 - P1100 * P0101 * avscore_10
							- P0010 * P0101 * avscore_11 - P1010 * P0101 * avscore_12
							- P0110 * P0101 * avscore_13 - P1110 * P0101 * avscore_14
							- P0001 * P0101 * avscore_15 - P1001 * P0101 * avscore_16
							+ P0101 * (1-P0101) * avscore_17 - P1101 * P1001 * avscore_18
							- P0011 * P0101 * avscore_19 - P1011 * P0101 * avscore_20
							- P0111 * P0101 * avscore_21;
			double avscore_16a = -avscore_7 * P0000 * P1101 - P1000 * P1101 * avscore_8
							- P0100 * P1101 * avscore_9 - P1100 * P1101 * avscore_10
							- P0010 * P1101 * avscore_11 - P1010 * P1101 * avscore_12
							- P0110 * P1101 * avscore_13 - P1110 * P1101 * avscore_14
							- P0001 * P1101 * avscore_15 - P1001 * P1101 * avscore_16
							- P0101 * P1101 * avscore_17 + P1101 * (1-P1101) * avscore_18
							- P0011 * P1101 * avscore_19 - P1011 * P1101 * avscore_20
							- P0111 * P1101 * avscore_21;
			double avscore_17a = -avscore_7 * P0000 * P0011 - P1000 * P0011 * avscore_8
							- P0100 * P0011 * avscore_9 - P1100 * P0011 * avscore_10
							- P0010 * P0011 * avscore_11 - P1010 * P0011 * avscore_12
							- P0110 * P0011 * avscore_13 - P1110 * P0011 * avscore_14
							- P0001 * P0011 * avscore_15 - P1001 * P0011 * avscore_16
							- P0101 * P0011 * avscore_17 - P1101 * P0011 * avscore_18
							+ P0011 * (1-P0011) * avscore_19 - P1011 * P0011 * avscore_20
							- P0111 * P0011 * avscore_21;
			double avscore_18a = -avscore_7 * P0000 * P1011 - P1000 * P1011 * avscore_8
							- P0100 * P1011 * avscore_9 - P1100 * P1011 * avscore_10
							- P0010 * P1011 * avscore_11 - P1010 * P1011 * avscore_12
							- P0110 * P1011 * avscore_13 - P1110 * P1011 * avscore_14
							- P0001 * P1011 * avscore_15 - P1001 * P1011 * avscore_16
							- P0101 * P1011 * avscore_17 - P1101 * P1011 * avscore_18
							- P0011 * P1011 * avscore_19 + P1011 * (1-P1011) * avscore_20
							- P0111 * P1011 * avscore_21;
			double avscore_19a = -avscore_7 * P0000 * P0111 - P1000 * P0111 * avscore_8
							- P0100 * P0111 * avscore_9 - P1100 * P0111 * avscore_10
							- P0010 * P0111 * avscore_11 - P1010 * P0111 * avscore_12
							- P0110 * P0111 * avscore_13 - P1110 * P0111 * avscore_14
							- P0001 * P0111 * avscore_15 - P1001 * P0111 * avscore_16
							- P0101 * P0111 * avscore_17 - P1101 * P0111 * avscore_18
							- P0011 * P0111 * avscore_19 - P1011 * P0111 * avscore_20
							+ P0111 * (1-P0111) * avscore_21;


			result1 -= result1a *  p_0 / p0min;
			result2 -= result2a *  p_1 / p1min;
			result3 -= result3a *  p_2 / p2min;
			result4 -= result4a *  p_3 / p3min;

			result[3+4 * k1+30] = (result4 / floglik);
			result[3+4 * k1+31] = (result1 / floglik) * V00;
			result[3+4 * k1+32] = (result2 / floglik) * V10;
			result[3+4 * k1+33] = (result3 / floglik) * V20;


			result[3+4 * k1+34] = (avscore_5a / floglik);
			result[3+4 * k1+35] = (avscore_6a / floglik);
			result[3+4 * k1+36] = (avscore_7a / floglik);
			result[3+4 * k1+38] = (avscore_8a / floglik);
			result[3+4 * k1+37] = (avscore_9a / floglik);
			result[3+4 * k1+39] = (avscore_10a / floglik);
			result[3+4 * k1+40] = (avscore_11a / floglik);
			result[3+4 * k1+41] = (avscore_12a / floglik);
			result[3+4 * k1+42] = (avscore_13a / floglik);
			result[3+4 * k1+43] = (avscore_14a / floglik);
			result[3+4 * k1+44] = (avscore_15a / floglik);
			result[3+4 * k1+46] = (avscore_16a / floglik);
			result[3+4 * k1+45] = (avscore_17a / floglik);
			result[3+4 * k1+47] = (avscore_18a / floglik);
			result[3+4 * k1+48] = (avscore_19a / floglik);

			int i_1 = 0;
			
			int hulp_k1 = 3 + 4 * k1 + 25;
			memcpy(result_0, result, sizeof(double) * hulp_k1); 
			result_0[hulp_k1 - 15] += result[hulp_k1];
			result_0[hulp_k1-14] += result[hulp_k1+1];
			result_0[hulp_k1-13] += result[hulp_k1+2];
			result_0[hulp_k1-12] += result[hulp_k1+3];
			result_0[hulp_k1-11] += result[hulp_k1+4];
			for(i=0;i<19;i++)
			{
				result_0[hulp_k1+i] = result[hulp_k1+5+i];
			}

			for(i=0;i<cp1;i++)
			{
				if (variables[i])
				{
					result_1[i_1] = result_0[i];
					i_1++;
				}
			}

			free(dfloglik1);
			free(dfloglik2);
			free(dfloglik3);
			free(dfloglik4);
			free(dfloglik5);
			free(dfloglik6);
			free(dfloglik7);
			free(dfloglik8);
			free(dfloglik9);
			free(dfloglik10);
			free(dfloglik11);
			free(dfloglik12);
			free(dfloglik13);
			free(dfloglik14);
			free(dfloglik15);
			free(dfloglik16);
	    	free(psi1_array);
	    	free(psi2_array);
	    	free(psi3_array);
	    	free(psi1a_array);
	    	free(psi2a_array);
	    	free(psi3a_array);

	    	free(hulp_x_g2);
	    	free(x_g2);

	    	free(result);
	    	free(result_0);


			return result_1;
		}

	void multiply_to_range(double* arraylist, double scalar, int k)
	{
		int i;
		for(i=0;i<k;i++)
		{
			arraylist[i] = scalar * arraylist[i];
		}
	}

	double* dFLoglik10a(double* T_1_a, double* T_1_b, double* D_1_a, double* D_1_b, double* D_2,
			double* T_2, double* H1, double* H2, double* x,
			double V0, double V1, double V2, double V3,
			int u_spells, int e_spells) {

		int k1 = x_size;
		int k_floglik = 3 + 4 * k1 + 34;
		double* result = zeros(k_floglik);
		int i;

		int k2 = max(u_spells, e_spells);
		for(i=0;i<k2;i++) {
			double* dfloglik = dFLoglik1(T_1_a[i], T_1_b[i], D_1_a[i], D_1_b[i], D_2[i], T_2[i], H1[i], H2[i], x,
					exp(V0), exp(V1), exp(V2), i);

			double* dfloglika = zeros(k_floglik);

			dfloglika[0] = dfloglik[0];
			dfloglika[1] = dfloglik[1];
			dfloglika[2] = dfloglik[2];

			memcpy(&dfloglika[3 + k1], &dfloglik[3], (3 * k1 + 33) * sizeof(double));

			double* dfloglik2 = dFLoglik2(H1[i], H2[i], x, V3, k1, T_1_a[i], T_2[i]);
			double* dfloglik1 = add(dfloglika, dfloglik2, k_floglik);


			add_to(result, dfloglik1, k_floglik);

			delete [] dfloglik;
			delete [] dfloglik2;
			delete [] dfloglika;
			delete [] dfloglik1;
		}

		return result;
	}

	double* dFLoglik2(double H1, double H2, double* x1, double v, int k1, double t1, double t2)
	{


			int i;
			double* result = zeros(x_size+1);
			double hulp = internal_product(x1, Beta0, x_size) + v;
			NormalDistribution normal(0,1);
			double hulp1 = normal.cumulativeProbability(hulp);
			double hulp2 = normal.Density(hulp);
			if (t1 > 0)
			{
				double h2 = H1;
				double expression1 = h2 > 0 ? (h2 * hulp2 / (hulp1)) : 0;
				double expression2 = h2 < 1? -((1-h2) * hulp2 / (1-hulp1)): 0;

				double* hulp_x = (double*)malloc(sizeof(double) * (x_size+1));
				int j;
				for(j=0;j<x_size;j++)
					hulp_x[j] =  (expression1 + expression2) * x1[j];
				hulp_x[x_size] = (expression1 + expression2);
				if (!((hulp1 == 0) || (hulp1==1)))
					add_to(result, hulp_x, x_size+1);
				free(hulp_x);
			}

			if (t2 > 0)
			{
				double h2 = H2;
				double expression1 = h2 > 0? (h2 * hulp2 / (hulp1)): 0;
				double expression2 = h2 < 1? -((1-h2) * hulp2 / (1-hulp1)): 0;

				double* hulp_x = new double[x_size+1];
				int j;
				for(j=0;j<x_size;j++)
					hulp_x[j] =  (expression1 + expression2) * x1[j];
				hulp_x[x_size] = (expression1 + expression2);
				if (!((hulp1 == 0) || (hulp1==1)))
					add_to(result, hulp_x, x_size+1);
				delete [] hulp_x;
			}

			double* result1 = zeros(3 + 4 * k1 + 34);
			memcpy(&result1[3], result, x_size * sizeof(double));
			result1[3 + 4 * k1 + 33] = result[x_size];
			delete [] result;

			return result1;
	}

	double* dFLoglik1(double T_1_a, double T_1_b, double D_1_a, double D_1_b, double D_2,
			double T_2, double H1, double H2, double* x, double V0, double V1, double V2, int i)
	{
		int k1 = x_size;

		if ((T_1_a < 0) && (T_2 < 0))
			return zeros(3+3 * k1+33);

		if ((T_1_a > 0) && (T_2 > 0))
			return dFLoglik1a(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, H1, H2, x, V0, V1, V2, i);

		if (T_2 > 0)
			return dFLoglik1b(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, H1, H2, x, V0, V1, V2, i);

		return dFLoglik1c(T_1_a, T_1_b, D_1_a, D_1_b, D_2, T_2, H1, H2, x, V0, V1, V2, i);
	}

	double* dFLoglik1a(double T_1_a, double T_1_b, double D_1_a, double D_1_b, double D_2,
			double T_2, double H1, double H2, double* x_g2, double V0, double V1, double V2
			, int index)
	{
		int k1 = x_size;
		double lambda1 = lambda1_array[index] * V0;
		double lambda2 = lambda2_array[index] * V1;
		double lambda3 = lambda3_array[index] * V2;

		double theta1 =  theta1_array[index] * V0;
		double theta2 =  theta2_array[index] * V1;
		double theta3 =  theta3_array[index] * V2;

		double dpart1 = (1-D_1_a  - lambda1) * H1;
		double dpart2 = (1-D_1_b - lambda2) * H1;
		double dpart3 = (1-D_2 - lambda3) * H2;

		double* mult_hulp1 = multiply(hulp1_array[index], theta1, 20);
		double* mult_hulp2 = multiply(hulp3_array[index], theta2, 20);
		double* mult_hulp3 = multiply(hulp5_array[index], theta3, 20);

		double* dpart1_2 = multiply(hulp2_array[index], 1-D_1_a, 20);
		subtract_to(dpart1_2, mult_hulp1, 20);
		multiply_to(dpart1_2, H1 / psi1a_array[index], 20);
		double* dpart2_2 = multiply(hulp4_array[index], 1-D_1_b, 20);
		subtract_to(dpart2_2, mult_hulp2, 20);
		multiply_to(dpart2_2, H1 / psi2a_array[index], 20);
		double* dpart3_2 = multiply(hulp6_array[index], 1-D_2, 20);
		subtract_to(dpart3_2, mult_hulp3, 20);
		multiply_to(dpart3_2, H2 / psi3a_array[index], 20);

		double* dpart1_3 = multiply(hulp2_array[index], 1-D_1_a, 20);
		subtract_to(dpart1_3, mult_hulp1, 20);
		multiply_to(dpart1_3, (1-H1) / psi1a_array[index], 20);
		double* dpart2_3 = multiply(hulp4_array[index], 1-D_1_b, 20);
		subtract_to(dpart2_3, mult_hulp2, 20);
		multiply_to(dpart2_3, (1-H1) / psi2a_array[index], 20);
		double* dpart3_3 = multiply(hulp6_array[index], 1-D_2, 20);
		subtract_to(dpart3_3, mult_hulp3, 20);
		multiply_to(dpart3_3, (1-H2) / psi3a_array[index], 20);

		free(mult_hulp1);
		free(mult_hulp2);
		free(mult_hulp3);


		double* dpart1_1 = multiply(x_g2, (1-D_1_a  - lambda1), x_size);
		double* dpart2_1 = multiply(x_g2, (1-D_1_b  - lambda2), x_size);
		double* dpart3_1 = multiply(x_g2, (1-D_2  - lambda3), x_size);


		double* result = (double*)malloc(sizeof(double) * (3 + 3 * k1 + 33));
		result[0] = dpart1;
		result[1] = dpart2;
		result[2] = dpart3;

		int i;
		for(i=0;i<x_size;i++)
		{
			result[3 + i] = dpart1_1[i];
			result[3 + k1 + i] = dpart2_1[i];
			result[3 + 2 * k1 + i] = dpart3_1[i];
		}

		double* dpart1_2b = (double*)malloc(sizeof(double) * 5);
		double* dpart2_2b = (double*)malloc(sizeof(double) * 5);
		double* dpart3_2b = (double*)malloc(sizeof(double) * 5);
		double* dpart1_3b = (double*)malloc(sizeof(double) * 5);
		double* dpart2_3b = (double*)malloc(sizeof(double) * 5);
		double* dpart3_3b = (double*)malloc(sizeof(double) * 5);

		for(i=0;i<4;i++)
		{
			double dpart1_2a = (internal_product_range(dpart1_2, a13[i], i * 4, i * 4 + 3)
						+ internal_product_range(dpart1_2, a14[i], (i+1)*4, (i+1)*4 + 3)) * Psi1a[i];

			double dpart2_2a = (internal_product_range(dpart2_2, a13[i], i * 4, i * 4 + 3)
					+ internal_product_range(dpart2_2, a14[i], (i+1)*4, (i+1)*4 + 3)) * Psi2a[i];
			double dpart3_2a = (internal_product_range(dpart3_2, a13[i], i * 4, i * 4 + 3)
					+ internal_product_range(dpart3_2, a14[i], (i+1)*4, (i+1)*4 + 3)) * Psi3a[i];
			double dpart1_3a = (internal_product_range(dpart1_3, a13[i], i * 4, i * 4 + 3)
					+ internal_product_range(dpart1_3, a14[i], (i+1)*4, (i+1)*4 + 3)) * Psi1b[i];
			double dpart2_3a = (internal_product_range(dpart2_3, a13[i], i * 4, i * 4 + 3)
				+ internal_product_range(dpart2_3, a14[i], (i+1)*4, (i+1)*4 + 3)) * Psi2b[i];
			double dpart3_3a = (internal_product_range(dpart3_3, a13[i],  i * 4, i * 4 + 3)
				+ internal_product_range(dpart3_3, a14[i],  (i+1)*4, (i+1)*4 + 3)) * Psi3b[i];

			dpart1_2b[i] = dpart1_2a;
			dpart2_2b[i] = dpart2_2a;
			dpart3_2b[i] = dpart3_2a;
			dpart1_3b[i] = dpart1_3a;
			dpart2_3b[i] = dpart2_3a;
			dpart3_3b[i] = dpart3_3a;
		}


		double dpart1_2a = (internal_product_range(dpart1_2, a13[4], 16, 19)) * Psi1a[4];
		dpart1_2b[4] = dpart1_2a;
		double dpart2_2a = (internal_product_range(dpart2_2, a13[4], 16, 19)) * Psi2a[4];
		dpart2_2b[4] = dpart2_2a;
		double dpart3_2a = (internal_product_range(dpart3_2, a13[4], 16, 19)) * Psi3a[4];
		dpart3_2b[4] = dpart3_2a;
		double dpart1_3a = (internal_product_range(dpart1_3, a13[4], 16, 19)) * Psi1b[4];
		dpart1_3b[4] = dpart1_3a;
		double dpart2_3a = (internal_product_range(dpart2_3, a13[4], 16, 19)) * Psi2b[4];
		dpart2_3b[4] = dpart2_3a;
		double dpart3_3a = (internal_product_range(dpart3_3, a13[4], 16, 19)) * Psi3b[4];
		dpart3_3b[4] = dpart3_3a;

		for(i=0;i<5;i++)
		{
			result[3 + 3 * k1 + i] = dpart1_2b[i];
			result[3 + 3 * k1 + 5 + i] = dpart2_2b[i];
			result[3 + 3 * k1 + 10 + i] = dpart3_2b[i];
			result[3 + 3 * k1 + 15 + i] = dpart1_3b[i];
			result[3 + 3 * k1 + 20 + i] = dpart2_3b[i];
			result[3 + 3 * k1 + 25 + i] = dpart3_3b[i];
		}


		double dpart4 = 1-D_1_a - lambda1;
		double dpart5 = 1-D_1_b - lambda2;
		double dpart6 = 1 - D_2 - lambda3;


		result[3 + 3 * k1 + 30] = dpart4;
		result[3 + 3 * k1 + 31] = dpart5;
		result[3 + 3 * k1 + 32] = dpart6;

		free(dpart1_1);
		free(dpart2_1);
		free(dpart3_1);
		free(dpart1_2);
		free(dpart2_2);
		free(dpart3_2);
		free(dpart1_3);
		free(dpart2_3);
		free(dpart3_3);
		free(dpart1_2b);
		free(dpart2_2b);
		free(dpart3_2b);
		free(dpart1_3b);
		free(dpart2_3b);
		free(dpart3_3b);

		return result;
	}

	double* dFLoglik1c(double T_1_a, double T_1_b, double D_1_a, double D_1_b, double D_2,
			double T_2, double H1, double H2, double* x, double V0, double V1, double V2
			, int index)
	{
		int k1 = x_size;
		double lambda1 = lambda1_array[index] * V0;
		double lambda2 = lambda2_array[index] * V1;

		double theta1 =  theta1_array[index] * V0;
		double theta2 =  theta2_array[index] * V1;

		double dpart1 = (1-D_1_a  - lambda1) * H1;
		double dpart2 = (1-D_1_b - lambda2) * H1;

		double* mult_hulp1 = multiply(hulp1_array[index], theta1, 20);
		double* mult_hulp2 = multiply(hulp3_array[index], theta2, 20);

		double* dpart1_2 = multiply(hulp2_array[index], 1-D_1_a, 20);
		subtract_to(dpart1_2, mult_hulp1, 20);
		multiply_to(dpart1_2, H1 / psi1a_array[index], 20);
		double* dpart2_2 = multiply(hulp4_array[index], 1-D_1_b, 20);
		subtract_to(dpart2_2, mult_hulp2, 20);
		multiply_to(dpart2_2, H1 / psi2a_array[index], 20);

		double* dpart1_3 = multiply(hulp2_array[index], 1-D_1_a, 20);
		subtract_to(dpart1_3, mult_hulp1, 20);
		multiply_to(dpart1_3, (1-H1) / psi1a_array[index], 20);
		double* dpart2_3 = multiply(hulp4_array[index], 1-D_1_b, 20);
		subtract_to(dpart2_3, mult_hulp2, 20);
		multiply_to(dpart2_3, (1-H1) / psi2a_array[index], 20);

		free(mult_hulp1);
		free(mult_hulp2);


		double* dpart1_1 = multiply(x, (1-D_1_a  - lambda1), x_size);
		double* dpart2_1 = multiply(x, (1-D_1_b  - lambda2), x_size);


		double* result = (double*)malloc(sizeof(double) * (3 + 3 * k1 + 33));
		result[0] = dpart1;
		result[1] = dpart2;
		result[2] = 0;

		int i;
		for(i=0;i<x_size;i++)
		{
			result[3 + i] = dpart1_1[i];
			result[3 + k1 + i] = dpart2_1[i];
			result[3 + 2 * k1 + i] = 0;
		}

		double* dpart1_2b = (double*)malloc(sizeof(double) * 5);
		double* dpart2_2b = (double*)malloc(sizeof(double) * 5);
		double* dpart1_3b = (double*)malloc(sizeof(double) * 5);
		double* dpart2_3b = (double*)malloc(sizeof(double) * 5);

		for(i=0;i<4;i++)
		{
			double dpart1_2a = (internal_product_range(dpart1_2, a13[i], i * 4, i * 4 + 3)
						+ internal_product_range(dpart1_2, a14[i], (i+1)*4, (i+1)*4 + 3)) * Psi1a[i];

			double dpart2_2a = (internal_product_range(dpart2_2, a13[i], i * 4, i * 4 + 3)
					+ internal_product_range(dpart2_2, a14[i], (i+1)*4, (i+1)*4 + 3)) * Psi2a[i];
			double dpart1_3a = (internal_product_range(dpart1_3, a13[i], i * 4, i * 4 + 3)
					+ internal_product_range(dpart1_3, a14[i], (i+1)*4, (i+1)*4 + 3)) * Psi1b[i];
			double dpart2_3a = (internal_product_range(dpart2_3, a13[i], i * 4, i * 4 + 3)
				+ internal_product_range(dpart2_3, a14[i], (i+1)*4, (i+1)*4 + 3)) * Psi2b[i];

			dpart1_2b[i] = dpart1_2a;
			dpart2_2b[i] = dpart2_2a;
			dpart1_3b[i] = dpart1_3a;
			dpart2_3b[i] = dpart2_3a;
		}


		double dpart1_2a = (internal_product_range(dpart1_2, a13[4], 16, 19)) * Psi1a[4];
		dpart1_2b[4] = dpart1_2a;
		double dpart2_2a = (internal_product_range(dpart2_2, a13[4], 16, 19)) * Psi2a[4];
		dpart2_2b[4] = dpart2_2a;
		double dpart1_3a = (internal_product_range(dpart1_3, a13[4], 16, 19)) * Psi1b[4];
		dpart1_3b[4] = dpart1_3a;
		double dpart2_3a = (internal_product_range(dpart2_3, a13[4], 16, 19)) * Psi2b[4];
		dpart2_3b[4] = dpart2_3a;

		for(i=0;i<5;i++)
		{
			result[3 + 3 * k1 + i] = dpart1_2b[i];
			result[3 + 3 * k1 + 5 + i] = dpart2_2b[i];
			result[3 + 3 * k1 + 10 + i] = 0;
			result[3 + 3 * k1 + 15 + i] = dpart1_3b[i];
			result[3 + 3 * k1 + 20 + i] = dpart2_3b[i];
			result[3 + 3 * k1 + 25 + i] = 0;
		}


		double dpart4 = 1-D_1_a - lambda1;
		double dpart5 = 1-D_1_b - lambda2;

		result[3 + 3 * k1 + 30] = dpart4;
		result[3 + 3 * k1 + 31] = dpart5;
		result[3 + 3 * k1 + 32] = 0;

		free(dpart1_1);
		free(dpart2_1);
		free(dpart1_2);
		free(dpart2_2);
		free(dpart1_3);
		free(dpart2_3);
		free(dpart1_2b);
		free(dpart2_2b);
		free(dpart1_3b);
		free(dpart2_3b);

		return result;
	}

	double* dFLoglik1b(double T_1_a, double T_1_b, double D_1_a, double D_1_b, double D_2,
				double T_2, double H1, double H2, double* x, double V0, double V1, double V2
				, int index)
	{
		int k1 = x_size;
		double lambda3 = lambda3_array[index] * V2;
		double theta3 =  theta3_array[index] * V2;
		double dpart3 = (1-D_2 - lambda3) * H2;
		double* mult_hulp3 = multiply(hulp5_array[index], theta3, 20);

		double* dpart3_2 = multiply(hulp6_array[index], 1-D_2, 20);
		subtract_to(dpart3_2, mult_hulp3, 20);
		multiply_to(dpart3_2, H2 / psi3a_array[index], 20);

		double* dpart3_3 = multiply(hulp6_array[index], 1-D_2, 20);
		subtract_to(dpart3_3, mult_hulp3, 20);
		multiply_to(dpart3_3, (1-H2) / psi3a_array[index], 20);
		free(mult_hulp3);

		double* dpart3_1 = multiply(x, (1-D_2  - lambda3), x_size);

		double* result = (double*)malloc(sizeof(double) * (3 + 3 * k1 + 33));
		result[0] = 0;
		result[1] = 0;
		result[2] = dpart3;

		int i;
		for(i=0;i<x_size;i++)
		{
			result[3 + i] = 0;
			result[3 + k1 + i] = 0;
			result[3 + 2 * k1 + i] = dpart3_1[i];
		}

		double* dpart3_2b = (double*)malloc(sizeof(double) * 5);
		double* dpart3_3b = (double*)malloc(sizeof(double) * 5);

		for(i=0;i<4;i++)
		{
			double dpart3_2a = (internal_product_range(dpart3_2, a13[i], i * 4, i * 4 + 3)
					+ internal_product_range(dpart3_2, a14[i], (i+1)*4, (i+1)*4 + 3)) * Psi3a[i];
			double dpart3_3a = (internal_product_range(dpart3_3, a13[i],  i * 4, i * 4 + 3)
				+ internal_product_range(dpart3_3, a14[i],  (i+1)*4, (i+1)*4 + 3)) * Psi3b[i];

			dpart3_2b[i] = dpart3_2a;
			dpart3_3b[i] = dpart3_3a;
		}

		double dpart3_2a = (internal_product_range(dpart3_2, a13[4], 16, 19)) * Psi3a[4];
		dpart3_2b[4] = dpart3_2a;
		double dpart3_3a = (internal_product_range(dpart3_3, a13[4], 16, 19)) * Psi3b[4];
		dpart3_3b[4] = dpart3_3a;

		for(i=0;i<5;i++)
		{
			result[3 + 3 * k1 + i] = 0;
			result[3 + 3 * k1 + 5 + i] = 0;
			result[3 + 3 * k1 + 10 + i] = dpart3_2b[i];
			result[3 + 3 * k1 + 15 + i] = 0;
			result[3 + 3 * k1 + 20 + i] = 0;
			result[3 + 3 * k1 + 25 + i] = dpart3_3b[i];
		}


		double dpart6 = 1 - D_2 - lambda3;

		result[3 + 3 * k1 + 30] = 0;
		result[3 + 3 * k1 + 31] = 0;
		result[3 + 3 * k1 + 32] = dpart6;

		free(dpart3_1);
		free(dpart3_2);
		free(dpart3_3);
		free(dpart3_2b);
		free(dpart3_3b);
		return result;
	}

	protected : double internal_product_range(double* arraylist, double* arraylist1, int begin, int end)
	{
		int i;
		double output = 0;

		for(i=begin;i<=end;i++)
		{
			output += arraylist[i] * arraylist1[i-begin];
			
		}

		return output;
	}

	private : void Finalize()
	{
		int i;
		for(i=0;i<c_all_n;i++)
		{
			free(theta_1_1a[i]);
			free(theta_1_2a[i]);
			free(theta_1_3a[i]);
			free(theta_1_1b[i]);
			free(theta_1_2b[i]);
			free(theta_1_3b[i]);
		}
		free(theta_1_1a);
		free(theta_1_2a);
		free(theta_1_3a);
		free(theta_1_1b);
		free(theta_1_2b);
		free(theta_1_3b);
	}

	private : void Initialize(double* variable_list)
	{

		int i;
		int k1 = x_size;

		double* variable_list1 = (double*)malloc(sizeof(double) * cp1);

		int i_1 = 0;
		for(i=0;i<cp1;i++)
		{
			if (variables[i])
			{
				variable_list1[i] = variable_list[i_1];
				i_1++;
			}
			else
				variable_list1[i] = vP_Theta[i];
		}
		
		Gamma1 = variable_list1[0];
		Gamma2 = variable_list1[1];
		Gamma3 = variable_list1[2];

		int index = 0;
		
		for(i=3;i<=3+k1-1;i++)
		{
			Beta0[index] = variable_list1[i];
			Beta1[index] = variable_list1[i+k1];
			Beta2[index] = variable_list1[i+2*k1];
			Beta3[index] = variable_list1[i+3 * k1];
			
			index++;
		}

		index = 0;
		for(i=3+4*k1;i<=3+4 * k1+4;i++)
		{
			Psi1a[index] = exp(variable_list1[i]);
			Psi2a[index] = exp(variable_list1[i + 5]);
			Psi3a[index] = exp(variable_list1[i + 10]);
			Psi1b[index] = exp(variable_list1[i + 15]);
			Psi2b[index] = exp(variable_list1[i + 20]);
			Psi3b[index] = exp(variable_list1[i + 10]);
			index++;
		}

		V30 = variable_list1[3 + 4 * k1 + 25];
		V00 = exp(variable_list1[3 + 4 * k1 + 26]);
		V10 = exp(variable_list1[3 + 4 * k1 + 27]);
		V20 = exp(variable_list1[3 + 4 * k1 + 28]);
		vector<double> p;
		double p2 = 0;

		for(i=3+4*k1+29;i<=3+4 * k1+43;i++)
		{
			double p1 = exp(variable_list1[i]);
			p.push_back(p1);
			p2 += p1;
		}

		P0000 = p[0] / (1 + p2);
		P1000 = p[1] / (1 + p2);
		P0100 = p[2] / (1 + p2);
		P0010 = p[3] / (1 + p2);
		P1100 = p[4] / (1 + p2);
		P1010 = p[5] / (1 + p2);
		P0110 = p[6] / (1 + p2);
		P1110 = p[7] / (1 + p2);
		P0001 = p[8] / (1 + p2);
		P1001 = p[9] / (1 + p2);
		P0101 = p[10] / (1 + p2);
		P0011 = p[11] / (1 + p2);
		P1101 = p[12] / (1 + p2);
		P1011 = p[13] / (1 + p2);
		P0111 = p[14] / (1 + p2);
		P1111 = 1  / (1 + p2);

		p_0 = P0000+P0100+P0010+P0110 + P0001+P0101+P0011+P0111;
		

	  	V01 = (-p_0 * V00) / (1-p_0);
		p_1 = P0000+P1000+P0010+P1010+ P0001+P1001+P0011+P1011;
	  	V11 = (-p_1 * V10) / (1-p_1);
		p_2 = P0000+P1000+P0100+P1100+P0001+P1001+P0101+P1101;
	  	V21 = (-p_2 * V20) / (1-p_2);
	  	p_3 = P0000 + P1000 + P0100 + P0010 + P1100 + P1010 + P0110 + P1110;
	  	V31 = (-p_3 * V30) / (1-p_3);


		p0min = 1- p_0;
		p1min = 1 - p_1;
		p2min = 1 - p_2;
		p3min = 1 - p_3;

		factor1 = ((-V00 )/ (p0min * p0min));
		factor2 = ((-V10 )/ (p1min * p1min));
		factor3 = ((-V20 )/ (p2min * p2min));
		factor4 = ((-V30 )/ (p3min * p3min));
		
	  	theta_1_1a = BerekenC(Psi1a);
	  	theta_1_2a = BerekenC(Psi2a);
	  	theta_1_3a = BerekenC(Psi3a);
	  	theta_1_1b = BerekenC(Psi1b);
	  	theta_1_2b = BerekenC(Psi2b);
	  	theta_1_3b = BerekenC(Psi3b);

		beta1_a[0] = Gamma1;
		memcpy(&beta1_a[1], Beta1, k1 * sizeof(double));

		beta2_a[0] = Gamma2;
		memcpy(&beta2_a[1], Beta2, k1 * sizeof(double));

		beta3_a[0] = Gamma3;
		memcpy(&beta3_a[1], Beta3, k1 * sizeof(double));

		free(variable_list1);
	}

	double* multiply_array(double a[4][4], double b[4], int cp)
	{
		int i;
		double* result1 = (double*)malloc(sizeof(double) * c_all_n);;

		for(i=0;i<cp;i++)
		{
			int j;
			double result = 0;
			for(j=0;j<cp;j++)
			{
				result += a[i][j] * b[j];
			}
			result1[i] = result;
		}
		return result1;
	}

	double** BerekenC(double* psi_all)
	{
		double b1[4] = {1., 0., psi_all[0], 0. };
		double b2[4] = {psi_all[0], 0., psi_all[1], 0. };
		double b3[4] = {psi_all[1], 0., psi_all[2], 0. };
		double b4[4] = {psi_all[2], 0., psi_all[3], 0. };
		double b5[4] = {psi_all[3], 0., psi_all[4], 0. };


	    double* b1a = multiply_array(a1a, b1, 4);
	    double* b2a = multiply_array(a2a, b2, 4);
	    double* b3a = multiply_array(a3a, b3, 4);
	    double* b4a = multiply_array(a4a, b4, 4);
	    double* b5a = multiply_array(a5a, b5, 4);

		double** theta1 = (double**)malloc(sizeof(double*) * c_all_n);

		theta1[0] = b1a;
		theta1[1] = b2a;
		theta1[2] = b3a;
		theta1[3] = b4a;
		theta1[4] = b5a;

		return theta1;
	}


};

#endif
