//============================================================================
// Name        : cpb_1.cpp
// Author      : Aico van Vuuren, University of Gothenburg
// Version     : September, 2nd 2016.
// Copyright   : Your copyright notice
// Description : Hello World in C++, Ansi-style
//============================================================================

#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include "loadmat.cpp"
#include "IndirectEstimation.cpp"
#include "NumJacobian.cpp"
#include <mpi.h>
#include "maximize.cpp"
#include <stdlib.h>
#undef MAXN
#define MAXN 140082
#undef MAX_SPELLS
#define MAX_SPELLS 10
#undef INTERMED_STRING
#define INTERMED_STRING "param_intermed23klein.txt"
#undef PARAM_STRING
#define PARAM_STRING "param_start.txt"

using namespace std;
	

void do_condition(char* argv, char* argv1, string* directory, int* n,
				int* k, string* intermed_string, string* param_string, string* avscore_string)
{
	string hulp = argv;
	if (hulp == "-d")
	{
		directory[0] = argv1;
		return;
	}

	if (hulp == "-n")
	{
		int hulp = atoi(argv1);
		if (hulp < MAXN)
		{
			n[0] = hulp;
		}
		return;
	}

	if (hulp == "-k")
	{
		int hulp = atoi(argv1);
		if (hulp < MAX_SPELLS)
		{
			k[0] = hulp;
		}
		return;
	}

	if (hulp == "-i")
	{
		intermed_string[0] = argv1;

		return;
	}

	if (hulp == "-p")
	{
		param_string[0] = argv1;

		return;
	}
	
	if (hulp == "-a")
	{
		avscore_string[0] = argv1;
		return;
	}

	throw RuntimeException("Argument not in list");
}

void handle_arguments(int argc, char *argv[], string* directory,
		int* n, int* k, string* intermed_string, string* param_string, string* avscore_string)
{
	if (argc >= 2)
	{
		int i;
		for(i=1;i<argc;i+=2)
		{
			if (argc != i+1)
			{
				try {
					do_condition(argv[i], argv[i+1], directory, n, k, intermed_string, param_string, avscore_string);
				}
				catch (RuntimeException &e)
				{
					throw RuntimeException("Invalid arguments");
				}
			}
			else
				throw RuntimeException("Invalid arguments");
		}
	}
	return;
}

int main(int argc, char *argv[]) {

	
	int numprocs, myid, rc;
	MPI_Status status;
	rc = MPI_Init(&argc, &argv);
	rc = MPI_Comm_size(MPI_COMM_WORLD, &numprocs);
	rc = MPI_Comm_rank(MPI_COMM_WORLD, &myid);
	
	//double Mu = 7.403476160945;
	//double Sigma = 1.089868;
	double Rho = 0.00246627;


	int n_size = MAXN;
	int k = 10;
	int cp1;
	LoadData load;
	string intermed_string = INTERMED_STRING;
	string param_string = PARAM_STRING;
	string directory = "";
	string avscore_string = "";
	mt19937 mt;
	try {
		handle_arguments(argc, argv, &directory, &n_size, &k, &intermed_string, &param_string, &avscore_string);
	}
	catch (RuntimeException &e)
	{
		if (myid == 0)
		{
			cout << "Usage: " << argv[0] << " [-d, -n, -k, -i, -p] command parameters" << endl;
			cout << "\t-d directory \t" << "Directory where data is stored" << endl;
			cout << "\t-n # \t" << "Number of observations to be used" << endl;
			cout << "\t-k # \t" << "Number of spells to be used" << endl;
			cout << "\t-i filename1 \t" << "File for intermediate parameters" << endl;
			cout << "\t-p filename2 \t" << "File for starting parameters" << endl;

			cout << endl;
		}
		rc = MPI_Finalize();
		return 0;
	}

	if (myid == 0)
	{
		cout << "Number of processors in use: " << numprocs << endl;
		cout << "Number of observations to be used: " << n_size << endl;
		cout << "Number of spells to be used: " << k << endl;
		cout << "Intermediate parameters to be stored in: " << intermed_string << endl;
	}


	double* vP1;
	try {
		vP1 = load.LoadTxt_vector(param_string);
	}
	catch (IOException &e)
	{
		if (myid == 0)
			cerr << "File not found: " << e.filename << endl;
		rc = MPI_Finalize();
		return 0;
	}

	cp1 = load.m;
	int i;

	double* vP_Theta;

	int x_size, cp;
	try {
		vP_Theta = load.LoadTxt_vector(directory + "vp_theta.txt");
		cp = load.m;
	}
	catch (IOException &e)
	{
		if (myid == 0)
			cerr << "File not found: " << directory + e.filename << endl;
		rc = MPI_Finalize();
		return 0;
	}

	IndirectEstimation* indirect;
	
	bool* variables = (bool*)malloc(cp * sizeof(bool));
	double* variables1 = (double*)malloc(cp * sizeof(double));


	for(i=0;i<cp;i++)
	{				
		if (vP_Theta[i] > -8)
		{
			variables[i] = true;
			variables1[i] = 1;
		}
		else
		{
			variables[i] = false;
			variables1[i] = 0;
		}	
	}
	
	SaveData save;

	save.SaveTxt_vector("variables.txt", variables1, cp);

	try {
		indirect = new IndirectEstimation(Rho, n_size, k, cp1, variables, cp, directory, myid, numprocs, intermed_string, status);

		if (!(myid == 0))
			indirect->Set_Print(0);
	}
	catch (IOException &e)
	{
		if (myid == 0)
			cerr << "File not found: " << e.filename << endl;
		rc = MPI_Finalize();
		return 0;
	}

	if (avscore_string.compare(""))
	{
		double** avscore = load.LoadTxt("avscore.txt");
		indirect->Set_MinvHess(avscore);
	}	
	
	double adT = 5;

	double* hi = new double[cp1];
	double* lo = new double[cp1];
	double* vm = Maximize::zeros(cp1);

	for(i=0;i<cp1;i++)
	{
		hi[i] = vP1[i] + 0.5;
		lo[i] = vP1[i] - 0.5;
	}
	

	indirect->Set_s_Hi(hi);
	indirect->Set_s_Lo(lo);
	if (!(myid == 0))
		indirect->Set_Print_SAN(0);
	else
		indirect->Set_Print_SAN(1);

	indirect->Set_MaxControl(1,1);
	
	try {
		indirect->MaxBFGS(vP1);
	}
	catch (RuntimeException &e) {
		if (myid == 0)
			cout << e.ExceptionText << endl;
		
		rc = MPI_Finalize();
		return 0;
	}
	
	rc = MPI_Finalize();
	return 0;
		 
}
