/*
 * NumJacobian.cpp
 *
 *  Created on: Jul 15, 2013
 *      Author: aico
 */
#ifndef NUMJAC_INCLUDED
#define NUMJAC_INCLUDED

#include "savemat.cpp"
#include "maximize.cpp"
#include <cmath>

class NumJacobian {

	int cu;
	protected : double SQRT_EPS;        /* appr. square root of machine precision */
	protected : double DIFF_EPS; /* Rice's formula: log(DIFF_EPS)=log(MACH_EPS)/2 */
	public : double  DIFF_EPS1; /* Rice's formula: log(DIFF_EPS)=log(MACH_EPS)/3 */
	protected:  double  DIFF_EPS2; /* Rice's formula: log(DIFF_EPS)=log(MACH_EPS)/4 */


	public: NumJacobian()
	{
		this->cu = 0;
		SQRT_EPS =1E-8;        /* appr. square root of machine precision */
		DIFF_EPS =1E-8; /* Rice's formula: log(DIFF_EPS)=log(MACH_EPS)/2 */
		DIFF_EPS1=5E-6; /* Rice's formula: log(DIFF_EPS)=log(MACH_EPS)/3 */
		DIFF_EPS2=1E-4; /* Rice's formula: log(DIFF_EPS)=log(MACH_EPS)/4 */
	}


	public: virtual ~NumJacobian(){
	}

	public: virtual void MultivariateFunction(double* f, double* variable_list, int n_size) throw(RuntimeException) = 0;


	private : double dFiniteDiff0(double x)
	{
	    return max( (fabs(x) + SQRT_EPS) * SQRT_EPS, DIFF_EPS);
	}

	public : double** do_NumJacobian(double* vU, int n_size, int cu, bool fCentral)
	{

		this->cu = cu;
	    int i;
	    double p, h, hi;
	    double* fp = (double*)malloc(sizeof(double*) * n_size);
	    double* fm = (double*)malloc(sizeof(double*) * n_size);
	    double* f0 = (double*)malloc(sizeof(double*) * n_size);
	    double** mj = (double**)malloc(sizeof(double*) * n_size);
	    
	    int j;
	    for(j=0;j<n_size;j++)
	    {
	    	mj[j] = Maximize::zeros(cu);//(double*)malloc(sizeof(double) * cu);
	    }
	    
		/*SaveData save;
				try {
					save.SaveTxt("fscore_intermed.txt", mj, n_size, cu);
				}
				catch (IOException &e) {
					cerr << "Could not write to " << e.filename;
				}
	    cout << cu << endl;
	    exit(-1);
*/
		bool fleft, fright;

		MultivariateFunction(f0, vU, n_size);		// assume always possible	
	

	    // approximate first derivative by taking central or one-sided difference
	    for (i = 0; i < cu; i++)
	    {
	        p = vU[i];
	        h = 5e-6;
	        
	        
	        
			hi = 0;

	        vU[i] = p + h;

	        try {
	        
	        	MultivariateFunction(fp, vU, n_size);		// take right difference
				
				double total_p = 0;
				double total = 0;
				for(j=0;j<n_size;j++)
				{
					total_p += fp[j];
					total += f0[j]; 
				}
				
				//if (myid == 0)
			
				
				while (fabs(total - total_p) > 100000000 * h)
				{
					h /= 2;
					cout << h << endl;
					vU[i] = p+h;
					MultivariateFunction(fp, vU, n_size);
					total_p = 0;
					total = 0;
					for(j=0;j<n_size;j++)
					{
						total_p += fp[j];
						total += f0[j]; 
					}
					//cout << total_p << "\t" << total << "\t" << (total_p - total) << "\t"<< 100 * h << endl;
					//cout << (abs(total_p - total) < 100 * h) << endl;
				}
	        	fright = true;
	        	hi = vU[i] - p;	    	// see, e.g., Dennis&Schnabel Section 5.4
	        }
	        catch (RuntimeException &e)
	        {
	        	fright = false;
	        }

			if (fCentral || !fright)	// central requested or right failed
			{
		        vU[i] =  p - h;
		        try {
		        	MultivariateFunction(fm, vU, n_size);
		        	// yes: left succeeded
					hi += p - vU[i];	// update actual step length
					fleft = true;
		        }
		        catch (RuntimeException &e){
		        	fleft = false;
		        }
			}
			else
				fleft = false;

			if (!fleft && !fright)
			{
				free(fp);
				free(fm);
				free(f0);
			    return mj;
			}
			vU[i] = p;                 	// restore original parameter

			// check step lengths for zeros/negative values
			if (hi <= 0)
				hi =(fright && fleft)? 2 * h: ((fright || fleft) ? h : 0);
			// allocate Jacobian matrix in first iteration

			int n = n_size;


			if (fleft && fright)
			{
				int j;
				for(j=0;j<n;j++)
				{
		//			cout << j << endl;
					mj[j][i] = ((fp[j] - fm[j]) / hi);	// central difference
				}
			}
			else
			{
				//if (!sizerc(f0)) f0 = vF;		    // first time only
				
				if (fright)
				{
					int j;
					for(j=0;j<n;j++)
					{			
						mj[j][i] =((fp[j] - f0[j]) / hi);	// backward difference
						
					//	cout << j << "\t" << mj[j][i] << endl;
					}
					
					//exit(-1);
					
					SaveData save;
					try {
						save.SaveTxt("fscore_intermed.txt", mj, n, cu);
					}
					catch (IOException &e) {
						cerr << "Could not write to " << e.filename;
					}
				}
				else
				{
					int j;
					for(j=0;j<n;j++)
					{
						mj[j][i] = ((f0[j] - fm[j]) / hi);	// forward difference
					}
				}
			}
	    }

	    free(fp);
	    free(fm);
	    free(f0);

	    return mj;
	}
};

#endif
