#ifndef NORMALDIST_INCLUDED
#define NORMALDIST_INCLUDED
#define LOW 0.02425
#define HIGH 0.97575

#include <cmath>
#include <errno.h>
using namespace std;

class NormalDistribution {

private : double a1, a2, a3, a4, a5, p, Pi;
private: double Mu, Sigma;
private : double a_inverse[6];
private : double b_inverse[5];
private : double c_inverse[6];
private : double d_inverse[4];


	public : NormalDistribution(double Mu, double Sigma) {
		
		this->Mu = Mu;
		this->Sigma = Sigma;
		a1 =  0.254829592;
		a2 = -0.284496736;
		a3 =  1.421413741;
		a4 = -1.453152027;
		a5 =  1.061405429;
		p  =  0.3275911;
		Pi = 3.14159265359;
		
/*		a_inverse = (double*)malloc(6 * sizeof(double));
		cout << "reached line 35" << endl;
		b_inverse = (double*)malloc(5 * sizeof(double));
		c_inverse = (double*)malloc(6 * sizeof(double));
		d_inverse = (double*)malloc(4 * sizeof(double));
*/
	
		a_inverse[0] = -3.969683028665376e+01;
		a_inverse[1] =	 2.209460984245205e+02;
		a_inverse[2] = -2.759285104469687e+02;
		a_inverse[3] = 1.383577518672690e+02;
		a_inverse[4] = -3.066479806614716e+01;
		a_inverse[5] = 2.506628277459239e+00;

		b_inverse[0] = -5.447609879822406e+01;
		b_inverse[1] = 1.615858368580409e+02;
		b_inverse[2] =	-1.556989798598866e+02;
		b_inverse[3] =	 6.680131188771972e+01;
		b_inverse[4] =	-1.328068155288572e+01;

		c_inverse[0]  = -7.784894002430293e-03;
		c_inverse[1]  = 	-3.223964580411365e-01;
		c_inverse[2]  = 	-2.400758277161838e+00;
		c_inverse[3]  = 	-2.549732539343734e+00;
		c_inverse[4]  = 	 4.374664141464968e+00;
		c_inverse[5]  = 	 2.938163982698783e+00;

		d_inverse[0]  = 7.784695709041462e-03;
		d_inverse[1]  = 	3.224671290700398e-01;
		d_inverse[2]  = 	2.445134137142996e+00;
		d_inverse[3]  = 	3.754408661907416e+00;
	}

	public : NormalDistribution() {
		NormalDistribution(0,1);
	}
	
	~NormalDistribution()
	{
	//	free(a_inverse);
	//	free(b_inverse);
	//	free(c_inverse);
	//	free(d_inverse);
	}

	public : double standard_normal(double x)
	{
		x = x / sqrt(2.);
		int sign = 1;
		if (x < 0)
			sign = -1;
		x = abs(x);

			// A&S formula 7.1.26

		double t = 1.0/(1.0 + p*x);
		double y = 1.0 - (((((a5*t + a4)*t) + a3)*t + a2)*t + a1)*t*exp(-x*x);

		return 0.5 * (1.+sign * y);
	}

	public : double cumulativeProbability(double x)
	{
		double y = (x - Mu) / Sigma;
		
		return standard_normal(y);
	}
	
	public : double Density(double x)
	{
		return (1 / sqrt(2 * Pi)) * exp(-0.5 * x * x);
	}
	
	public : double Normal_Inverse(double p)
	{
		return Mu + ltqnorm(p) * Sigma;
	}
	
	private : double ltqnorm(double p)
	{
		double q, r;

		errno = 0;

		if (p < 0 || p > 1)
		{
			errno = EDOM;
			return 0.0;
		}
		else if (p == 0)
		{
			errno = ERANGE;
			return -HUGE_VAL /* minus "infinity" */;
		}
		else if (p == 1)
		{
			errno = ERANGE;
			return HUGE_VAL /* "infinity" */;
		}
		else if (p < LOW)
		{
			/* Rational approximation for lower region */
			q = sqrt(-2*log(p));
			return (((((c_inverse[0]*q+c_inverse[1])*q+c_inverse[2])*q+c_inverse[3])*q+c_inverse[4])*q+c_inverse[5]) /
				((((d_inverse[0]*q+d_inverse[1])*q+d_inverse[2])*q+d_inverse[3])*q+1);
		}
		else if (p > HIGH)
		{
			/* Rational approximation for upper region */
			q  = sqrt(-2*log(1-p));
			return -(((((c_inverse[0]*q+c_inverse[1])*q+c_inverse[2])*q+c_inverse[3])*q+c_inverse[4])*q+c_inverse[5]) /
				((((d_inverse[0]*q+d_inverse[1])*q+d_inverse[2])*q+d_inverse[3])*q+1);
		}
		else
		{
			/* Rational approximation for central region */
	    		q = p - 0.5;
	    		r = q*q;
			return (((((a_inverse[0]*r+a_inverse[1])*r+a_inverse[2])*r+a_inverse[3])*r+a_inverse[4])*r+a_inverse[5])*q /
				(((((b_inverse[0]*r+b_inverse[1])*r+b_inverse[2])*r+b_inverse[3])*r+b_inverse[4])*r+1);
		}
	}
};


#endif



