/* Two-dimensional WARPing of a kernel density estimation using a
   multiplicative Gaussian kernel
   Inputs:  x   (n,2)-matrix of data of the two variables
            h   (2,1)-vector; bandwidths (same as in ordinary kernel
                density estimation)
            M   (2,1)-vector; binning parameter
            v1  (2,1)-vector; upper and lower boundary of pertinent range
                for the first variable (first column of x)           
                OR scalar; then v1=minc(x)-4*h[1]|maxc(x)+4*h[1]
            v2  same as v1 but for second variable
   Outputs:     (p,1)-vector of evaluation points (x-coordinates)
                (q,1)-vector of evaluation points (y-coordinates)
                (p,q)-matrix of estimated densities */

proc(3)=warpnrm2(x,h,M,v1,v2);
  local a,b,c,d,f,i,j,j1,j2,ja1,ja2,je1,je2,k1,k2,l1,l2,s1,s2,t,w;
  a=minc(x)-8*h;
  b=maxc(x)+8*h;
  d=h./m;
  s1=seqa(a[1],d[1],ceil((b[1]-a[1])/d[1])+1);
  s2=seqa(a[2],d[2],ceil((b[2]-a[2])/d[2])+1);
  t=rows(s1)|rows(s2);
  c=zeros(t[1],t[2]);
  f=c;
  if rows(v1)==1;
    v1=(minc(x[.,1])-4*h[1]-1e-9)|(maxc(x[.,1])+4*h[1]);
  else;
    v1[1]=v1[1]-1e-9;
  endif;
  if rows(v2)==1;
    v2=(minc(x[.,2])-4*h[2]-1e-9)|(maxc(x[.,2])+4*h[2]);
  else;
    v2[1]=v2[1]-1e-9;
  endif;
  i=1;
  do until i==t[2];
    i=i+1;
    j=indexcat(x[.,2],s2[i-1:i]);
    if scalmiss(j);
      c[.,i]=zeros(t[1],1);
    else;
      c[.,i]=counts(x[j,1],s1);
    endif;
  endo;
  l1=pdfn(seqa(-4*M[1],1,8*M[1]+1)./M[1]);
  l2=pdfn(seqa(-4*M[2],1,8*M[2]+1)./M[2]);
  w=(l1./sumc(l1).*M[1]).*(l2./sumc(l2).*M[2])';
  k1=seqa(-4*M[1],1,8*M[1]+1);
  k2=seqa(-4*M[2],1,8*M[2]+1);
  j1=indexcat(s1,v1);
  j2=indexcat(s2,v2);
  ja1=j1[1];
  ja2=j2[1];
  je1=j1[rows(j1)];
  je2=j2[rows(j2)];
  i=ja1-4*M[1]-1;
  do until i==je1+4*M[1];
    i=i+1;
    j=ja2-4*M[2]-1;
    do until j==je2+4*M[2];
      j=j+1;
      if c[i,j].>0;
        f[k1+i,k2'+j]=f[k1+i,k2'+j]+c[i,j].*w;
      endif;
    endo;
  endo;
  f=f[ja1:je1,ja2:je2]/(rows(x)*h[1]*h[2]);
  retp(s1[ja1:je1],s2[ja2:je2],f);
endp;
