/* Estimating the mobility based on the coefficient of variation
   conditional on age using (Gaussian) WARPing density estimation

   Inputs:  sy1 (n1,1)-vector, points of density evaluation in the
                first period
            sy2 (n2,1)-vector, same for second period
            sya (na,1)-vector, same for aggregate income
            f1  (n1,k)-matrix, (unconditional) densities at incomes sy1
                and various ages
            f2  (n2,k)-matrix, same for second period
            fa  (na,k)-matrix, same for aggregate income
   Output:      (k,1)-maxtrix of conditional mobility measures.
   Remarks:     All the inputs are returns of the WARPing algorithm
                "warpnrm2.g". Negative values are deleted. */

proc c_msv(sy1,sy2,sya,f1,f2,fa);
  local d1,d2,da,m1,m2,ma,v1,v2,va;
  d1=sy1[2]-sy1[1];
  d2=sy2[2]-sy2[1];
  da=sya[2]-sya[1];
  f1=f1./(d1.*sumc(f1)');
  f2=f2./(d2.*sumc(f2)');
  fa=fa./(da.*sumc(fa)');
  sy1=sy1+d1/2;
  sy2=sy2+d2/2;
  sya=sya+da/2;
  m1=sumc(sy1.*f1.*d1);
  m2=sumc(sy2.*f2.*d2);
  ma=sumc(sya.*fa.*da);
  v1=sumc(((sy1-m1')^2).*f1.*d1);
  v2=sumc(((sy2-m2')^2).*f2.*d2);
  va=sumc(((sya-ma')^2).*fa.*da);
  retp(1-sqrt(va)./(sqrt(v1)+sqrt(v2)));
endp;
