/* Estimating the inequality reduction mobility measure based on
   Theil's generalized inequality measures conditional on age using
   (Gaussian) WARPing density estimation

   Inputs:  l   (p,1)-vector of parameters for the Theil measure
            sy1 (n1,1)-vector, points of density evaluation in the
                first period
            sy2 (n2,1)-vector, same for second period
            sya (na,1)-vector, same for aggregate income
            f1  (n1,k)-matrix, (unconditional) densities at incomes sy1
                and various ages
            f2  (n2,k)-matrix, same for second period
            fa  (na,k)-matrix, same for aggregate income
   Output:      (k,p)-maxtrix of conditional mobility measures, one row per
                age, one column per parameter
   Remarks:     All the inputs except the vector l are returns of the
                WARPing algorithm "warpnrm2.g". If the evaluation points
                are negative they are deleted. */

proc c_mst(l,sy1,sy2,sya,f1,f2,fa);
  local d1,d2,da,i,m1,m2,ma,t1,t2,ta,z;
  d1=sy1[2]-sy1[1];
  d2=sy2[2]-sy2[1];
  da=sya[2]-sya[1];
  f1=f1./(d1.*sumc(f1)');
  f2=f2./(d2.*sumc(f2)');
  fa=fa./(da.*sumc(fa)');
  sy1=sy1+d1/2;
  sy2=sy2+d2/2;
  sya=sya+da/2;
  f1=delif(f1,sy1.<=0); sy1=delif(sy1,sy1.<=0);
  f2=delif(f2,sy2.<=0); sy2=delif(sy2,sy2.<=0);
  fa=delif(fa,sya.<=0); sya=delif(sya,sya.<=0);
  m1=sumc(sy1.*f1.*d1);
  m2=sumc(sy2.*f2.*d2);
  ma=sumc(sya.*fa.*da);
  z=zeros(cols(f1),rows(l));
  i=0;
  do until i==rows(l);
    i=i+1;
    t1=sumc(((sy1./m1')^(l[i]+1)).*f1.*d1)-1;
    t2=sumc(((sy2./m2')^(l[i]+1)).*f2.*d2)-1;
    ta=sumc(((sya./ma')^(l[i]+1)).*fa.*da)-1;
    z[.,i]=1-(ma.*ta)./(m1.*t1+m2.*t2);
  endo;
  retp(z);
endp;
