/* Calculates nonparametric confidence bands
   Inputs:  x   (n,k) matrix, each column is a curve
                (mobility age profile)
            p   scalar; confidence level (e.g. 0.95)
   Output:      (n,2) matrix, the first column contains the lower bounds,
                the second the upper bounds of the confidence band */

proc confband(x,p);
  local i,k,n,o,o0,u,u0,y;
  n=rows(x);
  k=cols(x);
  y=sortmat(x')';
  u=y[.,1];
  o=y[.,k];
  i=1;
  do while sumc(sumc((x.<u).or (x.>o)).==0)>k*p;
    i=i+1;
    u0=u;
    o0=o;
    u=y[.,i];
    o=y[.,k+1-i];
  endo;
  retp(u0~o0);
endp;


