function [bic,lb,ks] = t_dcs_diagnostics(thetahat,y)

T = length(y);

%%%%%%  get scales and likelihood
transtheta = thetahat;
transtheta(2) = log(transtheta(2)/(.999-transtheta(2)));
[nlnL,sigmas,scores] = DCS_T_vol_wlev_nll(transtheta,y); 

%%%%%%  Calc BIC
bic = 2*nlnL+length(thetahat)*log(T);

%%%%%  Test for autocorrealtion in the standardized resids
mu = transtheta(6);
standres = (y-mu)./sigmas;
[mean(y) mean(standres)]
[lbh,lbpValue,lbstat,lbcValue] = lbqtest(standres.^2,20,0.05);
lb = [lbpValue ; lbstat];

%%%%  Kolmogorov Smirnov test (just stat - no crit values)
Ord = sort(standres);
f = [1:T]'/(T+1);
nul  = thetahat(5);
nur  = nul;
alpha=.5;
Kl =  gamma((nul+1)/2)/(gamma(nul/2)*sqrt(pi*nul));
Kr =  gamma((nur+1)/2)/(gamma(nur/2)*sqrt(pi*nur));
astar =  alpha*Kl/(alpha*Kl + (1-alpha)*Kr);
fat = tcdf(min(Ord/(2*astar),0), nul) + tcdf(max(Ord/(2*(1-astar)),0), nur) - .5;
ks = max(abs(f-fat));
end