function [ks,pval,res]=dcs_st_ks_bootstrap(pars,x,sigma0,m,B)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  Original KS Test Statistic  %%%%%%%%%%%%%%%%
T = length(x);

standres = (x-pars(7))./sigma0;
%%%%  Kolmogorov Smirnov test 
Ord = sort(standres);
f = [1:T]'/(T+1);
hnul  = pars(6);
hnur  = pars(6);
halpha = pars(4);
hKl =  gamma((hnul+1)/2)/(gamma(hnul/2)*sqrt(pi*hnul));
hKr =  gamma((hnur+1)/2)/(gamma(hnur/2)*sqrt(pi*hnur));
hastar =  halpha*hKl/(halpha*hKl + (1-halpha)*hKr);
fat = 2*halpha*tcdf(min(Ord/(2*hastar),0), hnul) + 2*(1-halpha)*(tcdf(max(Ord/(2*(1-hastar)),0), hnur) - .5);
ks = sqrt(T)*max(abs(f-fat));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%  Bootstrap Procedure  %%%%%%%%%%%%%%
iter = B;

Tm = T+m;

%%%%   DGP
omega = pars(1);                    %%  parametised in terms of the unconditional level of lambda.
phi = pars(2);  
kappa = pars(3);  
alpha = pars(4); 
psi = pars(5);  
nul = pars(6);  
nur = pars(6);  
mu = pars(7);  

Kl =  gamma((nul+1)/2)/(gamma(nul/2)*sqrt(pi*nul));
Kr =  gamma((nur+1)/2)/(gamma(nur/2)*sqrt(pi*nur));
astar =  alpha*Kl/(alpha*Kl + (1-alpha)*Kr); 

%%%%%%%%%%%  Full standardised residuals  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
TT = Tm*iter;
%%  Draw full t dist and unif dist vectors for stochastic representation
tlrand = trnd(nul,TT,1);
trrand = trnd(nur,TT,1);
unirand = rand(TT,1);

vecfullstandy = astar*abs(tlrand).*(sign(unirand-alpha)-1) + (1-astar)*abs(trrand).*(sign(unirand-alpha)+1);
fullstandy = reshape(vecfullstandy,Tm,iter);

res = zeros(iter,1);

parfor j=1:iter
    
standy = fullstandy(:,j);

%%%%%%%%%%%%%

lambda = [omega/(1-phi) ; zeros(Tm-1,1)] ;        %% scale is initialised at the unconditional expectation.
sscore = [zeros(Tm,1)];                          %% scaled score is initialised at 0.
levterm = 0;
ym = [zeros(Tm,1)]; 
sgnmy = [0 ; sign(-standy)];
for t=1:Tm
    lambdat = omega + phi*lambda(t) + kappa*sscore(t) + psi*sgnmy(t)*(sscore(t)+1);
    sigmat = exp(lambdat);
    
    ym(t) = standy(t)*sigmat + mu; 
       
    Fl = 1/nul*(ym(t)-mu)^2/(2*astar*sigmat)^2;
    scoretl = (nul+1)*Fl/(1+Fl) - 1;
    scaletl = (nul+3)/(2*nul);
    Fr = 1/nur*(ym(t)-mu)^2/(2*(1-astar)*sigmat)^2;
    scoretr = (nur+1)*Fr/(1+Fr) - 1;
    scaletr = (nur+3)/(2*nur);
    ind = (sign(ym(t)-mu)+1)/2;
    
    sscoret = (1-ind)*scaletl*scoretl + ind*scaletr*scoretr;
    
   lambda(t+1,1) = lambdat;
   sscore(t+1,1) = sscoret;
end

y = ym(m+1:end,1);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%   Estimation
p0 = [omega phi kappa alpha psi nur mu];

[sigmas,nlnL,scores,resfull,covarmat,ef] = beta_skew_t_vol_wlev_model(p0*.95,y,0);
standres = (y-resfull(7))./sigmas;
%%%%  Kolmogorov Smirnov test 
Ord = sort(standres);
f = [1:T]'/(T+1);
hnul  = resfull(6);
hnur  = resfull(6);
halpha= resfull(4);
hKl =  gamma((hnul+1)/2)/(gamma(hnul/2)*sqrt(pi*hnul));
hKr =  gamma((hnur+1)/2)/(gamma(hnur/2)*sqrt(pi*hnur));
hastar =  halpha*hKl/(halpha*hKl + (1-halpha)*hKr);
fat = 2*halpha*tcdf(min(Ord/(2*hastar),0), hnul) + 2*(1-halpha)*(tcdf(max(Ord/(2*(1-hastar)),0), hnur) - .5);
ksstat = sqrt(T)*max(abs(f-fat));

res(j,:) = [ksstat];

end  %%% close iter loop

pval = 1-mean((ks>res));

end



