function [storesigmas,storenlnL,storescores,storeresfull,covarmat,storeef,step1f] = DCS_AT_vol_wlev_model(startparam,y,extras)
%% Function to estiamte a DCS_AT volatility model with leverage.
%% input : param is the vector of initial values for the optimiser (note order)
%%         y is a univariate time series
%%         extras is a binary indicator (1 = yes) for whether additonal output should be calculated.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%settings and for the optimisation problem
    opt = optimset('TolX', 0.0001, 'Display', 'off', 'MaxIter', 5000, 'MaxFunEvals', 5000, 'HessUpdate', 'bfgs') ;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
startvals = startparam;
% startvals = [startvals ;  .01 .98 .05  .02 5 5 .05];
% startvals = [startvals ;  .01 .95 .1  .05 5 10 .05];
% startvals = [startvals ;  .01 .9 .1  .1 7 12 .05];

storenlnL = 100000000;
storesigmas = [];
storeresfull = [];
storeef = [];
storescores = [];

for i=1:length(startvals(:,1))
    
param = startvals(i,:);    
    
param(2) = log(param(2)/(.999-param(2)));
param(5) = log(param(5)/(330-param(5)));
param(6) = log(param(6)/(330-param(6)));

fst = @(p)DCS_AT_vol_wlev_nll(p,y,0);
[resfull,val,ef] = fminsearch(fst,param,opt);                 %% conduct optimisation
 
% lb = [-3 0 0 0 6 6 -3];
% ub = [3 .999 1 1 50 50 3];
% % fst = @(p)beta_asym_t_vol_wlev_nll(p,factor);
% [resfull,val,ef] = fmincon(fst,[2 .95 .05 .1 6.7 40 1],[],[],[],[],lb,ub);            
% resfull(2) = log(resfull(2)/(.999-resfull(2)));

[nlnL,sigmas,scores,step1f] = DCS_AT_vol_wlev_nll(resfull,y,0);        %% Evaluate model at MLEs to get fitted states, scores and llf

resfull(2) = .999/(1+exp(-resfull(2)));
resfull(5) = 330/(1+exp(-resfull(5)));
resfull(6) = 330/(1+exp(-resfull(6)));

if (nlnL < storenlnL)
    storenlnL = nlnL;
    storesigmas = sigmas;
    storeresfull = resfull;
    storeef = ef;
    storescores = scores;
end


end

covarmat = eye(length(param));

if (extras == 1)
   covarmat = eye(length(param));                            %% To be updated with analytical matrix at a later date 
end
end