function [nlnL,sigmas,scores,step1] = DCS_AT_vol_nll(param,y)
%% Function for the negative loglikelihood of the DCS_AT score driven volatility model .
%% Asymmetric t distribution is specified in accordance with Zhu and Galbraith (2010, JoE).
%% If an initial parameter is provided for the mode (at the end of the parameter vector), the 
%% mode will be estimated by ML.  Otherwise it is set equal to zero.
%% The time varying scale is constrained using an exponential link function.
%% The score is scaled by the inverse of the information quantity in the dynamic equation for the scale.

omega = param(1);                    %%  parametised in terms of the unconditional level of lambda.
phi = .999/(1+exp(-param(2)));
kappa = param(3);
nul = 330/(1+exp(-param(4)));
nur = 330/(1+exp(-param(5)));
mu = 0;
if length(param) == 6
        mu = param(6);
end
    
T = length(y);

lambda = [omega/(1-phi) ; zeros(T,1)];        %% scale is initialised at the unconditional expectation.
sscore = zeros(T+1,1);                          %% scaled score is initialised at 0.
llf = 0;
alpha = 0.5;

ym = (y-mu);
ysq = ym.^2;
pFl = ysq/nul;
pFr = ysq/nur;

scaletleft = (nul+3)/(2*nul);
scaletright = (nur+3)/(2*nur);
    
rightind = (sign(ym)+1)/2;

for t=1:T
    
      
    
    lambdat = omega + phi*lambda(t) + kappa*sscore(t);

    sigmat = exp(lambdat);
    
    if (y(t) <= mu)                                           %%  Determining which side of the density to apply

    F = pFl(t)/(sigmat)^2;
    scoret = (nul+1)*F/(1+F) - 1;
    sscoret = scaletleft*scoret;
    
    else
    
    F = pFr(t)/(sigmat)^2;
    scoret = (nur+1)*F/(1+F) - 1;
    sscoret = scaletright*scoret;
    
    end
   
    lambda(t+1,1) = lambdat;
    sscore(t+1,1) = sscoret;
    
end

%%%% llf left
    Fl = pFl./exp(2*lambda(2:T+1));
    llft1 =   log( alpha*(gamma(nul/2+.5)/(gamma(nul/2)*sqrt(pi*nul))) + (1-alpha)*(gamma(nur/2+.5)/(gamma(nur/2)*sqrt(pi*nur))));
    llft2 = -lambda(2:T+1);
    llft3 = -(nul/2+.5)*log(1 + Fl);

    llftleft = llft1 + llft2 + llft3;
 
%%%% llf right
    Fr = pFr./exp(2*lambda(2:T+1));
    llft1 =   log( alpha*(gamma(nul/2+.5)/(gamma(nul/2)*sqrt(pi*nul))) + (1-alpha)*(gamma(nur/2+.5)/(gamma(nur/2)*sqrt(pi*nur))));
%     llft2 = -lambda;
    llft3 = -(nur/2+.5)*log(1 + Fr);

    llftright = llft1 + llft2 + llft3;
    
    
    
    llf = sum(llftleft.*(1-rightind) + llftright.*(rightind));



sigmas = exp(lambda(2:(T+1),1));               %%  (T*1) vector of tv scales for skew-t dist
scores = sscore(2:(T+1),1);                    %%  (T*1) vector of scaled scores

lambdat = omega*(1-phi) + phi*lambdat + kappa*sscoret;
step1f = exp(lambdat);

nlnL = -1*llf;

    lambdatp1 = omega + phi*lambdat + kappa*sscoret;

    step1 = exp(lambdatp1);

end