clear

tic

%%%%%%%%%  Get Data %%%%%%%%%%%%%%%
fullretdata = xlsread('ftse_sandp_rets');
% [T,N] = size(fullretdata);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
gam = 5;

dat1 = fullretdata(1:end,1)*100;
dat2 = fullretdata(1:end,2)*100; 

% dat1 = fullretdata(1000:2100,1)*100;
% dat2 = fullretdata(1000:2100,2)*100; 

[T,N] = size(dat1);

W = 1000; 
H = 5; 
iter = floor((T-W)/H);

storew = zeros(iter,4);

storepret_ast = zeros(H,iter);
storepret_at = zeros(H,iter);
storepret_st = zeros(H,iter);
storepret_t = zeros(H,iter);

parfor_progress(iter); % Initialize 
parfor j=1:iter

%     [j iter]
    
    li = 1 + (j-1)*H;
    ui = li + W-1;
    fi = ui + H;
    
 %%%%   Draws  %%%%%%%%
 d = 100000; 
 u = unifrnd(0,1,d,1);
 u2 = unifrnd(0,1,d,1);
%%%%%%%%%%%%%%%%%%%%%%%

sdat1 = dat1(li:ui,1);
sdat2 = dat2(li:ui,1);

fdat1 = dat1(ui+1:fi,1);
fdat2 = dat2(ui+1:fi,1);

%%%%%%  estimate marginals  %%%%%%

%%%%%%%%%%%%%%%%  AST DCS   %%%%%%%%%%%%%%%%%%%%%%%%%
[ast_dcs_wlev_h1,nlnL1,scores1,ast_dcs_wlev_pars1,covarmat1,ef1,step11,llf1] = beta_asym_skew_t_vol_wlev_model([.01 .98 .05 .51 .02 7 10 .05],sdat1,0);
[ast_dcs_wlev_h2,nlnL2,scores2,ast_dcs_wlev_pars2,covarmat2,ef2,step12,llf2] = beta_asym_skew_t_vol_wlev_model([.01 .98 .05 .51 .02 7 10 .05],sdat2,0);

ast_u1 =  ast_cdf(sdat1,[ast_dcs_wlev_pars1(4) ast_dcs_wlev_pars1(6:8)],ast_dcs_wlev_h1);
ast_u2 =  ast_cdf(sdat2,[ast_dcs_wlev_pars2(4) ast_dcs_wlev_pars2(6:8)],ast_dcs_wlev_h2);

% est copulas
options = optimset('Display','off','TolCon',10^-12,'TolFun',10^-4,'TolX',10^-6);
lower = 0.0001;
theta0 = 1.2;
% [ kappa_ast LL2] = fmincon('claytonCL',theta0,[],[],[],[],lower,[],[],options,[ast_u1,ast_u2]);
[ kappa_ast LL5] = fmincon('frankCL',theta0,[],[],[],[],lower,[],[],options,[ast_u1,ast_u2]);

optweight_ast = ast_optw(gam,kappa_ast, [ast_dcs_wlev_pars1(4) ast_dcs_wlev_pars1(6:8) step11], [ast_dcs_wlev_pars2(4) ast_dcs_wlev_pars2(6:8) step12], u, u2);

%%%%%%%%%%%%%%%%  AT DCS   %%%%%%%%%%%%%%%%%%%%%%%%%

[at_dcs_wlev_h1,nlnL1,scores1,at_dcs_wlev_pars1,covarmat1,ef1,step1f1] = beta_asym_t_vol_wlev_model_res([.01 .98 .05 .02 7 10 .05],sdat1,0);
[at_dcs_wlev_h2,nlnL2,scores2,at_dcs_wlev_pars2,covarmat2,ef2,step1f2] = beta_asym_t_vol_wlev_model_res([.01 .98 .05 .02 7 10 .05],sdat2,0);

at_u1 =  ast_cdf(sdat1,[0.5 at_dcs_wlev_pars1(5:7)],at_dcs_wlev_h1);
at_u2 =  ast_cdf(sdat2,[0.5 at_dcs_wlev_pars2(5:7)],at_dcs_wlev_h2);

% est copulas
options = optimset('Display','off','TolCon',10^-12,'TolFun',10^-4,'TolX',10^-6);
lower = 0.0001;
theta0 = 1.2;
% [ kappa_at LL2] = fmincon('claytonCL',theta0,[],[],[],[],lower,[],[],options,[ast_u1,ast_u2]);
[ kappa_at LL5] = fmincon('frankCL',theta0,[],[],[],[],lower,[],[],options,[at_u1,at_u2]);

optweight_at = ast_optw(gam,kappa_at, [0.5 at_dcs_wlev_pars1(5:7) step1f1], [0.5 at_dcs_wlev_pars2(5:7) step1f2], u, u2);

%%%%%%%%%%%%%%%%  ST DCS   %%%%%%%%%%%%%%%%%%%%%%%%%
[st_dcs_wlev_h1,nlnL1,scores1,st_dcs_wlev_pars1,covarmat1,ef1,storestep1f1] = beta_skew_t_vol_wlev_model([.01 .98 .05 .51 .02 10 .05],sdat1,0);
[st_dcs_wlev_h2,nlnL2,scores2,st_dcs_wlev_pars2,covarmat2,ef2,storestep1f2] = beta_skew_t_vol_wlev_model([.01 .98 .05 .51 .02 10 .05],sdat2,0);

st_u1 =  ast_cdf(sdat1,[st_dcs_wlev_pars1(4) st_dcs_wlev_pars1(6) st_dcs_wlev_pars1(6:7)],st_dcs_wlev_h1);
st_u2 =  ast_cdf(sdat2,[st_dcs_wlev_pars2(4) st_dcs_wlev_pars2(6) st_dcs_wlev_pars2(6:7)],st_dcs_wlev_h2);

% est copulas
options = optimset('Display','off','TolCon',10^-12,'TolFun',10^-4,'TolX',10^-6);
lower = 0.0001;
theta0 = 1.2;
% [ kappa_st LL2] = fmincon('claytonCL',theta0,[],[],[],[],lower,[],[],options,[ast_u1,ast_u2]);
[ kappa_st LL5] = fmincon('frankCL',theta0,[],[],[],[],lower,[],[],options,[st_u1,st_u2]);

optweight_st = ast_optw(gam,kappa_st, [st_dcs_wlev_pars1(4) st_dcs_wlev_pars1(6) st_dcs_wlev_pars1(6:7) storestep1f1], [st_dcs_wlev_pars2(4) st_dcs_wlev_pars2(6) st_dcs_wlev_pars2(6:7) storestep1f2], u, u2);

%%%%%%%%%%%%%%%%  T DCS   %%%%%%%%%%%%%%%%%%%%%%%%%
[beta_t_egarch_wlev_h1,nlnL1,scores1,beta_t_egarch_wlev_pars1,covarmat1,ef1,storestep1f1] = beta_t_vol_wlev_model([.01 .98 .05 .03 10 0],sdat1,0);
[beta_t_egarch_wlev_h2,nlnL2,scores2,beta_t_egarch_wlev_pars2,covarmat2,ef2,storestep1f12] = beta_t_vol_wlev_model([.01 .98 .05 .03 10 0],sdat2,0);

t_u1 =  ast_cdf(sdat1,[0.5 beta_t_egarch_wlev_pars1(5) beta_t_egarch_wlev_pars1(5:6)],beta_t_egarch_wlev_h1);
t_u2 =  ast_cdf(sdat2,[0.5 beta_t_egarch_wlev_pars2(5) beta_t_egarch_wlev_pars2(5:6)],beta_t_egarch_wlev_h2);

% est copulas
options = optimset('Display','off','TolCon',10^-12,'TolFun',10^-4,'TolX',10^-6);
lower = 0.0001;
theta0 = 1.2;
% [ kappa_t LL2] = fmincon('claytonCL',theta0,[],[],[],[],lower,[],[],options,[ast_u1,ast_u2]);
[ kappa_t LL5] = fmincon('frankCL',theta0,[],[],[],[],lower,[],[],options,[t_u1,t_u2]);

optweight_t = ast_optw(gam,kappa_t, [0.5 beta_t_egarch_wlev_pars1(5) beta_t_egarch_wlev_pars1(5:6) storestep1f1], [0.5 beta_t_egarch_wlev_pars2(5) beta_t_egarch_wlev_pars2(5:6) storestep1f2], u, u2);
  
%%%%%%%%%%%  Realised returns 

rr_ast = fdat1*optweight_ast + fdat2*(1-optweight_ast);
rr_at = fdat1*optweight_at + fdat2*(1-optweight_at);
rr_st = fdat1*optweight_st + fdat2*(1-optweight_st);
rr_t = fdat1*optweight_t + fdat2*(1-optweight_t);

%%%%%%%%%%%%%  store res

storew(j,:) = [optweight_ast optweight_at optweight_st optweight_t];

storepret_ast(:,j) = rr_ast;
storepret_at(:,j) = rr_at;
storepret_st(:,j) = rr_st;
storepret_t(:,j) = rr_t;

parfor_progress; % Count 
end

parfor_progress(0); % Clean up

storepret_ast = reshape(storepret_ast,H*iter,1);
storepret_at = reshape(storepret_at,H*iter,1);
storepret_st= reshape(storepret_st,H*iter,1);
storepret_t= reshape(storepret_t,H*iter,1);

pret_all = [storepret_ast storepret_at storepret_st storepret_t];
%%%  Management fees

mean(pret_all)
std(pret_all)
skewness(pret_all)
kurtosis(pret_all)
std(storew)

fun1 = @(f) match_util(f, storepret_st,storepret_ast, gam);    % function of x alone
mf_ast = fzero(fun1,0.0001)*252*100

fun2 = @(f) match_util(f, storepret_st,storepret_at, gam);    % function of  x alone
mf_at = fzero(fun2,0.0001)*252*100

fun3 = @(f) match_util(f, storepret_st,storepret_t, gam);    % function of x alone
mf_st = fzero(fun3,0.0001)*252*100

  
 y1 = ((1+storepret_st/100).^(1-gam))/(1-gam) - ((1+storepret_ast/100).^(1-gam))/(1-gam);
 [beta, R2, R2adj, X2_NW, X2_HH, X2_R, std_NW, std_HH, std_R, t_NW1, t_HH, t_R] = olshac(y1,ones(length(y1),1),1,1);
 

  y2 = ((1+storepret_st/100).^(1-gam))/(1-gam) - ((1+storepret_at/100).^(1-gam))/(1-gam);
 [beta, R2, R2adj, X2_NW, X2_HH, X2_R, std_NW, std_HH, std_R, t_NW2, t_HH, t_R] = olshac(y2,ones(length(y2),1),1,1);
 
toc



