function [storesigmas,storenlnL,storescores,storeresfull,covarmat,storeef,storestep1,llf] = DCS_AST_vol_wlev_model(startparam,y,extras)
%% Function to estiamte a DCS_AST volatility model with leverage.
%% input : param is the vector of initial values for the optimiser (note order)
%%         y is a univariate time series
%%         extras is a binary indicator (1 = yes) for whether additonal output should be calculated.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%settings and for the optimisation problem
    opt = optimset('TolX', 0.0001, 'Display', 'off', 'MaxIter', 5000, 'MaxFunEvals', 5000, 'HessUpdate', 'bfgs') ;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

startvals = startparam;
startvals = [startvals ;  0 .98 .05 .55 .02 5 1 .05];
startvals = [startvals ;  .02 .95 .1 .51 .05 5 6 .05];
startvals = [startvals ;  .03 .9 .15 .5 .06 8 15 .05];
% startvals = [startvals ;  0 .99 .01 .53 .05 6 1 .05];

storenlnL = 100000000;
storesigmas = [];
storeresfull = [];
storeef = [];
storescores = [];
storestep1 = [];

for i=1:length(startvals(:,1))

param = startvals(i,:);    
    
param(2) = log(param(2)/(.999-param(2)));
param(3) = log(param(3));
param(4) = log(param(4)/(.999-param(4)));
param(6) = log((param(6))/(330-param(6)));
param(7) = log((param(7))/(330-param(7)));

fst = @(p)DCS_AST_vol_wlev_nll(p,y,0);
[resfull,val,ef] = fminsearch(fst,param,opt);                 %% conduct optimisation
% [resfull,val,ef] = fminunc(fst,param,opt);   
[nlnL,sigmas,scores,step1,llf] = DCS_AST_vol_wlev_nll(resfull,y,0);        %% Evaluate model at MLEs to get fitted states, scores and llf

resfull(2) = .999/(1+exp(-resfull(2)));
resfull(3) = exp(resfull(3));
resfull(4) = .999/(1+exp(-resfull(4)));
resfull(6) = 330/(1+exp(-resfull(6)));
resfull(7) = 330/(1+exp(-resfull(7)));

if (nlnL < storenlnL)
    storenlnL = nlnL;
    storesigmas = sigmas;
    storeresfull = resfull;
    storeef = ef;
    storescores = scores;
    storestep1 = step1;
end


end

covarmat = eye(length(param));

if (extras == 1)
   covarmat = eye(length(param));                            %% To be updated with analytical matrix at a later date 
end
end