* open the data file: finaldata.dta

*** generate variables

egen id=group(country)
tsset id year
gen lngdp=ln(pop*pcgdp) /*log country GDP*/
gen b=bc
replace b=0 if bc[_n-1]==1 & b!=. /*dummy for the start of a bank crisis*/

* define the sample for regressions: every country has to have at least 15 complete
observations for the longest forecast period (10 years ahead)

quietly xtreg f10.lngdp l(0/3).lngdp l(0/3).b year , fe
gen x=e(sample)
bysort id: egen ttl=sum(x)
keep if ttl==15
drop x ttl
keep if year>1973 /*there are no banking crises observations before 1974*/
sort id year

*** regressions

gen count=_n-1
gen d=.
gen p=.
gen se=.

** Table 1
* levels, FE (column 1 of Table 1)

forvalues i=0/10 {
quietly xtreg f`i'.lngdp l(1/4).lngdp f(0/`i').b l(0/4).b year , fe cluster(id)
quietly replace d=_b[b] if count==`i'
quietly replace p=(1-ttail(1700,_b[b]/_se[b]))*2 if count==`i'
quietly replace se=_se[b] if count==`i'
}
list count d p se in 1/11

* growth rates, constrained (column 2 of Table 1)
sort id year
forvalues i=1/10 {
quietly gen d_`i'_y=f`i'.lngdp-lngdp
}
constraint define 1 _b[d.lngdp]+_b[l.d.lngdp]+_b[l2.d.lngdp]+_b[l3.d.lngdp]+_b[l4.d.lngdp]=0
forvalues i=1/10 {
quietly cnsreg d_`i'_y l(0/4).d.lngdp f(1/`i').b l(0/4).b , constraints(1) cluster(id)
quietly replace d=_b[b] if count==`i'
quietly replace p=(1-ttail(1700,_b[b]/_se[b]))*2 if count==`i'
quietly replace se=_se[b] if count==`i'
}
list count d p se in 1/11

* growth rates, unconstrained (column 3 of Table 1)
forvalues i=1/10 {
quietly reg d_`i'_y l(0/4).d.lngdp f(1/`i').b l(0/4).b , cluster(id)
test (_b[d.lngdp]+_b[l.d.lngdp]+_b[l2.d.lngdp]+_b[l3.d.lngdp]+_b[l4.d.lngdp]=0)
quietly replace d=_b[b] if count==`i'
quietly replace p=(1-ttail(1700,_b[b]/_se[b]))*2 if count==`i'
quietly replace se=_se[b] if count==`i'
}
list count d p se in 1/11

* levels, equation 9 in the paper (column 4 of Table 1)
matrix B=J(20,11,0)
sort id year
xtreg lngdp year l(0/9).b l(10/20).b, fe cluster(id) /* this is the equation from which IRF
estimates are taken*/

* this is to see from which number of lags the estimates stabilise
forvalues i=10/20{
quietly xtreg lngdp year l(0/9).b l(10/`i').b if e(sample), fe cluster(id)
forvalues j=1/`i' {
quietly matrix B[`j',`i'-9]=_b[l`j'.b]
}}
matrix list B /* so it's from l=18 and more*/
matrix drop B

* levels with FE (column 5 of Table 1)
forvalues i =0/10 {
quietly xtreg f`i'.lngdp l(1/4).lngdp l(0/4).b year, fe cluster(id)
quietly replace d=_b[b] if count==`i'
quietly replace p=(1-ttail(1700,_b[b]/_se[b]))*2 if count==`i'
quietly replace se=_se[b] if count==`i'
}
list count d p se in 1/11

* growth rates, no FE (column 6 of Table 1)
sort id year
forvalues i=1/10 {
quietly reg d_`i'_y l(0/4).d.lngdp l(0/4).b, cluster(id)
quietly replace d=_b[b] if count==`i'
quietly replace p=(1-ttail(1700,_b[b]/_se[b]))*2 if count==`i'
quietly replace se=_se[b] if count==`i'
}
list count d p se in 1/11


** specifications omitted in the paper

* levels, no FE

forvalues i =0/10 {
quietly reg f`i'.lngdp l(1/4).lngdp l(0/4).b year, cluster(id)
quietly replace d=_b[b] if count==`i'
quietly replace p=(1-ttail(1700,_b[b]/_se[b]))*2 if count==`i'
quietly replace se=_se[b] if count==`i'
}
list count d p se in 1/11

* constrained version, growth rates

constraint define 1 _b[d.lngdp]+_b[l.d.lngdp]+_b[l2.d.lngdp]+_b[l3.d.lngdp]+_b[l4.d.lngdp]=0
forvalues i=1/10 {
quietly cnsreg d_`i'_y l(0/4).d.lngdp l(0/4).b , constraints(1) cluster(id)
quietly replace d=_b[b] if count==`i'
quietly replace p=(1-ttail(1700,_b[b]/_se[b]))*2 if count==`i'
quietly replace se=_se[b] if count==`i'
}
list count d p se in 1/11

* growth rates regressions with fixed effects
forvalues i=1/10 {
quietly xtreg d_`i'_y l(0/4).d.lngdp l(0/4).b, fe cluster(id)
quietly replace d=_b[b] if count==`i'
quietly replace p=(1-ttail(1700,_b[b]/_se[b]))*2 if count==`i'
quietly replace se=_se[b] if count==`i'
}
list count d p se in 1/11

* levels, no FE, corrected local projections estimator
forvalues i=0/10 {
quietly reg f`i'.lngdp l(1/4).lngdp f(0/`i').b l(0/4).b year , cluster(id)
quietly replace d=_b[b] if count==`i'
quietly replace p=(1-ttail(1700,_b[b]/_se[b]))*2 if count==`i'
quietly replace se=_se[b] if count==`i'
}
list count d p se in 1/11

** Table 2
** variance in gdp explained by the history of banking crises between now and k years ago
gen r1=.
gen r2=.
forvalues i=0/10 {
quietly xtreg f`i'.lngdp l(1/4).lngdp year , fe robust
replace r1=e(rss) if count==`i'
quietly xtreg f`i'.lngdp l(1/4).lngdp l.f(0/`i').b l(0/3).b year , fe robust
replace r2=e(rss) if count==`i'
}
gen delta=(r1-r2)/r1
list delta in 1/11
drop delta r1 r2

* share of variance explained by just one single crisis
gen r1=.
gen r2=.
quietly xtreg lngdp l(1/4).lngdp l(1/3).b year , fe robust
replace r1=e(rss) if count==0
quietly xtreg lngdp l(1/4).lngdp l(0/3).b year , fe robust
replace r2=e(rss) if count==0
forvalues i=1/10 {
quietly xtreg f`i'.lngdp l(1/4).lngdp l(1/3).b f(1/`i').b year , fe robust
replace r1=e(rss) if count==`i'
quietly xtreg f`i'.lngdp l(1/4).lngdp l.f(0/`i').b l(0/3).b year , fe robust
replace r2=e(rss) if count==`i'
}
gen delta=(r1-r2)/r1
list delta in 1/11

** Table 3
* column 1

sort id year
forvalues i=0/10 {
quietly xtreg f`i'.lngdp l(1/3).lngdp f(0/`i').b l(0/4).b year if africa==1, fe cluster(id)
quietly replace d=_b[b] if count==`i'
quietly replace p=(1-ttail(1700,_b[b]/_se[b]))*2 if count==`i'
quietly replace se=_se[b] if count==`i'
}
list count d p se in 1/11

* column 2
sort id year
xtreg lngdp year l(0/9).b l(10/20).b if africa==1, fe cluster(id)

* column 3
forvalues i=0/10 {
quietly xtreg f`i'.lngdp l(1/3).lngdp f(0/`i').b l(0/4).b year if transition==0 & africa==0, fe
cluster(id)
quietly replace d=_b[b] if count==`i'
quietly replace p=(1-ttail(1700,_b[b]/_se[b]))*2 if count==`i'
quietly replace se=_se[b] if count==`i'
}
list count d p se in 1/11

* column 4
sort id year
xtreg lngdp year l(0/9).b l(10/20).b if transition==0 & africa==0, fe cluster(id)

** Table 4
logit b l(1/4).lngdp
xtlogit b l(1/4).lngdp, fe

** Table 5
xtreg lngdp year l(0/9).b l(10/20).b f1.b f2.b f3.b, fe